{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 10.04.2009
LastMod: 09.06.2011
Version: 0.3.1
}
unit APlugins03;

interface

uses
  ABase0, APlugins0, ARuntime0, ASettings0, ASystem0;

type
  TCheckPluginProc = function(Lib: ALibrary): ABoolean; stdcall;

//    .
function Plugins_AddPlugin(const FileName: AWideString): ABoolean; stdcall;
function Plugins_Clear: ABoolean; stdcall;
function Plugins_Count: AInteger; stdcall;
function Plugins_Delete(Index: Integer): ABoolean; stdcall;
procedure Plugins_Find(const Path: AWideString); stdcall;

{ Protected }

function Plugins_Boot: AInteger; stdcall;
function Plugins_Init: AInteger; stdcall;
function Plugins_Done: AInteger; stdcall;

procedure Plugins_SetOnCheckPlugin(CheckPluginProc: TCheckPluginProc); stdcall;

implementation

uses
  SysUtils;

exports
  Plugins_AddPlugin,
  Plugins_Clear,
  Plugins_Count,
  Plugins_Delete,
  Plugins_Find;

const
  PluginsVersionValue = $00030100;
  PluginsVersionMask = $FFFF0000;

const
  PluginsProcs: APluginsProcs_Type = (
    AddPlugin: Plugins_AddPlugin;
    Clear: Plugins_Clear;
    Count: Plugins_Count;
    Delete: Plugins_Delete;
    Find: Plugins_Find;
    Reserved05: 0;
    Reserved06: 0;
    Reserved07: 0;
    Reserved08: 0;
    Reserved09: 0;
    Reserved10: 0;
    Reserved11: 0;
    Reserved12: 0;
    Reserved13: 0;
    Reserved14: 0;
    Reserved15: 0;

    Reserved16: 0;
    Reserved17: 0;
    Reserved18: 0;
    Reserved19: 0;
    Reserved20: 0;
    Reserved21: 0;
    Reserved22: 0;
    Reserved23: 0;
    Reserved24: 0;
    Reserved25: 0;
    Reserved26: 0;
    Reserved27: 0;
    Reserved28: 0;
    Reserved29: 0;
    Reserved30: 0;
    Reserved31: 0;
    );

const
  PluginsModule: AModule_Type = (
    Version: APlugins_Version;
    Uid: APlugins_Uid;
    Name: APlugins_Name;
    Description: nil;
    Init: Plugins_Init;
    Done: Plugins_Done;
    Reserved06: 0;
    Procs: Addr(PluginsProcs);
    );

type
  APluginBootProc = function(Runtime: ARuntimeProcs): Integer; stdcall;
  APluginInitProc = TAGetIntProc;
  APluginDoneProc = TAGetIntProc;
  APluginVersionProc = TAGetIntProc;

type
  APlugin_Type = record
    Lib: ALibrary;
    InitProc: APluginInitProc;
    DoneProc: APluginDoneProc;
  end;

var
  FOnCheckPlugin: TCheckPluginProc;
  FPlugins: array of APlugin_Type;

{ Events }

function DoCheckPlugin(Lib: ALibrary): ABoolean; stdcall;
var
  PluginBootProc: APluginBootProc;
begin
  if not(ASystem.Library_GetSymbolW(Lib, 'Plugin_Boot', @PluginBootProc)) then
  begin
    Result := False;
    Exit;
  end;
  try
    Result := (PluginBootProc(Addr(ARuntime)) >= 0);
  except
    Result := False;
  end;
end;

{ Plugin }

function Plugin_Done(Index: Integer): Integer;
begin
  try
    Result := FPlugins[Index].DoneProc;
  except
    //System0.ShowMessage('Error Plugin_Done '+Library_GetName(FPlugins[Index].Lib));
    Result := -1;
  end;
end;

procedure Plugin_Free(Index: Integer);
begin
  ASystem.Library_Close(FPlugins[Index].Lib);
end;

function Plugin_Init(Index: Integer): Integer;
begin
  try
    Result := FPlugins[Index].InitProc;
  except
    Result := -1;
  end;
end;

{ Private }

function FindPluginByName(const Name: AWideString): AInteger;
var
  I: Integer;
begin
  for I := 0 to High(FPlugins) do
  begin
    if (ASystem.Library_GetNameW(FPlugins[I].Lib) = Name) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

procedure InitPluginFromConfig(Config: AConfig; const ConfigParamName: string);
var
  PluginName: AWideString;
  PluginIndex: Integer;
begin
  PluginName := Settings_ReadString(Config, 'Boot', ConfigParamName, '');
  if (PluginName <> '') then
  begin
    PluginIndex := FindPluginByName(PluginName);
    if (PluginIndex >= 0) then
      Plugin_Init(PluginIndex);
  end;
end;

// -------------------------------------------------------------------------------------------------

function CheckPlugin(Lib: ALibrary): ABoolean;
begin
  if Assigned(FOnCheckPlugin) then
    Result := FOnCheckPlugin(Lib)
  else
    Result := True;
end;

{ Module }

function Plugins_Boot: AInteger; stdcall;
begin
  if not(Assigned(ARuntime.Modules_FindByName)) then
  begin
    Result := -1;
    Exit;
  end;

  if (ARuntime.Modules_FindByName(APlugins_Name) > 0) then
  begin
    Result := -1;
    Exit;
  end;

  if (ARuntime.Modules_FindByUid(APlugins_Uid) > 0) then
  begin
    Result := -1;
    Exit;
  end;

  Plugins_SetOnCheckPlugin(DoCheckPlugin);
  Result := ARuntime.Module_Register(Addr(PluginsModule));
end;

function Plugins_Done: AInteger; stdcall;
begin
  Plugins_Clear;
  Result := 0;
end;

function Plugins_Init: AInteger; stdcall;
var
  I: Integer;
  Config: AConfig;
begin
  ARuntime.Modules_InitByUid(ASystem_Uid);

  Config := Runtime_GetConfig;
  InitPluginFromConfig(Config, 'InitPlugin0');
  InitPluginFromConfig(Config, 'InitPlugin1');
  InitPluginFromConfig(Config, 'InitPlugin2');
  InitPluginFromConfig(Config, 'InitPlugin3');
  InitPluginFromConfig(Config, 'InitPlugin4');
  InitPluginFromConfig(Config, 'InitPlugin5');
  InitPluginFromConfig(Config, 'InitPlugin6');
  InitPluginFromConfig(Config, 'InitPlugin7');

  for I := 0 to High(FPlugins) do
    Plugin_Init(I);
  Result := 0;
end;

{ Plugins }

function Plugins_AddPlugin(const FileName: AWideString): Boolean;
var
  I: Integer;
  Lib: ALibrary;
  PluginInitProc: APluginInitProc;
  PluginDoneProc: APluginDoneProc;
  PluginVersionProc: APluginVersionProc;
  Version: AInteger;
begin
  try
    Lib := ASystem.Library_OpenW(FileName, 0);
    if (Lib = 0) then
    begin
      Result := False;
      Exit;
    end;
    if not(ASystem.Library_GetSymbolW(Lib, 'Plugin_Init', @PluginInitProc)) then
    begin
      ASystem.Library_Close(Lib);
      Result := False;
      Exit;
    end;
    if not(ASystem.Library_GetSymbolW(Lib, 'Plugin_Done', @PluginDoneProc)) then
    begin
      ASystem.Library_Close(Lib);
      Result := False;
      Exit;
    end;
    if not(ASystem.Library_GetSymbolW(Lib, 'Plugin_Version', @PluginVersionProc)) then
    begin
      ASystem.Library_Close(Lib);
      Result := False;
      Exit;
    end;

    //   
    if Assigned(PluginVersionProc) then
    begin
      try
        Version := PluginVersionProc;
      except
        ASystem.Library_Close(Lib);
        Result := False;
        Exit;
      end;
      if (Version and PluginsVersionMask <> PluginsVersionValue and PluginsVersionMask) then
      begin
        ASystem.Library_Close(Lib);
        Result := False;
        Exit;
      end;
    end;

    if not(CheckPlugin(Lib)) then
    begin
      ASystem.Library_Close(Lib);
      Result := False;
      Exit;
    end;

    I := Length(FPlugins);
    SetLength(FPlugins, I + 1);
    FPlugins[I].Lib := Lib;
    FPlugins[I].InitProc := PluginInitProc;
    FPlugins[I].DoneProc := PluginDoneProc;
    Result := True;
  except
    Result := False;
  end;
end;

function Plugins_Clear: Boolean;
var
  I: Integer;
begin
  for I := 0 to High(FPlugins) do
  try
    Plugin_Done(I);
    Plugin_Free(I);
  except
  end;
  SetLength(FPlugins, 0);
  Result := True;
end;

function Plugins_Count: Integer;
begin
  Result := Length(FPlugins);
end;

function Plugins_Delete(Index: Integer): Boolean;
var
  I: Integer;
begin
  Result := False;
  if (Index < 0) or (Index >= Length(FPlugins)) then Exit;
  Plugin_Done(Index);
  Plugin_Free(Index);
  for I := Index to High(FPlugins) - 1 do
  begin
    FPlugins[I] := FPlugins[I + 1];
  end;
  SetLength(FPlugins, High(FPlugins));
  Result := True;
end;

procedure Plugins_Find(const Path: AWideString);

  procedure PFind(const Path: AWideString);
  var
    SearchRec: TSearchRec;
  begin
    if (FindFirst(Path + '*.dll', faAnyFile and (not(faDirectory)), SearchRec) <> 0) then Exit;
    Plugins_AddPlugin(Path + SearchRec.Name);
    while (FindNext(SearchRec) = 0) do
      Plugins_AddPlugin(Path + SearchRec.Name);
    SysUtils.FindClose(SearchRec);
  end;

var
  SearchRec: TSearchRec;
begin
  if (FindFirst(Path + '*', faDirectory, SearchRec) <> 0) then Exit;
  if (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
    PFind(Path+SearchRec.Name+'\');
  while (FindNext(SearchRec) = 0) do
  begin
    if (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
      PFind(Path+SearchRec.Name+'\');
  end;
  SysUtils.FindClose(SearchRec);
end;

procedure Plugins_SetOnCheckPlugin(CheckPluginProc: TCheckPluginProc);
begin
  FOnCheckPlugin := CheckPluginProc;
end;

initialization
  Plugins_SetProcs(Addr(PluginsProcs));
end.
