{
Abstract:   
Author: Prof1983 <prof1983@yandex.ru>
Created: 19.03.2008
LastMod: 09.06.2011
Version: 0.3.1
 ()     (Entity).
}
unit AEntities03;

interface

uses
  ABase0, AEntities0, ARuntime0,
  AEntities, AEntitiesIterator;

{  .       ,     . }
function A_Entities_AddEntity(EntityId, EntityType: AEntityId): AInteger; stdcall;

{  .       ,     . }
function A_Entities_AddEntityA(EntityId, EntityType: AEntityId; DataSource: Pointer; DataSize: AInteger): AInteger; stdcall;

function A_Entities_GetEntityById(Id: AEntityID; var Entity: AEntity_Type): AInteger; stdcall;
function A_Entities_GetEntityByIndex(Index: AInteger; var Entity: AEntity_Type): ABoolean; stdcall;
function A_Entities_GetEntityType(Id: AEntityId): AEntityId; stdcall;

{  True,    . }
function A_Entities_IsFree(Id: AEntityId): ABoolean; stdcall;

{   . }
function A_Entities_NewEntity(EntityType: AEntityId): AEntityId; stdcall;

function A_Entities_FindEntityById(Id: AEntityId): AInteger; stdcall;
function A_Entities_SetEntityData(Id: AEntityId; Data: Pointer; DataSize: AInteger): AInteger; stdcall;
function A_Entities_Count: AInteger; stdcall;

{ Protected procs }

function Entities_Boot: AInteger; stdcall;
function Entities_Init: AInteger; stdcall;
function Entities_Done: AInteger; stdcall;

implementation

const
  //   
  EntitiesProcs: AEntitiesProcs_Type = (
    AddEntity: A_Entities_AddEntity;
    SetEntityData: A_Entities_SetEntityData;
    Count: A_Entities_Count;
    GetEntityByIndex: A_Entities_GetEntityByIndex;
    Iterator_Create: Entities_Iterator_Create; //Reserved04: 0;
    Iterator_Free: Entities_Iterator_Free; //Reserved05: 0;
    FindEntityById: A_Entities_FindEntityById; //Reserved06: 0;
    AddEntityA: A_Entities_AddEntityA; //Reserved07: 0;
    Reserved08: 0;
    Reserved09: 0;
    Reserved10: 0;
    Reserved11: 0;
    Reserved12: 0;
    Reserved13: 0;
    Reserved14: 0;
    Reserved15: 0;
    );

const
  EntitiesModule: AModule_Type = (
    Version: Entities_Version;
    UID: Entities_Uid;
    Name: Entities_Name;
    Description: nil;
    Init: Entities_Init;
    Done: Entities_Done;
    Reserved06: 0;
    Procs: Addr(EntitiesProcs);
    );

{ A_Entities }

function A_Entities_AddEntity(EntityId, EntityType: AEntityId): AInteger; stdcall;
begin
  try
    Result := Entities_AddEntity(EntityId, EntityType);
  except
    Result := 0;
  end;
end;

function A_Entities_AddEntityA(EntityId, EntityType: AEntityId; DataSource: Pointer; DataSize: AInteger): AInteger; stdcall;
begin
  try
    Result := Entities_AddEntityA(EntityId, EntityType, DataSource, DataSize);
  except
    Result := 0;
  end;
end;

function A_Entities_Clear: AInteger; stdcall;
begin
  try
    Result := A_Entities_Clear;
  except
    Result := 0;
  end;
end;

function A_Entities_Count: AInteger; stdcall;
begin
  try
    Result := A_Entities_Count;
  except
    Result := 0;
  end;
end;

function A_Entities_FindEntityById(Id: AEntityId): AInteger; stdcall;
begin
  try
    Result := Entities_FindEntityById(Id);
  except
    Result := 0;
  end;
end;

function A_Entities_GetEntityById(Id: AEntityId; var Entity: AEntity_Type): AInteger; stdcall;
begin
  try
    Result := Entities_GetEntityById(Id, Entity);
  except
    Result := 0;
  end;
end;

function A_Entities_GetEntityByIndex(Index: AInteger; var Entity: AEntity_Type): ABoolean; stdcall;
begin
  try
    Result := Entities_GetEntityByIndex(Index, Entity);
  except
    Result := False;
  end;
end;

function A_Entities_GetEntityType(Id: AEntityId): AEntityId; stdcall;
begin
  try
    Result := Entities_GetEntityType(Id);
  except
    Result := 0;
  end;
end;

function A_Entities_IsFree(Id: AEntityId): ABoolean; stdcall;
begin
  try
    Result := Entities_IsFree(Id);
  except
    Result := False;
  end;
end;

function A_Entities_NewEntity(EntityType: AEntityId): AEntityId; stdcall;
begin
  try
    Result := Entities_NewEntity(EntityType);
  except
    Result := 0;
  end;
end;

function A_Entities_SetEntityData(Id: AEntityId; Data: Pointer; DataSize: AInteger): AInteger; stdcall;
begin
  try
    Result := Entities_SetEntityData(Id, Data, DataSize);
  except
    Result := 0;
  end;
end;

{ Module_Entities }

function Entities_Boot: AInteger; stdcall;
begin
  Entities_SetProcs(Addr(EntitiesProcs));
  Result := ARuntime.Module_Register(Addr(EntitiesModule));
end;

function Entities_Done: AInteger; stdcall;
begin
  Entities_Clear;
  Result := ARuntime.Modules_DeleteByUid(Entities_Uid);
end;

function Entities_Init: AInteger; stdcall;
begin
  Result := 0;
end;

initialization
  Entities_SetProcs(Addr(EntitiesProcs));
end.
