{
Abstract:   .    .    
           (   ).   stdcall.
           ()     (Entity).
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.03.2008
LastMod: 08.06.2011
Version: 0.2.6+0.3.1
}
unit AEntities;

interface

uses
  ABase0, AEntities0, ARuntime0,
  AEntitiesIterator;

//  .       ,     .
function Entities_AddEntity(EntityId, EntityType: AEntityId): AInteger; stdcall;
//  .       ,     .
function Entities_AddEntityA(EntityId, EntityType: AEntityId; DataSource: Pointer; DataSize: AInteger): AInteger; stdcall;

function Entities_Clear: AInteger; stdcall;
function Entities_Count: AInteger; stdcall;

function Entities_GetEntityById(Id: AEntityId; var Entity: AEntity_Type): AInteger; stdcall;
function Entities_GetEntityByIndex(Index: AInteger; var Entity: AEntity_Type): ABoolean; stdcall;
function Entities_GetEntityType(Id: AEntityId): AEntityId; stdcall;
// TODO: 
//function EntityData_GetEntityDataSize(Id: AEntityId): AInteger; stdcall;
//function EntityData_GetEntityData(Id: AEntityId; Size: AInteger; P: Pointer): AInteger; stdcall;

//  True,    .
function Entities_IsFree(Id: AEntityId): ABoolean; stdcall;
//   
function Entities_NewEntity(EntityType: AEntityId): AEntityId; stdcall;
//            .
//function EntityData_Select(EntityType: AEntityId): IAEntityIterator;

function Entities_FindEntityById(Id: AEntityId): AInteger; stdcall;
function Entities_SetEntityData(Id: AEntityId; Data: Pointer; DataSize: AInteger): AInteger; stdcall;

implementation

var
  FEntities: array of AEntity_Type;

{ Private procs }

function AddEntity(EntityID, EntityType: AEntityID): AInteger;
var
  Index: Integer;
begin
  Index := Length(FEntities);
  SetLength(FEntities, Index + 1);
  FEntities[Index].ID := EntityID;
  FEntities[Index].Typ := EntityType;
  FEntities[Index].Data := nil;
  FEntities[Index].DataSize := 0;
  Result := Index;
end;

function FindEntityByID(ID: AEntityID): AInteger;
var
  I: Integer;
begin
  for I := 0 to High(FEntities) do
  begin
    if (FEntities[I].ID = ID) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function GetMaxEntityID: AEntityID;
var
  I: Integer;
begin
  Result := 0;
  for I := 0 to High(FEntities) do
    if (FEntities[I].ID > Result) then
      Result := FEntities[I].ID;
  //Result := Index + AEntityGlobalMin;
end;

function NewEntity(EntityType: AEntityID): AInteger;
var
  MaxID: AEntityID;
begin
  MaxID := GetMaxEntityID;
  if (MaxID < AEntityGlobalMax) then
    MaxID := AEntityGlobalMax;
  Result := AddEntity(MaxID + 1, EntityType);
end;

{function NewGlobalEntity(EntityType: AEntityID): AInteger;
var
  MaxID: AEntityID;
begin
  MaxID := GetMaxEntityID;
  if MaxID <
  Result := AddEntityID(ID + 1, EntityType);
  //Result := Index + AEntityGlobalMin;
end;}

{ Entities procs }

function Entities_AddEntity(EntityId, EntityType: AEntityId): AInteger; stdcall;
begin
  Result := AddEntity(EntityId, EntityType);
end;

function Entities_AddEntityA(EntityId, EntityType: AEntityId; DataSource: Pointer; DataSize: AInteger): AInteger; stdcall;
var
  Index: Integer;
begin
  Index := Length(FEntities);
  SetLength(FEntities, Index + 1);
  FEntities[Index].Id := EntityId;
  FEntities[Index].Typ := EntityType;
  if (DataSize > 0) then
  begin
    GetMem(FEntities[Index].Data, DataSize);
    Move(DataSource^, FEntities[Index].Data^, DataSize);
  end
  else
    FEntities[Index].Data := nil;
  FEntities[Index].DataSize := DataSize;
  Result := Index;
end;

function Entities_Clear: AInteger; stdcall;
var
  I: Integer;
begin
  for I := 0 to High(FEntities) do
  begin
    if (FEntities[I].DataSize > 0) then
      FreeMem(FEntities[I].Data, FEntities[I].DataSize);
  end;
  SetLength(FEntities, 0);
  Result := 0;
end;

function Entities_Count: AInteger; stdcall;
begin
  Result := Length(FEntities);
end;

function Entities_FindEntityById(Id: AEntityId): AInteger; stdcall;
begin
  Result := FindEntityById(Id);
end;

function Entities_GetEntityById(Id: AEntityId; var Entity: AEntity_Type): AInteger;
begin
  Result := Entities_FindEntityById(Id);
  if (Result < 0) then
    Exit;
  Entity := FEntities[Result];
  //Result := Entities_GetEntityByIndex(ID - AEntityGlobalMin, Entity);
end;

function Entities_GetEntityByIndex(Index: AInteger; var Entity: AEntity_Type): ABoolean;
begin
  if (Index >= 0) and (Index < Length(FEntities)) then
  begin
    Entity := FEntities[Index];
    Result := True;
  end
  else
    Result := False;
end;

function Entities_GetEntityType(Id: AEntityId): AEntityId;
var
  Entity: AEntity_Type;
begin
  if (Entities_GetEntityById(Id, Entity) >= 0) then
    Result := Entity.Typ
  else
    Result := AEntityNull;
end;

function Entities_IsFree(Id: AEntityId): ABoolean;
var
  Index: Integer;
begin
  //  0..65535   
  if (Id < AEntityGlobalMin) then
  begin
    Result := False;
    Exit;
  end;

  Index := Id - AEntityGlobalMin;
  if (Index >= 0) and (Index < Length(FEntities)) then
    Result := True
  else
    Result := False;
end;

function Entities_NewEntity(EntityType: AEntityId): AEntityId;
var
  Index: Integer;
begin
  Index := Length(FEntities);
  SetLength(FEntities, Index + 1);
  Result := Index + AEntityGlobalMin;
  FEntities[Index].Id := Result;
  FEntities[Index].Typ := EntityType;
  FEntities[Index].Data := nil;
  FEntities[Index].DataSize := 0;
end;

function Entities_SetEntityData(Id: AEntityId; Data: Pointer; DataSize: AInteger): AInteger; stdcall;
begin
  Result := FindEntityById(Id);
  if (Result < 0) then
    Exit;
  FEntities[Result].Data := Data;
  FEntities[Result].DataSize := DataSize;
end;

end.
