{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 15.05.2011
LastMod: 09.06.2011
Version: 0.3.1
}
unit ADocuments03;

interface

uses
  ABase0, ADocuments0, AEntities0, ARuntime0,
  ADocumentsIO, ADocumentsIterator;

function A_Documents_LoadFromFile(const FileName: AString_Type): AInteger; stdcall;
function A_Documents_SaveToFile(const FileName: AString_Type): AInteger; stdcall;

function A_Documents_Iterator_Create: AInteger; stdcall;
function A_Documents_Iterator_Free(Iterator: AInteger): AInteger; stdcall;
function A_Documents_Iterator_NextDocument(Iterator: AInteger): AInteger; stdcall;

{ Protected }

function Documents_Boot: AInteger; stdcall;
function Documents_Init: AInteger; stdcall;
function Documents_Done: AInteger; stdcall;

implementation

const
  DocumentsProcs: ADocumentsProcs_Type = (
    Iterator_Create: A_Documents_Iterator_Create;
    Iterator_Free: A_Documents_Iterator_Free;
    LoadFromFile: A_Documents_LoadFromFile;
    SaveToFile: A_Documents_SaveToFile;
    LoadFromFileW: Documents_LoadFromFile; //Reserved04: 0;
    SaveToFileW: Documents_SaveToFile; //Reserved05: 0;
    Reserved06: 0;
    Reserved07: 0;
    Reserved08: 0;
    Reserved09: 0;
    Reserved10: 0;
    Reserved11: 0;
    Reserved12: 0;
    Reserved13: 0;
    Reserved14: 0;
    Reserved15: 0;
    );

const
  DocumentsModule: AModule_Type = (
    Version: Documents_Version;
    Uid: Documents_Uid;
    Name: Documents_Name;
    Description: nil;
    Init: Documents_Init;
    Done: Documents_Done;
    Reserved06: 0;
    Procs: Addr(DocumentsProcs);
    );

var
  FInitialized: Boolean;

function A_Documents_Iterator_Create: AInteger; stdcall;
begin
  Result := Documents_Iterator_Create;
end;

function A_Documents_Iterator_Free(Iterator: AInteger): AInteger; stdcall;
begin
  Result := Documents_Iterator_Free(Iterator);
end;

function A_Documents_Iterator_NextDocument(Iterator: AInteger): AInteger; stdcall;
begin
  Result := Documents_Iterator_NextDocument(Iterator);
end;

function A_Documents_LoadFromFile(const FileName: AString_Type): AInteger; stdcall;
begin
  Result := Documents_LoadFromFile(WideString(FileName.Str));
end;

function A_Documents_SaveToFile(const FileName: AString_Type): AInteger; stdcall;
begin
  Result := Documents_SaveToFile(WideString(FileName.Str));
end;

{ Module_Documents }

function Documents_Boot: AInteger; stdcall;
begin
  Documents_SetProcs(Addr(DocumentsProcs));
  Result := ARuntime.Module_Register(Addr(DocumentsModule));
end;

function Documents_Done: AInteger; stdcall;
begin
  FInitialized := False;
  Result := 0;
end;

function Documents_Init: AInteger; stdcall;
var
  Module: AModule_Type;
begin
  if (FInitialized) then
  begin
    Result := 0;
    Exit;
  end;

  if (ARuntime.Modules_GetByUid(Entities_Uid, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  if (Entities_SetProcs(Module.Procs) < 0) then
  begin
    Result := -2;
    Exit;
  end;

  FInitialized := True;
  Result := 0;
end;

initialization
  Documents_SetProcs(Addr(DocumentsProcs));
end.
