{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 15.05.2011
LastMod: 09.06.2011
Version: 0.2.6+0.3.1
}
unit DocumUI;

interface

uses
  Forms, ABase0, ADocuments0, ARuntime0, AUI0, DocumAssistantMainWin;

function DocumUI_Refresh: AInteger; stdcall;

function DocumUI_Boot: AInteger; stdcall;
function DocumUI_Init: AInteger; stdcall;

implementation

{ Events }

{$IFDEF A02}
procedure DoMainFormCreate; stdcall;
begin
  Application.CreateForm(TForm1, Form1);
  UI_MainWindow_Set(AWindow(Form1));
end;
{$ELSE}
function DoMainFormCreate: AInteger; stdcall;
begin
  Application.CreateForm(TForm1, Form1);
  UI_MainWindow_Set(AWindow(Form1));
  Result := 0;
end;
{$ENDIF}

{ DocumUI }

function DocumUI_Refresh: AInteger; stdcall;
var
  DocumIterator: AInteger;
  //Document: AInteger;
begin
  if not(Assigned(Form1)) then
  begin
    Result := -1;
    Exit;
  end;
  Form1.ListBox1.Clear;

  DocumIterator := ADocuments.Iterator_Create;

  {Document := Documents.Iterator_GetNextDocument;
  while (Document > 0) do
  begin
  end;}

  Form1.ListBox1.Items.Add('--- End ---');

  ADocuments.Iterator_Free(DocumIterator);

  Result := 0;
end;

{ Module }

function DocumUI_Boot: AInteger; stdcall;
begin
  Result := 0;
end;

function DocumUI_Init: AInteger; stdcall;
begin
  {$IFDEF A02}
  if (ARuntime.Module_InitByName(Documents_Name) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  {$ELSE}
  if (ARuntime.Modules_InitByUid(Documents_Uid) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  {$ENDIF}

  UI_OnMainFormCreate_Set(DoMainFormCreate);
  Result := 0;
end;

end.
 