{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 08.06.2011
LastMod: 08.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit ACollectionsStringListA;

interface

uses
  ABase0, ACollections0, AStrings0, ACollectionsStringList;

{    .  ,     . }
function A_System_Collection_StringList_Add(StringList: AStringList;
    const Value: AString_Type): AInteger; stdcall;
{   . }
function A_System_Collection_StringList_Clear(StringList: AStringList): AInteger; stdcall;
{       .
  ,      Index  ,  ,  
     . }
function A_System_Collection_StringList_Insert(StringList: AStringList; Index: AInteger;
    Value: AString_Type): AInteger; stdcall;
{  - . }
function A_System_Collection_StringList_New(): AStringList; stdcall;
{    ,    .
  ,     ,    . }
function A_System_Collection_StringList_RemoveAt(StringList: AStringList;
    Index: AInteger): AInteger; stdcall;

implementation

{ A_System_Collection_StringList }

function A_System_Collection_StringList_Add(StringList: AStringList;
    const Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := StringList_AddW(StringList, AStrings.String_ToWideString(Value));
  except
    Result := -1;
  end;
end;

function A_System_Collection_StringList_Clear(StringList: AStringList): AInteger; stdcall;
begin
  try
    StringList_Clear(StringList);
    Result := 0;
  except
    Result := -1;
  end;
end;

function A_System_Collection_StringList_Insert(StringList: AStringList; Index: AInteger;
    Value: AString_Type): AInteger; stdcall;
begin
  try
    StringList_InsertW(StringList, Index, AStrings.String_ToWideString(Value));
    Result := 0;
  except
    Result := -1;
  end;
end;

function A_System_Collection_StringList_New(): AStringList; stdcall;
begin
  try
    Result := StringList_New();
  except
    Result := 0;
  end;
end;

function A_System_Collection_StringList_RemoveAt(StringList: AStringList; Index: AInteger): AInteger; stdcall;
begin
  try
    StringList_Delete(StringList, Index);
    Result := 0;
  except
    Result := -1;
  end;
end;

end.
 