{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 30.09.2009
LastMod: 08.06.2011
Version: 0.2.6+0.3.1
}
unit AUtils0;

interface

uses
  ABase0, ACollections0;

const
  AUtils_Name = {$IFDEF A02}'Utils'{$ELSE}'AUtils'{$ENDIF};
  AUtils_Uid = $09093010;
  AUtils_Version = {$IFDEF A02}$00020600{$ELSE}$00030100{$ENDIF};

// --- Procs type ---

type
  //       -   
  A_Utils_FloatToStr_Proc = function(Value: AFloat): AWideString; stdcall;
  //     (c    )
  A_Utils_FloatToStrA_Proc = function(Value: AFloat; Digits: AInteger = 2): AWideString; stdcall;
  //         (SQL).  SQL   - .
  A_Utils_FloatToStrB_Proc = function(Value: AFloat; Digits: AInteger = 2): AWideString; stdcall;
  A_Utils_FloatToStrC_Proc = function(Value: AFloat; Digits: AInteger = 2): AWideString; stdcall;
  A_Utils_FloatToStrD_Proc = function(Value: AFloat): AWideString; stdcall;
  A_Utils_NormalizeFloat_Proc = function(Value: AFloat): AFloat; stdcall;
  //       #
  A_Utils_NormalizeStr_Proc = function(const Value: AWideString): AWideString; stdcall;
type
  A_Utils_ExtractFileExt_Proc = function(const FileName: AWideString): AWideString; stdcall;
  A_Utils_ExtractFilePath_Proc = function(const FileName: AWideString): AWideString; stdcall;
  A_Utils_FileExists_Proc = function(const FileName: AWideString): ABoolean; stdcall;
  A_Utils_Sleep_Proc = procedure(Milliseconds: AUInt); stdcall;
  A_Utils_Time_Now_Proc = function: TDateTime; stdcall;
  A_Utils_IntToStr_Proc = function(Value: AInteger): AWideString; stdcall;
  A_Utils_StrToFloat_Proc = function(const Value: AWideString): AFloat; stdcall;
  A_Utils_StrToInt_Proc = function(const Value: AWideString): AInteger; stdcall;
  //   Base   Exponent
  A_Utils_Power_Proc = function(Base, Exponent: AFloat): AFloat; stdcall;
  {               .
      DecimalSeparator ,    . }
  A_Utils_ReplaceComma_Proc = function(const S: AWideString; DecimalSeparator: AChar = #0; ClearSpace: ABoolean = True): AWideString; stdcall;
  A_Utils_StrToFloat1_Proc = function(const S: AWideString; DefValue: AFloat = 0): AFloat; stdcall;
  A_Utils_StrToInt1_Proc = function(const S: AWideString; DefValue: AInteger = 0): AInteger; stdcall;
  A_Utils_StrToDate_Proc = function(const Value: AWideString): TDateTime; stdcall;
  A_Utils_TryStrToFloat_Proc = function(const S: AWideString; var Value: AFloat): ABoolean; stdcall;
  A_Utils_TryStrToFloat32_Proc = function(const S: AWideString; var Value: AFloat32): ABoolean; stdcall;
  A_Utils_TryStrToFloat64_Proc = function(const S: AWideString; var Value: AFloat64): ABoolean; stdcall;
  A_Utils_TryStrToDate_Proc = function(const S: AWideString; var Value: TDateTime): ABoolean; stdcall;
  A_Utils_TryStrToInt_Proc = function(const S: AWideString; var Value: AInteger): ABoolean; stdcall;
  A_Utils_Trim_Proc = function(const S: AWideString): AWideString; stdcall;
  A_Utils_UpperString_Proc = function(const S: AWideString): AWideString; stdcall;
type
  A_Utils_FormatFloat_Proc = function(Value: AFloat; Count, Digits: AInteger): AWideString; stdcall;
  A_Utils_FormatInt_Proc = function(Value, Count: AInteger): AWideString; stdcall;
  A_Utils_FormatStr_Proc = function(const Value: AWideString; Len: AInteger): AWideString; stdcall;
{type
  A_Strings_Add_Proc = procedure(Strings: AStringList; const Value: AWideString); stdcall;
  A_Strings_Clear_Proc = procedure(Strings: AStringList); stdcall;}

// --- Procs var ---

{$IFDEF A02}
var
  //Utils_FloatToStr: A_Utils_FloatToStr;
  //Utils_FloatToStrA: A_Utils_FloatToStrA;
  //Utils_FloatToStrB: A_Utils_FloatToStrB;
  //Utils_FloatToStrC: A_Utils_FloatToStrC;
  //Utils_FloatToStrD: A_Utils_FloatToStrD;
  Utils_NormalizeFloat: A_Utils_NormalizeFloat_Proc;
  Utils_NormalizeStr: A_Utils_NormalizeStr_Proc;
var
  Utils_ExtractFileExt: A_Utils_ExtractFileExt_Proc;
  Utils_ExtractFilePath: A_Utils_ExtractFilePath_Proc;
  Utils_FileExists: A_Utils_FileExists_Proc;
  Utils_Sleep: A_Utils_Sleep_Proc;
  Utils_Time_Now: A_Utils_Time_Now_Proc;
  Utils_IntToStr: A_Utils_IntToStr_Proc;
  Utils_StrToFloat: A_Utils_StrToFloat_Proc;
  Utils_StrToInt: A_Utils_StrToInt_Proc;
  Utils_Power: A_Utils_Power_Proc;
  Utils_ReplaceComma: A_Utils_ReplaceComma_Proc;
  Utils_StrToDate: A_Utils_StrToDate_Proc;
  Utils_StrToFloat1: A_Utils_StrToFloat1_Proc;
  Utils_StrToInt1: A_Utils_StrToInt1_Proc;
  Utils_TryStrToFloat: A_Utils_TryStrToFloat_Proc;
  Utils_TryStrToFloat32: A_Utils_TryStrToFloat32_Proc;
  Utils_TryStrToFloat64: A_Utils_TryStrToFloat64_Proc;
  Utils_TryStrToDate: A_Utils_TryStrToDate_Proc;
  Utils_TryStrToInt: A_Utils_TryStrToInt_Proc;
  Utils_Trim: A_Utils_Trim_Proc;
  Utils_UpperString: A_Utils_UpperString_Proc;
var
  Utils_FormatFloat: A_Utils_FormatFloat_Proc;
  Utils_FormatInt: A_Utils_FormatInt_Proc;
  Utils_FormatStr: A_Utils_FormatStr_Proc;
{
var
  Utils_Strings_Add: A_Strings_Add_Proc;
  Utils_Strings_Clear: A_Strings_Clear_Proc;
}
{$ENDIF A02}

// --- Module ---

type
  AUtilsProcs = ^AUtilsProcs_Type;
  AUtilsProcs_Type = packed record {32x4} {64x4}
    FloatToStrA: A_Utils_FloatToStrA_Proc;
    FloatToStrB: A_Utils_FloatToStrB_Proc;
    FloatToStrC: A_Utils_FloatToStrC_Proc;
    FloatToStrD: A_Utils_FloatToStrD_Proc;
    NormalizeFloat: A_Utils_NormalizeFloat_Proc;
    NormalizeStr: A_Utils_NormalizeStr_Proc;

    FileExists: A_Utils_FileExists_Proc;
    Sleep: A_Utils_Sleep_Proc;
    Time_Now: A_Utils_Time_Now_Proc;
    IntToStr: A_Utils_IntToStr_Proc;
    StrToFloat: A_Utils_StrToFloat_Proc;
    StrToInt: A_Utils_StrToInt_Proc;
    ExtractFilePath: A_Utils_ExtractFilePath_Proc;
    Power: A_Utils_Power_Proc;
    ReplaceComma: A_Utils_ReplaceComma_Proc;
    StrToFloat1: A_Utils_StrToFloat1_Proc;
    StrToInt1: A_Utils_StrToInt1_Proc;
    TryStrToFloat: A_Utils_TryStrToFloat_Proc;
    TryStrToFloat32: A_Utils_TryStrToFloat32_Proc;
    TryStrToFloat64: A_Utils_TryStrToFloat64_Proc;
    TryStrToDate: A_Utils_TryStrToDate_Proc;
    TryStrToInt: A_Utils_TryStrToInt_Proc;

    FloatToStr: A_Utils_FloatToStr_Proc;
    Trim: A_Utils_Trim_Proc;
    UpperString: A_Utils_UpperString_Proc;
    ExtractFileExt: A_Utils_ExtractFileExt_Proc;

    FormatFloat: A_Utils_FormatFloat_Proc;
    FormatInt: A_Utils_FormatInt_Proc;
    StrToDate: A_Utils_StrToDate_Proc;

    FormatStr: A_Utils_FormatStr_Proc;

    Reserved30: Integer; //Strings_Add: A_Strings_Add_Proc;
    Reserved31: Integer; //Strings_Clear: A_Strings_Clear_Proc;

    {$IFNDEF A01}
    {$IFNDEF A02}
    Reserved32: Integer;
    Reserved33: Integer;
    Reserved34: Integer;
    Reserved35: Integer;
    Reserved36: Integer;
    Reserved37: Integer;
    Reserved38: Integer;
    Reserved39: Integer;
    Reserved40: Integer;
    Reserved41: Integer;
    Reserved42: Integer;
    Reserved43: Integer;
    Reserved44: Integer;
    Reserved45: Integer;
    Reserved46: Integer;
    Reserved47: Integer;

    Reserved48: Integer;
    Reserved49: Integer;
    Reserved50: Integer;
    Reserved51: Integer;
    Reserved52: Integer;
    Reserved53: Integer;
    Reserved54: Integer;
    Reserved55: Integer;
    Reserved56: Integer;
    Reserved57: Integer;
    Reserved58: Integer;
    Reserved59: Integer;
    Reserved60: Integer;
    Reserved61: Integer;
    Reserved62: Integer;
    Reserved63: Integer;
    {$ENDIF} // A02
    {$ENDIF} // A01
  end;

var
  AUtils: AUtilsProcs_Type;

function Utils_SetProcs(Procs: AUtilsProcs): AInteger;

{ Protected }

function FloatToStrA(Value: AFloat; Digits: Integer = 2): AWideString;
function FloatToStrB(Value: AFloat; Digits: Integer = 2): AWideString;
function FloatToStrC(Value: AFloat; Digits: AInteger = 2): AWideString;
function StrToFloat1(const S: AWideString; DefValue: AFloat = 0): AFloat;
function StrToInt1(const S: AWideString; DefValue: AInteger = 0): AInteger;

function Utils_FloatToStr(Value: AFloat): AWideString;
function Utils_FloatToStrA(Value: AFloat; Digits: Integer = 2): AWideString;
function Utils_FloatToStrB(Value: AFloat; Digits: Integer = 2): AWideString;
function Utils_FloatToStrC(Value: AFloat; Digits: AInteger = 2): AWideString;

implementation

function Utils_SetProcs(Procs: AUtilsProcs): AInteger;
begin
  AUtils := Procs^;

  {$IFDEF A02}
  Utils_NormalizeFloat := AUtils.NormalizeFloat;
  Utils_NormalizeStr := AUtils.NormalizeStr;
  Utils_FileExists := AUtils.FileExists;
  Utils_Sleep := AUtils.Sleep;
  Utils_Time_Now := AUtils.Time_Now;
  Utils_IntToStr := AUtils.IntToStr;
  Utils_StrToFloat := AUtils.StrToFloat;
  Utils_StrToInt := AUtils.StrToInt;
  Utils_ExtractFilePath := AUtils.ExtractFilePath;
  Utils_Power := AUtils.Power;
  Utils_ReplaceComma := AUtils.ReplaceComma;
  Utils_StrToFloat1 := AUtils.StrToFloat1;
  Utils_StrToInt1 := AUtils.StrToInt1;
  Utils_TryStrToFloat := AUtils.TryStrToFloat;
  Utils_TryStrToFloat32 := AUtils.TryStrToFloat32;
  Utils_TryStrToFloat64 := AUtils.TryStrToFloat64;
  Utils_TryStrToDate := AUtils.TryStrToDate;
  Utils_TryStrToInt := AUtils.TryStrToInt;
  //Utils_FloatToStr := AUtils.FloatToStr;
  Utils_Trim := AUtils.Trim;
  Utils_UpperString := AUtils.UpperString;
  Utils_ExtractFileExt := AUtils.ExtractFileExt;
  Utils_FormatFloat := AUtils.FormatFloat;
  Utils_FormatInt := AUtils.FormatInt;
  Utils_StrToDate := AUtils.StrToDate;
  Utils_FormatStr := AUtils.FormatStr;
  {
  Utils_Strings_Add := AUtils.Strings_Add;
  Utils_Strings_Clear := AUtils.Strings_Clear;
  }
  {$ENDIF A02}

  Result := 0;
end;

function FloatToStrA(Value: AFloat; Digits: Integer = 2): AWideString;
begin
  Result := Utils_FloatToStrA(Value, Digits);
end;

function FloatToStrB(Value: AFloat; Digits: Integer = 2): AWideString;
begin
  Result := Utils_FloatToStrB(Value, Digits);
end;

function FloatToStrC(Value: AFloat; Digits: AInteger = 2): AWideString;
begin
  Result := Utils_FloatToStrC(Value, Digits);
end;

function StrToFloat1(const S: AWideString; DefValue: AFloat = 0): AFloat;
begin
  Result := AUtils.StrToFloat1(S, DefValue);
end;

function StrToInt1(const S: AWideString; DefValue: AInteger = 0): AInteger;
begin
  Result := AUtils.StrToInt1(S, DefValue);
end;

function Utils_FloatToStr(Value: AFloat): AWideString;
begin
  Result := AUtils.FloatToStr(Value);
end;

function Utils_FloatToStrA(Value: AFloat; Digits: Integer = 2): AWideString;
begin
  Result := AUtils.FloatToStrA(Value, Digits);
end;

function Utils_FloatToStrB(Value: AFloat; Digits: Integer = 2): AWideString;
begin
  Result := AUtils.FloatToStrB(Value, Digits);
end;

function Utils_FloatToStrC(Value: AFloat; Digits: AInteger = 2): AWideString;
begin
  Result := AUtils.FloatToStrC(Value, Digits);
end;

end.

