{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 27.07.2009
LastMod: 06.06.2011
Version: 0.2.6+0.3.1
}
unit AUISettings0;

{DEFINE A02}
{DEFINE A03}

interface

uses
  ABase0, AUI0;

const
  AUISettings_Name = 'UISettings';
  AUISettings_Uid = $09072701;
  AUISettings_Version = {$IFDEF A02}$00020600{$ELSE}$00030100{$ENDIF};

type
  AUISettingsItem = type Integer;

// --- Procs type ---

type
  AUISettings_MainSettingsWin_Proc = function: AWindow; stdcall;
  AUISettings_SettingsWin_New_Proc = function: AWindow; stdcall;
  AUISettings_ShowSettingsWin_Proc = procedure; stdcall;
  AUISettings_NewItemW_Proc = function(Parent: AUISettingsItem; const Text: AWideString): AUISettingsItem; stdcall;
  AUISettings_Item_GetPage_Proc = function(Item: AUISettingsItem): AControl; stdcall;

// --- Procs var ---

var
  UISettings_MainSettingsWin: AUISettings_MainSettingsWin_Proc;
  UISettings_SettingsWin_New: AUISettings_SettingsWin_New_Proc;
  UISettings_ShowSettingsWin: AUISettings_ShowSettingsWin_Proc;
  UISettings_NewItem: AUISettings_NewItemW_Proc;
  UISettings_Item_GetPage: AUISettings_Item_GetPage_Proc;

// --- Module ---

type
  AUISettingsProcs = ^AUISettingsProcsType;
  { A02: 8x4; A03: 16x4 }
  AUISettingsProcsType = packed record
    MainSettingsWin: AUISettings_MainSettingsWin_Proc;
    SettingsWin_New: AUISettings_SettingsWin_New_Proc;
    ShowSettingsWin: AUISettings_ShowSettingsWin_Proc;
    NewItem: AUISettings_NewItemW_Proc;
    Item_GetPage: AUISettings_Item_GetPage_Proc;
    Reserved05: Integer;
    Reserved06: Integer;
    Reserved07: Integer;
    {$IFNDEF A02}
    Reserved08: AInteger;
    Reserved09: AInteger;
    Reserved10: AInteger;
    Reserved11: AInteger;
    Reserved12: AInteger;
    Reserved13: AInteger;
    Reserved14: AInteger;
    Reserved15: AInteger;
    {$ENDIF}
  end;

var
  UISettings: AUISettingsProcsType;

procedure UISettings_SetProcs(Procs: AUISettingsProcs);

implementation

procedure UISettings_SetProcs(Procs: AUISettingsProcs);
begin
  UISettings := Procs^;
  UISettings_MainSettingsWin := UISettings.MainSettingsWin;
  UISettings_SettingsWin_New := UISettings.SettingsWin_New;
  UISettings_ShowSettingsWin := UISettings.ShowSettingsWin;
  UISettings_NewItem := UISettings.NewItem;
  UISettings_Item_GetPage := UISettings.Item_GetPage;
end;

end.
 
