{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 08.06.2011
Version: 0.3.1
}
unit ASystem0;

{$IFDEF A02}
  {$MESSAGE A03 only}
{$ENDIF}

interface

uses
  ABase0{, ARuntime0, AStrings0};

const
  ASystem_Name = 'ASystem';
  ASystem_Uid = $11051501;
  ASystem_Version = $00030100;

// --- Types ---------------------------------------------------------------------------------------

// --- Procs ---------------------------------------------------------------------------------------

type // --- My.Application.Info functions ---
  A_Application_DataPath_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_DirectoryPath_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_ExeName_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_Info_CompanyName_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_Info_Copyright_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_Info_Description_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_Info_Name_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_Info_ProductName_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_Info_ProductVersion_Proc = function: AVersion; stdcall;
  A_Application_Info_Version_Proc = function: AVersion; stdcall;
  A_Application_Info_Title_Proc = function(out Value: AString_Type): AInteger; stdcall;
  A_Application_Info_Url_Proc = function(out Value: AString_Type): AInteger; stdcall;

type // --- Info functions (Old) ---
  A_Runtime_GetCompanyName_Proc = function: AWideString; stdcall;
  A_Runtime_GetCopyright_Proc = function: AWideString; stdcall;
  A_Runtime_GetDataPath_Proc = function: AWideString; stdcall;
  A_Runtime_GetDescription_Proc = function: AWideString; stdcall;
  A_Runtime_GetExeName_Proc = function: AWideString; stdcall;
  A_Runtime_GetExePath_Proc = function: AWideString; stdcall;
  A_Runtime_GetProductName_Proc = function: AWideString; stdcall;
  A_Runtime_GetProductVersion_Proc = function: AWideString; stdcall;
  A_Runtime_GetProgramName_Proc = function: AWideString; stdcall;
  A_Runtime_GetProgramVersion_Proc = function: AWideString; stdcall;
  A_Runtime_GetTitle_Proc = function: AWideString; stdcall;
  A_Runtime_GetUrl_Proc = function: AWideString; stdcall;

type
  A_System_GetConfig_Proc = function: AConfig; stdcall;
  A_System_GetResourceString_Proc = function(const Section, Name, Default: AString_Type; out Value: AString_Type): AInteger; stdcall;
  A_System_ProcessMessages_Proc = procedure; stdcall;
  A_System_SetConfig_Proc = procedure(Value: AConfig); stdcall;
  A_System_ShowError_Proc = procedure(const UserMessage, ExceptMessage: AString_Type); stdcall;
  A_System_ShowMessage_Proc = function(const Msg: AString_Type): ADialogBoxCommands; stdcall;
  A_System_ShowMessageA_Proc = function(const Text, Caption: AString_Type; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
  A_System_Shutdown_Proc = procedure; stdcall;

type // --- (Old) ---
  A_Runtime_GetConfig_Proc = function: AConfig; stdcall;
  A_Runtime_GetResourceString_Proc = function(const Section, Name, Default: AWideString): AWideString; stdcall;
  A_Runtime_ProcessMessages_Proc = procedure; stdcall;
  A_Runtime_SetConfig_Proc = procedure(Value: AConfig); stdcall;
  A_Runtime_ShowError_Proc = procedure(const UserMessage, ExceptMessage: AWideString); stdcall;
  A_Runtime_ShowMessage_Proc = function(const Msg: AWideString): ADialogBoxCommands; stdcall;
  A_Runtime_ShowMessageA_Proc = function(const Text, Caption: AWideString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;

type // --- Set event functions ---
  A_Runtime_SetOnProcessMessages_Proc = procedure(Value: AProc); stdcall;
  A_Runtime_SetOnShowError_Proc = procedure(Value: TAShowErrorProc); stdcall;
  A_Runtime_SetOnShowMessage_Proc = procedure(Value: TAShowMessageProc); stdcall;

type // --- Events and tools ---
  A_Runtime_OnAfterRun_Proc = function: AEvent; stdcall;
  A_Runtime_OnBeforeRun_Proc = function: AEvent; stdcall;
  A_Runtime_OnAfterRunConnect_Proc = function(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): Integer; stdcall;
  A_Runtime_OnAfterRunDisconnect_Proc = function(Callback: ACallbackProc): AInteger; stdcall;
  A_Runtime_OnBeforeRunConnect_Proc = function(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
  A_Runtime_OnBeforeRunDisconnect_Proc = function(Callback: ACallbackProc): AInteger; stdcall;

type // --- (Old) ---
  A_Runtime_ParamStr_Proc = function(Index: AInteger): AWideString; stdcall;
  A_Runtime_ShellExecute_Proc = function(const Operation, FileName, Parameters, Directory: AWideString): AInteger; stdcall;

type
  A_System_ParamStr_Proc = function(Index: AInteger; out Value: AString_Type): AInteger; stdcall;
  A_System_ShellExecute_Proc = function(const Operation, FileName, Parameters, Directory: AString_Type): AInteger; stdcall;
  A_System_PrepareW_Proc = procedure(const Title, ProgramName: AWideString; ProgramVersion: AVersion;
    ProductName: AWideString; ProductVersion: AVersion;
    CompanyName, Copyright, Url, Description, DataPath: AWideString); stdcall;

type
  {   ().  . }
  A_Library_OpenW_Proc = function(const FileName: AWideString; Flags: ALibraryFlags): ALibrary; stdcall;
  {   () }
  A_Library_Close_Proc = function(Lib: ALibrary): ABoolean; stdcall;
  A_Library_BuildPathW_Proc = function(const Directory, LibraryName: AWideString): AWideString; stdcall;
  A_Library_GetNameW_Proc = function(Lib: ALibrary): AWideString; stdcall;
  {    }
  A_Library_GetProcAddressW_Proc = function(Lib: ALibrary; const Name: AWideString): Pointer; stdcall;
  A_Library_GetSymbolW_Proc = function(Lib: ALibrary; const SymbolName: AWideString; var Symbol: Pointer): ABoolean; stdcall;

{
type
  A_System_String_NewC_Proc = function(Value: PChar): AString; stdcall;
  A_System_String_Free_Proc = function(S: AString): AInteger; stdcall;
  //  True,    (Length=0)
  A_System_String_IsEmpty_Proc = function(S: AString): ABoolean; stdcall;
  //  -   
  A_System_String_Length_Proc = function(S: AString): AInteger; stdcall;
  A_System_String_Compare_Proc = function(Str1, Str2: AString): AInteger; stdcall;
  A_System_String_CompareA_Proc = function(Str1, Str2: AString; IgnoreCase: ABoolean): AInteger; stdcall;
  A_System_String_Concat_Proc = function(Str1, Str2: AString): AString; stdcall;
  A_System_String_ConcatA_Proc = function(Str1, Str2, Str3: AString): AString; stdcall;
  A_System_String_IndexOfCh_Proc = function(S: AString; Ch: AChar): AInteger; stdcall;
  A_System_String_IndexOfStr_Proc = function(S, Str: AString): AInteger; stdcall;
  A_System_String_LastIndexOfCh_Proc = function(S: AString; Ch: AChar): AInteger; stdcall;
  A_System_String_LastIndexOfStr_Proc = function(S, Str: AString): AInteger; stdcall;
}

// --- Functions var -------------------------------------------------------------------------------

{IFDEF A02}
var // --- Info functions (Old) ---
  Runtime_GetCompanyName: A_Runtime_GetCompanyName_Proc;
  Runtime_GetCopyright: A_Runtime_GetCopyright_Proc;
  Runtime_GetDataPath: A_Runtime_GetDataPath_Proc;
  Runtime_GetDescription: A_Runtime_GetDescription_Proc;
  Runtime_GetExeName: A_Runtime_GetExeName_Proc;
  Runtime_GetExePath: A_Runtime_GetExePath_Proc;
  Runtime_GetProductName: A_Runtime_GetProductName_Proc;
  Runtime_GetProductVersion: A_Runtime_GetProductVersion_Proc;
  Runtime_GetProgramName: A_Runtime_GetProgramName_Proc;
  Runtime_GetProgramVersion: A_Runtime_GetProgramVersion_Proc;
  Runtime_GetTitle: A_Runtime_GetTitle_Proc;
  Runtime_GetUrl: A_Runtime_GetUrl_Proc;

var // --- (Old) ---
  Runtime_GetConfig: A_Runtime_GetConfig_Proc;
  Runtime_GetResourceString: A_Runtime_GetResourceString_Proc;
  Runtime_ProcessMessages: A_Runtime_ProcessMessages_Proc;
  Runtime_SetConfig: A_Runtime_SetConfig_Proc;
  Runtime_ShowError: A_Runtime_ShowError_Proc;
  Runtime_ShowMessage: A_Runtime_ShowMessage_Proc;
  Runtime_ShowMessageA: A_Runtime_ShowMessageA_Proc;

var // --- Set event functions (Old) ---
  Runtime_SetOnProcessMessages: A_Runtime_SetOnProcessMessages_Proc;
  Runtime_SetOnShowError: A_Runtime_SetOnShowError_Proc;
  Runtime_SetOnShowMessage: A_Runtime_SetOnShowMessage_Proc;

var // --- Events and tools (Old) ---
  Runtime_OnAfterRun: A_Runtime_OnAfterRun_Proc;
  Runtime_OnBeforeRun: A_Runtime_OnBeforeRun_Proc;
  Runtime_OnAfterRun_Connect: A_Runtime_OnAfterRunConnect_Proc;
  Runtime_OnAfterRun_Disconnect: A_Runtime_OnAfterRunDisconnect_Proc;
  Runtime_OnBeforeRun_Connect: A_Runtime_OnBeforeRunConnect_Proc;
  Runtime_OnBeforeRun_Disconnect: A_Runtime_OnBeforeRunDisconnect_Proc;
var // --- (Old) ---
  Runtime_ParamStr: A_Runtime_ParamStr_Proc;
  Runtime_ShellExecute: A_Runtime_ShellExecute_Proc;
{ENDIF A02}

// -------------------------------------------------------------------------------------------------

{
type
  ASystemString_Procs = packed record // (32x4)
    NewC: A_System_String_NewC_Proc;
    Free: A_System_String_Free_Proc;
    IsEmpty: A_System_String_IsEmpty_Proc;
    Length: A_System_String_Length_Proc;
    Compare: A_System_String_Compare_Proc;
    CompareA: A_System_String_CompareA_Proc;
    Concat: A_System_String_Concat_Proc;
    ConcatA: A_System_String_Concat_Proc;
    IndexOfCh: A_System_String_IndexOfCh_Proc;
    IndexOfStr: A_System_String_IndexOfStr_Proc;
    LastIndexOfCh: A_System_String_LastIndexOfCh_Proc;
    LastIndexOfStr: A_System_String_LastIndexOfStr_Proc;
    Reserved12: AInteger;
    Reserved13: AInteger;
    Reserved14: AInteger;
    Reserved15: AInteger;
    Reserved16: AInteger;
    Reserved17: AInteger;
    Reserved18: AInteger;
    Reserved19: AInteger;
    Reserved20: AInteger;
    Reserved21: AInteger;
    Reserved22: AInteger;
    Reserved23: AInteger;
    Reserved24: AInteger;
    Reserved25: AInteger;
    Reserved26: AInteger;
    Reserved27: AInteger;
    Reserved28: AInteger;
    Reserved29: AInteger;
    Reserved30: AInteger;
    Reserved31: AInteger;
  end;
}

type
  ASystemProcs = ^ASystemProcs_Type;
  ASystemProcs_Type = packed record // ( 128x4 = 512 bytes )
    // --- Info functions (Old) ---
    GetCompanyName: A_Runtime_GetCompanyName_Proc;
    GetCopyright: A_Runtime_GetCopyright_Proc;
    GetDescription: A_Runtime_GetDescription_Proc;
    GetExeName: A_Runtime_GetExeName_Proc;
    GetExePath: A_Runtime_GetExePath_Proc;
    GetProductName: A_Runtime_GetProductName_Proc;
    GetProductVersion: A_Runtime_GetProductVersion_Proc;
    GetProgramName: A_Runtime_GetProgramName_Proc;
    GetProgramVersion: A_Runtime_GetProgramVersion_Proc;
    GetTitle: A_Runtime_GetTitle_Proc;
    GetUrl: A_Runtime_GetUrl_Proc;

    // --- (Old) ---
    GetConfig: A_Runtime_GetConfig_Proc;
    GetResourceString: A_Runtime_GetResourceString_Proc;
    ProcessMessages: A_Runtime_ProcessMessages_Proc;
    SetConfig: A_Runtime_SetConfig_Proc;
    ShowError: A_Runtime_ShowError_Proc;
    ShowMessage: A_Runtime_ShowMessage_Proc; {16}
    ShowMessageA: A_Runtime_ShowMessageA_Proc;
    Reserved: AInteger; //Shutdown: A_Runtime_Shutdown_Proc;

    // --- Set event functions ---
    SetOnProcessMessages: A_Runtime_SetOnProcessMessages_Proc;
    SetOnShowError: A_Runtime_SetOnShowError_Proc;
    SetOnShowMessage: A_Runtime_SetOnShowMessage_Proc;

    // --- Events and tools ---
    OnAfterRun: A_Runtime_OnAfterRun_Proc;
    OnBeforeRun: A_Runtime_OnBeforeRun_Proc;
    OnAfterRun_Connect: A_Runtime_OnAfterRunConnect_Proc;
    OnAfterRun_Disconnect: A_Runtime_OnAfterRunDisconnect_Proc;
    OnBeforeRun_Connect: A_Runtime_OnBeforeRunConnect_Proc;
    OnBeforeRun_Disconnect: A_Runtime_OnBeforeRunDisconnect_Proc;

    // --- (Old) ---
    ParamStr: A_Runtime_ParamStr_Proc;
    ShellExecute: A_Runtime_ShellExecute_Proc;
    GetDataPath: A_Runtime_GetDataPath_Proc;

    // --- Application.Info (V03) ---
    Application_DataPath: A_Application_DataPath_Proc;
    Application_DirectoryPath: A_Application_DirectoryPath_Proc; {32}
    Application_ExeName: A_Application_ExeName_Proc;
    Application_Info_CompanyName: A_Application_Info_CompanyName_Proc;
    Application_Info_Copyright: A_Application_Info_Copyright_Proc;
    Application_Info_Description: A_Application_Info_Description_Proc;
    Application_Info_ProductName: A_Application_Info_ProductName_Proc;
    Application_Info_ProductVersion: A_Application_Info_ProductVersion_Proc;
    Application_Info_Name: A_Application_Info_Name_Proc;
    Application_Info_Version: A_Application_Info_Version_Proc;
    Application_Info_Title: A_Application_Info_Title_Proc;
    Application_Info_Url: A_Application_Info_Url_Proc;

    PrepareW: A_System_PrepareW_Proc; //Reserved43: AInteger;

    Library_OpenW: A_Library_OpenW_Proc; //Reserved44: AInteger;
    Library_Close: A_Library_Close_Proc; //Reserved45: AInteger;
    Library_BuildPathW: A_Library_BuildPathW_Proc; //Reserved46: AInteger;
    Library_GetNameW: A_Library_GetNameW_Proc; //Reserved47: AInteger;
    Library_GetProcAddressW: A_Library_GetProcAddressW_Proc; {48} //Reserved48: AInteger;
    Library_GetSymbolW: A_Library_GetSymbolW_Proc; //Reserved49: AInteger;

    Reserved50: AInteger;
    Reserved51: AInteger;
    Reserved52: AInteger;
    Reserved53: AInteger;
    Reserved54: AInteger;
    Reserved55: AInteger;
    Reserved56: AInteger;
    Reserved57: AInteger;
    Reserved58: AInteger;
    Reserved59: AInteger;
    Reserved60: AInteger;
    Reserved61: AInteger;
    Reserved62: AInteger;
    Reserved63: AInteger;
    Reserved64: AInteger; {64}
    Reserved65: AInteger;
    Reserved66: AInteger;
    Reserved67: AInteger;
    Reserved68: AInteger;
    Reserved69: AInteger;
    Reserved70: AInteger;
    Reserved71: AInteger;
    Reserved72: AInteger;
    Reserved73: AInteger;
    Reserved74: AInteger;
    Reserved75: AInteger;
    Reserved76: AInteger;
    Reserved77: AInteger;
    Reserved78: AInteger;
    Reserved79: AInteger;
    Reserved80: AInteger; {80}
    Reserved81: AInteger;
    Reserved82: AInteger;
    Reserved83: AInteger;
    Reserved84: AInteger;
    Reserved85: AInteger;
    Reserved86: AInteger;
    Reserved87: AInteger;
    Reserved88: AInteger;
    Reserved89: AInteger;
    Reserved90: AInteger;
    Reserved91: AInteger;
    Reserved92: AInteger;
    Reserved93: AInteger;
    Reserved94: AInteger;
    Reserved95: AInteger;
    Reserved96: AInteger; {96}
    Reserved97: AInteger;
    Reserved98: AInteger;
    Reserved99: AInteger;
    Reserved100: AInteger;
    Reserved101: AInteger;
    Reserved102: AInteger;
    Reserved103: AInteger;
    Reserved104: AInteger;
    Reserved105: AInteger;
    Reserved106: AInteger;
    Reserved107: AInteger;
    Reserved108: AInteger;
    Reserved109: AInteger;
    Reserved110: AInteger;
    Reserved111: AInteger;
    Reserved112: AInteger; {112}
    Reserved113: AInteger;
    Reserved114: AInteger;
    Reserved115: AInteger;
    Reserved116: AInteger;
    Reserved117: AInteger;
    Reserved118: AInteger;
    Reserved119: AInteger;
    Reserved120: AInteger;
    Reserved121: AInteger;
    Reserved122: AInteger;
    Reserved123: AInteger;
    Reserved124: AInteger;
    Reserved125: AInteger;
    Reserved126: AInteger;
    Reserved127: AInteger;
  end;

var
  ASystem: ASystemProcs_Type;

function System_SetProcs(Procs: ASystemProcs): AInteger;

implementation

function System_SetProcs(Procs: ASystemProcs): AInteger;
begin
  if not(Assigned(Procs)) then
  begin
    Result := -1;
    Exit;
  end;
  ASystem := Procs^;

  {IFDEF A02}
  Runtime_GetCompanyName := ASystem.GetCompanyName;
  Runtime_GetCopyright := ASystem.GetCopyright;
  Runtime_GetDescription := ASystem.GetDescription;
  Runtime_GetExeName := ASystem.GetExeName;
  Runtime_GetExePath := ASystem.GetExePath;
  Runtime_GetProductName := ASystem.GetProductName;
  Runtime_GetProductVersion := ASystem.GetProductVersion;
  Runtime_GetProgramName := ASystem.GetProgramName;
  Runtime_GetProgramVersion := ASystem.GetProgramVersion;
  Runtime_GetTitle := ASystem.GetTitle;
  Runtime_GetUrl := ASystem.GetUrl;

  Runtime_GetConfig := ASystem.GetConfig;
  Runtime_GetResourceString := ASystem.GetResourceString;
  Runtime_ProcessMessages := ASystem.ProcessMessages;
  Runtime_SetConfig := ASystem.SetConfig;
  Runtime_ShowError := ASystem.ShowError;
  Runtime_ShowMessage := ASystem.ShowMessage;
  Runtime_ShowMessageA := ASystem.ShowMessageA;

  Runtime_SetOnProcessMessages := ASystem.SetOnProcessMessages;
  Runtime_SetOnShowError := ASystem.SetOnShowError;
  Runtime_SetOnShowMessage := ASystem.SetOnShowMessage;

  Runtime_OnAfterRun := ASystem.OnAfterRun;
  Runtime_OnBeforeRun := ASystem.OnBeforeRun;
  Runtime_OnAfterRun_Connect := ASystem.OnAfterRun_Connect;
  Runtime_OnAfterRun_Disconnect := ASystem.OnAfterRun_Disconnect;
  Runtime_OnBeforeRun_Connect := ASystem.OnBeforeRun_Connect;
  Runtime_OnBeforeRun_Disconnect := ASystem.OnBeforeRun_Disconnect;

  Runtime_ParamStr := ASystem.ParamStr;
  Runtime_ShellExecute := ASystem.ShellExecute;
  Runtime_GetDataPath := ASystem.GetDataPath;
  {ENDIF A02}

  Result := 0;
end;

end.
