{
Abstract:     
Author:  Prof1983 <prof1983@yandex.ru>
Created: 23.07.2010
LastMod: 06.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit ASettings0;

{DEFINE A02}

interface

uses
  ABase0, ACollections0{  AStringList };

const
  ASettings_Name = 'Settings';

  ASettings_Uid = $10072301;

  ASettings_Version = {$IFDEF A02}$00020600{$ELSE}$00030100{$ENDIF};


// --- Procs type ---

type
  ASettings_Close = procedure(Config: AConfig); stdcall;
  // --- A02 ---
  ASettings_DeleteKey = function(Config: AConfig; const Section, Name: AWideString): ABoolean; stdcall;
  ASettings_DeleteSection = function(Config: AConfig; const Section: AWideString): ABoolean; stdcall;
  ASettings_IniConfig_New = function(const FileName: AWideString): AConfig; stdcall;
  ASettings_ReadBool = function(Config: AConfig; const Section, Name: AWideString; DefValue: ABoolean): ABoolean; stdcall;
  ASettings_ReadInteger = function(Config: AConfig; const Section, Name: AWideString; DefValue: AInteger): AInteger; stdcall;
  ASettings_ReadFloat = function(Config: AConfig; const Section, Name: AWideString; DefValue: AFloat): AFloat; stdcall;
  ASettings_ReadSection = function(Config: AConfig; const Section: AWideString; Strings: AStringList): ABoolean; stdcall;
  ASettings_ReadString = function(Config: AConfig; const Section, Name, DefValue: AWideString): AWideString; stdcall;
  ASettings_ReadDateTime = function(Config: AConfig; const Section, Name: AWideString; DefValue: TDateTime): TDateTime; stdcall;
  ASettings_RegConfig_New = function(const Prefix: AWideString): AConfig; stdcall;
  ASettings_RegConfig_NewA = function(const Prefix: AWideString; HKEY: Integer): AConfig; stdcall;
  ASettings_WriteBool = function(Config: AConfig; const Section, Name: AWideString; Value: Boolean): ABoolean; stdcall;
  ASettings_WriteInteger = function(Config: AConfig; const Section, Name: AWideString; Value: Integer): ABoolean; stdcall;
  ASettings_WriteFloat = function(Config: AConfig; const Section, Name: AWideString; Value: AFloat): ABoolean; stdcall;
  ASettings_WriteString = function(Config: AConfig; const Section, Name, Value: AWideString): ABoolean; stdcall;
  ASettings_WriteDateTime = function(Config: AConfig; const Section, Name: AWideString; Value: TDateTime): ABoolean; stdcall;
  // --- A03 ---
  A_Settings_DeleteKey = function(Config: AConfig; const Section, Name: AString_Type): ABoolean; stdcall;
  A_Settings_DeleteSection = function(Config: AConfig; const Section: AString_Type): ABoolean; stdcall;
  A_Settings_IniConfig_New = function(const FileName: AString_Type): AConfig; stdcall;
  A_Settings_ReadBool = function(Config: AConfig; const Section, Name: AString_Type; DefValue: ABoolean): ABoolean; stdcall;
  A_Settings_ReadInteger = function(Config: AConfig; const Section, Name: AString_Type; DefValue: AInteger): AInteger; stdcall;
  A_Settings_ReadFloat = function(Config: AConfig; const Section, Name: AString_Type; DefValue: AFloat): AFloat; stdcall;
  A_Settings_ReadSection = function(Config: AConfig; const Section: AString_Type; Strings: AStringList): ABoolean; stdcall;
  A_Settings_ReadString = function(Config: AConfig; const Section, Name, DefValue: AString_Type; out Value: AString_Type): AInteger; stdcall;
  A_Settings_ReadDateTime = function(Config: AConfig; const Section, Name: AString_Type; DefValue: TDateTime): TDateTime; stdcall;
  A_Settings_RegConfig_New = function(const Prefix: AString_Type): AConfig; stdcall;
  A_Settings_RegConfig_NewA = function(const Prefix: AString_Type; HKEY: Integer): AConfig; stdcall;
  A_Settings_WriteBool = function(Config: AConfig; const Section, Name: AString_Type; Value: Boolean): ABoolean; stdcall;
  A_Settings_WriteInteger = function(Config: AConfig; const Section, Name: AString_Type; Value: Integer): ABoolean; stdcall;
  A_Settings_WriteFloat = function(Config: AConfig; const Section, Name: AString_Type; Value: AFloat): ABoolean; stdcall;
  A_Settings_WriteString = function(Config: AConfig; const Section, Name, Value: AString_Type): ABoolean; stdcall;
  A_Settings_WriteDateTime = function(Config: AConfig; const Section, Name: AString_Type; Value: TDateTime): ABoolean; stdcall;

// --- Procs var ---

// - A02 -
var
  Settings_Close: ASettings_Close;
  Settings_DeleteKey: ASettings_DeleteKey;
  Settings_DeleteSection: ASettings_DeleteSection;
  Settings_IniConfig_New: ASettings_IniConfig_New;
  Settings_ReadBool: ASettings_ReadBool;
  Settings_ReadInteger: ASettings_ReadInteger;
  Settings_ReadFloat: ASettings_ReadFloat;
  Settings_ReadSection: ASettings_ReadSection;
  Settings_ReadString: ASettings_ReadString;
  Settings_ReadDateTime: ASettings_ReadDateTime;
  Settings_RegConfig_New: ASettings_RegConfig_New;
  Settings_RegConfig_NewA: ASettings_RegConfig_NewA;
  Settings_WriteBool: ASettings_WriteBool;
  Settings_WriteInteger: ASettings_WriteInteger;
  Settings_WriteFloat: ASettings_WriteFloat;
  Settings_WriteString: ASettings_WriteString;
  Settings_WriteDateTime: ASettings_WriteDateTime;

// --- Module ---

type
  ASettingsProcs = ^ASettingsProcs_Type;
  ASettingsProcs_Type = packed record { A02: 32x4; A03: 64x4 }
    Close: ASettings_Close;
    DeleteKeyW: ASettings_DeleteKey;
    DeleteSectionW: ASettings_DeleteSection;
    IniConfig_NewW: ASettings_IniConfig_New;
    ReadBoolW: ASettings_ReadBool;
    ReadIntegerW: ASettings_ReadInteger;
    ReadFloatW: ASettings_ReadFloat;
    ReadSectionW: ASettings_ReadSection;
    ReadStringW: ASettings_ReadString;
    ReadDateTimeW: ASettings_ReadDateTime;
    RegConfig_NewW: ASettings_RegConfig_New;
    RegConfig_NewAW: ASettings_RegConfig_NewA;
    WriteBoolW: ASettings_WriteBool;
    WriteIntegerW: ASettings_WriteInteger;
    WriteFloatW: ASettings_WriteFloat;
    WriteStringW: ASettings_WriteString;
    WriteDateTimeW: ASettings_WriteDateTime;

    {$IFDEF A02}
    Reserved17: Integer;
    Reserved18: Integer;
    Reserved19: Integer;
    Reserved20: Integer;
    Reserved21: Integer;
    Reserved22: Integer;
    Reserved23: Integer;
    Reserved24: Integer;
    Reserved25: Integer;
    Reserved26: Integer;
    Reserved27: Integer;
    Reserved28: Integer;
    Reserved29: Integer;
    Reserved30: Integer;
    Reserved31: Integer;
    {$ELSE}
    // --- A03 ---
    DeleteKey: A_Settings_DeleteKey;
    DeleteSection: A_Settings_DeleteSection;
    IniConfig_New: A_Settings_IniConfig_New;
    ReadBool: A_Settings_ReadBool;
    ReadInteger: A_Settings_ReadInteger;
    ReadFloat: A_Settings_ReadFloat;
    ReadSection: A_Settings_ReadSection;
    ReadString: A_Settings_ReadString;
    ReadDateTime: A_Settings_ReadDateTime;
    RegConfig_New: A_Settings_RegConfig_New;
    RegConfig_NewA: A_Settings_RegConfig_NewA;
    WriteBool: A_Settings_WriteBool;
    WriteInteger: A_Settings_WriteInteger;
    WriteFloat: A_Settings_WriteFloat;
    WriteString: A_Settings_WriteString;
    {$ENDIF}

    {$IFNDEF A02}
    // --- A03 ---
    WriteDateTime: A_Settings_WriteDateTime;
    Reserved33: AInteger;
    Reserved34: AInteger;
    Reserved35: AInteger;
    Reserved36: AInteger;
    Reserved37: AInteger;
    Reserved38: AInteger;
    Reserved39: AInteger;
    Reserved40: AInteger;
    Reserved41: AInteger;
    Reserved42: AInteger;
    Reserved43: AInteger;
    Reserved44: AInteger;
    Reserved45: AInteger;
    Reserved46: AInteger;
    Reserved47: AInteger;

    Reserved48: AInteger;
    Reserved49: AInteger;
    Reserved50: AInteger;
    Reserved51: AInteger;
    Reserved52: AInteger;
    Reserved53: AInteger;
    Reserved54: AInteger;
    Reserved55: AInteger;
    Reserved56: AInteger;
    Reserved57: AInteger;
    Reserved58: AInteger;
    Reserved59: AInteger;
    Reserved60: AInteger;
    Reserved61: AInteger;
    Reserved62: AInteger;
    Reserved63: AInteger;
    {$ENDIF}
  end;

function Settings_SetProcs(Procs: ASettingsProcs): AInteger;

var
  Settings: ASettingsProcs_Type;

implementation

function Settings_SetProcs(Procs: ASettingsProcs): AInteger;
begin
  if not(Assigned(Procs)) then
  begin
    FillChar(Settings, SizeOf(Settings), 0);
    Result := -1;
    Exit;
  end;
  Settings := Procs^;

  // - A02 -
  Settings_Close := Settings.Close;
  Settings_DeleteKey := Settings.DeleteKeyW;
  Settings_DeleteSection := Settings.DeleteSectionW;
  Settings_IniConfig_New := Settings.IniConfig_NewW;
  Settings_ReadBool := Settings.ReadBoolW;
  Settings_ReadInteger := Settings.ReadIntegerW;
  Settings_ReadFloat := Settings.ReadFloatW;
  Settings_ReadSection := Settings.ReadSectionW;
  Settings_ReadString := Settings.ReadStringW;
  Settings_ReadDateTime := Settings.ReadDateTimeW;
  Settings_RegConfig_New := Settings.RegConfig_NewW;
  Settings_RegConfig_NewA := Settings.RegConfig_NewAW;
  Settings_WriteBool := Settings.WriteBoolW;
  Settings_WriteInteger := Settings.WriteIntegerW;
  Settings_WriteFloat := Settings.WriteFloatW;
  Settings_WriteString := Settings.WriteStringW;
  Settings_WriteDateTime := Settings.WriteDateTimeW;

  Result := 0;
end;

end.
