{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 08.06.2011
Version: 0.3.1
}
unit ARuntime0;

interface

uses
  ABase0;

// --- Types ---------------------------------------------------------------------------------------

type
  AModuleInitProc = AProc;
  AModuleDoneProc = AProc;

type // Module description
  AModuleDescription = Pointer;

type
  {   .
       $YYMMDDxx,  YY - , MM-, DD-, xx-  }
  AModuleUid = type AInteger;

type // Module (8x4)
  AModule = ^AModule_Type;
  AModule_Type = packed record
    Version: AVersion;         // Module version ($AABBCCDD). AA=00h, BB=03h.
    Uid: AModuleUid;           // Module unique identificator $YYMMDDxx YY - Year, MM - Month, DD - Day
    Name: PChar;               // Module unuque name
    Description: AModuleDescription; // Module information and description
    Init: AModuleInitProc;     // Init proc
    Done: AModuleDoneProc;     // Done proc
    Reserved06: AInteger;      //Delete: AModuleDeleteProc;
    Procs: Pointer;
  end;

type
  ARuntimeProc = AProc;

// --- Runtime proc types --------------------------------------------------------------------------

type
  A_Runtime_IsShutdown_Proc = function: ABoolean; stdcall;
  A_Runtime_Shutdown_Proc = function: AInteger; stdcall;

type // --- Set event functions ---
  A_Runtime_OnRun_Set_Proc = procedure(Value: ARuntimeProc); stdcall;
  A_Runtime_OnShutdown_Set_Proc = procedure(Value: ARuntimeProc); stdcall;
  A_Runtime_OnAfterRun_Set_Proc = procedure(Value: ARuntimeProc); stdcall;
  A_Runtime_OnBeforeRun_Set_Proc = procedure(Value: ARuntimeProc); stdcall;

type // Runtime.Module
  A_Runtime_Module_Register_Proc = function(Module: AModule): AInteger; stdcall;

type // Runtime.Modules
  A_Runtime_Modules_AddModule_Proc = function(Module: AModule): AInteger; stdcall;
  A_Runtime_Modules_Count_Proc = function: AInteger; stdcall;
  A_Runtime_Modules_DeleteByName_Proc = function(Name: PChar): AInteger; stdcall;
  A_Runtime_Modules_DeleteByUid_Proc = function(Uid: AModuleUid): AInteger; stdcall;
  A_Runtime_Modules_FindByName_Proc = function(Name: PChar): AInteger; stdcall;
  A_Runtime_Modules_FindByUid_Proc = function(Uid: AModuleUid): AInteger; stdcall;
  A_Runtime_Modules_GetByName_Proc = function(Name: PChar; Module: AModule): AInteger; stdcall;
  //       -1   .
  A_Runtime_Modules_GetByUid_Proc = function(Uid: AModuleUid; Module: AModule): AInteger; stdcall;
  {    . :
    0 -   , >0 -  , <0 -     }
  A_Runtime_Modules_InitByName_Proc = function(Name: PChar): AInteger; stdcall;
  {     . :
    0 -   , >0 -  , <0 -     }
  A_Runtime_Modules_InitByUid_Proc = function(Uid: AModuleUid): AInteger; stdcall;
  A_Runtime_Modules_GetNameByIndex_Proc = function(Index: AInteger; Name: PChar; MaxLen: AInteger): AInteger; stdcall;
  A_Runtime_Modules_GetProcsByUid_Proc = function(Uid: AModuleUid): Pointer; stdcall;
  A_Runtime_Modules_GetUidByIndex_Proc = function(Index: AInteger): AModuleUid; stdcall;

// -------------------------------------------------------------------------------------------------

type
  ARuntimeProcs = ^ARuntimeProcs_Type;
  ARuntimeProcs_Type = packed record {64x4}
    // --- Set event functions ---
    OnAfterRun_Set: A_Runtime_OnAfterRun_Set_Proc;
    OnBeforeRun_Set: A_Runtime_OnBeforeRun_Set_Proc;
    OnRun_Set: A_Runtime_OnRun_Set_Proc;
    OnShutdown_Set: A_Runtime_OnShutdown_Set_Proc;

    Modules_AddModule: A_Runtime_Modules_AddModule_Proc;
    Modules_Count: A_Runtime_Modules_Count_Proc;
    Modules_FindByName: A_Runtime_Modules_FindByName_Proc;
    Modules_FindByUid: A_Runtime_Modules_FindByUid_Proc;
    Modules_DeleteByName: A_Runtime_Modules_DeleteByName_Proc;
    Modules_DeleteByUid: A_Runtime_Modules_DeleteByUid_Proc;
    Modules_GetByName: A_Runtime_Modules_GetByName_Proc;
    Modules_GetByUid: A_Runtime_Modules_GetByUid_Proc;
    Modules_GetNameByIndex: A_Runtime_Modules_GetNameByIndex_Proc;
    Modules_GetUidByIndex: A_Runtime_Modules_GetUidByIndex_Proc;
    Modules_InitByName: A_Runtime_Modules_InitByName_Proc;
    Modules_InitByUid: A_Runtime_Modules_InitByUid_Proc;

    IsShutdown: A_Runtime_IsShutdown_Proc;
    Shutdown: A_Runtime_Shutdown_Proc;
    Module_Register: A_Runtime_Module_Register_Proc;
    Modules_GetProcsByUid: A_Runtime_Modules_GetProcsByUid_Proc; //Reserved19: AInteger;
    Reserved20: AInteger;
    Reserved21: AInteger;
    Reserved22: AInteger;
    Reserved23: AInteger;
    Reserved24: AInteger;
    Reserved25: AInteger;
    Reserved26: AInteger;
    Reserved27: AInteger;
    Reserved28: AInteger;
    Reserved29: AInteger;
    Reserved30: AInteger;
    Reserved31: AInteger;

    Reserved32: AInteger;
    Reserved33: AInteger;
    Reserved34: AInteger;
    Reserved35: AInteger;
    Reserved36: AInteger;
    Reserved37: AInteger;
    Reserved38: AInteger;
    Reserved39: AInteger;
    Reserved40: AInteger;
    Reserved41: AInteger;
    Reserved42: AInteger;
    Reserved43: AInteger;
    Reserved44: AInteger;
    Reserved45: AInteger;
    Reserved46: AInteger;
    Reserved47: AInteger;
    Reserved48: AInteger;
    Reserved49: AInteger;
    Reserved50: AInteger;
    Reserved51: AInteger;
    Reserved52: AInteger;
    Reserved53: AInteger;
    Reserved54: AInteger;
    Reserved55: AInteger;
    Reserved56: AInteger;
    Reserved57: AInteger;
    Reserved58: AInteger;
    Reserved59: AInteger;
    Reserved60: AInteger;
    Reserved61: AInteger;
    Reserved62: AInteger;
    Reserved63: AInteger;
  end;

var
  ARuntime: ARuntimeProcs_Type;

function Runtime_SetProcs(RuntimeProcs: ARuntimeProcs): AInteger;

implementation

function Runtime_SetProcs(RuntimeProcs: ARuntimeProcs): AInteger;
begin
  ARuntime := RuntimeProcs^;
  Result := 0;
end;

end.
