{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 10.04.2009
LastMod: 08.06.2011
Version: 0.2.6+0.3.1
}
unit APlugins0;

{DEFINE A01}
{DEFINE A02}

interface

uses
  ABase0, {$IFDEF A02}ARuntime0_2{$ELSE}ARuntime0{$ENDIF};

const
  APlugins_Name = {$IFDEF A02}'Plugins'{$ELSE}'APlugins'{$ENDIF};
  APlugins_Uid = $09041001;
  APlugins_Version = {$IFDEF A02}$00020600{$ELSE}$00030100{$ENDIF};

// --- Tepes ---

type
  // Check and add plugin.
  A_Plugins_AddPluginW_Proc = function(const FileName: AWideString): ABoolean; stdcall;
  A_Plugins_Clear_Proc = function: ABoolean; stdcall;
  A_Plugins_Count_Proc = function: AInteger; stdcall;
  A_Plugins_Delete_Proc = function(Index: AInteger): ABoolean; stdcall;
  A_Plugins_FindW_Proc = procedure(const Path: AWideString); stdcall;

// ---

type
  APluginsProcs = ^APluginsProcs_Type;
  APluginsProcs_Type = packed record {8x4} {32x4}
    AddPlugin: A_Plugins_AddPluginW_Proc;
    Clear: A_Plugins_Clear_Proc;
    Count: A_Plugins_Count_Proc;
    Delete: A_Plugins_Delete_Proc;
    Find: A_Plugins_FindW_Proc;
    Reserved05: Integer;
    Reserved06: Integer;
    Reserved07: Integer;
    {$IFNDEF A01}
    {$IFNDEF A02}
    Reserved08: AInteger;
    Reserved09: AInteger;
    Reserved10: AInteger;
    Reserved11: AInteger;
    Reserved12: AInteger;
    Reserved13: AInteger;
    Reserved14: AInteger;
    Reserved15: AInteger;

    Reserved16: AInteger;
    Reserved17: AInteger;
    Reserved18: AInteger;
    Reserved19: AInteger;
    Reserved20: AInteger;
    Reserved21: AInteger;
    Reserved22: AInteger;
    Reserved23: AInteger;
    Reserved24: AInteger;
    Reserved25: AInteger;
    Reserved26: AInteger;
    Reserved27: AInteger;
    Reserved28: AInteger;
    Reserved29: AInteger;
    Reserved30: AInteger;
    Reserved31: AInteger;
    {$ENDIF} // A02
    {$ENDIF} // A01
  end;

// --- Vars ---

{
var
  Plugins_AddPlugin: APluginsAddPluginProc;
  Plugins_Clear: APluginsClearProc;
  Plugins_Count: APluginsCountProc;
  Plugins_Delete: APluginsDeleteProc;
  Plugins_Find: APluginsFindProc;
}

var
  APlugins: APluginsProcs_Type;

procedure Plugins_SetProcs(Procs: APluginsProcs);

implementation

procedure Plugins_SetProcs(Procs: APluginsProcs);
begin
  APlugins := Procs^;
  {
  Plugins_AddPlugin := Plugins.AddPlugin;
  Plugins_Clear := Plugins.Clear;
  Plugins_Count := Plugins.Count;
  Plugins_Delete := Plugins.Delete;
  Plugins_Find := Plugins.Find;
  }
end;

end.
 
