{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 06.04.2011
LastMod: 07.06.2011
Version: 0.3.1
}
unit AEntities0;

{
    :
KIF  SUO-KIF http://www-ksl.stanford.edu/knowledge-sharing/kif/
http://sigmakee.cvs.sourceforge.net/vie ... uo-kif.pdf
}

{
type
  //   
  AValueType = Integer;
const
  avtEmpty      = 0;
  avtNill       = 1;
  avtBool       = 2;
  avtInt        = 3;
  avtFloat      = 4;
  avtString     = 5;
  avtDateTime   = 6;
  avtCollection = 7;
const
  AEmptyType    = $0000; // vt_empty        0
  ANullType     = $0001; // vt_null         1
  ASmallintType = $0002; // vt_i2           2
  AIntegerType  = $0003; // vt_i4           3
  ASingleType   = $0004; // vt_r4           4
  ADoubleType   = $0005; // vt_r8           5
  ACurrencyType = $0006; // vt_cy           6
  ADateType     = $0007; // vt_date         7
  AStringType   = $0008; // vt_bstr         8  // AIOleStr
  ADispatchType = $0009; // vt_dispatch     9
  AErrorType    = $000A; // vt_error       10
  ABooleanType  = $000B; // vt_bool        11
  AVariantType  = $000C; // vt_variant     12
  AUnknownType  = $000D; // vt_unknown     13
  AShortIntType = $0010; // vt_i1          16
  AByteType     = $0011; // vt_ui1         17
  AWordType     = $0012; // vt_ui2         18
  ALongWordType = $0013; // vt_ui4         19
  AInt64Type    = $0014; // vt_i8          20
const
  AArray    = $000E;
  AType     = $000F;

//    
function Entity_Commit: Boolean;
//    
function Entity_Update: Boolean;
}

{
  (form ABase0)
  .       .
   0       AI .
    0  1023 .
   1024     AI .
    1025  2047      AI .
    2028  65535 .
    65535  2^31     .
     2^32  2^63   AI .
      2^32   
  (      ).
  :
    ru.narod.profsoft.ai.common.BaseTypes
    org.framerd.OID.OID
}
//TAID = AInt64;

interface

uses
  ABase0;

const
  Entities_Name = 'AEntities';
  Entities_Uid = $11040601;
  Entities_Version = $00030100;

type
  {
      .
     $00000000..$0000FFFF   ,
     $00010000..$00FFFFFF      () .
    AEntityTypeId = AEntityId
  }
  AEntityId = type AInteger;
const
  AEntityNull          = $00000000;  // 0
  AEntityStaticMin     = $00000001;  // 1
  AEntityStaticMax     = $0000FFFF;  // 65535
  AEntityGlobalMin     = $00010000;  // 65536
  AEntityGlobalMax     = $00FFFFFF;  // 16777216

// ---    [0..1024] (  AEntityTypeId) ---

const
  AEmptyType           = 0;    // 
  ADescriptTypeId      = 1;    //  
  ABoolTypeId          = 2;    // Boolean
  AIntTypeId           = 3;    // 
  AFloatTypeId         = 4;    //    
  AStringTypeId        = 5;    // 
  ADateTimeTypeId      = 6;    // /
  ACollectionTypeId    = 7;    // 
  ALocalSettingsId     = 1024; //   
  //AOwlClass          = 1028;
  //AOwlProperty       = 1029;

type
  {
     ()

    http://ai.obrazec.ru/forum/viewtopic.php?p=28744#p28744

    Entity = EntityId EntityType Data.
    EntityId = Integer. -  
    EntityType = Integer. -  ,    
    Data = Param*.

    EntityType = EntityId EntityType Data.
      :
    EntityId = Integer. -  
    EntityType = const Integer. -  ,  = 1
    Data = ParamDescriptionCount ParamDescription*.
    ParamDescriptionCount = Integer.
    ParamDescription = ParamType ParamName ParamDefValue ParamTags.
    ParamType = (Float, Integer, String). -    
    ParamName = String. -  
    ParamDefValue -   
    ParamTags -    
  }
  AEntity = ^AEntity_Type;
  AEntity_Type = packed record
    Id: AEntityId;     //    //  (    )
    Typ: AEntityId;    //   //   ( ,      )
    Data: Pointer;     //  
    DataSize: Integer; //  
  end;

// --- Procs types ---

type
  //  .       ,     .
  A_Entities_AddEntity_Proc = function(EntityId, EntityType: AEntityId): AInteger; stdcall;
  A_Entities_AddEntityA_Proc = function(EntityId, EntityType: AEntityId; DataSource: Pointer; DataSize: AInteger): AInteger; stdcall;
  A_Entities_SetEntityData_Proc = function(Id: AEntityId; Data: Pointer; DataSize: AInteger): AInteger; stdcall;
  A_Entities_Count_Proc = function: AInteger; stdcall;
  A_Entities_GetEntityByIndex_Proc = function(Index: AInteger; var Entity: AEntity_Type): ABoolean; stdcall;
  A_Entities_Iterator_Create_Proc = function: AInteger; stdcall;
  A_Entities_Iterator_Free_Proc = function(Iterator: AInteger): AInteger; stdcall;
  A_Entities_FindEntityById_Proc = function(Id: AEntityId): AInteger; stdcall;

type
  AEntitiesProcs = ^AEntitiesProcs_Type;
  AEntitiesProcs_Type = packed record
    AddEntity: A_Entities_AddEntity_Proc;
    SetEntityData: A_Entities_SetEntityData_Proc;
    Count: A_Entities_Count_Proc;
    GetEntityByIndex: A_Entities_GetEntityByIndex_Proc;
    Iterator_Create: A_Entities_Iterator_Create_Proc; //Reserved04: AInteger;
    Iterator_Free: A_Entities_Iterator_Free_Proc; //Reserved05: AInteger;
    FindEntityById: A_Entities_FindEntityById_Proc; //Reserved06: AInteger;
    AddEntityA: A_Entities_AddEntityA_Proc; //Reserved07: AInteger;
    Reserved08: AInteger;
    Reserved09: AInteger;
    Reserved10: AInteger;
    Reserved11: AInteger;
    Reserved12: AInteger;
    Reserved13: AInteger;
    Reserved14: AInteger;
    Reserved15: AInteger;
  end;

var
  { Entities: AEntitiesProcs_Type; -   
    AEntities: AEntitiesProcs_Type; -   
       AEntities. }
  AEntities: AEntitiesProcs_Type;

function Entities_SetProcs(Procs: AEntitiesProcs): AInteger;

implementation

function Entities_SetProcs(Procs: AEntitiesProcs): AInteger;
begin
  AEntities := Procs^;
  Result := 0;
end;

end.
 