{
      ( .dll, .so)
Author:  Prof1983 <prof1983@yandex.ru>
Created: 02.10.2005
LastMod: 08.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit ALibrary0;

{$I Defines.inc}

interface

uses
  {$IFNDEF NoSysUtils}SysUtils,{$ENDIF}
  ABase0;

{
type
  ALibrary = type Integer;
  ALibraryFlags = Integer;
}

//   ().  .
function Library_OpenW(const FileName: AWideString; Flags: ALibraryFlags): ALibrary; stdcall;
//   ()
function Library_Close(Lib: ALibrary): ABoolean; stdcall;
function Library_BuildPathW(const Directory, LibraryName: AWideString): AWideString; stdcall;
function Library_GetNameW(Lib: ALibrary): AWideString; stdcall;
//   
function Library_GetProcAddressW(Lib: ALibrary; const Name: AWideString): Pointer; stdcall;
function Library_GetSymbolW(Lib: ALibrary; const SymbolName: AWideString; var Symbol: Pointer): ABoolean; stdcall;

implementation

type
  TALibraryRec = record
    FileName: AWideString;        //    (.dll, .so)
    Handle: HMODULE;          // 
  end;

var
  FLibraries: array of TALibraryRec;

{ API functions }

type
  LPCSTR = PAnsiChar;
  BOOL = Boolean;
  FARPROC = Pointer;
  HMODULE = Integer;

const
  kernel32  = 'kernel32.dll';

function FreeLibrary(hLibModule: HMODULE): BOOL; stdcall; external kernel32 name 'FreeLibrary';
function GetProcAddress(hModule: HMODULE; lpProcName: LPCSTR): FARPROC; stdcall; external kernel32 name 'GetProcAddress';
function LoadLibrary(lpLibFileName: PChar): HMODULE; stdcall; external kernel32 name 'LoadLibraryA';

{ Private functions }

function AddLibrary(const FileName: AWideString; Handle: HMODULE): Integer;
begin
  Result := Length(FLibraries);
  SetLength(FLibraries, Result + 1);
  FLibraries[Result].FileName := FileName;
  FLibraries[Result].Handle := Handle;
end;

procedure DelLibrary(Index: Integer);
begin
  if (Index < 0) then Exit;
  FLibraries[Index] := FLibraries[High(FLibraries)];
  SetLength(FLibraries, High(FLibraries));
end;

function FindLibraryByHandle(Handle: Integer): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FLibraries) do
  begin
    if (FLibraries[I].Handle = HMODULE(Handle)) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindLibraryByFileName(const FileName: AWideString): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FLibraries) do
  begin
    if (FLibraries[I].FileName = FileName) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

{ Public Functions }

function Library_BuildPathW(const Directory, LibraryName: AWideString): AWideString; stdcall;
begin
  Result := LibraryName + '.dll';
  {$IFNDEF NoSysUtils}
  Result := ExpandFileName(Result);
  {$ENDIF}
end;

function Library_Close(Lib: ALibrary): ABoolean; stdcall;
var
  Index: Integer;
begin
  if (Lib = 0) then
  begin
    Result := True;
    Exit;
  end;
  try
    FreeLibrary(Lib{FHandle});
    Result := True;
  except
    Result := False;
  end;
  Index := FindLibraryByHandle(Lib);
  DelLibrary(Index);
end;

function Library_GetName(Lib: ALibrary; out Value: AString_Type): AInteger; stdcall;
begin
  Result := Library_GetName(Lib, Value);
end;

function Library_GetNameW(Lib: ALibrary): AWideString; stdcall;
{$IFNDEF NoSysUtils}
var
  Index: Integer;
{$ENDIF}
begin
  {$IFNDEF NoSysUtils}
  Index := FindLibraryByHandle(Lib);
  if (Index >= 0) then
  begin
    Result := ExtractFileName(FLibraries[Index].FileName);
    Result := ChangeFileExt(Result, '');
  end;
  {$ENDIF}
end;

function Library_GetProcAddressW(Lib: ALibrary; const Name: AWideString): Pointer; stdcall;
var
  S: string;
  P: PChar;
begin
  S := string(Name);
  P := PChar(S);
  Result := GetProcAddress(Lib{FHandle}, P);
end;

function Library_GetSymbolW(Lib: ALibrary; const SymbolName: AWideString; var Symbol: Pointer): ABoolean; stdcall;
begin
  Symbol := Library_GetProcAddressW(Lib, SymbolName);
  Result := (Symbol <> nil);
end;

function Library_OpenW(const FileName: AWideString; Flags: ALibraryFlags): ALibrary; stdcall;
var
  //Error: LongWord;
  P: PChar;
  Index: Integer;
  Handle: Integer;
begin
  Index := FindLibraryByFileName(FileName);
  if (Index >= 0) then
  begin
    Result := FLibraries[Index].Handle;
    Exit;
  end;

  if (FileName = '') then
  begin
    Result := 0;
    Exit;
  end;
  {$IFNDEF VER170}
  P := PChar(string(FileName));
  Handle := LoadLibrary(P);
  //Handle := Windows.LoadLibrary(P);
  {$ELSE}
  Handle := Windows.LoadLibrary(FileName);
  {$ENDIF}
  if (Handle <= 32) then
  begin
    //Error := GetLastError;
    Result := 0;
    Exit;
  end;
  AddLibrary(FileName, Handle);
  Result := Handle;
end;

end.
