{
Abstract: 
Author:  Prof1983 <prof1983@yandex.ru>
Created: 20.10.2005
LastMod: 08.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit AEvents0;

interface

uses
  ABase0;

function Event_NewW(Obj: Integer; const Name: AWideString): AEvent; stdcall;
procedure Event_Free(Event: AEvent); stdcall;
procedure Event_FreeAndNil(var Event: AEvent); stdcall;
function Event_Clear(Event: AEvent): AInteger; stdcall;
function Event_GetListenersCount(Event: AEvent): AInteger; stdcall;
function Event_GetNameW(Event: AEvent): AWideString; stdcall;
function Event_Connect(Event: AEvent; Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
function Event_Disconnect(Event: AEvent; Callback: ACallbackProc): AInteger; stdcall;
function Event_Invoke(Event: AEvent; Data: Integer): AInteger; stdcall;

implementation

type
  AArray = ^AArrayType;
  AArrayType = packed record {2x4}
    Data: Pointer;
    Len: AInteger;
    AllocateLen: AInteger;
    Reserved03: AInteger;
  end;

type
  AEventListener = ^AEventListenerType;
  AEventListenerType = packed record {2x4}
    Proc: ACallbackProc;
    Weight: AInteger;
  end;

{
type
  PEvent = ^AEventType;
  AEventType = packed record // 4x4
    Listeners: AArray;
    Name: AStringA;
    Obj: AInteger;
    Reserved03: AInteger;
  end;
}

type
  TAEvent = class
  private
    FListeners: array of record
      Proc: ACallbackProc;
      Weight: AInteger;
    end;
    FName: WideString;
    FObj: Integer;
    procedure Delete(Index: Integer);
  protected
    function GetCount: AInteger;
    function GetName: WideString;
  public
    procedure Clear;
    function Connect(CallBack: ACallbackProc; Weight: Integer): Integer;
    function Disconnect(CallBack: ACallbackProc): Integer;
    function Invoke(Data: AInteger): AInteger;
  public
    constructor Create(Obj: Integer; const Name: WideString);
  end;

{
var
  FEvents: array of TAEvent;
  //FEvents: array of AEventType;
}

{ Array }

{
function Array_Reallocate(Arr: AArray; NewSize: AInteger): AInteger;
var
  P: Pointer;
  MoveSize: AInteger;
begin
  GetMem(P, NewSize);
  if (Arr^.AllocateLen > NewSize) then
    MoveSize := NewSize
  else
    MoveSize := Arr^.AllocateLen;
  Move(Arr^.Data, P, MoveSize);
  Arr^.Data := P;
end;

function Array_Add(Arr: AArray; Rec: Pointer): AInteger;
var
  NewSize: AInteger;
  //I: Pointer;
begin
  if (Arr^.AllocateLen < Arr^.Len) then
  begin
    // New allocated size OldAllocateLen+64; 64 = 16*4
    NewSize := Arr^.AllocateLen + 64;
    if (Array_Reallocate(Arr, NewSize) <> NewSize) then
    begin
      Result := -1;
      Exit;
    end;
  end;
  Integer(Pointer(Integer(Arr^.Data) + (Arr^.Len)*4)^) := Integer(Rec^);
  Arr^.Len := Arr^.Len + 1;
  Result := Arr^.Len;
end;

procedure Array_Clear(Arr: AArray);
begin
  Arr^.Len := 0;
end;
}

{ Event }

function Event_Clear(Event: AEvent): AInteger; stdcall;
begin
  //Array_Clear(PEvent(Event)^.Listeners);
  TAEvent(Event).Clear;
  Result := 0;
end;

function Event_Connect(Event: AEvent; Callback: ACallbackProc; Weight: AInteger): AInteger; stdcall;
begin
  Result := TAEvent(Event).Connect(Callback, Weight);
end;
{function Event_Connect(Event: AEvent; Callback: ACallbackProc; Weight: AInteger): AInteger; stdcall;
var
  Listener: AEventListener;
begin
  GetMem(Listener, SizeOf(AEventListenerType));
  Result := Array_Add(PEvent(Event)^.Listeners, Listener);
  //Result := TAEvent(Event).Connect(Callback, Weight);
end;}

function Event_Disconnect(Event: AEvent; Callback: ACallbackProc): AInteger; stdcall;
begin
  // ...
  Result := TAEvent(Event).Disconnect(Callback);
end;

procedure Event_Free(Event: AEvent); stdcall;
begin
  // ...
  TAEvent(Event).Free;
end;

procedure Event_FreeAndNil(var Event: AEvent); stdcall;
begin
  if (Event <> 0) then
  begin
    Event_Free(Event);
    Event := 0;
  end;
end;

function Event_GetListenersCount(Event: AEvent): AInteger; stdcall;
begin
  Result := TAEvent(Event).GetCount;
end;

function Event_GetNameW(Event: AEvent): AWideString; stdcall;
begin
  Result := TAEvent(Event).GetName;
end;

function Event_Invoke(Event: AEvent; Data: Integer): AInteger; stdcall;
begin
  Result := TAEvent(Event).Invoke(Data);
end;

function Event_NewW(Obj: Integer; const Name: AWideString): AEvent; stdcall;
var
  Event: TAEvent;
begin
  Event := TAEvent.Create(Obj, Name);
  Result := AEvent(Event);
end;

{ TAEvent }

procedure TAEvent.Clear;
begin
  SetLength(FListeners, 0);
end;

function TAEvent.Connect(CallBack: ACallbackProc; Weight: Integer): Integer;
var
  I: Integer;
  Index: Integer;
begin
  if not(Assigned(CallBack)) then
  begin
    Result := 0;
    Exit;
  end;

  if (Weight < High(AInteger)) then
  begin
    for Index := 0 to High(FListeners) do
    begin
      if (FListeners[Index].Weight > Weight) then
      begin
        // Insert Listener into Index
        SetLength(FListeners, Length(FListeners) + 1);
        for I := High(FListeners) - 1 downto Index do
          FListeners[I + 1] := FListeners[I];
        FListeners[Index].Proc := CallBack;
        FListeners[Index].Weight := Weight;
        Result := Index;
        Exit;
      end;
    end;
  end;

  // Add Listener
  I := Length(FListeners);
  SetLength(FListeners, I + 1);
  FListeners[I].Proc := CallBack;
  FListeners[I].Weight := Weight;
  Result := I;
end;

constructor TAEvent.Create(Obj: Integer; const Name: WideString);
begin
  inherited Create;
  FObj := Obj;
  FName := Name;
end;

procedure TAEvent.Delete(Index: Integer);
var
  I: Integer;
begin
  for I := Index to High(FListeners) - 1 do
    FListeners[I] := FListeners[I + 1];
  SetLength(FListeners, High(FListeners));
end;

function TAEvent.Disconnect(CallBack: ACallbackProc): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FListeners) do
  begin
    if (Addr(FListeners[I]) = Addr(CallBack)) then
    begin
      Delete(I);
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function TAEvent.GetCount: AInteger;
begin
  Result := Length(FListeners);
end;

function TAEvent.GetName: WideString;
begin
  Result := FName;
end;

function TAEvent.Invoke(Data: AInteger): AInteger;
var
  I: Integer;
begin
  for I := 0 to High(FListeners) do
  try
    FListeners[I].Proc(FObj, Data);
  except
  end;
  Result := Length(FListeners);
end;


end.
