{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 15.05.2011
LastMod: 18.05.2011
Version: 0.3.0
}
unit DocumAssistantMonolitBoot;

{$I Defines.inc}

interface

uses
  ADocuments03,
  AEntities03, AEntities0,
  ARuntime03,
  ASystem03,
  ASettings03,
  AUI03,
  AUISettings03,
  AUISplash03,
  AUtils03,
  APlugins03,
  AUIWorkbench03,
  DocumUI,
  ABaseUtils;

procedure Assistant_Boot;
procedure Assistant_Init;
procedure Assistant_Run;
procedure Assistant_Done;

implementation

const
  ATitle = 'DocumAssistant';
  AProgramName = 'DocumAssistant';
  AProgramVersion = '0.3.0'; //{$IFDEF FPC}'0.3.0'{$ELSE}''{$ENDIF};
  AProductName = 'DocumAssistant';
  AProductVersion = '0.3';
  ACopyright = '(c) 2000-2011 AIKernel <prof1983@yandex.ru>';
  AUrl = 'http://www.aikernel.org/';

{$IFDEF FPC}
  {$I DocumAssistant_en.inc}
{$ELSE}
  {$I DocumAssistant_ru.inc}
{$ENDIF}

procedure Assistant_Boot;
begin
  Runtime_Boot;
  System_Boot;
//  Documents_Boot;
  Entities_Boot;
  Plugins_Boot;
  Settings_Boot;
  UI_Boot;
  UISettings_Boot;
  UISplash_Boot;
  UIWorkbench_Boot;
  Utils_Boot;

  System_BootA(ATitle, AProgramName, AProgramVersion, AProductName, AProductVersion, '', ACopyright, AUrl, ADescription, '.\Data\');
//  Plugins_Find(Runtime_GetExePath+'Plugins\');
end;

procedure Assistant_Done;
begin
  Runtime_Done;
end;

procedure Assistant_Init;
begin
  UI_OnMainFormCreate_Set(DocumUI_DoMainFormCreate);

//  Documents_Init;
//  Runtime_Init;
//  System_Init;
  UISplash_Init;
//  Data_Init;
//  Settings_Init;
  UI_Init;
  UI_InitMainTrayIcon;
  UI_InitMainMenu;
  UI_InitMenus;

//  {$IFNDEF FPC}ModuleManager_Init;{$ENDIF}
  UIWorkbench_Init;
  UISettings_Init;

  Plugins_Init;
end;

procedure Assistant_Run;
var
  I: Integer;
  //J: Integer;
  //Entity: AEntityType;
  //S: string;
type
  AEntityTypeData_Type = packed record
    ParamCount: Integer;
    Param1_Type: Integer;
    Param1_Name_Len: Integer;
    Param1_Name: Char;
    Param1_DefValue: Integer;
    Param1_Tags_Count: Integer;
  end;
const
  AEntityTypeData: AEntityTypeData_Type = (
    ParamCount: 1;
    Param1_Type: 0;
    Param1_Name_Len: 0;
    Param1_Name: #0;
    Param1_DefValue: 0;
    Param1_Tags_Count: 0;
    //Data = ParamDescriptionCount ParamDescription*.
    //ParamDescriptionCount = Integer.
    //ParamDescription = ParamType ParamName ParamDefValue ParamTags.
    );
begin
  //  
  Documents_LoadFromFile(Runtime_GetExePath+'Example.adb');

  //       ( )
  I := Entities_FindEntityByID(ADescriptTypeID);
  if (I < 0) then
  begin
    I := Entities_AddEntityA(ADescriptTypeID, ADescriptTypeID, Addr(AEntityTypeData), SizeOf(AEntityTypeData));
    if (I < 0) then
    begin
      Runtime_ShowMessage('     1');
      Exit;
    end;
  end;

  {
  //Runtime_ShowMessage('- : '+Utils_IntToStr(Entities_Count));
  for I := 0 to Entities_Count - 1 do
  begin
    if not(Entities_GetEntityByIndex(I, Entity)) then
    begin
      Runtime_ShowMessage(' ');
      Exit;
    end;
    S := '';
    for J := 0 to Entity.DataSize - 1 do
      S := S + ' ' + ByteToHex(Byte(Pointer(Integer(Entity.Data) + J)^));
    Runtime_ShowMessage(' '+Utils_IntToStr(I)+#13#10+
        'ID: '+Utils_IntToStr(Entity.ID)+#13#10+
        'Type: '+Utils_IntToStr(Entity.Typ)+#13#10+
        'DataSize: '+Utils_IntToStr(Entity.DataSize)+#13#10+
        'Data: '+S);
  end;
  }

  Runtime_Run;
  //  
  Documents_SaveToFile(Runtime_GetExePath+'Example.adb');
end;

end.
 
