{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 30.09.2009
LastMod: 17.05.2011
Version: 0.3.0
}
unit AUtils03;

interface

uses
  ABase0, ABaseUtils, ARuntime0, AUtils0, ASystem0, AStringsUtils;

//    
function Utils_FloatToStr(Value: AFloat): AString; stdcall;
//     c    
function Utils_FloatToStrA(Value: AFloat; Digits: Integer = 2): AString; stdcall;
//         (SQL).  SQL   - .
function Utils_FloatToStrB(Value: AFloat; Digits: Integer = 2): AString; stdcall;
function Utils_FloatToStrC(Value: AFloat; Digits: Integer = 2): AString; stdcall;
function Utils_FloatToStrD(Value: AFloat): AString; stdcall;
function Utils_NormalizeFloat(Value: AFloat): AFloat; stdcall;
//       #
function Utils_NormalizeStr(const Value: AString): AString; stdcall;

{               .
    DecimalSeparator ,    . }
function Utils_ReplaceComma(const S: AString; DecimalSeparator: AChar = #0; ClearSpace: ABoolean = True): AString; stdcall;
function Utils_StrToFloat1(const S: AString; DefValue: AFloat = 0): AFloat; stdcall;
function Utils_StrToInt1(const S: AString; DefValue: AInteger = 0): AInteger; stdcall;
function Utils_TryStrToFloat32(const S: AString; var Value: AFloat32): ABoolean; stdcall;
function Utils_TryStrToFloat64(const S: AString; var Value: AFloat64): ABoolean; stdcall;
function Utils_FileExists(const FileName: AString): ABoolean; stdcall;
procedure Utils_Sleep(Milliseconds: AUInt); stdcall;
function Utils_Time_Now: TDateTime; stdcall;
function Utils_IntToStr(Value: AInteger): AString; stdcall;
function Utils_StrToFloat(const Value: AString): AFloat; stdcall;
function Utils_StrToInt(const Value: AString): AInteger; stdcall;
function Utils_ExtractFilePath(const FileName: AString): AString; stdcall;
//   Base   Exponent
function Utils_Power(Base, Exponent: AFloat): AFloat; stdcall;
function Utils_TryStrToDate(const S: AString; var Value: TDateTime): ABoolean; stdcall;
function Utils_TryStrToFloat(const S: AString; var Value: AFloat): ABoolean; stdcall;
function Utils_TryStrToInt(const S: AString; var Value: AInteger): ABoolean; stdcall;

{ Testing }

function Utils_ExtractFileExt(const FileName: AString): AString; stdcall;
{ Trims leading and trailing spaces and control characters from a string.
       }
function Utils_Trim(const S: AString): AString; stdcall;
function Utils_UpperString(const S: AString): AString; stdcall;
function Utils_FormatFloat(Value: AFloat; Count, Digits: AInteger): AString; stdcall;
function Utils_FormatInt(Value, Count: AInteger): AString; stdcall;
function Utils_FormatStr(const Value: AString; Len: AInteger): AString; stdcall;
function Utils_StrToDate(const Value: AString): TDateTime; stdcall;

{ Protected }

function Utils_Boot: AInteger; stdcall;
function Utils_Init: AInteger; stdcall;
function Utils_Done: AInteger; stdcall;

{ Private }

type //   
  TWinVersion = (wvUnknown, wv95, wv98, wvME, wvNT3, wvNT4, wvW2K, wvXP, wv2003);

{$IFNDEF FPC}
//       
//   Result:      
function WinVersion: TWinVersion;
{$ENDIF}

implementation

uses
  {$IFNDEF FPC}Windows,{$ENDIF}
  SysUtils;

exports
  Utils_Done,
  Utils_Init,
  Utils_FloatToStrA,
  Utils_FloatToStrB,
  Utils_FloatToStrC,
  Utils_FloatToStrD,
  Utils_NormalizeFloat,
  Utils_ReplaceComma;

const
  Utils: AUtilsProcsType = (
    FloatToStrA: Utils_FloatToStrA;
    FloatToStrB: Utils_FloatToStrB;
    FloatToStrC: Utils_FloatToStrC;
    FloatToStrD: Utils_FloatToStrD;
    NormalizeFloat: Utils_NormalizeFloat;
    NormalizeStr: Utils_NormalizeStr;

    FileExists: Utils_FileExists;
    Sleep: Utils_Sleep;
    Time_Now: Utils_Time_Now;
    IntToStr: Utils_IntToStr;
    StrToFloat: Utils_StrToFloat;
    StrToInt: Utils_StrToInt;
    ExtractFilePath: Utils_ExtractFilePath;
    Power: Utils_Power;
    ReplaceComma: Utils_ReplaceComma;
    StrToFloat1: Utils_StrToFloat1;
    StrToInt1: Utils_StrToInt1;
    TryStrToFloat: Utils_TryStrToFloat;
    TryStrToFloat32: Utils_TryStrToFloat32;
    TryStrToFloat64: Utils_TryStrToFloat64;
    TryStrToDate: Utils_TryStrToDate;
    TryStrToInt: Utils_TryStrToInt;

    FloatToStr: Utils_FloatToStr;
    Trim: Utils_Trim;
    UpperString: Utils_UpperString;
    ExtractFileExt: Utils_ExtractFileExt;

    FormatFloat: Utils_FormatFloat;
    FormatInt: Utils_FormatInt;
    StrToDate: Utils_StrToDate;

    FormatStr: Utils_FormatStr;
    Strings_Add: Strings_Add;
    Strings_Clear: Strings_Clear;

    Reserved32: 0;
    Reserved33: 0;
    Reserved34: 0;
    Reserved35: 0;
    Reserved36: 0;
    Reserved37: 0;
    Reserved38: 0;
    Reserved39: 0;
    Reserved40: 0;
    Reserved41: 0;
    Reserved42: 0;
    Reserved43: 0;
    Reserved44: 0;
    Reserved45: 0;
    Reserved46: 0;
    Reserved47: 0;

    Reserved48: 0;
    Reserved49: 0;
    Reserved50: 0;
    Reserved51: 0;
    Reserved52: 0;
    Reserved53: 0;
    Reserved54: 0;
    Reserved55: 0;
    Reserved56: 0;
    Reserved57: 0;
    Reserved58: 0;
    Reserved59: 0;
    Reserved60: 0;
    Reserved61: 0;
    Reserved62: 0;
    Reserved63: 0;
    );

const
  Module: AModuleType = (
    Version: AUtils_Version;
    Uid: AUtils_Uid;
    Name: AUtils_Name;
    Description: nil;
    Init: Utils_Init;
    Done: Utils_Done;
    Reserved06: 0;
    Procs: Addr(Utils);
    );

var
  FInitialized: Boolean;

{ Private procs }

{$IFNDEF FPC}
function WinVersion: TWinVersion;
var
  OSVersionInfo: TOSVersionInfo;
begin
  Result := wvUnknown;
  OSVersionInfo.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  if GetVersionEx(OSVersionInfo) then
  begin
    case OSVersionInfo.DwMajorVersion of
      3: Result := wvNT3;
      4: case OSVersionInfo.DwMinorVersion of
           0: if (OSVersionInfo.dwPlatformId = VER_PLATFORM_WIN32_NT) then
                Result := wvNT4
              else
                Result := wv95;
           10: Result := wv98;
           90: Result := wvME;
         end;
      5: case OSVersionInfo.DwMinorVersion of
           0: Result := wvW2K;
           1: Result := wvXP;
           2: Result := wv2003;
         end;
    end;
  end;
end;
{$ENDIF}

{ Utils }

function Utils_Boot: AInteger; stdcall;
begin
  Utils_SetProcs(Addr(Utils));
  Result := Runtime_Module_Register(Addr(Module));
end;

function Utils_Done: AInteger; stdcall;
begin
  Result := 0;
end;

function Utils_ExtractFileExt(const FileName: AString): AString; stdcall;
begin
  Result := ExtractFileExt(FileName);
end;

function Utils_ExtractFilePath(const FileName: AString): AString; stdcall;
begin
  Result := ExtractFilePath(FileName);
end;

function Utils_FileExists(const FileName: AString): ABoolean; stdcall;
begin
  Result := FileExists(FileName);
end;

function Utils_FloatToStr(Value: AFloat): AString; stdcall;
begin
  Result := FloatToStr(Value);
end;

function Utils_FloatToStrA(Value: AFloat; Digits: AInteger = 2): AString; stdcall;
begin
  Result := FloatToStrF(Value, ffFixed, 10, Digits);
end;

function Utils_FloatToStrB(Value: AFloat; Digits: AInteger): AString; stdcall;
begin
  Result := Utils_ReplaceComma(FloatToStrF(Value, ffFixed, 10, Digits), '.');
end;

function Utils_FloatToStrC(Value: AFloat; Digits: AInteger): AString; stdcall;
begin
  case Digits of
    0: Result := FormatFloat('### ### ### ##0', Value);
    1: Result := FormatFloat('### ### ### ##0.0', Value);
    2: Result := FormatFloat('### ### ### ##0.00', Value);
    3: Result := FormatFloat('### ### ### ##0.000', Value);
    4: Result := FormatFloat('### ### ### ##0.0000', Value);
    5: Result := FormatFloat('### ### ### ##0.00000', Value);
  else
    Result := FormatFloat('### ### ### ##0.00', Value);
  end;
end;

function Utils_FloatToStrD(Value: AFloat): AString; stdcall;
begin
  Result := FormatFloat(',0.00', Value);
end;

function Utils_FormatFloat(Value: AFloat; Count, Digits: AInteger): AString; stdcall;
var
  FormatS: string;
begin
  if (Count >= 0) and (Count <= 9) and (Digits >= 0) and (Digits <= 9) then
  begin
    FormatS := '%' + Chr(Ord('0')+Count) + '.' + Chr(Ord('0')+Digits) + 'f';
    Result := Format(FormatS,[Value]);
  end
  else
    Result := Utils_FloatToStrB(Value, Digits);
end;

function Utils_FormatInt(Value, Count: AInteger): AString; stdcall;
begin
  if (Count > 0) and (Count <= 9) then
    Result := Format('%'+Chr(Ord('0')+Count)+'d',[Value])
  else
    Result := IntToStr(Value);
end;

function Utils_FormatStr(const Value: AString; Len: AInteger): AString; stdcall;
var
  Form: string;
  S: string;
begin
  if (Len > 0) and (Len < High(Byte)) then
  begin
    Form := '%'+ByteToStr(Byte(Len))+'s';
    S := string(Value);
    Result := Format(Form, [S])
  end
  else
    Result := Value;
end;

function Utils_Init: AInteger; stdcall;
begin
  Result := 0;
  if FInitialized then Exit;
  Runtime_Modules_InitByUID(ASystem_UID);
end;

function Utils_IntToStr(Value: AInteger): AString; stdcall;
begin
  Result := IntToStr(Value);
end;

function Utils_NormalizeFloat(Value: AFloat): AFloat; stdcall;
begin
  Result := Utils_StrToFloat(Utils_FloatToStrA(Value));
end;

function Utils_NormalizeStr(const Value: AString): AString; stdcall;
var
  i: Integer;
  S: string;
begin
  S := Value;
  for i := 1 to Length(S) do
  begin
    if (Ord(S[i]) < 31) then // 
      S[i] := '#';
  end;
  Result := S;
end;

function Utils_Power(Base, Exponent: AFloat): AFloat; stdcall;
begin
  Result := Exp(Exponent * Ln(Base));
end;

function Utils_ReplaceComma(const S: AString; DecimalSeparator: AChar; ClearSpace: ABoolean): AString; stdcall;
var
  ic: Integer;
  SS: AString;
begin
  if (DecimalSeparator = #0) then
    DecimalSeparator := AChar(SysUtils.DecimalSeparator);
  if (DecimalSeparator <> '.') and (DecimalSeparator <> ',') then
    raise Exception.Create('  ReplaceComma().  DecimalSeparator     .');

  // 44 - ; 46 - 
  ic := 1;
  SS := '';
  while (ic <= (Length(S))) do
  begin
    if not(ClearSpace) or (S[ic] <> ' ') then
    begin
      if (DecimalSeparator = '.') then
      begin
        if S[ic] = ',' then
          SS := SS + '.'
        else
          SS := SS + S[ic];
      end
      else
      begin
        if (S[ic] = '.') then
          SS := SS + ','
        else
          SS := SS + S[ic];
      end;
    end;
    ic := ic + 1;
  end;
  Result := SS;
end;

procedure Utils_Sleep(Milliseconds: AUInt); stdcall;
begin
  Runtime_ProcessMessages;
  Sleep(Milliseconds);
end;

function Utils_StrToDate(const Value: AString): TDateTime; stdcall;
begin
  Result := StrToDate(Value);
end;

function Utils_StrToFloat(const Value: AString): AFloat; stdcall;
begin
  Result := StrToFloat(Value);
end;

function Utils_StrToFloat1(const S: AString; DefValue: AFloat): AFloat; stdcall;
var
  Value: Real;
begin
  if Utils_TryStrToFloat32(S, Value) then
    Result := Value
  else
    Result := DefValue;
end;

function Utils_StrToInt(const Value: AString): AInteger; stdcall;
begin
  Result := StrToInt(Value);
end;

function Utils_StrToInt1(const S: AString; DefValue: AInteger): AInteger; stdcall;
begin
  if not(Utils_TryStrToInt(S, Result)) then
    Result := DefValue;
end;

function Utils_Time_Now: TDateTime; stdcall;
begin
  Result := Now;
end;

function Utils_Trim(const S: AString): AString; stdcall;
begin
  Result := SysUtils.Trim(S);
end;

function Utils_TryStrToDate(const S: AString; var Value: TDateTime): Boolean; stdcall;
begin
  Result := TryStrToDate(S, Value);
end;

function Utils_TryStrToFloat(const S: AString; var Value: AFloat): ABoolean; stdcall;
begin
  Result := Utils_TryStrToFloat64(S, Value);
end;

function Utils_TryStrToFloat32(const S: AString; var Value: AFloat32): ABoolean;
var
  Value1: Extended;
  S1: string;
begin
  S1 := Trim(Utils_ReplaceComma(S));
  if (S1 <> '') then
  begin
    Result := TryStrToFloat(S1, Value1);
    if Result then
      Value := Value1;
  end
  else
    Result := False;
end;

function Utils_TryStrToFloat64(const S: AString; var Value: AFloat64): ABoolean;
var
  Value1: Extended;
  S1: string;
begin
  S1 := Trim(Utils_ReplaceComma(S));
  if (S1 <> '') then
  begin
    Result := TryStrToFloat(Trim(Utils_ReplaceComma(S)), Value1);
    if Result then
      Value := Value1;
  end
  else
    Result := False;
end;

function Utils_TryStrToInt(const S: AString; var Value: AInteger): ABoolean; stdcall;
begin
  Result := TryStrToInt(Trim(S), Value);
end;

function Utils_UpperString(const S: AString): AString; stdcall;
begin
  Result := AnsiUpperCase(S);
end;

end.

