{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 26.08.2009
LastMod: 17.05.2011
Version: 0.3.0
}
unit AUIWorkbench03;

interface

uses
  ABase0, ARuntime0, AUI0, AUIWorkbench0;

function UIWorkbench_AddPage(const Name, Text: AString): AControl; stdcall;
procedure UIWorkbench_SetOnChange(OnChange: ACallbackProc); stdcall;

{ Protected }

function UIWorkbench_Boot: AInteger; stdcall;
function UIWorkbench_Init: AInteger; stdcall;
function UIWorkbench_Done: AInteger; stdcall;

implementation

exports
  UIWorkbench_AddPage,
  UIWorkbench_Init,
  UIWorkbench_Done;

const
  UIWorkbenchProcs: AUIWorkbenchProcsType = (
    AddPage: AUIWorkbench03.UIWorkbench_AddPage;
    Reserved01: 0;
    Reserved02: 0;
    Reserved03: 0;
    Reserved04: 0;
    Reserved05: 0;
    Reserved06: 0;
    Reserved07: 0;
    );

const
  Module: AModuleType = (
    Version: AUIWorkbench_Version;
    Uid: AUIWorkbench_Uid;
    Name: AUIWorkbench_Name;
    Description: nil;
    Init: UIWorkbench_Init;
    Done: UIWorkbench_Done;
    Reserved06: 0;
    Procs: Addr(UIWorkbenchProcs);
    );

var
  FInitialized: Boolean;
  FPageControl: AControl;

{ UIWorkbench }

function UIWorkbench_AddPage(const Name, Text: AString): AControl; stdcall;
begin
  Result := UI_PageControl_AddPage(FPageControl, Name, Text);
end;

function UIWorkbench_Boot: AInteger; stdcall;
begin
  UIWorkbench_SetProcs(Addr(UIWorkbenchProcs));

  if (Runtime_Modules_FindByName(AUIWorkbench_Name) >= 0) then
  begin
    Result := -1;
    Exit;
  end;

  Runtime_Module_Register(Addr(Module));
  Result := 0;
end;

function UIWorkbench_Done: AInteger; stdcall;
begin
  Runtime_Modules_DeleteByName(AUIWorkbench_Name);
  FInitialized := False;
  Result := 0;
end;

function UIWorkbench_Init: AInteger; stdcall;
var
  Module: AModuleType;
begin
  if FInitialized then
  begin
    Result := 0;
    Exit;
  end;

  // --- Init request modules ---

  if (Runtime_Modules_InitByName(AUI_Name) < 0) then
  begin
    Result := -2;
    Exit;
  end;

  if (Runtime_Modules_GetByName(AUI_Name, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  UI_SetProcs(Module.Procs);

  FPageControl := UI_PageControl_New(UI_MainWindow_GetMainContainer);
  FInitialized := True;
  Result := 0;
end;

procedure UIWorkbench_SetOnChange(OnChange: ACallbackProc); stdcall;
begin
  if FInitialized then
    UI_Control_SetOnChange(FPageControl, OnChange);
end;

end.
