{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 08.12.2009
LastMod: 18.05.2011
Version: 0.3.0
}
unit AUISplash03;

interface

uses
  ABase0, ARuntime0, ASettings0, ASystem0, AUI0, AUtils0;

const
  AUISplash_Name = 'UISplash';
  AUISplash_UID = $00000009;
  AUISplash_Version = $00030000;

procedure UISplash_Hide; stdcall;
procedure UISplash_Sleep; stdcall;
function UISplash_StepIt(const Text: AString): AInteger; stdcall;

{ Protected }

function UISplash_Boot: AInteger; stdcall;
function UISplash_Init: AInteger; stdcall;
function UISplash_Done: AInteger; stdcall;

implementation

type
  AUISplashProcsRec = packed record {8x4}
    Reserved00: AInteger;
    Reserved01: AInteger;
    Reserved02: AInteger;
    Reserved03: AInteger;
    Reserved04: AInteger;
    Reserved05: AInteger;
    Reserved06: AInteger;
    Reserved07: AInteger;
    Reserved08: AInteger;
    Reserved09: AInteger;
    Reserved10: AInteger;
    Reserved11: AInteger;
    Reserved12: AInteger;
    Reserved13: AInteger;
    Reserved14: AInteger;
    Reserved15: AInteger;
  end;

const
  UISplashProcs: AUISplashProcsRec = (
    Reserved00: 0;
    Reserved01: 0;
    Reserved02: 0;
    Reserved03: 0;
    Reserved04: 0;
    Reserved05: 0;
    Reserved06: 0;
    Reserved07: 0;
    Reserved08: 0;
    Reserved09: 0;
    Reserved10: 0;
    Reserved11: 0;
    Reserved12: 0;
    Reserved13: 0;
    Reserved14: 0;
    Reserved15: 0;
    );

const
  UISplashModule: AModuleType = (
    Version: AUISplash_Version;
    UID: AUISplash_UID;
    Name: AUISplash_Name;
    Description: nil;
    Init: UISplash_Init;
    Done: UISplash_Done;
    Reserved06: 0;
    Procs: Addr(UISplashProcs);
    );

var
  FInitialized: Boolean;
  FImageFileName: AString;
  FStartTime: TDateTime;
  NoSplash: Boolean;
var
  Box1: AControl;
  Box2: AControl;
  SplashWin: AWindow;
  TextView: AControl;
  TextLabel: AControl;
  ProgressBar: AControl;
  Image: AControl;

{ Private procs }

procedure DoBeforeRun(Obj, Data: AInteger); stdcall;
begin
  if not(NoSplash) then
    UISplash_Hide;
end;

function ReadNoSplash: Boolean;
var
  I: Integer;
  S: string;
  Config: AConfig;
begin
  Result := False;
  I := 1;
  repeat
    S := Runtime_ParamStr(I);
    if (Utils_UpperString(S) = '-NOSPLASH') then
    begin
      Result := True;
      Exit;
    end;
    Inc(I);
  until (S = '');

  if not(NoSplash) then
  begin
    Config := Runtime_GetConfig;
    if (Config <> 0) then
      Result := Settings_ReadBool(Config, 'App', 'NoSplash', False);
  end;
end;

{ UISplash }

function UISplash_Boot: AInteger;
begin
  Result := Runtime_Module_Register(Addr(UISplashModule));
end;

function UISplash_Done: AInteger; stdcall;
begin
  UI_Window_Free(SplashWin);
  SplashWin := 0;
  Runtime_Modules_DeleteByName(AUISplash_Name);
  FInitialized := False;
  Result := 0;
end;

procedure UISplash_Hide; stdcall;
const
  cTime = 1;
begin
  if (SplashWin = 0) then Exit;
  while (Utils_Time_Now - FStartTime < cTime/(24*60*60)) do
  begin
    UI_Control_SetVisible(SplashWin, True);
    UI_ProcessMessages;
    Utils_Sleep(50);
  end;
  UI_Control_Free(SplashWin);
  SplashWin := 0;
  {$IFNDEF FPC}
  //UI_Control_SetFocus(UI_MainWindow);
  {$ENDIF}
end;

function UISplash_Init: AInteger; stdcall;
var
  S: string;
  Module: AModuleType;
begin
  if FInitialized then
  begin
    Result := 0;
    Exit;
  end;

  // --- Init request modules ---

  if (Runtime_Modules_GetByUid(ASettings_Uid, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  Settings_SetProcs(Module.Procs);

  if (Runtime_Modules_GetByUid(ASystem_Uid, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  System_SetProcs(Module.Procs);

  if (Runtime_Modules_GetByUid(AUI_Uid, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  UI_SetProcs(Module.Procs);

  if (Runtime_Modules_GetByUid(AUtils_Uid, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  Utils_SetProcs(Module.Procs);

  if (Runtime_Modules_InitByUid(AUI_Uid) < 0) then
  begin
    Result := -1;
    Exit;
  end;

  if (Runtime_Modules_InitByUid(AUtils_Uid) < 0) then
  begin
    Result := -2;
    Exit;
  end;

  // --- Init recomended modules ---

  if (Runtime_Modules_GetByUid(ASettings_Uid, Addr(Module)) < 0) then
  begin
    Settings_SetProcs(Module.Procs);
    Runtime_Modules_InitByName(ASettings_Name);
  end;

  // --- Run ---

  Runtime_OnBeforeRun_Connect(DoBeforeRun);

  if (SplashWin = 0) then
  begin
    SplashWin := UI_Window_New;
    UI_Control_SetColor(SplashWin, 0{AInteger(clBlack)});
    UI_Window_SetBorderStyle(SplashWin, 0{AInteger(bsNone)});
    UI_Window_SetFormStyle(SplashWin, 3{AInteger(fsStayOnTop)});
    UI_Window_SetPosition(SplashWin, 4{AInteger(poScreenCenter)});
    UI_Control_SetClientSize(SplashWin, 573, 295);

      Box1 := UI_Box_New(SplashWin, 0);
      UI_Control_SetSize(Box1, 557, 49);
      UI_Control_SetPosition(Box1, 8, 8);
      UI_Control_SetColor(Box1, $FFFFFF{clWhite});

        Image := UI_Image_New(Box1);
        UI_Control_SetAlign(Image, uiAlignLeft);
        UI_Control_SetSize(Image, 168, 47);

        S := Runtime_GetTitle;
        TextLabel := UI_Label_New(Box1);
        UI_Control_SetColor(TextLabel, $FFFFFF{clWhite});
        UI_Control_SetText(TextLabel, S);
        if (Length(s) > 40) then
        begin
          UI_Control_SetPosition(TextLabel, 10, 0);
          UI_Control_SetFont1(TextLabel, 'Calisto MT', 16);
        end
        else if (Length(s) > 20) then
        begin
          UI_Control_SetPosition(TextLabel, 50, 0);
          UI_Control_SetFont1(TextLabel, 'Calisto MT', 20);
        end
        else
        begin
          UI_Control_SetPosition(TextLabel, 176, 0);
          UI_Control_SetFont1(TextLabel, 'Calisto MT', 24);
        end;

      Box2 := UI_Box_New(SplashWin, 0);
      UI_Control_SetSize(Box2, 557, 226);
      UI_Control_SetPosition(Box2, 8, 63);
      UI_Control_SetColor(Box2, $FFFFFF{clWhite});

        ProgressBar := UI_ProgressBar_New(Box2, 100);
        UI_Control_SetAlign(ProgressBar, uiAlignBottom);
        UI_Control_SetSize(ProgressBar, 556, 14);
        UI_Control_SetPosition(ProgressBar, 8, 272);

        TextView := UI_TextView_New(Box2, 1);
        UI_Control_SetAlign(TextView, uiAlignClient);
        UI_Control_SetSize(TextView, 557, 210);
        UI_Control_SetPosition(TextView, 8, 63);
        UI_TextView_SetReadOnly(TextView, True);
        UI_TextView_SetScrollBars(TextView, 3{ssBoth});
        UI_TextView_SetWordWrap(TextView, False);
  end;

  FStartTime := Utils_Time_Now;

  if (FImageFileName = '') then
  begin
    S := Runtime_GetDataPath + Runtime_GetProgramName + '.png';
    if Utils_FileExists(S) then
      FImageFileName := S;
  end;

  if (FImageFileName = '') then
  begin
    S := Runtime_GetDataPath + Runtime_GetProgramName + '.bmp';
    if Utils_FileExists(S) then
      FImageFileName := S;
  end;

  if (FImageFileName <> '') then
  begin
    if Utils_FileExists(FImageFileName) then
      UI_Image_LoadFromFile(Image, FImageFileName);
  end;

  NoSplash := ReadNoSplash;

  if NoSplash then
    UI_Control_SetVisible(SplashWin, False)
  else
  begin
    UI_Control_SetVisible(SplashWin, True);
    UI_ProcessMessages;
  end;

  FInitialized := True;
  Result := 0;
end;

procedure UISplash_Sleep; stdcall;
begin
  Utils_Sleep(1000);
end;

function UISplash_StepIt(const Text: AString): AInteger; stdcall;
begin
  if (SplashWin = 0) then
  begin
    Result := -1;
    Exit;
  end;
  Result := UI_ProgressBar_StepIt(ProgressBar);
  if (Text <> '') then
    UI_TextView_AddLine(TextView, Text);
end;

end.
 
