{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 13.03.2009
LastMod: 17.05.2011
Version: 0.3.0
}
unit AUISettings03;

interface

uses
  ABase0, ARuntime0, AUI0, AUISettings0;

function UISettings_MainSettingsWin: AWindow; stdcall;
function UISettings_SettingsWin_New: AWindow; stdcall;
procedure UISettings_ShowSettingsWin; stdcall;
function UISettings_NewItem(Parent: AUISettingsItem; const Text: AString): AUISettingsItem; stdcall;
function UISettings_Item_GetPage(Item: AUISettingsItem): AControl; stdcall;

{ Protected }

function UISettings_Boot: AInteger; stdcall;
function UISettings_Init: AInteger; stdcall;
function UISettings_Done: AInteger; stdcall;

implementation

exports
  UISettings_Done,
  UISettings_Init,
  UISettings_MainSettingsWin,
  UISettings_NewItem,
  UISettings_SettingsWin_New,
  UISettings_ShowSettingsWin;

{$IFDEF FPC}
  {$I AUISettingsConsts.en.inc}
{$ELSE}
  {$I AUISettingsConsts.ru.inc}
{$ENDIF}

const
  UISettingsProcs: AUISettingsProcsType = (
    MainSettingsWin: AUISettings03.UISettings_MainSettingsWin;
    SettingsWin_New: AUISettings03.UISettings_SettingsWin_New;
    ShowSettingsWin: AUISettings03.UISettings_ShowSettingsWin;
    NewItem: AUISettings03.UISettings_NewItem;
    Item_GetPage: AUISettings03.UISettings_Item_GetPage;
    Reserved05: 0;
    Reserved06: 0;
    Reserved07: 0;
    Reserved08: 0;
    Reserved09: 0;
    Reserved10: 0;
    Reserved11: 0;
    Reserved12: 0;
    Reserved13: 0;
    Reserved14: 0;
    Reserved15: 0;
    );

const
  Module: AModuleType = (
    Version: AUISettings_Version;
    UID: AUISettings_UID;
    Name: AUISettings_Name;
    Description: nil;
    Init: UISettings_Init;
    Done: UISettings_Done;
    Reserved06: 0;
    Procs: Addr(UISettingsProcs);
    );

type
  TUISettingsItem = record
    TreeNode: ATreeNode;
    Page: AControl;
  end;

var
  FInitialized: Boolean;
  FItems: array of TUISettingsItem;
  SettingsWin: AWindow;
  FPageControl: AControl;
  FTreeView: AControl;

{ Functions }

function AddSettingsItem(TreeNode: ATreeNode; Page: AControl): Integer;
begin
  Result := Length(FItems);
  SetLength(FItems, Result + 1);
  FItems[Result].TreeNode := TreeNode;
  FItems[Result].Page := Page;
end;

procedure InitSettingsWin;
begin
  if (SettingsWin = 0) then
    SettingsWin := UISettings_SettingsWin_New;
end;

{ Events }

procedure miSettingsClick(Obj, Data: Integer); stdcall;
begin
  UISettings_ShowSettingsWin;
end;

{ UISettings }

function UISettings_Boot: AInteger; stdcall;
begin
  UISettings_SetProcs(Addr(UISettingsProcs));

  // Check dublicate module
  {if (Runtime_Modules_FindByName(AUISettings_Name) >= 0) then
  begin
    Result := -1;
    Exit;
  end;}

  Runtime_Module_Register(Addr(Module));
  Result := 0;
end;

function UISettings_Done: AInteger; stdcall;
var
  I: Integer;
begin
  if FInitialized then
  begin
    for I := 0 to High(FItems) do
      UI_Control_Free(FItems[I].Page);
    SetLength(FItems, 0);
    UI_Control_FreeAndNil(FTreeView);
    UI_Control_FreeAndNil(FPageControl);
    UI_Window_Free(SettingsWin);
    SettingsWin := 0;
    FInitialized := False;
  end;
  Runtime_Modules_DeleteByUid(AUISettings_Uid);
  Result := 0;
end;

function UISettings_Init: AInteger; stdcall;
var
  {Window: Integer;
  Menu: Integer;
  Items: Integer;
  miTools: Integer;}
  Module: AModuleType;
begin
  if FInitialized then
  begin
    Result := 0;
    Exit;
  end;

  // --- Init request modules ---

  if (Runtime_Modules_GetByUID(AUI_UID, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  UI_SetProcs(Module.Procs);

  if (Runtime_Modules_InitByUID(AUI_UID) < 0) then
  begin
    Result := -1;
    Exit;
  end;

  UI_MainWindow_AddMenuItem('', 'Tools', miToolsText, nil, 0, 900);
  UI_MainWindow_AddMenuItem('Tools', 'Settings', miSettingsText, miSettingsClick, 0, 1000);
  {Window := UI_GetMainWindow;
  Menu := UI_Window_GetMenu(Window);
  Items := UI_Menu_GetItems(Menu);
  miTools := UI_MenuItem_Add(Items, 'Tools', miToolsText, nil, 0, 900);
  UI_MenuItem_Add(miTools, 'Settings', miSettingsText, miSettingsClick, 0, 1000);}

  InitSettingsWin;

  FInitialized := True;
  Result := 0;
end;

function UISettings_Item_GetPage(Item: AUISettingsItem): AControl; stdcall;
begin
  Result := FItems[Item - 1].Page;
end;

{function UISettings_Item_New(Parent: AUISettingsItem; const Text: AString; ...): AUISettingsItem; stdcall;
var
  ParentTreeNode: ATreeNode;
  TreeNode: ATreeNode;
  Page: AControl;
begin
  if (Parent > 0) then
    ParentTreeNode := FItems[Parent-1].TreeNode
  else
    ParentTreeNode := 0;

  TreeNode := UI_TreeView_AddItem(FTreeView, ParentTreeNode, Text);
  Page := UI_PageControl_AddPage(FPageControl, '', Text);

  Result := AddSettingsItem(TreeNode, Page)+1;
end;}

function UISettings_MainSettingsWin: AWindow; stdcall;
begin
  Result := SettingsWin;
end;

function UISettings_NewItem(Parent: AUISettingsItem; const Text: AString): AUISettingsItem; stdcall;
var
  ParentTreeNode: ATreeNode;
  TreeNode: ATreeNode;
  Page: AControl;
begin
  if (Parent > 0) then
    ParentTreeNode := FItems[Parent-1].TreeNode
  else
    ParentTreeNode := 0;

  TreeNode := UI_TreeView_AddItem(FTreeView, ParentTreeNode, Text);
  Page := UI_PageControl_AddPage(FPageControl, '', Text);

  Result := AddSettingsItem(TreeNode, Page)+1;
end;

function UISettings_SettingsWin_New: AWindow; stdcall;
var
  Dialog: ADialog;
begin
  Dialog := UI_Dialog_New(MB_ApplyOkCancel);
  Result := UI_Dialog_GetWindow(Dialog);
  //Result := UI_Window_New;
  if (Result <> 0) then
  begin
    UI_Control_SetText(Result, wndName);
    UI_Control_SetPosition(Result, 100, 100);
    UI_Control_SetSize(Result, 500, 400);

    FTreeView := UI_TreeView_New(Result);
    UI_Control_SetSize(FTreeView, 150, 400);

    {Splitter :=} UI_Splitter_New(Result, 1);

    FPageControl := UI_PageControl_New(Result);
  end;
end;

procedure UISettings_ShowSettingsWin; stdcall;
begin
  InitSettingsWin;
  UI_Control_SetVisible(SettingsWin, True);
end;

{initialization
  UISettings_Boot(Addr(UISettingsFuncs));}
end.
