{
Abstract:  " "
Author:  Prof1983 <prof1983@yandex.ru>
Created: 04.04.2006
LastMod: 16.05.2011
Version: 0.2.5+0.3.0
}
unit fAbout;

{$IFDEF FPC}
  {$MODE Delphi}
  {$DEFINE A02}
{$ENDIF}

{$IFDEF A02}{$DEFINE A02UP}{$ENDIF}
{$IFDEF A03}{$DEFINE A02UP}{$ENDIF}

interface

uses
  {$IFDEF FPC}LResources,{$ENDIF}
  {$IFDEF MSWINDOWS}ShellAPI, Windows,{$ENDIF}
  Buttons, Classes, Controls, Dialogs, ExtCtrls, Graphics, Forms, Messages, StdCtrls, SysUtils,
  {$IFDEF A03}ASystem0,{$ENDIF}
  ABase0, {$IFDEF A02UP}ARuntime0{$ELSE}ARuntime01{$ENDIF}, AUI0;

type
  TAboutForm = class(TForm)
    Panel1: TPanel;
    Image1: TImage;
    lbName: TLabel;
    Memo: TMemo;
    procedure FormResize(Sender: TObject);
  private
    ButtonsPanel: TPanel;
    OkButton: AControl{TBitBtn};
    UrlText: TLabel;
    procedure UrlTextClick(Sender: TObject);
  private
    function GetPicture: TPicture;
    function GetProgramName: AString;
    function GetReference: AString;
    procedure SetProgramName(const Value: AString);
    procedure SetReference(const Value: AString);
  protected
    procedure DoCreate; override;
  public
    function AddButton(Left, Width: Integer; const Text: AString; OnClick: ACallbackProc): AControl;
    procedure Init;
    procedure InitA(MemoWidth, MemoHeight: Integer);
    procedure LoadApplicationIcon;
    //   
    property Picture: TPicture read GetPicture;
    //  
    property ProgramName: AString read GetProgramName write SetProgramName;
    //    
    property Reference: AString read GetReference write SetReference;
  end;

// Default MemoWidth=250, MemoHeight=115
procedure ShowAboutWinA(MemoWidth, MemoHeight: Integer);

implementation

{$IFNDEF FPC}
  {$R *.dfm}
{$ENDIF}

const
  {$IFDEF FPC}
  cCaption = 'About...';
  cCompanyName = 'Company: ';
  cDesctiption = 'Description: ';
  cProgramName = 'Program name: ';
  cProgramVersion = 'Version: ';
  cProductVersion = 'Product version: ';
  {$ELSE}
  cCaption = ' ';
  cCompanyName = ': ';
  cDesctiption = ': ';
  cProgramName = ' : ';
  cProgramVersion = ': ';
  cProductVersion = ' : ';
  {$ENDIF}

{ Public procs }

procedure ShowAboutWinA(MemoWidth, MemoHeight: Integer);
var
  Form: TAboutForm;
begin
  Form := TAboutForm.Create(nil);
  try
    Form.InitA(MemoWidth, MemoHeight);
    Form.ShowModal;
  finally
    Form.Free;
  end;
end;

{ TAboutForm }

function TAboutForm.AddButton(Left, Width: Integer; const Text: AString; OnClick: ACallbackProc): AControl;
var
  Button: AControl;
begin
  Button := UI_Button_New(AControl(ButtonsPanel));
  if (Button <> 0) then
  begin
    UI_Control_SetPosition(Button, Left, 4);
    UI_Control_SetSize(Button, Width, 25);
    UI_Control_SetText(Button, Text);
    UI_Control_SetOnClick(Button, OnClick);
    {$IFNDEF FPC}TBitBtn(Button).Anchors := [akRight, akBottom];{$ENDIF}
  end;
  Result := Button;
end;

procedure TAboutForm.DoCreate;
{var
  Button: AControl;}
begin
  inherited;

  ButtonsPanel := TPanel.Create(Self);
  ButtonsPanel.Parent := Self;
  ButtonsPanel.Align := alBottom;
  ButtonsPanel.Height := 34;

    OkButton := AddButton(270, 75, 'OK', nil);
    TBitBtn(OkButton).TabOrder := 1;
    TBitBtn(OkButton).Kind := bkOK;

  UrlText := TLabel.Create(Self);
  UrlText.Parent := Self;
  UrlText.Left := 4;
  UrlText.Top := 143;
  UrlText.Anchors := [akLeft, akBottom];
  UrlText.Cursor := crHandPoint;
  UrlText.Font.Style := [fsUnderline];
  UrlText.Font.Color := clBlue;
  UrlText.OnClick := UrlTextClick;
end;

procedure TAboutForm.FormResize(Sender: TObject);
begin
  UI_Control_SetSize(OkButton, ButtonsPanel.Width - UI_Control_GetWidth(OkButton) - 4, UI_Control_GetHeight(OkButton));
  UrlText.Top := ButtonsPanel.Top - UrlText.Height - 4;
  {Delta := Self.Height - Self.ClientHeight;
  UrlText.Top := 143 + Delta;}
end;

function TAboutForm.GetPicture: TPicture;
begin
  Result := Image1.Picture;
end;

function TAboutForm.GetProgramName: AString;
begin
  Result := lbName.Caption;
end;

function TAboutForm.GetReference: AString;
begin
  Result := UrlText.Caption;
end;

procedure TAboutForm.Init;
begin
  InitA(0, 115);
end;

procedure TAboutForm.InitA(MemoWidth, MemoHeight: Integer);
var
  S: string;
begin
  if (Runtime_GetUrl <> '') then
    Memo.Height := Memo.Height - 10;
  Self.Reference := Runtime_GetUrl;
  Self.lbName.Caption := Runtime_GetProductName;
  // Prof1983: 01.11.2010
  {S := Runtime_GetProductVersion;
  if (S <> '') then
  begin
    lbName.Caption := lbName.Caption+' ('+S+')';
    if (Length(lbName.Caption) > 30) then
      lbName.Height := 45;
  end;}
  S := Runtime_GetProgramName; // OriginalFilename
  if (S <> '') then Memo.Lines.Add(cProgramName+S);
  S := Runtime_GetProgramVersion; // FileVersion
  if (S <> '') then Memo.Lines.Add(cProgramVersion+S);

  // Prof1983: 01.11.2010
  S := Runtime_GetProductVersion;
  if (S <> '') then Memo.Lines.Add(cProductVersion+S);

  S := Runtime_GetCopyright; // LegalCopyright
  if (S <> '') then Memo.Lines.Add(S);
  S := Runtime_GetCompanyName;
  if (S <> '') then Memo.Lines.Add(cCompanyName+S);
  S := Runtime_GetDescription;
  if (S <> '') then Memo.Lines.Add(S);
  //if (S <> '') then Memo.Lines.Add(cDesctiption+S);

  Caption := cCaption;

  S := Runtime_GetExePath+Runtime_GetProgramName+'.bmp';
  if FileExists(S) then
  try
    Image1.Picture.LoadFromFile(S);
  except
    Self.LoadApplicationIcon;
  end
  else
    Self.LoadApplicationIcon;

  if (MemoWidth > 0) then
    Memo.Width := MemoWidth;

  if (MemoHeight > 0) then
    Memo.Height := MemoHeight;

  Self.ClientWidth := Memo.Left + Memo.Width + 8;
  Self.ClientHeight := Memo.Top + Memo.Height + UrlText.Height + ButtonsPanel.Height + 8;
end;

procedure TAboutForm.LoadApplicationIcon;
begin
  Image1.Picture.Assign(Application.Icon);
end;

procedure TAboutForm.SetProgramName(const Value: AString);
begin
  lbName.Caption := Value;
end;

procedure TAboutForm.SetReference(const Value: AString);
begin
  UrlText.Caption := Value;
end;

procedure TAboutForm.UrlTextClick(Sender: TObject);
begin
  {$IFNDEF UNIX}
  ShellExecute(Handle, 'Open', PChar(UrlText.Caption), nil, nil, 0);
  {$ENDIF}
end;

initialization
{$IFDEF FPC}
  {$I fAbout.lrs}
{$ENDIF}
end.
