{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 11.01.2010
LastMod: 03.05.2011
Version: 0.3.0
}
unit AUIGrids;

{DEFINE A01}
{$IFDEF FPC}
  {$DEFINE A02}
{$ENDIF}

{$IFDEF A02}{$DEFINE A02UP}{$ENDIF}
{$IFDEF A03}{$DEFINE A02UP}{$ENDIF}

interface

uses
  Classes, Controls, DBGrids, Grids, SysUtils,
  ABase0, {$IFDEF A02UP}ASettings0{$ELSE}ASettings01{$ENDIF};
  //ABase, {$IFDEF A02UP}ASettings0{$ELSE}{$IFDEF A01}ASettings{$ELSE}ASettings01{$ENDIF}{$ENDIF};

function DBGrid_New(Parent: TWinControl): TDBGrid;
//   DBGrid
procedure DBGrid_RestoreColProps(Grid: TDBGrid; Config: AConfig; const Key: AString; Delimer: AChar = '\');
//   DBGrid
procedure DBGrid_SaveColProps(Grid1: TDBGrid; Config: AConfig; const Key: AString; Delimer: AChar = '\');
//     DBGrid
procedure DBGrid_SetColumnWidth(Grid1: TDBGrid; ColumnIndex, Width, Persent, MinWidth: AInteger);
procedure DBGrid_SetColumnWidthA(Grid1: TDBGrid; ColumnIndex, Width, Persent, MinWidth, MaxWidth: AInteger);

procedure StringGrid_Clear(Grid: TStringGrid);
procedure StringGrid_ClearA(Grid: TStringGrid; FixedRows: Integer);
procedure StringGrid_DeleteRowByValue(Grid: TStringGrid; Col: Integer; const Value: string);
function StringGrid_Find(Grid: TStringGrid; Col: Integer; const Value: string): Integer;
function StringGrid_FindInt(Grid: TStringGrid; Col, Value: Integer): Integer;
function StringGrid_New(Parent: TWinControl): TStringGrid;
function StringGrid_RowAdd(Grid: TStringGrid): Integer;
function StringGrid_RowAddA(Grid: TStringGrid): Integer;
procedure StringGrid_RowClear(Grid: TStringGrid);
procedure StringGrid_RowClearA(Grid: TStringGrid; Row: Integer);
procedure StringGrid_RowDelete(Grid: TStringGrid);
procedure StringGrid_RowDeleteA(Grid: TStringGrid; Row: Integer);
//   
procedure StringGrid_RowDown(Grid: TStringGrid);
//   
procedure StringGrid_RowDownA(Grid: TStringGrid; Row: Integer);
procedure StringGrid_RowInsert(Grid: TStringGrid);
//   
procedure StringGrid_RowUp(Grid: TStringGrid);
procedure StringGrid_RowSelect(Grid: TStringGrid; Row: Integer);
//   StringGrid
procedure StringGrid_RestoreColProps(Grid: TStringGrid; Config: AConfig; const Key: AString; Delimer: AChar = '\');
//   StringGrid
procedure StringGrid_RestoreColPropsA(Grid: TStringGrid; Config: AConfig; const Parent, Name: AString; Delimer: AChar = '\');
//   StringGrid
procedure StringGrid_SaveColProps(Grid: TStringGrid; Config: AConfig; const Key: AString; Delimer: AChar = '\');
//   StringGrid
procedure StringGrid_SaveColPropsA(Grid: TStringGrid; Config: AConfig; const Parent, Name: AString; Delimer: AChar = '\');
procedure StringGrid_SetRowCount(Grid: TStringGrid; Count: Integer);
procedure StringGrid_Sort_Float(Grid: TStringGrid);
procedure StringGrid_Sort_Int(Grid: TStringGrid);

{ Testing }

procedure StringGrid_ClearCol(Grid: TStringGrid; Col: Integer);
function StringGrid_FindInt_Trim(Grid: TStringGrid; Col, Value: Integer): Integer;

implementation

{ DBGrid }

function DBGrid_New(Parent: TWinControl): TDBGrid;
var
  Grid: TDBGrid;
begin
  Grid := TDBGrid.Create(Parent);
  Grid.Parent := Parent;
  Grid.Align := alClient;
  Result := Grid;
end;

procedure DBGrid_RestoreColProps(Grid: TDBGrid; Config: AConfig; const Key: AString; Delimer: AChar);
var
  i: SmallInt;
  k: SmallInt;
  idx: Integer;
  wdt: Integer;
  C: TColumn;
  C1: TColumn;
  default: Boolean;
  S: TStringList;
  S1: TStringList;
begin
  {$IFNDEF FPC}
  default := (Grid.Columns.State = csDefault);
  try
    C := TColumn.Create(nil);
    C1 := TColumn.Create(nil);
    S := TStringList.Create;
    S1 := TStringList.Create;
    try
      for i := 0 to Grid.Columns.Count - 1 do
      begin
        wdt := Settings_ReadInteger(Config, Key + Delimer + Grid.Name + Delimer + Grid.Columns.Items[i].FieldName, 'Width', 0);
        if (wdt > 0) then
          Grid.Columns.Items[i].Width := wdt;
      end;

      for i := 0 to Grid.Columns.Count - 1 do
      begin
        C.Assign(Grid.Columns.Items[i]);
        idx := Settings_ReadInteger(Config, Key + Delimer + Grid.Name + Delimer + Grid.Columns.Items[i].FieldName, 'Index', -1);
        if (idx <> -1) and (idx >= Grid.Columns.Count) then
        begin
          if not default then
          begin
            if (i <> idx) then
            begin
              C1.Assign(Grid.Columns.Items[idx]);
              Grid.Columns.Items[i].Assign(C1);
            end;
            Grid.Columns.Items[idx].Assign(C);
          end
          else
          begin
            S.Add(Grid.Columns.Items[i].FieldName+'='+IntToStr(idx));
          end;
        end;
      end;

      for i := 0 to S.Count - 1 do
        for k := 0 to S.Count - 1 do
        begin
          if (StrToInt(S.Values[S.Names[k]])) = i then
          begin
            S1.Add(S[k]);
            Break;
          end;
        end;

      for i := 0 to S1.Count - 1 do
        for k := 0 to Grid.Columns.Count - 1 do
        begin
          if (Grid.Columns.Items[k].FieldName = S1.Names[i]) then
          begin
            Grid.Columns.Items[k].Index := StrToInt(S1.Values[S1.Names[i]]);
            Break;
          end;
        end;
    finally
      C.Free;
      C1.Free;
      S.Free;
      S1.Free;
    end;
  except
  end;
  {$ENDIF}
end;

procedure DBGrid_SaveColProps(Grid1: TDBGrid; Config: AConfig; const Key: AString; Delimer: AChar);
var
  I: Integer;
  C: TColumn;
  SectionName: string;
begin
  {$IFNDEF FPC}
  for I := 0 to Grid1.Columns.Count - 1 do
  begin
    C := Grid1.Columns.Items[I];
    SectionName := Key+Delimer+Grid1.Name+Delimer+C.FieldName;
    Settings_WriteInteger(Config, SectionName, 'Index', I);
    Settings_WriteInteger(Config, SectionName, 'Width', C.Width);
  end;
  {$ENDIF}
end;

procedure DBGrid_SetColumnWidth(Grid1: TDBGrid; ColumnIndex, Width, Persent, MinWidth: AInteger);
var
  tmpWidth: Integer;
  Column: TColumn;
begin
  {$IFNDEF FPC}
  Column := Grid1.Columns.Items[ColumnIndex];
  tmpWidth := (Width * Persent) div 100;
  if (tmpWidth >= MinWidth) then
    Column.Width := tmpWidth
  else
    Column.Width := MinWidth;
  {$ENDIF}
end;

procedure DBGrid_SetColumnWidthA(Grid1: TDBGrid; ColumnIndex, Width, Persent, MinWidth, MaxWidth: AInteger);
var
  tmpWidth: Integer;
  Column: TColumn;
begin
  {$IFNDEF FPC}
  Column := Grid1.Columns.Items[ColumnIndex];
  tmpWidth := Round((Width - 30) * Persent / 100) - 4;
  if (tmpWidth < MinWidth) then
    tmpWidth := MinWidth
  else if (tmpWidth > MaxWidth) then
    tmpWidth := MaxWidth;
  Column.Width := tmpWidth;
  {$ENDIF}
end;

{ StringGrid }

procedure StringGrid_Clear(Grid: TStringGrid);
var
  i: Integer;
  j: Integer;
begin
  Grid.RowCount := Grid.FixedRows+1;
  j := Grid.FixedRows;
  for i := 0 to Grid.ColCount-1 do
    Grid.Cells[i,j] := '';
end;

procedure StringGrid_ClearA(Grid: TStringGrid; FixedRows: Integer);
var
  I: Integer;
begin
  Grid.RowCount := FixedRows+1;
  Grid.FixedRows := FixedRows;
  for I := 0 to Grid.ColCount-1 do
    Grid.Cells[I, FixedRows] := '';
end;

procedure StringGrid_ClearCol(Grid: TStringGrid; Col: Integer);
var
  I: Integer;
begin
  for I := Grid.FixedRows to Grid.RowCount-1 do
    Grid.Cells[Col,I] := '';
end;

procedure StringGrid_DeleteRowByValue(Grid: TStringGrid; Col: Integer; const Value: string);
var
  I: Integer;
begin
  for I := 0 to Grid.RowCount-1 do
    if (Grid.Cells[Col,I] = Value) then
      StringGrid_RowDelete(Grid);
end;

function StringGrid_Find(Grid: TStringGrid; Col: Integer; const Value: string): Integer;
var
  I: Integer;
begin
  for I := Grid.FixedRows to Grid.RowCount - 1 do
  begin
    if (Grid.Cells[Col,I] = Value) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function StringGrid_FindInt(Grid: TStringGrid; Col, Value: Integer): Integer;
var
  I: Integer;
begin
  for I := Grid.FixedRows to Grid.RowCount - 1 do
  begin
    if (StrToIntDef(Grid.Cells[Col,I], 0) = Value) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function StringGrid_FindInt_Trim(Grid: TStringGrid; Col, Value: Integer): Integer;
var
  I: Integer;
begin
  for I := Grid.FixedRows to Grid.RowCount - 1 do
  begin
    if (StrToIntDef(Trim(Grid.Cells[Col,I]),0) = Value) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function StringGrid_New(Parent: TWinControl): TStringGrid;
var
  SGrid: TStringGrid;
begin
  SGrid := TStringGrid.Create(Parent);
  SGrid.Parent := Parent;
  SGrid.ColCount := 4;
  SGrid.RowCount := 2;
  SGrid.FixedCols := 1;
  SGrid.FixedRows := 1;
  SGrid.Cells[0,0] := '';
  SGrid.Cells[1,0] := 'Subject';
  SGrid.Cells[2,0] := 'Property';
  SGrid.Cells[3,0] := 'Object';
  SGrid.ColWidths[0] := 30;
  SGrid.ColWidths[1] := 150;
  SGrid.ColWidths[2] := 150;
  SGrid.ColWidths[3] := 150;
  SGrid.DefaultRowHeight := 16;
  Result := SGrid;
end;

procedure StringGrid_RestoreColProps(Grid: TStringGrid; Config: AConfig; const Key: AString; Delimer: AChar = '\');
begin
  StringGrid_RestoreColPropsA(Grid, Config, Key, Grid.Name, Delimer);
end;

procedure StringGrid_RestoreColPropsA(Grid: TStringGrid; Config: AConfig; const Parent, Name: AString; Delimer: AChar = '\');
var
  i: Integer;
begin
  for i := 0 to Grid.ColCount - 1 do
    Grid.ColWidths[i] := Settings_ReadInteger(Config, Parent + Delimer + Name + Delimer + IntToStr(i), 'Width', Grid.ColWidths[i]);
end;

function StringGrid_RowAdd(Grid: TStringGrid): Integer;
begin
  Result := Grid.RowCount;
  Grid.RowCount := Result+1;
end;

function StringGrid_RowAddA(Grid: TStringGrid): Integer;
var
  i: Integer;
  IsClear: Boolean;
begin
  if (Grid.RowCount = Grid.FixedRows+1) then
  begin
    IsClear := True;
    for i := Grid.FixedCols to Grid.ColCount do
    begin
      IsClear := False;
      Break;
    end;
    if IsClear then
    begin
      Result := Grid.FixedRows;
      Exit;
    end;
  end;
  Result := Grid.RowCount;
  Grid.RowCount := Result+1;
end;

procedure StringGrid_RowClear(Grid: TStringGrid);
begin
  StringGrid_RowClearA(Grid, Grid.Row);
end;

procedure StringGrid_RowClearA(Grid: TStringGrid; Row: Integer);
var
  I: Integer;
begin
  for I := 0 to Grid.ColCount - 1 do
    Grid.Cells[I,Row] := '';
end;

procedure StringGrid_RowDelete(Grid: TStringGrid);
begin
  StringGrid_RowDeleteA(Grid, Grid.Row);
end;

procedure StringGrid_RowDeleteA(Grid: TStringGrid; Row: Integer);
var
  ic: Integer;
begin
  if (Grid.RowCount <= Grid.FixedRows+1) then
    StringGrid_Clear(Grid)
  else
  begin
    for ic := Row to Grid.RowCount - 1 do
      Grid.Rows[ic] := Grid.Rows[ic+1];
    Grid.RowCount := Grid.RowCount - 1;
  end;
end;

procedure StringGrid_RowDown(Grid: TStringGrid);
begin
  StringGrid_RowDownA(Grid, Grid.Row);
end;

procedure StringGrid_RowDownA(Grid: TStringGrid; Row: Integer);
var
  i: Integer;
  S: string;
begin
  if (Row < Grid.RowCount - 1) then
  begin
    for i := 0 to Grid.ColCount - 1 do
    begin
      S := Grid.Cells[i,Row];
      Grid.Cells[i,Row] := Grid.Cells[i,Row+1];
      Grid.Cells[i,Row+1] := S;
    end;
    Grid.Row := Row + 1;
  end;
end;

procedure StringGrid_RowInsert(Grid: TStringGrid);
var
  ic: Integer;
  jc: Integer;
  SRect: TGridRect;
begin
  for ic := Grid.RowCount - 1 downto Grid.Row + 1 do
    Grid.Rows[ic+1] := Grid.Rows[ic];
  for jc := 0 to Grid.ColCount-1 do
    Grid.Cells[jc,Grid.Row+1] := '';
  Grid.RowCount := Grid.RowCount + 1;
  SRect.Top := Grid.Row + 1;
  SRect.Left := 0 + Grid.FixedCols;
  SRect.Bottom := Grid.Row + 1;
  SRect.Right := 0 + Grid.FixedCols;
  Grid.Selection := SRect;
end;

procedure StringGrid_RowSelect(Grid: TStringGrid; Row: Integer);
var
  Srect: TGridRect;
begin
  SRect.Top := Row;
  SRect.Left := 0;
  SRect.Bottom := Row;
  SRect.Right := 0;
  Grid.Selection := SRect;
end;

procedure StringGrid_RowUp(Grid: TStringGrid);
var
  i: Integer;
  Row: Integer;
  S: string;
begin
  Row := Grid.Row;
  if (Row > Grid.FixedRows) then
  begin
    for i := 0 to Grid.ColCount - 1 do
    begin
      S := Grid.Cells[i,Row];
      Grid.Cells[i,Row] := Grid.Cells[i,Row-1];
      Grid.Cells[i,Row-1] := S;
    end;
    Grid.Row := Row - 1;
  end;
end;

procedure StringGrid_SaveColProps(Grid: TStringGrid; Config: AConfig; const Key: AString; Delimer: AChar = '\');
begin
  StringGrid_SaveColPropsA(Grid, Config, Key, Grid.Name, Delimer);
end;

procedure StringGrid_SaveColPropsA(Grid: TStringGrid; Config: AConfig; const Parent, Name: AString; Delimer: AChar = '\');
var
  I: Integer;
  SectionName: string;
begin
  for I := 0 to Grid.ColCount - 1 do
  begin
    SectionName := Parent+Delimer+Name+Delimer+IntToStr(i);
    Settings_WriteInteger(Config, SectionName, 'Width', Grid.ColWidths[i]);
  end;
end;

procedure StringGrid_SetRowCount(Grid: TStringGrid; Count: Integer);
begin
  if (Count >= Grid.FixedRows+1) then
    Grid.RowCount := Count
  else
    StringGrid_Clear(Grid);
  {begin
    TablDavl.RowCount := 3;
    TablDavl.Cells[0,2] := '';
    TablDavl.Cells[0,3] := '';
  end;}
end;

procedure StringGrid_Sort_Float(Grid: TStringGrid);
var
  IsWork: Boolean;
  Col: Integer;
  i: Integer;
  a: Double;
  b: Double;
begin
  Col := Grid.Col;
  IsWork := True;
  while (IsWork) do
  begin
    IsWork := False;
    for i := Grid.FixedRows to Grid.RowCount - 2 do
    begin
      a := StrToFloatDef(Grid.Cells[Col,i],0);
      b := StrToFloatDef(Grid.Cells[Col,i+1],0);
      if (a > b) then
      begin
        StringGrid_RowDownA(Grid, i);
        IsWork := True;
      end;
    end;
  end;
end;

procedure StringGrid_Sort_Int(Grid: TStringGrid);
var
  IsWork: Boolean;
  Col: Integer;
  i: Integer;
  a: Integer;
  b: Integer;
begin
  Col := Grid.Col;
  IsWork := True;
  while (IsWork) do
  begin
    IsWork := False;
    for i := Grid.FixedRows to Grid.RowCount - 2 do
    begin
      a := StrToIntDef(Grid.Cells[Col,i],0);
      b := StrToIntDef(Grid.Cells[Col,i+1],0);
      if (a > b) then
      begin
        StringGrid_RowDownA(Grid, i);
        IsWork := True;
      end;
    end;
  end;
end;

end.
