{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 20.01.2010
LastMod: 03.05.2011
Version: 0.3.0
}
unit AUIForm;

{$IFDEF FPC}
  {$DEFINE A02}
{$ENDIF}

{$IFDEF A02}{$DEFINE A02UP}{$ENDIF}
{$IFDEF A03}{$DEFINE A02UP}{$ENDIF}

interface

uses
  Forms, ABase0, {$IFDEF A02UP}ASettings0{$ELSE}ASettings01{$ENDIF};

function Form_LoadConfig(Form: TForm; Config: AConfig): ABoolean;
function Form_LoadConfig2(Form: TForm; Config: AConfig; const ConfigKey: AString): ABoolean;
function Form_LoadConfig3(Form: TForm; Config: AConfig; const ConfigKey: AString; DefWindowState: TWindowState): ABoolean;
function Form_SaveConfig(Form: TForm; Config: AConfig): ABoolean;
function Form_SaveConfig2(Form: TForm; Config: AConfig; const ConfigKey: AString): ABoolean;

implementation

function Form_LoadConfig(Form: TForm; Config: AConfig): ABoolean;
begin
  Result := Form_LoadConfig2(Form, Config, Form.Name);
end;

function Form_LoadConfig2(Form: TForm; Config: AConfig; const ConfigKey: AString): ABoolean;
begin
  Result := Form_LoadConfig3(Form, Config, ConfigKey, Form.WindowState);
end;

function Form_LoadConfig3(Form: TForm; Config: AConfig; const ConfigKey: AString; DefWindowState: TWindowState): ABoolean;
begin
  try
    Form.WindowState := wsNormal;
    Form.Left := Settings_ReadInteger(Config, ConfigKey, 'Left', Form.Left);
    Form.Top := Settings_ReadInteger(Config, ConfigKey, 'Top', Form.Top);
    Form.Width := Settings_ReadInteger(Config, ConfigKey, 'Width', Form.Width);
    Form.Height := Settings_ReadInteger(Config, ConfigKey, 'Height', Form.Height);
    Form.WindowState := TWindowState(Settings_ReadInteger(Config, ConfigKey, 'WindowState', Integer(DefWindowState)));
    Result := True;
  except
    Result := False;
  end;
end;
{function Form_LoadConfig3(Form: TForm; Config: AConfig; const ConfigKey: AString; DefWindowState: TWindowState): ABoolean;
var
  OldWindowState: TWindowState;
  //OldFormVisible: Boolean; // Prof1983: 07.04.2011
begin
  try
    //OldFormVisible := Form.Visible;
    //Form.Visible := False;
    OldWindowState := Form.WindowState;
    Form.WindowState := wsNormal;
    Form.Left := Settings_ReadInteger(Config, ConfigKey, 'Left', Form.Left);
    Form.Top := Settings_ReadInteger(Config, ConfigKey, 'Top', Form.Top);
    Form.Width := Settings_ReadInteger(Config, ConfigKey, 'Width', Form.Width);
    Form.Height := Settings_ReadInteger(Config, ConfigKey, 'Height', Form.Height);
    Form.WindowState := TWindowState(Settings_ReadInteger(Config, ConfigKey, 'WindowState', Integer(OldWindowState)));
    //Form.Visible := OldFormVisible;
    Result := True;
  except
    Result := False;
  end;
end;}

function Form_SaveConfig(Form: TForm; Config: AConfig): ABoolean;
begin
  Result := Form_SaveConfig2(Form, Config, Form.Name);
end;

function Form_SaveConfig2(Form: TForm; Config: AConfig; const ConfigKey: AString): ABoolean;
begin
  try
    if (Config <> 0) and (Form.WindowState <> wsMaximized) then
    begin
      Settings_WriteInteger(Config, ConfigKey, 'Left', Form.Left);
      Settings_WriteInteger(Config, ConfigKey, 'Top', Form.Top);
      Settings_WriteInteger(Config, ConfigKey, 'Width', Form.Width);
      Settings_WriteInteger(Config, ConfigKey, 'Height', Form.Height);
    end;
    Settings_WriteInteger(Config, ConfigKey, 'WindowState', Integer(Form.WindowState));
    Result := True;
  except
    Result := False;
  end;
end;

end.
 
