{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 14.01.2010
LastMod: 12.05.2011
Version: 0.1.1+0.2.5+0.3.0
}
unit AUIEdit;

{$IFDEF FPC}
  {$DEFINE A02}
{$ENDIF}

{$IFDEF A02}{$DEFINE A02UP}{$ENDIF}
{$IFDEF A03}{$DEFINE A02UP}{$ENDIF}

interface

uses
  StdCtrls, ABase0, {$IFDEF A02UP}AUtils0{$ELSE}AUtils01{$ENDIF};

function Edit_CheckDate(Edit: TCustomEdit{TMaskEdit}; out Value: TDateTime): ABoolean;
function Edit_CheckFloat(Edit: TCustomEdit; out Value: Double): ABoolean;
function Edit_CheckFloat32(Edit: TCustomEdit; out Value: AFloat32): ABoolean;
function Edit_CheckFloat64(Edit: TCustomEdit; out Value: AFloat64): ABoolean;
function Edit_CheckInt(Edit: TCustomEdit; out Value: AInteger): ABoolean;

implementation

{ Edit }

function Edit_CheckDate(Edit: TCustomEdit; out Value: TDateTime): ABoolean;
begin
  Value := 0;
  if (Edit.Text <> '') and (Edit.Text <> '  .  .  ') then
  begin
    Result := Utils_TryStrToDate(Edit.Text, Value);
    if not(Result) then
    begin
      Edit.SelectAll;
      Edit.SetFocus;
    end;
  end;
  Result := True;
end;

function Edit_CheckFloat(Edit: TCustomEdit; out Value: Double): ABoolean;
begin
  if (Edit.Text <> '') then
  begin
    if not(Utils_TryStrToFloat64(Edit.Text, Value)) then
    begin
      Edit.SetFocus;
      Edit.SelectAll;
      Result := False;
      Exit;
    end;
  end
  else
    Value := 0;
  Result := True;
end;

function Edit_CheckFloat32(Edit: TCustomEdit; out Value: AFloat32): ABoolean;
var
  V: Double;
begin
  Result := Edit_CheckFloat(Edit, V);
  if Result then
    Value := V;
end;

function Edit_CheckFloat64(Edit: TCustomEdit; out Value: AFloat64): ABoolean;
begin
  Result := Edit_CheckFloat(Edit, Value);
end;

function Edit_CheckInt(Edit: TCustomEdit; out Value: AInteger): ABoolean;
begin
  if (Edit.Text <> '') then
  begin
    if not(Utils_TryStrToInt(Edit.Text, Value)) then
    begin
      Edit.SetFocus;
      Edit.SelectAll;
      Result := False;
      Exit;
    end;
  end
  else
    Value := 0;
  Result := True;
end;

end.
 
