{
Author: Prof1983 <prof1983@yandex.ru>
Created: 16.02.2009
LastMod: 15.05.2011
Version: 0.2.5+0.3.0
}
unit AUIDialogs;

{DEFINE USE_JEDI}

interface

uses
  {$IFDEF USE_JEDI}JvBaseDlg, JvSelectDirectory,{$ENDIF}
  Dialogs, ABase0;

function ExecuteColorDialog(var Color: AColor): ABoolean;
function ExecuteFontDialog(var FontName: AString; var FontSize: AInteger; var FontColor: AColor): ABoolean; stdcall;
function ExecuteOpenDialogA(const InitialDir, Filter, DefaultExt, Title: AString; var FileName: AString; var FilterIndex: AInteger): ABoolean;
function ExecuteSaveFileDialog(const InitialDir, DefExt, DefFileName: string): string;
function ExecuteSaveFileDialogA(const InitialDir, DefExt, DefFileName, Filter: AString; var FilterIndex: AInteger): AString; stdcall;

{ Testing }

function ExecuteSelectDirectoryDialog(var Directory: AString): ABoolean;

{ Old }

//function SelectSaveFileName(const Dir, Ext, DefFileName: string): string; deprecated;
//function SelectSaveFileNameA(const InitialDir, DefExt, DefFileName, Filter: AString; var FilterIndex: AInteger): AString; stdcall; deprecated;

implementation

function ExecuteColorDialog(var Color: AColor): ABoolean;
var
  ColorDialog: TColorDialog;
begin
  ColorDialog := TColorDialog.Create(nil);
  try
    ColorDialog.Color := Color;
    Result := ColorDialog.Execute;
    if Result then
      Color := ColorDialog.Color;
  finally
    ColorDialog.Free;
  end;
end;

function ExecuteFontDialog(var FontName: AString; var FontSize: AInteger; var FontColor: AColor): ABoolean; stdcall;
var
  FontDialog: TFontDialog;
begin
  FontDialog := TFontDialog.Create(nil);
  try
    FontDialog.Font.Color := FontColor;
    FontDialog.Font.Name := FontName;
    FontDialog.Font.Size := FontSize;
    Result := FontDialog.Execute;
    if Result then
    begin
      FontColor := FontDialog.Font.Color;
      FontName := FontDialog.Font.Name;
      FontSize := FontDialog.Font.Size;
    end;
  finally
    FontDialog.Free;
  end;
end;

{function ExecuteOpenDialog1(const InitialDir, Filter, Title: AString; var FileName: AString): Boolean;
var
  Open: TOpenDialog;
begin
  Open := TOpenDialog.Create(nil);
  try
    Open.Options := [ofNoChangeDir,ofFileMustExist,ofPathMustExist];
    Open.Initialdir := InitialDir;
    Open.Filter := Filter;
    Open.Title := Title;
    Result := Open.Execute;
    if Result then
      FileName := Open.FileName;
  finally
    Open.Free;
  end;
end;}

function ExecuteOpenDialogA(const InitialDir, Filter, DefaultExt, Title: AString; var FileName: AString; var FilterIndex: AInteger): ABoolean;
var
  Open: TOpenDialog;
begin
  Open := TOpenDialog.Create(nil);
  try
    Open.Options := [ofNoChangeDir,ofFileMustExist,ofPathMustExist];
    Open.Initialdir := InitialDir;
    Open.Filter := Filter;
    Open.DefaultExt := DefaultExt;
    if (Title = '') then
      Open.Title := ''
    else
      Open.Title := Title;
    Open.FilterIndex := FilterIndex;
    Result := Open.Execute;
    if Result then
    begin
      FileName := Open.FileName;
      FilterIndex := Open.FilterIndex;
    end;
  finally
    Open.Free;
  end;
end;

function ExecuteSaveFileDialog(const InitialDir, DefExt, DefFileName: string): string;
var
  FilterIndex: Integer;
begin
  FilterIndex := 0;
  Result := ExecuteSaveFileDialogA(InitialDir, DefExt, DefFileName, '', FilterIndex);
  //Result := SelectSaveFileNameA(Dir, Ext, DefFileName, '', FilterIndex);
end;

function ExecuteSaveFileDialogA(const InitialDir, DefExt, DefFileName, Filter: AString; var FilterIndex: AInteger): AString; stdcall;
var
  Dialog: TSaveDialog;
begin
  Dialog := TSaveDialog.Create(nil);
  try
    Dialog.InitialDir := InitialDir;
    Dialog.DefaultExt := DefExt;
    Dialog.Options := Dialog.Options + [ofNoChangeDir];
    Dialog.FileName := DefFileName;
    Dialog.Filter := Filter;
    Dialog.FilterIndex := FilterIndex;
    Dialog.Options := Dialog.Options + [ofOverwritePrompt];
    if Dialog.Execute then
    begin
      Result := Dialog.FileName;
      FilterIndex := Dialog.FilterIndex;
    end
    else
      Result := '';
  finally
    Dialog.Free();
  end;
end;

function ExecuteSelectDirectoryDialog(var Directory: AString): ABoolean;
{$IFDEF USE_JEDI}
var
  Dialog: TJvSelectDirectory;
{$ENDIF USE_JEDI}
begin
  {$IFDEF USE_JEDI}
  Dialog := TJvSelectDirectory.Create(nil);
  try
    Dialog.InitialDir := Directory;
    if Dialog.Execute then
    begin
      Directory := Dialog.Directory;
      Result := True;
    end
    else
      Result := False;
  finally
    Dialog.Free;
  end;
  {$ELSE}
  Result := False;
  {$ENDIF USE_JEDI}
end;

end.
 
