{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 17.05.2011
Version: 0.3.0
}
unit ASystem03;

{$I Defines.inc}

{$IFDEF UNIX}
  {$DEFINE NoRuntimeSysUtils}
{$ENDIF}

{$IFDEF NoSysUtils}
  {$DEFINE NoRuntimeSysUtils}
{$ENDIF NoSysUtils}

{$IFNDEF NoRuntimeConfig}
  {$DEFINE USE_CONFIG}
{$ENDIF NoRuntimeConfig}

{$IFNDEF NoRuntimeEvents}
  {$DEFINE USE_EVENTS}
{$ENDIF NoRuntimeEvents}

{$IFNDEF NoRuntimeSysUtils}
  {$DEFINE USE_SYSUTILS}
{$ENDIF NoRuntimeSysUtils}

interface

uses
  {$IFNDEF FPC}
    {$IFNDEF UNIX}ShellApi,{$ENDIF}
  {$ENDIF}

  {$IFDEF USE_SYSUTILS}SysUtils,{$ENDIF}
  {$IFNDEF UNIX}Windows,{$ENDIF}
  {$IFDEF USE_EVENTS}AEvents0,{$ENDIF}
  {$IFDEF USE_CONFIG}ASettings0,{$ENDIF}
  ABase0, ARuntime0, ASystem0;

// --- Info functions ---
function Runtime_GetCompanyName: AString; stdcall;
function Runtime_GetCopyright: AString; stdcall;
function Runtime_GetDescription: AString; stdcall;
function Runtime_GetExeName: AString; stdcall;
function Runtime_GetExePath: AString; stdcall;
function Runtime_GetProductName: AString; stdcall;
function Runtime_GetProductVersion: AString; stdcall;
function Runtime_GetProgramName: AString; stdcall;
function Runtime_GetProgramVersion: AString; stdcall;
function Runtime_GetTitle: AString; stdcall;
function Runtime_GetUrl: AString; stdcall;

function Runtime_GetConfig: AConfig; stdcall;
function Runtime_GetResourceString(const Section, Name, Default: AString): AString; stdcall;
procedure Runtime_ProcessMessages; stdcall;
procedure Runtime_SetConfig(Value: AConfig); stdcall;
procedure Runtime_ShowError(const UserMessage, ExceptMessage: AString); stdcall;
function Runtime_ShowMessage(const Msg: AString): ADialogBoxCommands; stdcall;
function Runtime_ShowMessageA(const Text, Caption: AString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;

// --- Set event functions ---
procedure Runtime_SetOnProcessMessages(Value: ARuntimeProc); stdcall;
procedure Runtime_SetOnShowError(Value: TAShowErrorProc); stdcall;
procedure Runtime_SetOnShowMessage(Value: TAShowMessageProc); stdcall;

{ Testing }

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun: AEvent; stdcall;
function Runtime_OnBeforeRun: AEvent; stdcall;
function Runtime_OnAfterRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): Integer; stdcall;
function Runtime_OnAfterRun_Disconnect(Callback: ACallbackProc): AInteger; stdcall;
function Runtime_OnBeforeRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
function Runtime_OnBeforeRun_Disconnect(Callback: ACallbackProc): AInteger; stdcall;
{$ENDIF USE_EVENTS}
function Runtime_ParamCount: AInteger; stdcall;
function Runtime_ParamStr(Index: AInteger): AString; stdcall;
function Runtime_ShellExecute(const Operation, FileName, Parameters, Directory: AString): AInteger; stdcall;
function Runtime_GetDataPath: AString; stdcall;

{ Private }

function IntToHex4(Value: Integer): string;
function IntToHex8(Value: Integer): string;
function AGuidToString(const ID: TGuid): string;
{$IFNDEF USE_SYSUTILS}
function IsEqualGUID(const guid1, guid2: TGUID): Boolean;
{$ENDIF}
function NormalizePath(const Path: string): string;

// --- Module ---

function System_Boot: AInteger; stdcall;

// Initialize Core (for Linux)
procedure System_BootA(const Title, ProgramName, ProgramVersion, ProductName, ProductVersion,
    CompanyName, Copyright, Url, Description, DataPath: AString);

// Initialise system
function System_Init: AInteger; stdcall;

// Finalize Core
function System_Done: AInteger; stdcall;

implementation

exports
  Runtime_GetCompanyName,
  Runtime_GetCopyright,
  Runtime_GetDescription,
  Runtime_GetExeName,
  Runtime_GetExePath,
  Runtime_GetProductName,
  Runtime_GetProductVersion,
  Runtime_GetProgramName,
  Runtime_GetProgramVersion,
  Runtime_GetTitle,
  Runtime_GetUrl,
  Runtime_GetResourceString,
  Runtime_GetConfig,
  {$IFDEF USE_EVENTS}
  Runtime_OnAfterRun_Connect,
  Runtime_OnAfterRun_Disconnect,
  Runtime_OnBeforeRun_Connect,
  Runtime_OnBeforeRun_Disconnect,
  {$ENDIF USE_EVENTS}
  Runtime_ProcessMessages,
  Runtime_SetConfig,
  Runtime_ShowError,
  Runtime_ShowMessage,
  Runtime_ShowMessageA,
  Runtime_Shutdown,
  Runtime_SetOnProcessMessages,
  Runtime_SetOnShowError,
  Runtime_SetOnShowMessage;

const
  {$IFDEF FPC}
  cAbout = 'About...';
  cSettings = 'Options...';
  cModules = 'Modules';
  {$ELSE}
  cAbout = ' ...';
  cSettings = '...';
  cModules = '';
  {$ENDIF}

const
  SystemProcs: ASystemProcs_Type = (
    // --- Info functions ---
    GetCompanyName: ASystem03.Runtime_GetCompanyName;
    GetCopyright: ASystem03.Runtime_GetCopyright;
    GetDescription: ASystem03.Runtime_GetDescription;
    GetExeName: ASystem03.Runtime_GetExeName;
    GetExePath: ASystem03.Runtime_GetExePath;
    GetProductName: ASystem03.Runtime_GetProductName;
    GetProductVersion: ASystem03.Runtime_GetProductVersion;
    GetProgramName: ASystem03.Runtime_GetProgramName;
    GetProgramVersion: ASystem03.Runtime_GetProgramVersion;
    GetTitle: ASystem03.Runtime_GetTitle;
    GetUrl: ASystem03.Runtime_GetUrl;

    GetConfig: ASystem03.Runtime_GetConfig;
    GetResourceString: ASystem03.Runtime_GetResourceString;
    ProcessMessages: ASystem03.Runtime_ProcessMessages;
    SetConfig: ASystem03.Runtime_SetConfig;
    ShowError: ASystem03.Runtime_ShowError;
    ShowMessage: ASystem03.Runtime_ShowMessage;
    ShowMessageA: ASystem03.Runtime_ShowMessageA;

    // --- Set event functions ---
    SetOnProcessMessages: ASystem03.Runtime_SetOnProcessMessages;
    SetOnShowError: ASystem03.Runtime_SetOnShowError;
    SetOnShowMessage: ASystem03.Runtime_SetOnShowMessage;

    {$IFDEF USE_EVENTS}
    OnAfterRun: ASystem03.Runtime_OnAfterRun;
    OnBeforeRun: ASystem03.Runtime_OnBeforeRun;
    OnAfterRun_Connect: ASystem03.Runtime_OnAfterRun_Connect;
    OnAfterRun_Disconnect: ASystem03.Runtime_OnAfterRun_Disconnect;
    OnBeforeRun_Connect: ASystem03.Runtime_OnBeforeRun_Connect;
    OnBeforeRun_Disconnect: ASystem03.Runtime_OnBeforeRun_Disconnect;
    {$ELSE}
    OnAfterRun: nil;
    OnBeforeRun: nil;
    OnAfterRun_Connect: nil;
    OnAfterRun_Disconnect: nil;
    OnBeforeRun_Connect: nil;
    OnBeforeRun_Disconnect: nil;
    {$ENDIF USE_EVENTS}

    ParamStr: ASystem03.Runtime_ParamStr;
    ShellExecute: ASystem03.Runtime_ShellExecute;
    GetDataPath: ASystem03.Runtime_GetDataPath;

    Reserved41: 0; //ParamCount: Runtime_ParamCount;
    Reserved42: 0;
    Reserved43: 0;
    Reserved44: 0;
    Reserved45: 0;
    Reserved46: 0;
    Reserved47: 0;
    Reserved48: 0;
    Reserved49: 0;
    Reserved50: 0;
    Reserved51: 0;
    Reserved52: 0;
    Reserved53: 0;
    Reserved54: 0;
    Reserved55: 0;
    Reserved56: 0;
    Reserved57: 0;
    Reserved58: 0;
    Reserved59: 0;
    Reserved60: 0;
    Reserved61: 0;
    Reserved62: 0;
    Reserved63: 0;
    );

const
  SystemModule: AModuleType = (
    Version: ASystem_Version;
    UID: ASystem_UID;
    Name: ASystem_Name;
    Description: nil;
    Init: System_Init;
    Done: System_Done;
    Reserved06: 0;
    Procs: Addr(SystemProcs);
    );

var
  FCompanyName: AString;
  FConfig: AConfig;
  FCopyright: AString;
  FDataPath: AString;
  FDescription: AString;
  FExeFileName: AString; // "Program1.exe"  //      
  FExeName: AString;     // "Program1"      //   
  FExePath: AString;     // "C:\Programs\Program1\"  //    
  FProductName: AString;
  FProductVersion: AString;
  // Original Program name. Use for config file <ProgramName>.ini
  FProgramName: AString;
  FProgramVersion: AString;
  FTitle: AString;
  FUrl: AString;
  FOnProcessMessages: ARuntimeProc;
  FOnShowError: TAShowErrorProc;
  FOnShowMessage: TAShowMessageProc;
  {$IFDEF USE_EVENTS}
  FOnAfterRunEvent: AEvent;                  // 
  FOnBeforeRunEvent: AEvent;                 // 
  {$ENDIF USE_EVENTS}

{$IFNDEF USE_SYSUTILS}
  const
  {$IFDEF MSWINDOWS}
    PathDelim = '\';
  {$ELSE}
    {$IFDEF UNIX}
      PathDelim = '/';
    {$ELSE}
      {$MESSAGE 'No MSWindows and no Unux'}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

{ Procedures }

function IntToHex4(Value: Integer): string;
const
  A: array[0..15] of Char = ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
var
  B: Byte;
begin
  SetLength(Result, 4);
  B := Byte((Value shr 12) and $0F); Result[1] := A[B];
  B := Byte((Value shr 08) and $0F); Result[2] := A[B];
  B := Byte((Value shr 04) and $0F); Result[3] := A[B];
  B := Byte(Value and $0F);          Result[4] := A[B];
end;

function IntToHex8(Value: Integer): string;
const
  A: array[0..15] of Char = ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
var
  B: Byte;
begin
  SetLength(Result, 8);
  B := Byte((Value shr 28) and $0F); Result[1] := A[B];
  B := Byte((Value shr 24) and $0F); Result[2] := A[B];
  B := Byte((Value shr 20) and $0F); Result[3] := A[B];
  B := Byte((Value shr 16) and $0F); Result[4] := A[B];
  B := Byte((Value shr 12) and $0F); Result[5] := A[B];
  B := Byte((Value shr 08) and $0F); Result[6] := A[B];
  B := Byte((Value shr 04) and $0F); Result[7] := A[B];
  B := Byte(Value and $0F);          Result[8] := A[B];
end;

function AGuidToString(const ID: TGuid): string;
{$IFNDEF FPC}
var
  W: Word;
  I: Integer;
{$ENDIF}
begin
  {$IFDEF FPC}
  Result := '';
  {$ELSE}
  Result := IntToHex8(ID.D1)+'-'+IntToHex4(ID.D2)+'-'+IntToHex4(ID.D3)+'-';
  W := (ID.D4[0] shl 8)+ID.D4[1];
  Result := Result + IntToHex4(W)+'-';
  W := (ID.D4[2] shl 8)+ID.D4[3];
  Result := Result + IntToHex4(W);
  I := (ID.D4[4] shl 24)+(ID.D4[5] shl 16)+(ID.D4[6] shl 8)+ID.D4[7];
  Result := Result + IntToHex8(I);
  {$ENDIF}
end;

procedure ExtractFileNameAndPath(const FExeFileName: AString1; var FExeName, FExePath: AString1);
var
  I: Integer;
begin
  for I := Length(FExeFileName) downto 1 do
    if (FExeFileName[I] = PathDelim) then
    begin
      FExeName := Copy(FExeFileName, I+1, Length(FExeFileName));
      FExePath := Copy(FExeFileName, 1, I);
      Exit;
    end;
end;

{$IFNDEF USE_SYSUTILS}
  {$IFDEF MSWINDOWS}
  function IsEqualGUID(const guid1, guid2: TGUID): Boolean; external 'ole32.dll' name 'IsEqualGUID';
  {$ENDIF}
  {$IFDEF UNIX}
  function IsEqualGUID(const guid1, guid2: TGUID): Boolean;
  var
    a, b: PIntegerArray;
  begin
    a := PIntegerArray(@guid1);
    b := PIntegerArray(@guid2);
    Result := (a^[0] = b^[0]) and (a^[1] = b^[1]) and (a^[2] = b^[2]) and (a^[3] = b^[3]);
  end;
  {$ENDIF}
{$ENDIF}

function NormalizePath(const Path: string): string;
begin
  if (Path = '') then
    Result := FExePath
  else
  begin
    Result := Path;
    if (Result[1] = '.') then
      Result := Copy(FExePath, 1, Length(FExePath)-1) + Copy(Result, 2, Length(Result)-1);
  end;
end;

{ Events }

{$IFDEF USE_EVENTS}
function DoAfterRun: AInteger; stdcall;
begin
  Result := Event_Invoke(FOnAfterRunEvent, 0);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function DoBeforeRun: AInteger; stdcall;
begin
  Result := Event_Invoke(FOnBeforeRunEvent, 0);
end;
{$ENDIF USE_EVENTS}

{ System public procs }

function System_Boot: AInteger; stdcall;
begin
  System_SetProcs(Addr(SystemProcs));
  Result := Runtime_Module_Register(Addr(SystemModule));
end;

procedure System_BootA(const Title, ProgramName, ProgramVersion, ProductName, ProductVersion,
    CompanyName, Copyright, Url, Description, DataPath: AString);
{$IFNDEF UNIX}
type
  arrc = array[0..$ffff] of Char;
var
  Wnd: DWORD;
  InfoSize: DWORD;
  VersionInfo: Pointer;

  function ReadVer(BlockName: string): AnsiString;
  var
    st: ShortString;
    p: ^arrc; // absolute VersionInfo
    Size: DWORD;
  begin
    if (VerQueryValue(VersionInfo, PChar(BlockName), Pointer(p), Size)) and (Size > 1) then
    begin
      SetLength(st, Size);
      st := Copy(p^,1,Size);
      Result := st;
    end
    else
      Result := '';
  end;
{$ENDIF}

var
  S: string;
begin
  {$IFDEF USE_EVENTS}
  FOnAfterRunEvent := Event_New(0, 'AfterRun');
  FOnBeforeRunEvent := Event_New(0, 'BeforeRun');
  Runtime_OnAfterRun_Set(DoAfterRun);
  Runtime_OnBeforeRun_Set(DoBeforeRun);
  {$ENDIF USE_EVENTS}

  FCompanyName := CompanyName;
  FCopyright := Copyright;
  FDescription := Description;
  FProductName := ProductName;
  FProductVersion := ProductVersion;
  FProgramName := ProgramName;
  FProgramVersion := ProgramVersion;
  FTitle := Title;
  FUrl := Url;

  FExeFileName := ParamStr(0);
  ExtractFileNameAndPath(FExeFileName, FExeName, FExePath);

  FDataPath := NormalizePath(DataPath);

  if (FProgramName = '') then
  begin
    // Set default ProgramName
    if (Length(FExeName) > 4) and (Copy(FExeName, Length(FExeName) - 4, 4) = '.exe') then
      FProgramName := Copy(FExeName, 1, Length(FExeName) - 4)
    else
      FProgramName := FExeName;
  end;

  if (FTitle = '') then
    FTitle := FProgramName;

  {$IFNDEF UNIX}
  InfoSize := GetFileVersionInfoSize(PChar(Paramstr(0)), Wnd);
  if (InfoSize <> 0) then
  begin
    GetMem(VersionInfo, InfoSize);
    try
      if GetFileVersionInfo(PChar(Paramstr(0)), Wnd, InfoSize, VersionInfo) then
      begin
        S := ReadVer('\StringFileInfo\041904E3\ProductName');
        if (S <> '') then FProductName := S;
        S := ReadVer('\StringFileInfo\041904E3\ProductVersion');
        if (S <> '') then FProductVersion := S;
        S := ReadVer('\StringFileInfo\041904E3\InternalName');
        if (S <> '') then FProgramName := S;
        S := ReadVer('\StringFileInfo\041904E3\FileVersion');
        if (S <> '') then FProgramVersion := S;
        S := ReadVer('\StringFileInfo\041904E3\LegalCopyright');
        if (S <> '') then FCopyright := S;
        S := ReadVer('\StringFileInfo\041904E3\CompanyName');
        if (S <> '') then FCompanyName := S;
        S := ReadVer('\StringFileInfo\041904E3\FileDescription');
        if (S <> '') then FDescription := S;
        //S := ReadVer('\StringFileInfo\041904E3\OriginalFilename');
        //if (S <> '') then Memo.Lines.Add(' : '+S);
      end;
    finally
      FreeMem(VersionInfo);
    end;
  end;
  {$ENDIF}
end;

function System_Done: AInteger; stdcall;
begin
  {$IFDEF USE_CONFIG}
  if (FConfig <> 0) then
    Settings_Close(FConfig);
  {$ENDIF USE_CONFIG}
  Result := 0;
end;

{ --- }

function Runtime_GetCompanyName: AString; stdcall;
begin
  Result := FCompanyName;
end;

function Runtime_GetConfig: AConfig; stdcall;
begin
  Result := FConfig;
end;

function Runtime_GetCopyright: AString; stdcall;
begin
  Result := FCopyright;
end;

function Runtime_GetDataPath: AString; stdcall;
begin
  Result := FDataPath;
end;

function Runtime_GetDescription: AString; stdcall;
begin
  Result := FDescription;
end;

function Runtime_GetExeName: AString; stdcall;
begin
  Result := FExeName;
end;

function Runtime_GetExePath: AString; stdcall;
begin
  Result := FExePath;
end;

function Runtime_GetProductName: AString; stdcall;
begin
  Result := FProductName;
end;

function Runtime_GetProductVersion: AString; stdcall;
begin
  Result := FProductVersion;
end;

function Runtime_GetProgramName: AString; stdcall;
begin
  Result := FProgramName;
end;

function Runtime_GetProgramVersion: AString; stdcall;
begin
  Result := FProgramVersion;
end;

function Runtime_GetResourceString(const Section, Name, Default: AString): AString; stdcall;
begin
  Result := Default;
  if (Section = 'About') then
  begin
    if (Name = 'MenuText') then
      Result := cAbout;
  end
  else if (Section = 'Tools') then
  begin
    if (Name = 'Options') then
      Result := cSettings;
  end
  else if (Section = '') then
  begin
    if (Name = 'Modules') then
      Result := cModules;
  end;
end;

function Runtime_GetTitle: AString; stdcall;
begin
  Result := FTitle;
end;

function Runtime_GetUrl: AString; stdcall;
begin
  Result := FUrl;
end;

function System_Init: AInteger; stdcall;
{$IFDEF USE_CONFIG}
var
  S: string;
  {$ENDIF USE_CONFIG}
begin
  {$IFDEF USE_CONFIG}
  if Assigned(Settings_IniConfig_New) then
  begin
    FConfig := Settings_IniConfig_New(FExePath+FProgramName+'.ini');
    S := Settings_ReadString(FConfig, 'App', 'DataPath', '');
    if (S <> '') then
      FDataPath := NormalizePath(S);
  end;
  {$ENDIF USE_CONFIG}
  Result := 0;
end;

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun: AEvent; stdcall;
begin
  Result := FOnAfterRunEvent;
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun_Connect(Callback: ACallbackProc; Weight: AInteger): Integer; stdcall;
begin
  Result := Event_Connect(FOnAfterRunEvent, Callback, Weight);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun_Disconnect(Callback: ACallbackProc): Integer; stdcall;
begin
  Result := Event_Disconnect(FOnAfterRunEvent, Callback);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun: AEvent; stdcall;
begin
  Result := FOnBeforeRunEvent;
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
begin
  Result := Event_Connect(FOnBeforeRunEvent, Callback, Weight);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun_Disconnect(Callback: ACallbackProc): Integer; stdcall;
begin
  Result := Event_Disconnect(FOnBeforeRunEvent, Callback);
end;
{$ENDIF USE_EVENTS}

function Runtime_ParamCount: AInteger; stdcall;
begin
  Result := ParamCount;
end;

function Runtime_ParamStr(Index: AInteger): AString; stdcall;
begin
  Result := ParamStr(Index);
end;

procedure Runtime_ProcessMessages; stdcall;
begin
  if Assigned(FOnProcessMessages) then
    FOnProcessMessages;
end;

procedure Runtime_SetConfig(Value: AConfig); stdcall;
begin
  FConfig := Value;
end;

procedure Runtime_SetOnProcessMessages(Value: ARuntimeProc); stdcall;
begin
  FOnProcessMessages := Value;
end;

procedure Runtime_SetOnShowError(Value: TAShowErrorProc); stdcall;
begin
  FOnShowError := Value;
end;

procedure Runtime_SetOnShowMessage(Value: TAShowMessageProc); stdcall;
begin
  FOnShowMessage := Value;
end;

function Runtime_ShellExecute(const Operation, FileName, Parameters, Directory: AString): AInteger; stdcall;
begin
  Result := ShellExecute(0{DrawWin.Handle}, nil, 'Calc', nil, nil, SW_SHOW);
  //Result := -1;
end;

procedure Runtime_ShowError(const UserMessage, ExceptMessage: AString); stdcall;
begin
  if Assigned(FOnShowError) then
    FOnShowError(FTitle, UserMessage, ExceptMessage);
end;

function Runtime_ShowMessage(const Msg: AString): ADialogBoxCommands; stdcall;
begin
  Result := Runtime_ShowMessageA(Msg, FTitle, MB_OK);
end;

function Runtime_ShowMessageA(const Text, Caption: AString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
begin
  if Assigned(FOnShowMessage) then
    Result := FOnShowMessage(Text, Caption, Flags)
  else
    Result := 0;
end;

{initialization
  System_Boot; //System_SetProcs(Addr(SystemProcs));}
end.
