{
Abstract:     
Author:  Prof1983 <prof1983@yandex.ru>
Created: 06.03.2008
LastMod: 17.05.2011
Version: 0.3.0
}
unit ASettings03;

interface

uses
  ABase0, ASettings0;

function Settings_IniConfig_New(const FileName: AString): AConfig; stdcall;
function Settings_RegConfig_New(const Prefix: AString): AConfig; stdcall;
function Settings_RegConfig_NewA(const Prefix: AString; HKEY: Integer): AConfig; stdcall;

procedure Settings_Close(Config: AConfig); stdcall;
function Settings_DeleteKey(Config: AConfig; const Section, Name: AString): ABoolean; stdcall;
function Settings_DeleteSection(Config: AConfig; const Section: AString): ABoolean; stdcall;
function Settings_ReadBool(Config: AConfig; const Section, Name: AString; DefValue: ABoolean): ABoolean; stdcall;
function Settings_ReadInteger(Config: AConfig; const Section, Name: AString; DefValue: AInteger): AInteger; stdcall;
function Settings_ReadFloat(Config: AConfig; const Section, Name: AString; DefValue: AFloat): AFloat; stdcall;
function Settings_ReadSection(Config: AConfig; const Section: AString; Strings: AStrings): ABoolean; stdcall;
function Settings_ReadString(Config: AConfig; const Section, Name, DefValue: AString): AString; stdcall;
function Settings_ReadDateTime(Config: AConfig; const Section, Name: AString; DefValue: TDateTime): TDateTime; stdcall;
function Settings_WriteBool(Config: AConfig; const Section, Name: AString; Value: Boolean): ABoolean; stdcall;
function Settings_WriteInteger(Config: AConfig; const Section, Name: AString; Value: Integer): ABoolean; stdcall;
function Settings_WriteFloat(Config: AConfig; const Section, Name: AString; Value: AFloat): ABoolean; stdcall;
function Settings_WriteString(Config: AConfig; const Section, Name, Value: AString): ABoolean; stdcall;
function Settings_WriteDateTime(Config: AConfig; const Section, Name: AString; Value: TDateTime): ABoolean; stdcall;

{ Protected }

function Settings_Boot: AInteger; stdcall;
function Settings_Init: AInteger; stdcall;
function Settings_Done: AInteger; stdcall;

implementation

uses
  ARuntime0, SysUtils, {$IFDEF MSWINDOWS}Windows, ARegistrySettings,{$ENDIF}
  AAbstractSettings, AIniSettings;

exports
  Settings_IniConfig_New,
  Settings_RegConfig_New,
  Settings_RegConfig_NewA,
  Settings_Close,
  Settings_DeleteKey,
  Settings_DeleteSection,
  Settings_ReadBool,
  Settings_ReadInteger,
  Settings_ReadFloat,
  Settings_ReadSection,
  Settings_ReadString,
  Settings_ReadDateTime,
  Settings_WriteBool,
  Settings_WriteInteger,
  Settings_WriteFloat,
  Settings_WriteString,
  Settings_WriteDateTime;

const
  Settings: ASettingsProcs_Type = (
    Close: ASettings03.Settings_Close;
    DeleteKey: ASettings03.Settings_DeleteKey;
    DeleteSection: ASettings03.Settings_DeleteSection;
    IniConfig_New: ASettings03.Settings_IniConfig_New;
    ReadBool: ASettings03.Settings_ReadBool;
    ReadInteger: ASettings03.Settings_ReadInteger;
    ReadFloat: ASettings03.Settings_ReadFloat;
    ReadSection: ASettings03.Settings_ReadSection;
    ReadString: ASettings03.Settings_ReadString;
    ReadDateTime: ASettings03.Settings_ReadDateTime;
    RegConfig_New: ASettings03.Settings_RegConfig_New;
    RegConfig_NewA: ASettings03.Settings_RegConfig_NewA;
    WriteBool: ASettings03.Settings_WriteBool;
    WriteInteger: ASettings03.Settings_WriteInteger;
    WriteFloat: ASettings03.Settings_WriteFloat;
    WriteString: ASettings03.Settings_WriteString;
    WriteDateTime: ASettings03.Settings_WriteDateTime;
    Reserved17: 0;
    Reserved18: 0;
    Reserved19: 0;
    Reserved20: 0;
    Reserved21: 0;
    Reserved22: 0;
    Reserved23: 0;
    Reserved24: 0;
    Reserved25: 0;
    Reserved26: 0;
    Reserved27: 0;
    Reserved28: 0;
    Reserved29: 0;
    Reserved30: 0;
    Reserved31: 0;
    Reserved32: 0;
    Reserved33: 0;
    Reserved34: 0;
    Reserved35: 0;
    Reserved36: 0;
    Reserved37: 0;
    Reserved38: 0;
    Reserved39: 0;
    Reserved40: 0;
    Reserved41: 0;
    Reserved42: 0;
    Reserved43: 0;
    Reserved44: 0;
    Reserved45: 0;
    Reserved46: 0;
    Reserved47: 0;
    Reserved48: 0;
    Reserved49: 0;
    Reserved50: 0;
    Reserved51: 0;
    Reserved52: 0;
    Reserved53: 0;
    Reserved54: 0;
    Reserved55: 0;
    Reserved56: 0;
    Reserved57: 0;
    Reserved58: 0;
    Reserved59: 0;
    Reserved60: 0;
    Reserved61: 0;
    Reserved62: 0;
    Reserved63: 0;
    );

const
  Module: AModuleType = (
    Version: ASettings_Version;
    UID: ASettings_UID;
    Name: ASettings_Name;
    Description: nil;
    Init: Settings_Init;
    Done: Settings_Done;
    Reserved06: 0;
    Procs: Addr(Settings);
    );

var
  FInitialized: Boolean;

{ Settings }

function Settings_Boot: AInteger; stdcall;
begin
  Settings_SetProcs(Addr(Settings));
  Result := Runtime_Module_Register(Addr(Module));
end;

procedure Settings_Close(Config: AConfig); stdcall;
begin
  try
    TAbstractSettings(Config).Close;
  except
  end;
end;

function Settings_DeleteKey(Config: AConfig; const Section, Name: AString): ABoolean; stdcall;
begin
  try
    Result := TAbstractSettings(Config).DeleteKey(Section, Name);
  except
    Result := False;
  end;
end;

function Settings_DeleteSection(Config: AConfig; const Section: AString): ABoolean; stdcall;
begin
  try
    Result := TAbstractSettings(Config).DeleteSection(Section);
  except
    Result := False;
  end;
end;

function Settings_Done: AInteger; stdcall;
begin
  Result := 0;
end;

function Settings_IniConfig_New(const FileName: AString): AConfig; stdcall;
var
  S: TIniSettings;
begin
  S := TIniSettings.Create;
  S.OpenIniFile(FileName);
  Result := Integer(S);
end;

function Settings_Init: AInteger; stdcall;
begin
  if FInitialized then
  begin
    Result := 0;
    Exit;
  end;

  FInitialized := True;
  Result := 0;
end;

function Settings_ReadBool(Config: AConfig; const Section, Name: AString; DefValue: ABoolean): ABoolean; stdcall;
begin
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).ReadBool(Section, Name, DefValue)
  except
    Result := DefValue;
  end
  else
    Result := DefValue;
end;

function Settings_ReadDateTime(Config: AConfig; const Section, Name: AString; DefValue: TDateTime): TDateTime; stdcall;
begin
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).ReadDateTime(Section, Name, DefValue)
  except
    Result := DefValue;
  end
  else
    Result := DefValue;
end;

function Settings_ReadFloat(Config: AConfig; const Section, Name: AString; DefValue: AFloat): AFloat; stdcall;
begin
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).ReadFloat(Section, Name, DefValue)
  except
    Result := DefValue;
  end
  else
    Result := DefValue;
end;

function Settings_ReadInteger(Config: AConfig; const Section, Name: AString; DefValue: AInteger): AInteger; stdcall;
begin
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).ReadInteger(Section, Name, DefValue)
  except
    Result := DefValue;
  end
  else
    Result := DefValue;
end;

function Settings_ReadSection(Config: AConfig; const Section: AString; Strings: AStrings): ABoolean; stdcall;
begin
  try
    Result := TAbstractSettings(Config).ReadSection(Section, Strings);
  except
    Result := False;
  end;
end;

function Settings_ReadString(Config: AConfig; const Section, Name, DefValue: AString): AString; stdcall;
begin
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).ReadString(Section, Name, DefValue)
  except
    Result := DefValue;
  end
  else
    Result := DefValue;
end;

function Settings_RegConfig_New(const Prefix: AString): AConfig; stdcall;
begin
  {$IFDEF MSWINDOWS}
  Result := Settings_RegConfig_NewA(Prefix, Integer(HKEY_CURRENT_USER));
  {$ELSE}
  Result := 0;
  {$ENDIF}
end;

function Settings_RegConfig_NewA(const Prefix: AString; HKEY: Integer): AConfig; stdcall;
{$IFDEF MSWINDOWS}
var
  S: TARegistrySettings;
{$ENDIF}
begin
  {$IFDEF MSWINDOWS}
  try
    S := TARegistrySettings.Create;
    S.Registry.RootKey := HKEY;
    S.Prefix := Prefix;
    Result := AConfig(S);
  except
    Result := 0;
  end;
  {$ELSE}
  Result := 0;
  {$ENDIF}
end;

function Settings_WriteBool(Config: AConfig; const Section, Name: AString; Value: ABoolean): ABoolean; stdcall;
begin
  Result := False;
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).WriteBool(Section, Name, Value);
  except
  end;
end;

function Settings_WriteDateTime(Config: AConfig; const Section, Name: AString; Value: TDateTime): ABoolean; stdcall;
begin
  Result := False;
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).WriteDateTime(Section, Name, Value);
  except
  end;
end;

function Settings_WriteFloat(Config: AConfig; const Section, Name: AString; Value: AFloat): ABoolean; stdcall;
begin
  Result := False;
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).WriteFloat(Section, Name, Value);
  except
  end;
end;

function Settings_WriteInteger(Config: AConfig; const Section, Name: AString; Value: AInteger): ABoolean; stdcall;
begin
  Result := False;
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).WriteInteger(Section, Name, Value);
  except
  end;
end;

function Settings_WriteString(Config: AConfig; const Section, Name, Value: AString): ABoolean; stdcall;
begin
  Result := False;
  if (Config <> 0) then
  try
    Result := TAbstractSettings(Config).WriteString(Section, Name, Value);
  except
  end;
end;

end.
