{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 04.05.2008
Lastmod: 17.05.2011
Version: 0.2.5+0.3.0
}
unit ARegistrySettings;

interface

uses
  Classes, Registry, Windows,
  ABase0, AUtils0, AAbstractSettings;

type
  TARegistrySettings = class(TAbstractSettings)
  private
    FPrefix: string;
    FRegistry: TRegistry;
  public
    function DeleteKey(const Section, Name: AString): ABoolean; override;
    function DeleteSection(const Section: AString): ABoolean; override;
    //function GetNodeByName(Name: string): TANode; //override;
    function NodeExists(Name: string): ABoolean; //override;
    function ReadBool(const Section, Name: AString; DefValue: ABoolean): ABoolean; override;
    function ReadInteger(const Section, Name: AString; DefValue: Integer): Integer; override;
    function ReadSection(const Section: AString; Strings: AStrings): ABoolean; override;
    function ReadString(const Section, Name, DefValue: AString): AString; override;
    function WriteBool(const Section, Name: AString; Value: ABoolean): ABoolean; override;
    function WriteInteger(const Section, Name: AString; Value: AInteger): ABoolean; override;
    function WriteString(const Section, Name, Value: AString): ABoolean; override;
  public
    constructor Create;
    destructor Destroy; override;
  public
    property Prefix: string read FPrefix write FPrefix;
    property Registry: TRegistry read FRegistry;
  end;

implementation

{ TARegistrySettings }

constructor TARegistrySettings.Create;
begin
  inherited;
  FRegistry := TRegistry.Create;
  FRegistry.RootKey := HKEY_CURRENT_USER;
end;

function TARegistrySettings.DeleteKey(const Section, Name: AString): ABoolean;
begin
  Result := FRegistry.OpenKey(Prefix+Section, False);
  if Result then
  try
    FRegistry.DeleteValue(Name);
  finally
    FRegistry.CloseKey;
  end;
end;

function TARegistrySettings.DeleteSection(const Section: AString): ABoolean;
begin
  FRegistry.DeleteKey(Prefix+Section);
  Result := True;
end;

destructor TARegistrySettings.Destroy;
begin
  FRegistry.Free;
  FRegistry := nil;
  inherited;
end;

function TARegistrySettings.NodeExists(Name: string): Boolean;
begin
  Result := FRegistry.KeyExists(Prefix+Name);
end;

function TARegistrySettings.ReadBool(const Section, Name: AString; DefValue: ABoolean): ABoolean;
begin
  Result := DefValue;
  if FRegistry.OpenKey(Prefix+Section, False) then
  begin
    if FRegistry.ValueExists(Name) then
    try
      Result := FRegistry.ReadBool(Name);
    except
    end;
    FRegistry.CloseKey;
  end;
end;

function TARegistrySettings.ReadInteger(const Section, Name: AString; DefValue: AInteger): AInteger;
begin
  Result := DefValue;
  if FRegistry.OpenKey(Prefix+Section, False) then
  begin
    if FRegistry.ValueExists(Name) then
    try
      Result := FRegistry.ReadInteger(Name);
    except
    end;
    FRegistry.CloseKey;
  end;
end;

function TARegistrySettings.ReadSection(const Section: AString; Strings: AStrings): ABoolean;
var
  S: TStringList;
  I: Integer;
begin
  Result := False;
  if FRegistry.OpenKey(Prefix+Section, False) then
  begin
    try
      S := TStringList.Create;
      FRegistry.GetValueNames(S);
      Utils_Strings_Clear(Strings);
      for I := 0 to S.Count - 1 do
        Utils_Strings_Add(Strings, S.Strings[I]+'='+FRegistry.ReadString(S.Strings[I]));
      S.Free;
      Result := True;
    except
    end;
    FRegistry.CloseKey;
  end;
end;

function TARegistrySettings.ReadString(const Section, Name, DefValue: AString): AString;
begin
  Result := DefValue;
  if FRegistry.OpenKey(Prefix+Section, False) then
  begin
    if FRegistry.ValueExists(Name) then
    try
      Result := FRegistry.ReadString(Name);
    except
    end;
    FRegistry.CloseKey;
  end;
end;

function TARegistrySettings.WriteBool(const Section, Name: AString; Value: ABoolean): ABoolean;
begin
  Result := False;
  if FRegistry.OpenKey(Prefix+Section, True) then
  try
    try
      FRegistry.WriteBool(Name, Value);
      Result := True;
    finally
      FRegistry.CloseKey;
    end;
  except
  end;
end;

function TARegistrySettings.WriteInteger(const Section, Name: AString; Value: AInteger): ABoolean;
begin
  Result := False;
  if FRegistry.OpenKey(Prefix+Section, True) then
  try
    try
      FRegistry.WriteInteger(Name, Value);
      Result := True;
    finally
      FRegistry.CloseKey;
    end;
  except
  end;
end;

function TARegistrySettings.WriteString(const Section, Name, Value: AString): ABoolean;
begin
  Result := False;
  if FRegistry.OpenKey(Prefix+Section, True) then
  try
    try
      FRegistry.WriteString(Name, Value);
      Result := True;
    finally
      FRegistry.CloseKey;
    end;
  except
  end;
end;

end.
 
