{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 10.04.2009
LastMod: 17.05.2011
Version: 0.3.0
}
unit APlugins03;

interface

uses
  ABase0, ALibrary0, APlugins0, ARuntime0, ASettings0, ASystem0;

type
  TCheckPluginModuleProc = function(Module: ALibrary): ABoolean; stdcall;

//    .
function Plugins_AddPlugin(const FileName: AString): ABoolean; stdcall;
function Plugins_Clear: ABoolean; stdcall;
function Plugins_Count: AInteger; stdcall;
function Plugins_Delete(Index: Integer): ABoolean; stdcall;
procedure Plugins_Find(const Path: AString); stdcall;

{ Protected }

function Plugins_Boot: AInteger; stdcall;
function Plugins_Init: AInteger; stdcall;
function Plugins_Done: AInteger; stdcall;

procedure Plugins_SetOnCheckPluginModule(CheckPluginModuleProc: TCheckPluginModuleProc); stdcall;

implementation

uses
  SysUtils;

exports
  Plugins_Init,
  Plugins_Done,
  Plugins_AddPlugin,
  Plugins_Clear,
  Plugins_Count,
  Plugins_Delete,
  Plugins_Find;

const
  PluginsVersionValue = $00030000;
  PluginsVersionMask = $FFFF0000;

const
  Module: AModuleType = (
    Version: APlugins_Version;
    UID: APlugins_UID;
    Name: APlugins_Name;
    Description: nil;
    Init: Plugins_Init;
    Done: Plugins_Done;
    Reserved06: 0;
    Procs: nil;
    );

type
  TPluginBootProc = function(Runtime: ARuntimeProcs): Integer; stdcall;
  TPluginInitProc = TAGetIntProc;
  TPluginDoneProc = TAGetIntProc;
  TPluginVersionProc = TAGetIntProc;

type
  TPluginRec = record
    Module: ALibrary;
    InitProc: TPluginInitProc;
    DoneProc: TPluginDoneProc;
  end;

var
  FOnCheckPluginModule: TCheckPluginModuleProc;
  FPlugins: array of TPluginRec;

{ Events }

function DoCheckPluginModule(Module: ALibrary): ABoolean; stdcall;
var
  PluginBootProc: TPluginBootProc;
begin
  if not(Library_GetSymbol(Module, 'Plugin_Boot', @PluginBootProc)) then
  begin
    Result := False;
    Exit;
  end;
  try
    Result := (PluginBootProc(Addr(Runtime)) >= 0);
  except
    Result := False;
  end;
end;

{ Plugin }

function Plugin_Done(Index: Integer): Integer;
begin
  try
    Result := FPlugins[Index].DoneProc;
  except
    Result := -1;
  end;
end;

procedure Plugin_Free(Index: Integer);
begin
  Library_Close(FPlugins[Index].Module);
end;

function Plugin_Init(Index: Integer): Integer;
begin
  try
    Result := FPlugins[Index].InitProc;
  except
    Result := -1;
  end;
end;

{ Private }

function FindPluginByName(const Name: AString): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FPlugins) do
  begin
    if (Library_GetName(FPlugins[I].Module) = Name) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

procedure InitPluginFromConfig(Config: AConfig; const ConfigParamName: string);
var
  PluginName: AString;
  PluginIndex: Integer;
begin
  PluginName := Settings_ReadString(Config, 'Boot', ConfigParamName, '');
  if (PluginName <> '') then
  begin
    PluginIndex := FindPluginByName(PluginName);
    if (PluginIndex >= 0) then
      Plugin_Init(PluginIndex);
  end;
end;

// -------------------------------------------------------------------------------------------------

function CheckPluginModule(Module: ALibrary): ABoolean;
begin
  if Assigned(FOnCheckPluginModule) then
    Result := FOnCheckPluginModule(Module)
  else
    Result := True;
end;

{ Plugins }

function Plugins_AddPlugin(const FileName: AString): Boolean;
var
  I: Integer;
  Module: ALibrary;
  PluginInitProc: TPluginInitProc;
  PluginDoneProc: TPluginDoneProc;
  PluginVersionProc: TPluginVersionProc;
  Version: AInteger;
begin
  try
    Module := Library_Open(FileName, 0);
    if (Module = 0) then
    begin
      Result := False;
      Exit;
    end;
    if not(Library_GetSymbol(Module, 'Plugin_Init', @PluginInitProc)) then
    begin
      Library_Close(Module);
      Result := False;
      Exit;
    end;
    if not(Library_GetSymbol(Module, 'Plugin_Done', @PluginDoneProc)) then
    begin
      Library_Close(Module);
      Result := False;
      Exit;
    end;
    if not(Library_GetSymbol(Module, 'Plugin_Version', @PluginVersionProc)) then
    begin
      Library_Close(Module);
      Result := False;
      Exit;
    end;

    //   
    if Assigned(PluginVersionProc) then
    begin
      try
        Version := PluginVersionProc;
      except
        Library_Close(Module);
        Result := False;
        Exit;
      end;
      if (Version and PluginsVersionMask <> PluginsVersionValue and PluginsVersionMask) then
      begin
        Library_Close(Module);
        Result := False;
        Exit;
      end;
    end;

    if not(CheckPluginModule(Module)) then
    begin
      Library_Close(Module);
      Result := False;
      Exit;
    end;

    I := Length(FPlugins);
    SetLength(FPlugins, I + 1);
    FPlugins[I].Module := Module;
    FPlugins[I].InitProc := PluginInitProc;
    FPlugins[I].DoneProc := PluginDoneProc;
    Result := True;
  except
    Result := False;
  end;
end;

function Plugins_Boot: AInteger; stdcall;
begin
  if not(Assigned(Runtime_Modules_FindByName)) then
  begin
    Result := -1;
    Exit;
  end;

  if (Runtime_Modules_FindByName(APlugins_Name) > 0) then
  begin
    Result := -1;
    Exit;
  end;

  if (Runtime_Modules_FindByUid(APlugins_Uid) > 0) then
  begin
    Result := -1;
    Exit;
  end;

  Plugins_SetOnCheckPluginModule(DoCheckPluginModule);
  Result := Runtime_Module_Register(Addr(Module));
end;

function Plugins_Clear: Boolean;
var
  I: Integer;
begin
  for I := 0 to High(FPlugins) do
  try
    Plugin_Done(I);
    Plugin_Free(I);
  except
  end;
  SetLength(FPlugins, 0);
  Result := True;
end;

function Plugins_Count: Integer;
begin
  Result := Length(FPlugins);
end;

function Plugins_Delete(Index: Integer): Boolean;
var
  I: Integer;
begin
  Result := False;
  if (Index < 0) or (Index >= Length(FPlugins)) then Exit;
  Plugin_Done(Index);
  Plugin_Free(Index);
  for I := Index to High(FPlugins) - 1 do
  begin
    FPlugins[I] := FPlugins[I + 1];
  end;
  SetLength(FPlugins, High(FPlugins));
  Result := True;
end;

function Plugins_Done: AInteger; stdcall;
begin
  Plugins_Clear;
  Result := 0;
end;

procedure Plugins_Find(const Path: AString);

  procedure PFind(const Path: AString);
  var
    SearchRec: TSearchRec;
  begin
    if (FindFirst(Path + '*.dll', faAnyFile and (not(faDirectory)), SearchRec) <> 0) then Exit;
    Plugins_AddPlugin(Path + SearchRec.Name);
    while (FindNext(SearchRec) = 0) do
      Plugins_AddPlugin(Path + SearchRec.Name);
    SysUtils.FindClose(SearchRec);
  end;

var
  SearchRec: TSearchRec;
begin
  if (FindFirst(Path + '*', faDirectory, SearchRec) <> 0) then Exit;
  if (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
    PFind(Path+SearchRec.Name+'\');
  while (FindNext(SearchRec) = 0) do
  begin
    if (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
      PFind(Path+SearchRec.Name+'\');
  end;
  SysUtils.FindClose(SearchRec);
end;

function Plugins_Init: AInteger; stdcall;
var
  I: Integer;
  Config: AConfig;
begin
  Runtime_Modules_InitByUid(ASystem_Uid);

  Config := Runtime_GetConfig;
  InitPluginFromConfig(Config, 'InitPlugin0');
  InitPluginFromConfig(Config, 'InitPlugin1');
  InitPluginFromConfig(Config, 'InitPlugin2');
  InitPluginFromConfig(Config, 'InitPlugin3');
  InitPluginFromConfig(Config, 'InitPlugin4');
  InitPluginFromConfig(Config, 'InitPlugin5');
  InitPluginFromConfig(Config, 'InitPlugin6');
  InitPluginFromConfig(Config, 'InitPlugin7');

  for I := 0 to High(FPlugins) do
    Plugin_Init(I);
  Result := 0;
end;

procedure Plugins_SetOnCheckPluginModule(CheckPluginModuleProc: TCheckPluginModuleProc);
begin
  FOnCheckPluginModule := CheckPluginModuleProc;
end;

{initialization
  Plugins_Boot;}
end.
