{
Abstract:   
Author: Prof1983 <prof1983@yandex.ru>
Created: 19.03.2008
LastMod: 18.05.2011
Version: 0.3.0
 ()     (Entity).
}
unit AEntities03;

interface

uses
  ABase0, AEntities0, ARuntime0;

//  .     .
function Entities_AddEntity(EntityID, EntityType: AEntityID): AInteger; stdcall;
//  .     .
function Entities_AddEntityA(EntityID, EntityType: AEntityID; DataSource: Pointer; DataSize: AInteger): AInteger; stdcall;

function Entities_GetEntityByID(ID: AEntityID; var Entity: AEntityType): AInteger; stdcall;
function Entities_GetEntityByIndex(Index: AInteger; var Entity: AEntityType): ABoolean; stdcall;
function Entities_GetEntityType(ID: AEntityID): AEntityID; stdcall;
// TODO: 
//function EntityData_GetEntityDataSize(ID: AEntityDI): AInteger; stdcall;
//function EntityData_GetEntityData(ID: AEntityID; Size: AInteger; P: Pointer): AInteger; stdcall;

//  True,    .
function Entities_IsFree(ID: AEntityID): ABoolean; stdcall;
//   
function Entities_NewEntity(EntityType: AEntityID): AEntityID; stdcall;
//            .
//function EntityData_Select(EntityType: AEntityID): IAEntityIterator;

function Entities_FindEntityByID(ID: AEntityID): AInteger; stdcall;
function Entities_SetEntityData(ID: AEntityID; Data: Pointer; DataSize: AInteger): AInteger; stdcall;
function Entities_Count: AInteger; stdcall;

{ Protected procs }

function Entities_Boot: AInteger; stdcall;
function Entities_Init: AInteger; stdcall;
function Entities_Done: AInteger; stdcall;

implementation

const
  EntitiesProcs: AEntitiesProcsType = (
    Reserved00: 0;
    Reserved01: 0;
    Reserved02: 0;
    Reserved03: 0;
    Reserved04: 0;
    Reserved05: 0;
    Reserved06: 0;
    Reserved07: 0;
    Reserved08: 0;
    Reserved09: 0;
    Reserved10: 0;
    Reserved11: 0;
    Reserved12: 0;
    Reserved13: 0;
    Reserved14: 0;
    Reserved15: 0;
    );

const
  EntitiesModule: AModuleType = (
    Version: Entities_Version;
    UID: Entities_UID;
    Name: Entities_Name;
    Description: nil;
    Init: Entities_Init;
    Done: Entities_Done;
    Reserved06: 0;
    Procs: Addr(EntitiesProcs);
    );

var
  FEntities: array of AEntityType;

{ Private procs }

function AddEntity(EntityID, EntityType: AEntityID): AInteger;
var
  Index: Integer;
begin
  Index := Length(FEntities);
  SetLength(FEntities, Index + 1);
  FEntities[Index].ID := EntityID;
  FEntities[Index].Typ := EntityType;
  FEntities[Index].Data := nil;
  FEntities[Index].DataSize := 0;
  Result := Index;
end;

function FindEntityByID(ID: AEntityID): AInteger;
var
  I: Integer;
begin
  for I := 0 to High(FEntities) do
  begin
    if (FEntities[I].ID = ID) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function GetMaxEntityID: AEntityID;
var
  I: Integer;
begin
  Result := 0;
  for I := 0 to High(FEntities) do
    if (FEntities[I].ID > Result) then
      Result := FEntities[I].ID;
  //Result := Index + AEntityGlobalMin;
end;

function NewEntity(EntityType: AEntityID): AInteger;
var
  MaxID: AEntityID;
begin
  MaxID := GetMaxEntityID;
  if (MaxID < AEntityGlobalMax) then
    MaxID := AEntityGlobalMax;
  Result := AddEntity(MaxID + 1, EntityType);
end;

{function NewGlobalEntity(EntityType: AEntityID): AInteger;
var
  MaxID: AEntityID;
begin
  MaxID := GetMaxEntityID;
  if MaxID <
  Result := AddEntityID(ID + 1, EntityType);
  //Result := Index + AEntityGlobalMin;
end;}

{ Entities procs }

function Entities_AddEntity(EntityID, EntityType: AEntityID): AInteger; stdcall;
begin
  Result := AddEntity(EntityID, EntityType);
end;

function Entities_AddEntityA(EntityID, EntityType: AEntityID; DataSource: Pointer; DataSize: AInteger): AInteger; stdcall;
var
  Index: Integer;
begin
  Index := Length(FEntities);
  SetLength(FEntities, Index + 1);
  FEntities[Index].ID := EntityID;
  FEntities[Index].Typ := EntityType;
  if (DataSize > 0) then
  begin
    GetMem(FEntities[Index].Data, DataSize);
    Move(DataSource^, FEntities[Index].Data^, DataSize);
  end
  else
    FEntities[Index].Data := nil;
  FEntities[Index].DataSize := DataSize;
  Result := Index;
end;

function Entities_Boot: AInteger; stdcall;
begin
  Result := Runtime_Module_Register(Addr(EntitiesModule));
  {SetLength(FEntities, 1);
  FEntities[0].ID := AEntityGlobalMin;
  FEntities[0].Typ := 0;
  FEntities[0].Data := nil;
  FEntities[0].DataSize := 0;}
end;

function Entities_Clear: AInteger; stdcall;
var
  I: Integer;
begin
  for I := 0 to High(FEntities) do
  begin
    if (FEntities[I].DataSize > 0) then
      FreeMem(FEntities[I].Data, FEntities[I].DataSize);
  end;
  SetLength(FEntities, 0);
  Result := 0;
end;

function Entities_Count: AInteger; stdcall;
begin
  Result := Length(FEntities);
end;

function Entities_Done: AInteger; stdcall;
begin
  Entities_Clear;
  Result := Runtime_Modules_DeleteByUID(Entities_UID);
end;

function Entities_FindEntityByID(ID: AEntityID): AInteger; stdcall;
begin
  Result := FindEntityByID(ID);
end;

function Entities_GetEntityByID(ID: AEntityID; var Entity: AEntityType): AInteger;
begin
  Result := Entities_FindEntityByID(ID);
  if (Result < 0) then
    Exit;
  Entity := FEntities[Result];
  //Result := Entities_GetEntityByIndex(ID - AEntityGlobalMin, Entity);
end;

function Entities_GetEntityByIndex(Index: AInteger; var Entity: AEntityType): ABoolean;
begin
  if (Index >= 0) and (Index < Length(FEntities)) then
  begin
    Entity := FEntities[Index];
    Result := True;
  end
  else
    Result := False;
end;

function Entities_GetEntityType(ID: AEntityID): AEntityID;
var
  Entity: AEntityType;
begin
  if (Entities_GetEntityByID(ID, Entity) >= 0) then
    Result := Entity.Typ
  else
    Result := AEntityNull;
end;

function Entities_Init: AInteger; stdcall;
begin
  Result := 0;
end;

function Entities_IsFree(ID: AEntityID): ABoolean;
var
  Index: Integer;
begin
  //  0..65535   
  if (ID < AEntityGlobalMin) then
  begin
    Result := False;
    Exit;
  end;

  Index := ID - AEntityGlobalMin;
  if (Index >= 0) and (Index < Length(FEntities)) then
    Result := True
  else
    Result := False;
end;

function Entities_NewEntity(EntityType: AEntityID): AEntityID;
var
  Index: Integer;
begin
  Index := Length(FEntities);
  SetLength(FEntities, Index + 1);
  Result := Index + AEntityGlobalMin;
  FEntities[Index].ID := Result;
  FEntities[Index].Typ := EntityType;
  FEntities[Index].Data := nil;
  FEntities[Index].DataSize := 0;
end;

function Entities_SetEntityData(ID: AEntityID; Data: Pointer; DataSize: AInteger): AInteger; stdcall;
begin
  Result := FindEntityByID(ID);
  if (Result < 0) then
    Exit;
  FEntities[Result].Data := Data;
  FEntities[Result].DataSize := DataSize;
end;

end.
