{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 15.05.2011
LastMod: 15.05.2011
Version: 0.3.0
}
unit ADocuments03;

interface

uses
  ABase0, AEntities0, AEntities03;

function Documents_LoadFromFile(const FileName: AString): AInteger; stdcall;
function Documents_SaveToFile(const FileName: AString): AInteger; stdcall;

implementation

type
  AFileHeader = packed record // 4x4 = 16
    ID: array[0..3] of Char;   // = 'ADB0'
    FileID: AUInt32;           // = 1
    FileType: AUInt32;         // = 1
    FileVersion: AUInt32;      // = 1
  end;

type
  AFileDBHeader = packed record // 4x4 = 16
    EntityCount: AUInt32;
    Reserved01: AUInt32;
    Reserved02: AUInt32;
    Reserved03: AUInt32;
  end;

type
  AEntityFileRec = packed record // 4x4 = 16
    EntityID: AUInt32;
    EntityType: AUInt32;
    DataSize: AUInt32;
    Reserved03: AUInt32; // CRC
  end;

function Documents_LoadFromFile(const FileName: AString): AInteger; stdcall;
var
  F: file;
  Header: AFileHeader;
  DBHeader: AFileDBHeader;
  I: Integer;
  Entity: AEntityFileRec;
  Data: Pointer;
  TempBuf: array[0..15] of Byte;
  Count: Integer;
begin
  {$I-}
  AssignFile(F, FileName);
  Reset(F,1);
  {$I+}
  if (IOResult <> 0) then
  begin
    Result := -1;
    Exit;
  end;
  {$I-}
  BlockRead(F, Header, SizeOf(Header));
  {$I+}
  if (Header.ID <> 'ADB0') or (Header.FileID <> 1) or
     (Header.FileType <> 1) or (Header.FileVersion <> 1) then
  begin
    {$I-}
    CloseFile(F);
    {$I+}
    Result := -2;
    Exit;
  end;
  {$I-}
  BlockRead(F, DBHeader, SizeOf(DBHeader));
  for I := 0 to DBHeader.EntityCount - 1 do
  begin
    BlockRead(F, Entity, SizeOf(Entity));
    Entities_AddEntity(Entity.EntityID, Entity.EntityType);
    if (Entity.DataSize > 0) then
    begin
      GetMem(Data, Entity.DataSize);
      BlockRead(F, Data^, Entity.DataSize);
      Entities_SetEntityData(Entity.EntityID, Data, Entity.DataSize);
      //        16 
      if (Entity.DataSize mod 16 <> 0) then
      begin
        Count := 16 - (Entity.DataSize mod 16);
        BlockRead(F, TempBuf, Count);
      end;
    end;
  end;
  CloseFile(F);
  {$I+}
  Result := 0;
end;

function Documents_SaveToFile(const FileName: AString): AInteger; stdcall;
var
  F: file;
  Header: AFileHeader;
  DBHeader: AFileDBHeader;
  Entity: AEntityFileRec;
  I: Integer;
  E: AEntityType;
  TempBuf: array[0..15] of Byte;
  Count: Integer;
begin
  //   
  FillChar(TempBuf, SizeOf(TempBuf), 0);
  {$I-}
  AssignFile(F, FileName);
  Rewrite(F,1);
  {$I+}
  if (IOResult <> 0) then
  begin
    Result := -1;
    Exit;
  end;
  {$I-}
  Header.ID := 'ADB0';
  Header.FileID := 1;
  Header.FileType := 1;
  Header.FileVersion := 1;
  BlockWrite(F, Header, SizeOf(Header));
  DBHeader.EntityCount := Entities_Count;
  DBHeader.Reserved01 := 0;
  DBHeader.Reserved02 := 0;
  DBHeader.Reserved03 := 0;
  BlockWrite(F, DBHeader, SizeOf(DBHeader));
  {$I+}
  for I := 0 to DBHeader.EntityCount - 1 do
  begin
    if not(Entities_GetEntityByIndex(I, E)) then
    begin
      {$I-}
      CloseFile(F);
      {$I+}
      Result := -2;
      Exit;
    end;
    Entity.EntityID := E.ID;
    Entity.EntityType := E.Typ;
    Entity.DataSize := E.DataSize;
    Entity.Reserved03 := 0;
    {$I-}
    BlockWrite(F, Entity, SizeOf(Entity));
    if (Entity.DataSize > 0) then
    begin
      BlockWrite(F, E.Data^, Entity.DataSize);
      //        16 
      if (Entity.DataSize mod 16 <> 0) then
      begin
        Count := 16 - (Entity.DataSize mod 16);
        BlockWrite(F, TempBuf, Count);
      end;
      // ...
    end;
    {$I+}
  end;
  {$I-}
  CloseFile(F);
  {$I+}
  Result := 0;
end;

end.
