{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 30.09.2009
LastMod: 17.05.2011
Version: 0.2.5+0.3.0
}
unit AUtils0;

interface

uses
  ABase0;

const
  AUtils_Name = 'Utils';
  AUtils_Uid = $00000004;
  AUtils_Version = {$IFDEF A02}$00020500{$ELSE}$00030000{$ENDIF};

// --- Procs type ---

type
  //       -   
  A_Utils_FloatToStr = function(Value: AFloat): AString; stdcall;
  //     (c    )
  A_Utils_FloatToStrA = function(Value: AFloat; Digits: AInteger = 2): AString; stdcall;
  //         (SQL).  SQL   - .
  A_Utils_FloatToStrB = function(Value: AFloat; Digits: AInteger = 2): AString; stdcall;
  A_Utils_FloatToStrC = function(Value: AFloat; Digits: AInteger = 2): AString; stdcall;
  A_Utils_FloatToStrD = function(Value: AFloat): AString; stdcall;
  A_Utils_NormalizeFloat = function(Value: AFloat): AFloat; stdcall;
  //       #
  A_Utils_NormalizeStr = function(const Value: AString): AString; stdcall;
type
  A_Utils_ExtractFileExt = function(const FileName: AString): AString; stdcall;
  A_Utils_ExtractFilePath = function(const FileName: AString): AString; stdcall;
  A_Utils_FileExists = function(const FileName: AString): ABoolean; stdcall;
  A_Utils_Sleep = procedure(Milliseconds: AUInt); stdcall;
  A_Utils_Time_Now = function: TDateTime; stdcall;
  A_Utils_IntToStr = function(Value: AInteger): AString; stdcall;
  A_Utils_StrToFloat = function(const Value: AString): AFloat; stdcall;
  A_Utils_StrToInt = function(const Value: AString): AInteger; stdcall;
  //   Base   Exponent
  A_Utils_Power = function(Base, Exponent: AFloat): AFloat; stdcall;
  {               .
      DecimalSeparator ,    . }
  A_Utils_ReplaceComma = function(const S: AString; DecimalSeparator: AChar = #0; ClearSpace: ABoolean = True): AString; stdcall;
  A_Utils_StrToFloat1 = function(const S: AString; DefValue: AFloat = 0): AFloat; stdcall;
  A_Utils_StrToInt1 = function(const S: AString; DefValue: AInteger = 0): AInteger; stdcall;
  A_Utils_StrToDate = function(const Value: AString): TDateTime; stdcall;
  A_Utils_TryStrToFloat = function(const S: AString; var Value: AFloat): ABoolean; stdcall;
  A_Utils_TryStrToFloat32 = function(const S: AString; var Value: AFloat32): ABoolean; stdcall;
  A_Utils_TryStrToFloat64 = function(const S: AString; var Value: AFloat64): ABoolean; stdcall;
  A_Utils_TryStrToDate = function(const S: AString; var Value: TDateTime): ABoolean; stdcall;
  A_Utils_TryStrToInt = function(const S: AString; var Value: AInteger): ABoolean; stdcall;
  A_Utils_Trim = function(const S: AString): AString; stdcall;
  A_Utils_UpperString = function(const S: AString): AString; stdcall;
type
  A_Utils_FormatFloat_Proc = function(Value: AFloat; Count, Digits: AInteger): AString; stdcall;
  A_Utils_FormatInt_Proc = function(Value, Count: AInteger): AString; stdcall;
  A_Utils_FormatStr_Proc = function(const Value: AString; Len: AInteger): AString; stdcall;
type
  A_Strings_Add_Proc = procedure(Strings: AStrings; const Value: AString); stdcall;
  A_Strings_Clear_Proc = procedure(Strings: AStrings); stdcall;

// --- Procs var ---

var
  Utils_FloatToStr: A_Utils_FloatToStr;
  Utils_FloatToStrA: A_Utils_FloatToStrA;
  Utils_FloatToStrB: A_Utils_FloatToStrB;
  Utils_FloatToStrC: A_Utils_FloatToStrC;
  Utils_FloatToStrD: A_Utils_FloatToStrD;
  Utils_NormalizeFloat: A_Utils_NormalizeFloat;
  Utils_NormalizeStr: A_Utils_NormalizeStr;
var
  Utils_ExtractFileExt: A_Utils_ExtractFileExt;
  Utils_ExtractFilePath: A_Utils_ExtractFilePath;
  Utils_FileExists: A_Utils_FileExists;
  Utils_Sleep: A_Utils_Sleep;
  Utils_Time_Now: A_Utils_Time_Now;
  Utils_IntToStr: A_Utils_IntToStr;
  Utils_StrToFloat: A_Utils_StrToFloat;
  Utils_StrToInt: A_Utils_StrToInt;
  Utils_Power: A_Utils_Power;
  Utils_ReplaceComma: A_Utils_ReplaceComma;
  Utils_StrToDate: A_Utils_StrToDate;
  Utils_StrToFloat1: A_Utils_StrToFloat1;
  Utils_StrToInt1: A_Utils_StrToInt1;
  Utils_TryStrToFloat: A_Utils_TryStrToFloat;
  Utils_TryStrToFloat32: A_Utils_TryStrToFloat32;
  Utils_TryStrToFloat64: A_Utils_TryStrToFloat64;
  Utils_TryStrToDate: A_Utils_TryStrToDate;
  Utils_TryStrToInt: A_Utils_TryStrToInt;
  Utils_Trim: A_Utils_Trim;
  Utils_UpperString: A_Utils_UpperString;
var
  Utils_FormatFloat: A_Utils_FormatFloat_Proc;
  Utils_FormatInt: A_Utils_FormatInt_Proc;
  Utils_FormatStr: A_Utils_FormatStr_Proc;
var
  Utils_Strings_Add: A_Strings_Add_Proc;
  Utils_Strings_Clear: A_Strings_Clear_Proc;

// --- Module ---

type
  AUtilsProcs = ^AUtilsProcsType;
  AUtilsProcsType = packed record {32x4} {64x4}
    FloatToStrA: A_Utils_FloatToStrA;
    FloatToStrB: A_Utils_FloatToStrB;
    FloatToStrC: A_Utils_FloatToStrC;
    FloatToStrD: A_Utils_FloatToStrD;
    NormalizeFloat: A_Utils_NormalizeFloat;
    NormalizeStr: A_Utils_NormalizeStr;

    FileExists: A_Utils_FileExists;
    Sleep: A_Utils_Sleep;
    Time_Now: A_Utils_Time_Now;
    IntToStr: A_Utils_IntToStr;
    StrToFloat: A_Utils_StrToFloat;
    StrToInt: A_Utils_StrToInt;
    ExtractFilePath: A_Utils_ExtractFilePath;
    Power: A_Utils_Power;
    ReplaceComma: A_Utils_ReplaceComma;
    StrToFloat1: A_Utils_StrToFloat1;
    StrToInt1: A_Utils_StrToInt1;
    TryStrToFloat: A_Utils_TryStrToFloat;
    TryStrToFloat32: A_Utils_TryStrToFloat32;
    TryStrToFloat64: A_Utils_TryStrToFloat64;
    TryStrToDate: A_Utils_TryStrToDate;
    TryStrToInt: A_Utils_TryStrToInt;

    FloatToStr: A_Utils_FloatToStr;
    Trim: A_Utils_Trim;
    UpperString: A_Utils_UpperString;
    ExtractFileExt: A_Utils_ExtractFileExt;

    FormatFloat: A_Utils_FormatFloat_Proc;
    FormatInt: A_Utils_FormatInt_Proc;
    StrToDate: A_Utils_StrToDate;

    FormatStr: A_Utils_FormatStr_Proc;

    Strings_Add: A_Strings_Add_Proc;
    Strings_Clear: A_Strings_Clear_Proc;

    {$IFDEF A03}
    Reserved32: Integer;
    Reserved33: Integer;
    Reserved34: Integer;
    Reserved35: Integer;
    Reserved36: Integer;
    Reserved37: Integer;
    Reserved38: Integer;
    Reserved39: Integer;
    Reserved40: Integer;
    Reserved41: Integer;
    Reserved42: Integer;
    Reserved43: Integer;
    Reserved44: Integer;
    Reserved45: Integer;
    Reserved46: Integer;
    Reserved47: Integer;

    Reserved48: Integer;
    Reserved49: Integer;
    Reserved50: Integer;
    Reserved51: Integer;
    Reserved52: Integer;
    Reserved53: Integer;
    Reserved54: Integer;
    Reserved55: Integer;
    Reserved56: Integer;
    Reserved57: Integer;
    Reserved58: Integer;
    Reserved59: Integer;
    Reserved60: Integer;
    Reserved61: Integer;
    Reserved62: Integer;
    Reserved63: Integer;
    {$ENDIF A03}
  end;

var
  Utils: AUtilsProcsType;

procedure Utils_SetProcs(Procs: AUtilsProcs);

function FloatToStrA(Value: AFloat; Digits: Integer = 2): AString; stdcall;
function FloatToStrB(Value: AFloat; Digits: Integer = 2): AString; stdcall;
function FloatToStrC(Value: AFloat; Digits: AInteger = 2): AString; stdcall;
function StrToFloat1(const S: AString; DefValue: AFloat = 0): AFloat; stdcall;
function StrToInt1(const S: AString; DefValue: AInteger = 0): AInteger; stdcall;

implementation

procedure Utils_SetProcs(Procs: AUtilsProcs);
begin
  Utils := Procs^;
  Utils_FloatToStrA := Utils.FloatToStrA;
  Utils_FloatToStrB := Utils.FloatToStrB;
  Utils_FloatToStrC := Utils.FloatToStrC;
  Utils_FloatToStrD := Utils.FloatToStrD;
  Utils_NormalizeFloat := Utils.NormalizeFloat;
  Utils_NormalizeStr := Utils.NormalizeStr;
  Utils_FileExists := Utils.FileExists;
  Utils_Sleep := Utils.Sleep;
  Utils_Time_Now := Utils.Time_Now;
  Utils_IntToStr := Utils.IntToStr;
  Utils_StrToFloat := Utils.StrToFloat;
  Utils_StrToInt := Utils.StrToInt;
  Utils_ExtractFilePath := Utils.ExtractFilePath;
  Utils_Power := Utils.Power;
  Utils_ReplaceComma := Utils.ReplaceComma;
  Utils_StrToFloat1 := Utils.StrToFloat1;
  Utils_StrToInt1 := Utils.StrToInt1;
  Utils_TryStrToFloat := Utils.TryStrToFloat;
  Utils_TryStrToFloat32 := Utils.TryStrToFloat32;
  Utils_TryStrToFloat64 := Utils.TryStrToFloat64;
  Utils_TryStrToDate := Utils.TryStrToDate;
  Utils_TryStrToInt := Utils.TryStrToInt;
  Utils_FloatToStr := Utils.FloatToStr;
  Utils_Trim := Utils.Trim;
  Utils_UpperString := Utils.UpperString;
  Utils_ExtractFileExt := Utils.ExtractFileExt;
  Utils_FormatFloat := Utils.FormatFloat;
  Utils_FormatInt := Utils.FormatInt;
  Utils_StrToDate := Utils.StrToDate;
  Utils_FormatStr := Utils.FormatStr;
  Utils_Strings_Add := Utils.Strings_Add;
  Utils_Strings_Clear := Utils.Strings_Clear;
end;

function FloatToStrA(Value: AFloat; Digits: Integer = 2): AString; stdcall;
begin
  Result := Utils_FloatToStrA(Value, Digits);
end;

function FloatToStrB(Value: AFloat; Digits: Integer = 2): AString; stdcall;
begin
  Result := Utils_FloatToStrB(Value, Digits);
end;

function FloatToStrC(Value: AFloat; Digits: AInteger = 2): AString; stdcall;
begin
  Result := Utils_FloatToStrC(Value, Digits);
end;

function StrToFloat1(const S: AString; DefValue: AFloat = 0): AFloat; stdcall;
begin
  Result := Utils_StrToFloat1(S, DefValue);
end;

function StrToInt1(const S: AString; DefValue: AInteger = 0): AInteger; stdcall;
begin
  Result := Utils_StrToInt1(S, DefValue);
end;

end.

