{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 27.07.2009
LastMod: 16.05.2011
Version: 0.2.5+0.3.0
}
unit AUISettings0;

{DEFINE A02}
{DEFINE A03}

interface

uses
  ABase0, AUI0;

const
  AUISettings_Name = 'UISettings';
  AUISettings_Uid = $0000000A; // = 10
  AUISettings_Version = {$IFDEF A02}$00020500{$ELSE}$00030000{$ENDIF};

type
  AUISettingsItem = type Integer;

// --- Procs type ---

type
  AUISettings_MainSettingsWin = function: AWindow; stdcall;
  AUISettings_SettingsWin_New = function: AWindow; stdcall;
  AUISettings_ShowSettingsWin = procedure; stdcall;
  AUISettings_NewItem = function(Parent: AUISettingsItem; const Text: AString): AUISettingsItem; stdcall;
  AUISettings_Item_GetPage = function(Item: AUISettingsItem): AControl; stdcall;

// --- Procs var ---

var
  UISettings_MainSettingsWin: AUISettings_MainSettingsWin;
  UISettings_SettingsWin_New: AUISettings_SettingsWin_New;
  UISettings_ShowSettingsWin: AUISettings_ShowSettingsWin;
  UISettings_NewItem: AUISettings_NewItem;
  UISettings_Item_GetPage: AUISettings_Item_GetPage;

// --- Module ---

type
  AUISettingsProcs = ^AUISettingsProcsType;
  // {8x4} {16x4}
  AUISettingsProcsType = packed record
    MainSettingsWin: AUISettings_MainSettingsWin;
    SettingsWin_New: AUISettings_SettingsWin_New;
    ShowSettingsWin: AUISettings_ShowSettingsWin;
    NewItem: AUISettings_NewItem;
    Item_GetPage: AUISettings_Item_GetPage;
    Reserved05: Integer;
    Reserved06: Integer;
    Reserved07: Integer;
    {$IFDEF A03}
    Reserved08: AInteger;
    Reserved09: AInteger;
    Reserved10: AInteger;
    Reserved11: AInteger;
    Reserved12: AInteger;
    Reserved13: AInteger;
    Reserved14: AInteger;
    Reserved15: AInteger;
    {$ENDIF A03}
  end;

var
  UISettings: AUISettingsProcsType;

procedure UISettings_SetProcs(Procs: AUISettingsProcs);

implementation

procedure UISettings_SetProcs(Procs: AUISettingsProcs);
begin
  UISettings := Procs^;
  UISettings_MainSettingsWin := UISettings.MainSettingsWin;
  UISettings_SettingsWin_New := UISettings.SettingsWin_New;
  UISettings_ShowSettingsWin := UISettings.ShowSettingsWin;
  UISettings_NewItem := UISettings.NewItem;
  UISettings_Item_GetPage := UISettings.Item_GetPage;
end;

end.
 
