{
Abstract: User Interface
Author:  Prof1983 <prof1983@yandex.ru>
Created: 25.10.2008
LastMod: 18.05.2011
Version: 0.1.1+0.2.5+0.3.0
}
unit AUI0;

{DEFINE A02}
{DEFINE A03}

{$IFDEF A01} {$DEFINE A01_OR_02} {$ENDIF}
{$IFDEF A02} {$DEFINE A01_OR_02} {$ENDIF}

{$IFDEF A02} {$DEFINE A02UP} {$ENDIF}
{$IFDEF A03} {$DEFINE A02UP} {$ENDIF}

{
Object
|- Control
|   |- Box
|   |- Button
|   |- Calendar
|   |- ComboBox
|   |- Edit
|   |- Grid
|   |- Image
|   |- Label
|   |- ListBox
|   |- PageControl
|   |- ProgressBar
|   |- PropertyBox
|   |- Report
|   |- SpinEdit
|   |- Splitter
|   |- TextView
|   |- ToolBar
|   |- TreeView
|   \- Window
|- DataSource
|- MainWindow
|- MenuItem
|- Menu
|- TrayIcon
\- WaytWin

A_UI_Box_Type = TPanel
A_UI_Button_Type = TButton
A_UI_Calendar_Type = TCalendar
A_UI_ComboBox_Type = TComboBox
A_UI_Control_Type = TControl
A_UI_DataSource = TDataSource
}

interface

uses
  ABase0;

const
  AUI_Name = 'UI';
  AUI_UID = $00000002;
  AUI_Version = {$IFDEF A02}$00020500{$ELSE}$00030000{$ENDIF};

// --- Types ---------------------------------------------------------------------------------------

type
  AControl = type Integer;
  AButton = type AControl;
  ABox = type AControl;
  AMenu = type AInteger;
  AMenuItem = type AControl;
  ATrayIcon = type AInteger;
  ATreeNode = type AControl;
  AWindow = type AControl;
  AReport = type AInteger;
  ADialog = type AInteger;
type
  PADataSource = type AInteger;

type
  AUIBoxType = type AInteger;
const
  AUIBoxTypeNone = 0;
  AUIBoxTypeH = 1;
  AUIBoxTypeV = 2;

type
  AUIWindowFlags = type AInteger;
const
  AUIWindowCreateMenu = $00010000;
  AUIWindowCreateToolBar = $00020000;
  AUIWindowCreateButtonsPanel = $00040000;
type
  AUIWindowButtons = type AMessageBoxFlags;

type
  TUIAlign = (uiAlignNone, uiAlignTop, uiAlignBottom, uiAlignLeft, uiAlignRight, uiAlignClient, uiAlignCustom);
const
  UI_Align_None = 0;
  UI_Align_Top = 1;
  UI_Align_Bottom = 2;
  UI_Align_Left = 3;
  UI_Align_Right = 4;
  UI_Align_Client = 5;
  UI_Align_Custom = 6;

type
  TAUIButtonKind = (
    uibkCustom,
    uibkOK,
    uibkCancel,
    uibkHelp,
    uibkYes,
    uibkNo,
    uibkClose,
    uibkAbort,
    uibkRetry,
    uibkIgnore,
    uibkAll
    );

type
  AUISplitterType = type AInteger;
const
  AUISplitter_HSplitter = 0;       //(Align=alTop)
  AUISplitter_VSplitter = 1;       //(Align=alLeft)
  AUISplitter_HSplitterBottom = 2; //(Align=alBottom)
  AUISplitter_VSplitterRight = 3;  //(Align=alRight)

//type // = Controls.TMouseButton
//  AUIMouseButton = (mbLeft, mbRight, mbMiddle);

// --- Procs ---

type
  AUI_InitMainTrayIcon = function: AInteger; stdcall;
  AUI_InitMenus01 = procedure; stdcall;
  AUI_InitMenus02 = procedure; stdcall;
  AUI_InitMenus03 = function: AInteger; stdcall;
  AUI_IsShowApp = function: ABoolean; stdcall;
  AUI_IsShowApp_Set = procedure(Value: ABoolean); stdcall;
  AUI_OnMainFormCreate_Set = procedure(Value: AProc); stdcall;
  {$IFDEF A03}
  AUI_ProcessMessages = function: AInteger; stdcall;
  {$ELSE}
  AUI_ProcessMessages = procedure; stdcall;
  {$ENDIF}
  AUI_ShowHelp = procedure; stdcall;
  {$IFDEF A03}
  AUI_Shutdown = function: AInteger; stdcall;
  {$ELSE}
  AUI_Shutdown = procedure; stdcall;
  {$ENDIF}
type
  { BoxType
    0 - Simple
    1 - HBox
    2 - VBox }
  AUI_Box_New = function(Parent: AControl; BoxType: AInteger): AControl; stdcall;
type
  AUI_Button_New = function(Parent: AControl): AButton; stdcall;
type
  AUI_Calendar_GetDate = function(Calendar: AControl): TDateTime; stdcall;
  AUI_Calendar_New = function(Parent: AControl): AControl; stdcall;
  AUI_Calendar_SetMonth = procedure(Calendar: AControl; Value: AInteger); stdcall;
type
  AUI_Control_Free = procedure(Control: AControl); stdcall;
  AUI_Control_FreeAndNil = procedure(var Control: AControl); stdcall;
  AUI_Control_GetEnabled = function(Control: AControl): ABoolean; stdcall;
  AUI_Control_GetHeight = function(Control: AControl): AInteger; stdcall;
  AUI_Control_GetHint = function(Control: AControl): AString; stdcall;
  AUI_Control_GetName = function(Control: AControl): AString; stdcall;
  AUI_Control_GetText = function(Control: AControl): AString; stdcall;
  AUI_Control_GetVisible = function(Control: AControl): ABoolean; stdcall;
  AUI_Control_GetWidth = function(Control: AControl): AInteger; stdcall;
  AUI_Control_SetAlign = procedure(Control: AControl; Align: TUIAlign); stdcall;
  AUI_Control_SetClientSize = procedure(Control: AControl; ClientWidth, ClientHeight: AInteger); stdcall;
  AUI_Control_SetColor = procedure(Control: AControl; Color: AColor); stdcall;
  AUI_Control_SetEnabled = procedure(Control: AControl; Value: ABoolean); stdcall;
  AUI_Control_SetFocus = function(Control: AControl): ABoolean; stdcall;
  AUI_Control_SetFont1 = procedure(Control: AControl; const FontName: AString; FontSize: AInteger); stdcall;
  AUI_Control_SetFont2 = procedure(Control: AControl; const FontName: AString; FontSize: AInteger; Color: AColor); stdcall;
  AUI_Control_SetHint = procedure(Control: AControl; const Value: AString); stdcall;
  AUI_Control_SetName = procedure(Control: AControl; const Value: AString); stdcall;
  AUI_Control_SetOnChange = procedure(Control: AControl; OnChange: ACallbackProc); stdcall;
  AUI_Control_SetOnClick = procedure(Control: AControl; Value: ACallbackProc); stdcall;
  AUI_Control_SetPosition = procedure(Control: AControl; Left, Top: AInteger); stdcall;
  AUI_Control_SetSize = procedure(Control: AControl; Width, Height: AInteger); stdcall;
  AUI_Control_SetText = procedure(Control: AControl; const Value: AString); stdcall;
  AUI_Control_SetVisible = procedure(Control: AControl; Value: ABoolean); stdcall;
  AUI_Control_SetWidth = function(Control: AControl; Value: AInteger): AInteger; stdcall;
type
  AUI_DataSource_New = function: PADataSource; stdcall;
  //procedure UI_DataSource_SetDataSet(DataSource: PADataSource; Value: PADataSet); stdcall;
  AUI_DataSource_SetOnDataChange = procedure(DataSource: PADataSource; OnDataChange: ACallbackProc); stdcall;
type
  AUI_Dialog_About = procedure; stdcall;
  AUI_Dialog_About_New = function: AWindow; stdcall;
  AUI_Dialog_AddButton = function(Win: AWindow; Left, Width: AInteger; const Text: AString; OnClick: ACallbackProc): AControl; stdcall;
  AUI_Dialog_Calendar = function(var Date: TDateTime; CenterX, CenterY: AInteger): ABoolean; stdcall;
  AUI_Dialog_Color = function(var Color: AColor): ABoolean; stdcall;
  AUI_Dialog_DateFilter = function(var Group: Integer; var DateBegin, DateEnd: TDateTime): Boolean; stdcall;
  AUI_Dialog_Error = procedure(const Caption, UserMessage, ExceptMessage: AString); stdcall;
  AUI_Dialog_Font = function(var FontName: AString; var FontSize: AInteger; FontColor: AColor): ABoolean; stdcall;
  AUI_Dialog_GetWindow = function(Dialog: ADialog): AWindow; stdcall;
  AUI_Dialog_InputBox = function(const Text: AString; var Value: AString): ABoolean; stdcall;
  AUI_Dialog_InputBox2 = function(const Caption, Text1, Text2: AString; var Value1, Value2: AString): ABoolean; stdcall;
  AUI_Dialog_InputBoxA = function(const Caption, Text: AString; var Value: AString): ABoolean; stdcall;
  AUI_Dialog_Login = function(var UserName, Password: AString; IsSave: ABoolean): ABoolean; stdcall;
  AUI_Dialog_Message = function(const Text, Caption: AString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
  AUI_Dialog_New = function(Buttons: AUIWindowButtons): ADialog; stdcall;
  AUI_Dialog_OpenFile = function(const InitialDir, Filter, Title: AString; var FileName: AString): ABoolean; stdcall;
  AUI_Dialog_OpenFileA = function(const InitialDir, Filter, DefaultExt, Title: AString; var FileName: AString; var FilterIndex: AInteger): ABoolean; stdcall;
  AUI_Dialog_SaveFile = function(const Dir, Ext, DefFileName: AString): AString; stdcall;
  AUI_Dialog_SaveFileA = function(const InitialDir, DefExt, DefFileName, Filter: AString; var FilterIndex: AInteger): AString; stdcall;
type
  AUI_Edit_CheckDate = function(Edit: AControl; out Value: TDateTime): ABoolean; stdcall;
  AUI_Edit_CheckFloat = function(Edit: AControl; out Value: Double): ABoolean; stdcall;
  //    Int.  ,        false.
  AUI_Edit_CheckInt = function(Edit: AControl; out Value: AInteger): ABoolean; stdcall;
  //    TEdit
  AUI_Edit_New = function(Parent: AControl): AControl; stdcall;
  { EditType
    0 - TEdit
    1 - TEdit + Button
    2 - TComboBox }
  AUI_Edit_NewA = function(Parent: AControl; EditType: AInteger; OnClick: ACallbackProc; Left, Top, Width: AInteger): AControl; stdcall;
type
  AUI_Grid_AddColumn = procedure(Grid: AControl; const FieldName, Title: AString; Width: Integer); stdcall;
  { GridType
    0 - StringGrid
    1 - DBGrid }
  AUI_Grid_New = function(Parent: AControl; GridType: AInteger): AControl; stdcall;
  //   DBGrid
  AUI_Grid_RestoreColProps = procedure(Grid: AControl; Config: AConfig; const Key: AString; Delimer: AChar = '\'); stdcall;
  //   DBGrid
  AUI_Grid_SaveColProps = procedure(Grid: AControl; Config: AConfig; const Key: AString; Delimer: AChar = '\'); stdcall;
  //     DBGrid
  AUI_Grid_SetColumnWidth = procedure(Grid: AControl; ColumnIndex, Width, Persent, MinWidth: AInteger); stdcall;
  AUI_Grid_SetColumnWidthA = procedure(Grid: AControl; ColumnIndex, Width, Persent, MinWidth, MaxWidth: AInteger); stdcall;
  AUI_Grid_SetDataSource = procedure(Grid: AControl; Value: PADataSource); stdcall;
type
  AUI_Image_New = function(Parent: AControl): AControl; stdcall;
  AUI_Image_LoadFromFile = function(Image: AControl; const FileName: AString): ABoolean; stdcall;
type
  AUI_Label_New = function(Parent: AControl): AControl; stdcall;
type
  AUI_ListBox_Add = function(ListBox: AControl; const Text: AString): Integer; stdcall;
  AUI_ListBox_Clear = procedure(ListBox: AControl); stdcall;
  AUI_ListBox_New = function(Parent: AControl): AControl; stdcall;
type
  AUI_MainToolBar = function: AControl; stdcall;
  {$IFDEF A01}AUI_MainToolBar_Set = procedure(ToolBar: AControl); stdcall;{$ENDIF}
  {$IFDEF A02}AUI_MainToolBar_Set = procedure(ToolBar: AControl); stdcall;{$ENDIF}
type
  AUI_MainTrayIcon = function: ATrayIcon; stdcall;
type
  AUI_MainWindow = function: AWindow; stdcall;
  AUI_MainWindow_AddMenuItem = function(const ParentItemName, Name, Text: AString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
  AUI_MainWindow_AddMenuItem2 = function(const ParentItemName, Name, Text: AString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
  AUI_MainWindow_Set = procedure(Value: AWindow); stdcall;
  AUI_MainWindow_SetA = procedure(Value: AWindow; ToolBar, StatusBar: AControl; Config: AConfig); stdcall;
type
  AUI_MainWindow_GetLeftContainer = function: AControl; stdcall;
  AUI_MainWindow_GetMainContainer = function: AControl; stdcall;
  AUI_MainWindow_GetRightContainer = function: AControl; stdcall;
type
  AUI_Menu_GetItems = function(Menu: AMenu): AMenuItem; stdcall;
  AUI_Menu_New = function(MenuType: AInteger): AMenu; stdcall;
type
  AUI_MenuItem_Add = function(MenuItem: AMenuItem; const Name, Text: AString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
  AUI_MenuItem_Add2 = function(Parent: AMenuItem; MenuItem: AMenuItem; Weight: AInteger): AMenuItem; stdcall;
  AUI_MenuItem_FindByName = function(MenuItem: AMenuItem; const Name: AString): AMenuItem; stdcall;
type
  AUI_PageControl_AddPage = function(PageControl: AControl; const Name, Text: AString): AControl; stdcall;
  AUI_PageControl_New = function(Parent: AControl): AControl; stdcall;
type
  AUI_ProgressBar_New = function(Parent: AControl; Max: AInteger): AControl; stdcall;
  AUI_ProgressBar_StepIt = function(ProgressBar: AControl): AInteger; stdcall;
type
  AUI_PropertyBox_Add = function(PropertyBox: AControl; const Caption: AString): Integer; stdcall;
  AUI_PropertyBox_AddA = function(PropertyBox: AControl; const Caption, Text, Hint: AString; EditWidth: AInteger): AInteger; stdcall;
  AUI_PropertyBox_Item_GetValue = function(PropertyBox: AControl; Index: Integer): AString; stdcall;
  AUI_PropertyBox_Item_SetValue = procedure(PropertyBox: AControl; Index: Integer; const Value: AString); stdcall;
  AUI_PropertyBox_New = function(Parent: AControl): AControl; stdcall;
type
  AUI_Report_New = function(Parent: AControl): AReport; stdcall;
  AUI_Report_SetText = procedure(Report: AReport; const Value: AString); stdcall;
type
  AUI_ReportWin_New = function: AWindow; stdcall;
  // ReportWinType -   : 0-TReportForm; 1-SimpleReport
  AUI_ReportWin_NewA = function(ReportWinType: AInteger; const Text: AString): AWindow; stdcall;
type
  AUI_Splitter_New = function(Parent: AControl; SplitterType: AUISplitterType): AControl; stdcall;
type
  //     TextView
  AUI_TextView_AddLine = function(TextView: AControl; const Text: AString): AInteger; stdcall;
  {     
    ViewType
      0 - TMemo
      1 - RichEdit }
  AUI_TextView_New = function(Parent: AControl; ViewType: AInteger): AControl; stdcall;
  AUI_TextView_SetFont = procedure(TextView: AControl; const FontName: AString; FontSize: AInteger); stdcall;
  AUI_TextView_SetReadOnly = procedure(TextView: AControl; ReadOnly: ABoolean); stdcall;
  { ScrollBars
      0 - ssNone
      1 - ssHorizontal
      2 - ssVertical
      3 - ssBoth }
  AUI_TextView_SetScrollBars = procedure(TextView: AControl; ScrollBars: AInteger); stdcall;
  AUI_TextView_SetWordWrap = procedure(TextView: AControl; Value: ABoolean); stdcall;
type
  AUI_ToolBar_AddButton = function(ToolBar: AControl; const Name, Text, Hint: AString; OnClick: ACallbackProc; ImageID, Weight: AInteger): AButton; stdcall;
  AUI_ToolBar_New = function(Parent: AControl): AControl; stdcall;
type
  AUI_TrayIcon_GetMenuItems = function(TrayIcon: ATrayIcon): AMenuItem; stdcall; // $IFNDEF UNIX
type
  AUI_TreeView_AddItem = function(TreeView: AControl; Parent: ATreeNode; Text: AString): ATreeNode; stdcall;
  AUI_TreeView_New = function(Parent: AControl): AControl; stdcall;
type
  AUI_WaitWin_New = function(const Caption, Text: AString; MaxPosition: Integer): AWindow; stdcall;
  AUI_WaitWin_StepBy = function(Window: AWindow; Step: AInteger): AInteger; stdcall;
type
  AUI_Window_Free = procedure(Window: AWindow); stdcall;
  AUI_Window_GetMenu = function(Window: AWindow): AMenu; stdcall;
  AUI_Window_LoadConfig = function(Window: AWindow; Config: AConfig): ABoolean; stdcall;
  AUI_Window_LoadConfig2 = function(Window: AWindow; Config: AConfig; const ConfigKey: AString): ABoolean; stdcall;
  AUI_Window_New = function: AControl; stdcall;
  AUI_Window_SaveConfig = function(Window: AWindow; Config: AConfig): ABoolean; stdcall;
  AUI_Window_SaveConfig2 = function(Window: AWindow; Config: AConfig; const ConfigKey: AString): ABoolean; stdcall;
  AUI_Window_SetBorderStyle = procedure(Window: AWindow; BorderStyle: AInteger); stdcall;
  AUI_Window_SetFormStyle = procedure(Window: AWindow; FormStyle: AInteger); stdcall;
  AUI_Window_SetPosition = procedure(Window: AWindow; Position: AInteger); stdcall;
  AUI_Window_ShowModal = function(Window: AWindow): ABoolean; stdcall;

// --- Procs var ---

var
  UI_InitMainTrayIcon: AUI_InitMainTrayIcon;
  UI_InitMenus: {$IFDEF A01}AUI_InitMenus01{$ELSE}{$IFDEF A02}AUI_InitMenus02{$ELSE}AUI_InitMenus03{$ENDIF}{$ENDIF};
  UI_IsShowApp: AUI_IsShowApp;
  UI_IsShowApp_Set: AUI_IsShowApp_Set;
  UI_OnMainFormCreate_Set: AUI_OnMainFormCreate_Set;
  UI_ProcessMessages: AUI_ProcessMessages;
  UI_ShowHelp: AUI_ShowHelp;
  UI_Shutdown: AUI_Shutdown;
var
  UI_Box_New: AUI_Box_New;
  UI_Button_New: AUI_Button_New;
{$IFDEF A02UP}
var
  UI_Calendar_GetDate: AUI_Calendar_GetDate;
  UI_Calendar_New: AUI_Calendar_New;
  UI_Calendar_SetMonth: AUI_Calendar_SetMonth;
{$ENDIF A02UP}
var
  UI_Control_Free: AUI_Control_Free;
  UI_Control_FreeAndNil: AUI_Control_FreeAndNil;
  UI_Control_GetEnabled: AUI_Control_GetEnabled;
  UI_Control_GetHeight: AUI_Control_GetHeight;
  UI_Control_GetHint: AUI_Control_GetHint;
  UI_Control_GetName: AUI_Control_GetName;
  UI_Control_GetText: AUI_Control_GetText;
  UI_Control_GetVisible: AUI_Control_GetVisible;
  UI_Control_GetWidth: AUI_Control_GetWidth;
  UI_Control_SetAlign: AUI_Control_SetAlign;
  UI_Control_SetClientSize: AUI_Control_SetClientSize;
  UI_Control_SetColor: AUI_Control_SetColor;
  UI_Control_SetEnabled: AUI_Control_SetEnabled;
  UI_Control_SetFocus: AUI_Control_SetFocus;
  UI_Control_SetFont1: AUI_Control_SetFont1;
  UI_Control_SetFont2: AUI_Control_SetFont2;
  UI_Control_SetHint: AUI_Control_SetHint;
  UI_Control_SetName: AUI_Control_SetName;
  UI_Control_SetOnChange: AUI_Control_SetOnChange;
  UI_Control_SetOnClick: AUI_Control_SetOnClick;
  UI_Control_SetPosition: AUI_Control_SetPosition;
  UI_Control_SetSize: AUI_Control_SetSize;
  UI_Control_SetText: AUI_Control_SetText;
  UI_Control_SetVisible: AUI_Control_SetVisible;
  UI_Control_SetWidth: AUI_Control_SetWidth;
var
  UI_DataSource_New: AUI_DataSource_New;
  UI_DataSource_SetOnDataChange: AUI_DataSource_SetOnDataChange;
var
  UI_Dialog_About: AUI_Dialog_About;
  UI_Dialog_About_New: AUI_Dialog_About_New;
  UI_Dialog_AddButton: AUI_Dialog_AddButton;
  UI_Dialog_Calendar: AUI_Dialog_Calendar;
  UI_Dialog_Color: AUI_Dialog_Color;
  UI_Dialog_DateFilter: AUI_Dialog_DateFilter;
  UI_Dialog_Error: AUI_Dialog_Error;
  UI_Dialog_Font: AUI_Dialog_Font;
  UI_Dialog_GetWindow: AUI_Dialog_GetWindow;
  UI_Dialog_InputBox: AUI_Dialog_InputBox;
  UI_Dialog_InputBox2: AUI_Dialog_InputBox2;
  UI_Dialog_InputBoxA: AUI_Dialog_InputBoxA;
  UI_Dialog_Login: AUI_Dialog_Login;
  UI_Dialog_Message: AUI_Dialog_Message;
  UI_Dialog_New: AUI_Dialog_New;
  UI_Dialog_OpenFile: AUI_Dialog_OpenFile;
  UI_Dialog_OpenFileA: AUI_Dialog_OpenFileA;
  UI_Dialog_SaveFile: AUI_Dialog_SaveFile;
  UI_Dialog_SaveFileA: AUI_Dialog_SaveFileA;
var
  UI_Edit_CheckDate: AUI_Edit_CheckDate;
  UI_Edit_CheckFloat: AUI_Edit_CheckFloat;
  UI_Edit_CheckInt: AUI_Edit_CheckInt;
  UI_Edit_New: AUI_Edit_New;
  UI_Edit_NewA: AUI_Edit_NewA;
var
  UI_Grid_AddColumn: AUI_Grid_AddColumn;
  UI_Grid_New: AUI_Grid_New;
  UI_Grid_RestoreColProps: AUI_Grid_RestoreColProps;
  UI_Grid_SaveColProps: AUI_Grid_SaveColProps;
  UI_Grid_SetColumnWidth: AUI_Grid_SetColumnWidth;
  UI_Grid_SetColumnWidthA: AUI_Grid_SetColumnWidthA;
  UI_Grid_SetDataSource: AUI_Grid_SetDataSource;
var
  UI_Image_New: AUI_Image_New;
  UI_Image_LoadFromFile: AUI_Image_LoadFromFile;
var
  UI_Label_New: AUI_Label_New;
var
  UI_ListBox_Add: AUI_ListBox_Add;
  UI_ListBox_Clear: AUI_ListBox_Clear;
  UI_ListBox_New: AUI_ListBox_New;
var
  UI_MainToolBar: AUI_MainToolBar;
  {$IFDEF A01}UI_MainToolBar_Set: AUI_MainToolBar_Set;{$ENDIF}
  {$IFDEF A02}UI_MainToolBar_Set: AUI_MainToolBar_Set;{$ENDIF}
var
  UI_MainTrayIcon: AUI_MainTrayIcon;
var
  UI_MainWindow: AUI_MainWindow;
  UI_MainWindow_AddMenuItem: AUI_MainWindow_AddMenuItem;
  UI_MainWindow_AddMenuItem2: AUI_MainWindow_AddMenuItem2;
  UI_MainWindow_GetLeftContainer: AUI_MainWindow_GetLeftContainer;
  UI_MainWindow_GetMainContainer: AUI_MainWindow_GetMainContainer;
  UI_MainWindow_GetRightContainer: AUI_MainWindow_GetRightContainer;
  UI_MainWindow_Set: AUI_MainWindow_Set;
  UI_MainWindow_SetA: AUI_MainWindow_SetA;
var
  UI_Menu_GetItems: AUI_Menu_GetItems;
  UI_Menu_New: AUI_Menu_New;
var
  UI_MenuItem_Add: AUI_MenuItem_Add;
  UI_MenuItem_Add2: AUI_MenuItem_Add2;
  UI_MenuItem_FindByName: AUI_MenuItem_FindByName;
var
  UI_PageControl_AddPage: AUI_PageControl_AddPage;
  UI_PageControl_New: AUI_PageControl_New;
var
  UI_ProgressBar_New: AUI_ProgressBar_New;
  UI_ProgressBar_StepIt: AUI_ProgressBar_StepIt;
var
  UI_PropertyBox_Add: AUI_PropertyBox_Add;
  UI_PropertyBox_AddA: AUI_PropertyBox_AddA;
  UI_PropertyBox_Item_GetValue: AUI_PropertyBox_Item_GetValue;
  UI_PropertyBox_Item_SetValue: AUI_PropertyBox_Item_SetValue;
  UI_PropertyBox_New: AUI_PropertyBox_New;
var
  UI_Report_New: AUI_Report_New;
  UI_Report_SetText: AUI_Report_SetText;
var
  UI_ReportWin_New: AUI_ReportWin_New;
  UI_ReportWin_NewA: AUI_ReportWin_NewA;
var
  UI_Splitter_New: AUI_Splitter_New;
var 
  UI_TextView_AddLine: AUI_TextView_AddLine;
  UI_TextView_New: AUI_TextView_New;
  UI_TextView_SetFont: AUI_TextView_SetFont;
  UI_TextView_SetReadOnly: AUI_TextView_SetReadOnly;
  UI_TextView_SetScrollBars: AUI_TextView_SetScrollBars;
  UI_TextView_SetWordWrap: AUI_TextView_SetWordWrap;
var
  UI_ToolBar_AddButton: AUI_ToolBar_AddButton;
  UI_ToolBar_New: AUI_ToolBar_New;
var
  UI_TrayIcon_GetMenuItems: AUI_TrayIcon_GetMenuItems;
var
  UI_TreeView_AddItem: AUI_TreeView_AddItem;
  UI_TreeView_New: AUI_TreeView_New;
var
  UI_Window_Free: AUI_Window_Free;
  UI_Window_GetMenu: AUI_Window_GetMenu;
  UI_Window_LoadConfig: AUI_Window_LoadConfig;
  UI_Window_LoadConfig2: AUI_Window_LoadConfig2;
  UI_Window_New: AUI_Window_New;
  UI_Window_SaveConfig: AUI_Window_SaveConfig;
  UI_Window_SaveConfig2: AUI_Window_SaveConfig2;
  UI_Window_SetBorderStyle: AUI_Window_SetBorderStyle;
  UI_Window_SetFormStyle: AUI_Window_SetFormStyle;
  UI_Window_SetPosition: AUI_Window_SetPosition;
  UI_Window_ShowModal: AUI_Window_ShowModal;
var
  UI_WaitWin_New: AUI_WaitWin_New;
  UI_WaitWin_StepBy: AUI_WaitWin_StepBy;

// --- Module ---

type
  AUIProcs = ^AUIProcsType;
  {$IFDEF A01_OR_02}
  AUIProcsType = packed record // 144x4
    IsShowApp: AUI_IsShowApp;
    InitMainTrayIcon: AUI_InitMainTrayIcon;
    InitMenus: AUI_InitMenus02;
    ProcessMessages: AUI_ProcessMessages;
    IsShowApp_Set: AUI_IsShowApp_Set;
    ShowHelp: AUI_ShowHelp;
    Shutdown: AUI_Shutdown;

    Box_New: AUI_Box_New;
    Button_New: AUI_Button_New;

    Control_Free: AUI_Control_Free;
    Control_FreeAndNil: AUI_Control_FreeAndNil;
    Control_GetEnabled: AUI_Control_GetEnabled;
    Control_GetHeight: AUI_Control_GetHeight;
    Control_GetHint: AUI_Control_GetHint;
    Control_GetName: AUI_Control_GetName;
    Control_GetText: AUI_Control_GetText;
    Control_GetVisible: AUI_Control_GetVisible;
    Control_GetWidth: AUI_Control_GetWidth;
    Control_SetAlign: AUI_Control_SetAlign;
    Control_SetClientSize: AUI_Control_SetClientSize;
    Control_SetColor: AUI_Control_SetColor;
    Control_SetEnabled: AUI_Control_SetEnabled;
    Control_SetFocus: AUI_Control_SetFocus;
    Control_SetHint: AUI_Control_SetHint;
    Control_SetName: AUI_Control_SetName;
    Control_SetOnChange: AUI_Control_SetOnChange;
    Control_SetOnClick: AUI_Control_SetOnClick;
    Control_SetPosition: AUI_Control_SetPosition;
    Control_SetSize: AUI_Control_SetSize;
    Control_SetText: AUI_Control_SetText;
    Control_SetVisible: AUI_Control_SetVisible;
    Control_SetWidth: AUI_Control_SetWidth;

    DataSource_New: AUI_DataSource_New;
    DataSource_SetOnDataChange: AUI_DataSource_SetOnDataChange;

    Dialog_About: AUI_Dialog_About;
    Dialog_Calendar: AUI_Dialog_Calendar;
    Dialog_Color: AUI_Dialog_Color;
    Dialog_DateFilter: AUI_Dialog_DateFilter;
    Dialog_Error: AUI_Dialog_Error;
    Dialog_Font: AUI_Dialog_Font;
    Dialog_GetWindow: AUI_Dialog_GetWindow;
    Dialog_InputBox: AUI_Dialog_InputBox;
    Dialog_InputBox2: AUI_Dialog_InputBox2;
    Dialog_InputBoxA: AUI_Dialog_InputBoxA;
    Dialog_Login: AUI_Dialog_Login;
    Dialog_Message: AUI_Dialog_Message;
    Dialog_New: AUI_Dialog_New;
    Dialog_OpenFile: AUI_Dialog_OpenFile;
    Dialog_OpenFileA: AUI_Dialog_OpenFileA;
    Dialog_SaveFile: AUI_Dialog_SaveFile;
    Dialog_SaveFileA: AUI_Dialog_SaveFileA;

    Edit_CheckDate: AUI_Edit_CheckDate;
    Edit_CheckFloat: AUI_Edit_CheckFloat;
    Edit_CheckInt: AUI_Edit_CheckInt;
    Edit_New: AUI_Edit_New;
    Edit_NewA: AUI_Edit_NewA;

    Grid_AddColumn: AUI_Grid_AddColumn;
    Grid_New: AUI_Grid_New;
    Grid_RestoreColProps: AUI_Grid_RestoreColProps;
    Grid_SaveColProps: AUI_Grid_SaveColProps;
    Grid_SetColumnWidth: AUI_Grid_SetColumnWidth;
    Grid_SetColumnWidthA: AUI_Grid_SetColumnWidthA;
    Grid_SetDataSource: AUI_Grid_SetDataSource;

    Image_New: AUI_Image_New;
    Image_LoadFromFile: AUI_Image_LoadFromFile;

    Label_New: AUI_Label_New;
    Label_SetFont: AUI_Control_SetFont1;

    ListBox_Add: AUI_ListBox_Add;
    ListBox_Clear: AUI_ListBox_Clear;
    ListBox_New: AUI_ListBox_New;

    MainToolBar: AUI_MainToolBar;
    MainToolBar_Set: AUI_MainToolBar_Set;

    MainTrayIcon: AUI_MainTrayIcon;

    MainWindow: AUI_MainWindow;
    MainWindow_AddMenuItem: AUI_MainWindow_AddMenuItem;
    MainWindow_AddMenuItem2: AUI_MainWindow_AddMenuItem2;
    MainWindow_GetLeftContainer: AUI_MainWindow_GetLeftContainer;
    MainWindow_GetMainContainer: AUI_MainWindow_GetMainContainer;
    MainWindow_GetRightContainer: AUI_MainWindow_GetRightContainer;
    MainWindow_Set: AUI_MainWindow_Set;

    Menu_GetItems: AUI_Menu_GetItems;
    Menu_New: AUI_Menu_New;

    MenuItem_Add: AUI_MenuItem_Add;
    MenuItem_Add2: AUI_MenuItem_Add2;
    MenuItem_FindByName: AUI_MenuItem_FindByName;

    PageControl_AddPage: AUI_PageControl_AddPage;
    PageControl_New: AUI_PageControl_New;

    ProgressBar_New: AUI_ProgressBar_New;
    ProgressBar_StepIt: AUI_ProgressBar_StepIt;

    PropertyBox_Add: AUI_PropertyBox_Add;
    PropertyBox_AddA: AUI_PropertyBox_AddA;
    PropertyBox_Item_GetValue: AUI_PropertyBox_Item_GetValue;
    PropertyBox_Item_SetValue: AUI_PropertyBox_Item_SetValue;
    PropertyBox_New: AUI_PropertyBox_New;

    Splitter_New: AUI_Splitter_New;

    TextView_AddLine: AUI_TextView_AddLine;
    TextView_New: AUI_TextView_New;
    TextView_SetFont: AUI_TextView_SetFont;
    TextView_SetReadOnly: AUI_TextView_SetReadOnly;
    TextView_SetScrollBars: AUI_TextView_SetScrollBars;
    TextView_SetWordWrap: AUI_TextView_SetWordWrap;

    ToolBar_AddButton: AUI_ToolBar_AddButton;
    ToolBar_New: AUI_ToolBar_New;

    TrayIcon_GetMenuItems: AUI_TrayIcon_GetMenuItems;

    TreeView_AddItem: AUI_TreeView_AddItem;
    TreeView_New: AUI_TreeView_New;

    Window_Free: AUI_Window_Free;
    Window_GetMenu: AUI_Window_GetMenu;
    Window_LoadConfig: AUI_Window_LoadConfig;
    Window_LoadConfig2: AUI_Window_LoadConfig2;
    Window_New: AUI_Window_New;
    Window_SaveConfig: AUI_Window_SaveConfig;
    Window_SaveConfig2: AUI_Window_SaveConfig2;
    Window_SetBorderStyle: AUI_Window_SetBorderStyle;
    Window_SetFormStyle: AUI_Window_SetFormStyle;
    Window_SetPosition: AUI_Window_SetPosition;
    Window_ShowModal: AUI_Window_ShowModal;

    ReportWin_New: AUI_ReportWin_New;
    WaitWin_New: AUI_WaitWin_New;
    WaitWin_StepBy: AUI_WaitWin_StepBy;
    // Testing
    OnMainFormCreate_Set: AUI_OnMainFormCreate_Set;
    MainWindow_SetA: AUI_MainWindow_SetA;

    {$IFDEF A01}
    Reserved125: Integer;
    Reserved126: Integer;
    Reserved127: Integer;
    Reserved128: Integer;
    Reserved129: Integer;
    Reserved130: Integer;
    {$ENDIF A01}
    {$IFDEF A02}
    ReportWin_NewA: AUI_ReportWin_NewA;
    Calendar_GetDate: AUI_Calendar_GetDate;
    Calendar_New: AUI_Calendar_New;
    Calendar_SetMonth: AUI_Calendar_SetMonth;
    Report_New: AUI_Report_New;
    Report_SetText: AUI_Report_SetText;
    {$ENDIF A02}

    Reserved131: Integer;
    Reserved132: Integer;
    Reserved133: Integer;
    Reserved134: Integer;
    Reserved135: Integer;
    Reserved136: Integer;
    Reserved137: Integer;
    Reserved138: Integer;
    Reserved139: Integer;
    Reserved140: Integer;
    Reserved141: Integer;
    Reserved142: Integer;
    Reserved143: Integer;
  end;
  {$ELSE} // A01_OR_02
  AUIProcsType = packed record // 256x4
    InitMainTrayIcon: AUI_InitMainTrayIcon;
    InitMenus: AUI_InitMenus03;
    IsShowApp: AUI_IsShowApp;
    IsShowApp_Set: AUI_IsShowApp_Set;
    OnMainFormCreate_Set: AUI_OnMainFormCreate_Set;
    ProcessMessages: AUI_ProcessMessages;
    ShowHelp: AUI_ShowHelp;
    Shutdown: AUI_Shutdown;

    Box_New: AUI_Box_New;
    Button_New: AUI_Button_New;

    Calendar_GetDate: AUI_Calendar_GetDate;
    Calendar_New: AUI_Calendar_New;
    Calendar_SetMonth: AUI_Calendar_SetMonth;

    Control_Free: AUI_Control_Free;
    Control_FreeAndNil: AUI_Control_FreeAndNil;
    Control_GetEnabled: AUI_Control_GetEnabled;
    Control_GetHeight: AUI_Control_GetHeight;
    Control_GetHint: AUI_Control_GetHint;
    Control_GetName: AUI_Control_GetName;
    Control_GetText: AUI_Control_GetText;
    Control_GetVisible: AUI_Control_GetVisible;
    Control_GetWidth: AUI_Control_GetWidth;
    Control_SetAlign: AUI_Control_SetAlign;
    Control_SetClientSize: AUI_Control_SetClientSize;
    Control_SetColor: AUI_Control_SetColor;
    Control_SetEnabled: AUI_Control_SetEnabled;
    Control_SetFocus: AUI_Control_SetFocus;
    Control_SetFont1: AUI_Control_SetFont1;
    Control_SetFont2: AUI_Control_SetFont2;
    Control_SetHint: AUI_Control_SetHint;
    Control_SetName: AUI_Control_SetName;
    Control_SetOnChange: AUI_Control_SetOnChange;
    Control_SetOnClick: AUI_Control_SetOnClick;
    Control_SetPosition: AUI_Control_SetPosition;
    Control_SetSize: AUI_Control_SetSize;
    Control_SetText: AUI_Control_SetText;
    Control_SetVisible: AUI_Control_SetVisible;
    Control_SetWidth: AUI_Control_SetWidth;

    DataSource_New: AUI_DataSource_New;
    DataSource_SetOnDataChange: AUI_DataSource_SetOnDataChange;

    Dialog_About: AUI_Dialog_About;
    Dialog_About_New: AUI_Dialog_About_New;
    Dialog_AddButton: AUI_Dialog_AddButton;
    Dialog_Calendar: AUI_Dialog_Calendar;
    Dialog_Color: AUI_Dialog_Color;
    Dialog_DateFilter: AUI_Dialog_DateFilter;
    Dialog_Error: AUI_Dialog_Error;
    Dialog_Font: AUI_Dialog_Font;
    Dialog_GetWindow: AUI_Dialog_GetWindow;
    Dialog_InputBox: AUI_Dialog_InputBox;
    Dialog_InputBox2: AUI_Dialog_InputBox2;
    Dialog_InputBoxA: AUI_Dialog_InputBoxA;
    Dialog_Login: AUI_Dialog_Login;
    Dialog_Message: AUI_Dialog_Message;
    Dialog_New: AUI_Dialog_New;
    Dialog_OpenFile: AUI_Dialog_OpenFile;
    Dialog_OpenFileA: AUI_Dialog_OpenFileA;
    Dialog_SaveFile: AUI_Dialog_SaveFile;
    Dialog_SaveFileA: AUI_Dialog_SaveFileA;

    Edit_CheckDate: AUI_Edit_CheckDate;
    Edit_CheckFloat: AUI_Edit_CheckFloat;
    Edit_CheckInt: AUI_Edit_CheckInt;
    Edit_New: AUI_Edit_New;
    Edit_NewA: AUI_Edit_NewA;

    Grid_AddColumn: AUI_Grid_AddColumn;
    Grid_New: AUI_Grid_New;
    Grid_RestoreColProps: AUI_Grid_RestoreColProps;
    Grid_SaveColProps: AUI_Grid_SaveColProps;
    Grid_SetColumnWidth: AUI_Grid_SetColumnWidth;
    Grid_SetColumnWidthA: AUI_Grid_SetColumnWidthA;
    Grid_SetDataSource: AUI_Grid_SetDataSource;

    Image_New: AUI_Image_New;
    Image_LoadFromFile: AUI_Image_LoadFromFile;

    Label_New: AUI_Label_New;

    ListBox_Add: AUI_ListBox_Add;
    ListBox_Clear: AUI_ListBox_Clear;
    ListBox_New: AUI_ListBox_New;

    MainToolBar: AUI_MainToolBar;
    //MainToolBar_Set: AUI_MainToolBar_Set;

    MainTrayIcon: AUI_MainTrayIcon;

    MainWindow: AUI_MainWindow;
    MainWindow_AddMenuItem: AUI_MainWindow_AddMenuItem;
    MainWindow_AddMenuItem2: AUI_MainWindow_AddMenuItem2;
    MainWindow_GetLeftContainer: AUI_MainWindow_GetLeftContainer;
    MainWindow_GetMainContainer: AUI_MainWindow_GetMainContainer;
    MainWindow_GetRightContainer: AUI_MainWindow_GetRightContainer;
    MainWindow_Set: AUI_MainWindow_Set;
    MainWindow_SetA: AUI_MainWindow_SetA;

    Menu_GetItems: AUI_Menu_GetItems;
    Menu_New: AUI_Menu_New;

    MenuItem_Add: AUI_MenuItem_Add;
    MenuItem_Add2: AUI_MenuItem_Add2;
    MenuItem_FindByName: AUI_MenuItem_FindByName;

    PageControl_AddPage: AUI_PageControl_AddPage;
    PageControl_New: AUI_PageControl_New;

    ProgressBar_New: AUI_ProgressBar_New;
    ProgressBar_StepIt: AUI_ProgressBar_StepIt;

    PropertyBox_Add: AUI_PropertyBox_Add;
    PropertyBox_AddA: AUI_PropertyBox_AddA;
    PropertyBox_Item_GetValue: AUI_PropertyBox_Item_GetValue;
    PropertyBox_Item_SetValue: AUI_PropertyBox_Item_SetValue;
    PropertyBox_New: AUI_PropertyBox_New;

    Report_New: AUI_Report_New;
    Report_SetText: AUI_Report_SetText;

    ReportWin_New: AUI_ReportWin_New;
    ReportWin_NewA: AUI_ReportWin_NewA;

    Splitter_New: AUI_Splitter_New;

    TextView_AddLine: AUI_TextView_AddLine;
    TextView_New: AUI_TextView_New;
    TextView_SetFont: AUI_TextView_SetFont;
    TextView_SetReadOnly: AUI_TextView_SetReadOnly;
    TextView_SetScrollBars: AUI_TextView_SetScrollBars;
    TextView_SetWordWrap: AUI_TextView_SetWordWrap;

    ToolBar_AddButton: AUI_ToolBar_AddButton;
    ToolBar_New: AUI_ToolBar_New;

    TrayIcon_GetMenuItems: AUI_TrayIcon_GetMenuItems;

    TreeView_AddItem: AUI_TreeView_AddItem;
    TreeView_New: AUI_TreeView_New;

    WaitWin_New: AUI_WaitWin_New;
    WaitWin_StepBy: AUI_WaitWin_StepBy;

    Window_Free: AUI_Window_Free;
    Window_GetMenu: AUI_Window_GetMenu;
    Window_LoadConfig: AUI_Window_LoadConfig;
    Window_LoadConfig2: AUI_Window_LoadConfig2;
    Window_New: AUI_Window_New;
    Window_SaveConfig: AUI_Window_SaveConfig;
    Window_SaveConfig2: AUI_Window_SaveConfig2;
    Window_SetBorderStyle: AUI_Window_SetBorderStyle;
    Window_SetFormStyle: AUI_Window_SetFormStyle;
    Window_SetPosition: AUI_Window_SetPosition;
    Window_ShowModal: AUI_Window_ShowModal;

    { Testing }

    Reserved129: Integer;
    Reserved130: Integer;
    Reserved131: Integer;
    Reserved132: Integer;
    Reserved133: Integer;
    Reserved134: Integer;
    Reserved135: Integer;
    Reserved136: Integer;
    Reserved137: Integer;
    Reserved138: Integer;
    Reserved139: Integer;
    Reserved140: Integer;
    Reserved141: Integer;
    Reserved142: Integer;
    Reserved143: Integer;

    Reserved144: Integer;
    Reserved145: Integer;
    Reserved146: Integer;
    Reserved147: Integer;
    Reserved148: Integer;
    Reserved149: Integer;
    Reserved150: Integer;
    Reserved151: Integer;
    Reserved152: Integer;
    Reserved153: Integer;
    Reserved154: Integer;
    Reserved155: Integer;
    Reserved156: Integer;
    Reserved157: Integer;
    Reserved158: Integer;
    Reserved159: Integer;

    Reserved160: Integer;
    Reserved161: Integer;
    Reserved162: Integer;
    Reserved163: Integer;
    Reserved164: Integer;
    Reserved165: Integer;
    Reserved166: Integer;
    Reserved167: Integer;
    Reserved168: Integer;
    Reserved169: Integer;
    Reserved170: Integer;
    Reserved171: Integer;
    Reserved172: Integer;
    Reserved173: Integer;
    Reserved174: Integer;
    Reserved175: Integer;

    Reserved176: Integer;
    Reserved177: Integer;
    Reserved178: Integer;
    Reserved179: Integer;
    Reserved180: Integer;
    Reserved181: Integer;
    Reserved182: Integer;
    Reserved183: Integer;
    Reserved184: Integer;
    Reserved185: Integer;
    Reserved186: Integer;
    Reserved187: Integer;
    Reserved188: Integer;
    Reserved189: Integer;
    Reserved190: Integer;
    Reserved191: Integer;

    Reserved192: Integer;
    Reserved193: Integer;
    Reserved194: Integer;
    Reserved195: Integer;
    Reserved196: Integer;
    Reserved197: Integer;
    Reserved198: Integer;
    Reserved199: Integer;
    Reserved200: Integer;
    Reserved201: Integer;
    Reserved202: Integer;
    Reserved203: Integer;
    Reserved204: Integer;
    Reserved205: Integer;
    Reserved206: Integer;
    Reserved207: Integer;

    Reserved208: Integer;
    Reserved209: Integer;
    Reserved210: Integer;
    Reserved211: Integer;
    Reserved212: Integer;
    Reserved213: Integer;
    Reserved214: Integer;
    Reserved215: Integer;
    Reserved216: Integer;
    Reserved217: Integer;
    Reserved218: Integer;
    Reserved219: Integer;
    Reserved220: Integer;
    Reserved221: Integer;
    Reserved222: Integer;
    Reserved223: Integer;

    Reserved224: Integer;
    Reserved225: Integer;
    Reserved226: Integer;
    Reserved227: Integer;
    Reserved228: Integer;
    Reserved229: Integer;
    Reserved230: Integer;
    Reserved231: Integer;
    Reserved232: Integer;
    Reserved233: Integer;
    Reserved234: Integer;
    Reserved235: Integer;
    Reserved236: Integer;
    Reserved237: Integer;
    Reserved238: Integer;
    Reserved239: Integer;

    Reserved240: Integer;
    Reserved241: Integer;
    Reserved242: Integer;
    Reserved243: Integer;
    Reserved244: Integer;
    Reserved245: Integer;
    Reserved246: Integer;
    Reserved247: Integer;
    Reserved248: Integer;
    Reserved249: Integer;
    Reserved250: Integer;
    Reserved251: Integer;
    Reserved252: Integer;
    Reserved253: Integer;
    Reserved254: Integer;
    Reserved255: Integer;
  end;
  {$ENDIF} // A01_OR_02

var
  UI: AUIProcsType;

procedure UI_SetProcs(UIProcs: AUIProcs);

implementation

procedure UI_SetProcs(UIProcs: AUIProcs);
begin
  if not(Assigned(UIProcs)) then Exit;
  UI := UIProcs^;

{$IFDEF A01_OR_02}
  UI_IsShowApp := UI.IsShowApp;
  UI_InitMainTrayIcon := UI.InitMainTrayIcon;
  UI_InitMenus := UI.InitMenus;
  UI_ProcessMessages := UI.ProcessMessages;
  UI_IsShowApp_Set := UI.IsShowApp_Set;
  UI_ShowHelp := UI.ShowHelp;
  UI_Shutdown := UI.Shutdown;

  UI_Box_New := UI.Box_New;
  UI_Button_New := UI.Button_New;

  UI_Control_Free := UI.Control_Free;
  UI_Control_FreeAndNil := UI.Control_FreeAndNil;
  UI_Control_GetEnabled := UI.Control_GetEnabled;
  UI_Control_GetHeight := UI.Control_GetHeight;
  UI_Control_GetHint := UI.Control_GetHint;
  UI_Control_GetName := UI.Control_GetName;
  UI_Control_GetText := UI.Control_GetText;
  UI_Control_GetVisible := UI.Control_GetVisible;
  UI_Control_GetWidth := UI.Control_GetWidth;
  UI_Control_SetAlign := UI.Control_SetAlign;
  UI_Control_SetClientSize := UI.Control_SetClientSize;
  UI_Control_SetColor := UI.Control_SetColor;
  UI_Control_SetEnabled := UI.Control_SetEnabled;
  UI_Control_SetFocus := UI.Control_SetFocus;
  UI_Control_SetHint := UI.Control_SetHint;
  UI_Control_SetName := UI.Control_SetName;
  UI_Control_SetOnChange := UI.Control_SetOnChange;
  UI_Control_SetOnClick := UI.Control_SetOnClick;
  UI_Control_SetPosition := UI.Control_SetPosition;
  UI_Control_SetSize := UI.Control_SetSize;
  UI_Control_SetText := UI.Control_SetText;
  UI_Control_SetVisible := UI.Control_SetVisible;
  UI_Control_SetWidth := UI.Control_SetWidth;

  UI_DataSource_New := UI.DataSource_New;
  UI_DataSource_SetOnDataChange := UI.DataSource_SetOnDataChange;

  UI_Dialog_About := UI.Dialog_About;
  UI_Dialog_Calendar := UI.Dialog_Calendar;
  UI_Dialog_Color := UI.Dialog_Color;
  UI_Dialog_DateFilter := UI.Dialog_DateFilter;
  UI_Dialog_Error := UI.Dialog_Error;
  UI_Dialog_Font := UI.Dialog_Font;
  UI_Dialog_GetWindow := UI.Dialog_GetWindow;
  UI_Dialog_InputBox := UI.Dialog_InputBox;
  UI_Dialog_InputBox2 := UI.Dialog_InputBox2;
  UI_Dialog_InputBoxA := UI.Dialog_InputBoxA;
  UI_Dialog_Login := UI.Dialog_Login;
  UI_Dialog_Message := UI.Dialog_Message;
  UI_Dialog_New := UI.Dialog_New;
  UI_Dialog_OpenFile := UI.Dialog_OpenFile;
  UI_Dialog_OpenFileA := UI.Dialog_OpenFileA;
  UI_Dialog_SaveFile := UI.Dialog_SaveFile;
  UI_Dialog_SaveFileA := UI.Dialog_SaveFileA;

  UI_Edit_CheckDate := UI.Edit_CheckDate;
  UI_Edit_CheckFloat := UI.Edit_CheckFloat;
  UI_Edit_CheckInt := UI.Edit_CheckInt;
  UI_Edit_New := UI.Edit_New;
  UI_Edit_NewA := UI.Edit_NewA;

  UI_Grid_AddColumn := UI.Grid_AddColumn;
  UI_Grid_New := UI.Grid_New;
  UI_Grid_RestoreColProps := UI.Grid_RestoreColProps;
  UI_Grid_SaveColProps := UI.Grid_SaveColProps;
  UI_Grid_SetColumnWidth := UI.Grid_SetColumnWidth;
  UI_Grid_SetColumnWidthA := UI.Grid_SetColumnWidthA;
  UI_Grid_SetDataSource := UI.Grid_SetDataSource;

  UI_Image_New := UI.Image_New;
  UI_Image_LoadFromFile := UI.Image_LoadFromFile;

  UI_Label_New := UI.Label_New;
  UI_Control_SetFont1 := UI.Label_SetFont;

  UI_ListBox_Add := UI.ListBox_Add;
  UI_ListBox_Clear := UI.ListBox_Clear;
  UI_ListBox_New := UI.ListBox_New;

  UI_MainToolBar := UI.MainToolBar;
  UI_MainToolBar_Set := UI.MainToolBar_Set;

  UI_MainTrayIcon := UI.MainTrayIcon;

  UI_MainWindow := UI.MainWindow;
  UI_MainWindow_AddMenuItem := UI.MainWindow_AddMenuItem;
  UI_MainWindow_AddMenuItem2 := UI.MainWindow_AddMenuItem2;
  UI_MainWindow_GetLeftContainer := UI.MainWindow_GetLeftContainer;
  UI_MainWindow_GetMainContainer := UI.MainWindow_GetMainContainer;
  UI_MainWindow_GetRightContainer := UI.MainWindow_GetRightContainer;
  UI_MainWindow_Set := UI.MainWindow_Set;

  UI_Menu_GetItems := UI.Menu_GetItems;
  UI_Menu_New := UI.Menu_New;

  UI_MenuItem_Add := UI.MenuItem_Add;
  UI_MenuItem_Add2 := UI.MenuItem_Add2;
  UI_MenuItem_FindByName := UI.MenuItem_FindByName;

  UI_PageControl_AddPage := UI.PageControl_AddPage;
  UI_PageControl_New := UI.PageControl_New;

  UI_ProgressBar_New := UI.ProgressBar_New;
  UI_ProgressBar_StepIt := UI.ProgressBar_StepIt;

  UI_PropertyBox_Add := UI.PropertyBox_Add;
  UI_PropertyBox_AddA := UI.PropertyBox_AddA;
  UI_PropertyBox_Item_GetValue := UI.PropertyBox_Item_GetValue;
  UI_PropertyBox_Item_SetValue := UI.PropertyBox_Item_SetValue;
  UI_PropertyBox_New := UI.PropertyBox_New;

  UI_Splitter_New := UI.Splitter_New;

  UI_TextView_AddLine := UI.TextView_AddLine;
  UI_TextView_New := UI.TextView_New;
  UI_TextView_SetFont := UI.TextView_SetFont;
  UI_TextView_SetReadOnly := UI.TextView_SetReadOnly;
  UI_TextView_SetScrollBars := UI.TextView_SetScrollBars;
  UI_TextView_SetWordWrap := UI.TextView_SetWordWrap;

  UI_ToolBar_AddButton := UI.ToolBar_AddButton;
  UI_ToolBar_New := UI.ToolBar_New;

  UI_TrayIcon_GetMenuItems := UI.TrayIcon_GetMenuItems;

  UI_TreeView_AddItem := UI.TreeView_AddItem;
  UI_TreeView_New := UI.TreeView_New;

  UI_Window_Free := UI.Window_Free;
  UI_Window_GetMenu := UI.Window_GetMenu;
  UI_Window_LoadConfig := UI.Window_LoadConfig;
  UI_Window_LoadConfig2 := UI.Window_LoadConfig2;
  UI_Window_New := UI.Window_New;
  UI_Window_SaveConfig := UI.Window_SaveConfig;
  UI_Window_SaveConfig2 := UI.Window_SaveConfig2;
  UI_Window_SetBorderStyle := UI.Window_SetBorderStyle;
  UI_Window_SetFormStyle := UI.Window_SetFormStyle;
  UI_Window_SetPosition := UI.Window_SetPosition;
  UI_Window_ShowModal := UI.Window_ShowModal;

  UI_ReportWin_New := UI.ReportWin_New;
  UI_WaitWin_New := UI.WaitWin_New;
  UI_WaitWin_StepBy := UI.WaitWin_StepBy;
  { Testing }
  UI_OnMainFormCreate_Set := UI.OnMainFormCreate_Set;
  UI_MainWindow_SetA := UI.MainWindow_SetA;
  {$IFDEF A02}
  UI_ReportWin_NewA := UI.ReportWin_NewA;

  UI_Calendar_GetDate := UI.Calendar_GetDate;
  UI_Calendar_New := UI.Calendar_New;
  UI_Calendar_SetMonth := UI.Calendar_SetMonth;

  UI_Report_New := UI.Report_New;
  UI_Report_SetText := UI.Report_SetText;
  {$ENDIF A02}
  {IFDEF A02}
  {UI_IsShowApp := UI.IsShowApp;
  UI_InitMainTrayIcon := UI.InitMainTrayIcon;
  UI_InitMenus := UI.InitMenus;
  UI_ProcessMessages := UI.ProcessMessages;
  UI_IsShowApp_Set := UI.SetIsShowApp;
  UI_ShowHelp := UI.ShowHelp;
  UI_Shutdown := UI.Shutdown;

  UI_Box_New := UI.Box_New;
  UI_Button_New := UI.Button_New;

  UI_Control_Free := UI.Control_Free;
  UI_Control_FreeAndNil := UI.Control_FreeAndNil;
  UI_Control_GetEnabled := UI.Control_GetEnabled;
  UI_Control_GetHeight := UI.Control_GetHeight;
  UI_Control_GetHint := UI.Control_GetHint;
  UI_Control_GetName := UI.Control_GetName;
  UI_Control_GetText := UI.Control_GetText;
  UI_Control_GetVisible := UI.Control_GetVisible;
  UI_Control_GetWidth := UI.Control_GetWidth;
  UI_Control_SetAlign := UI.Control_SetAlign;
  UI_Control_SetClientSize := UI.Control_SetClientSize;
  UI_Control_SetColor := UI.Control_SetColor;
  UI_Control_SetEnabled := UI.Control_SetEnabled;
  UI_Control_SetFocus := UI.Control_SetFocus;
  UI_Control_SetHint := UI.Control_SetHint;
  UI_Control_SetName := UI.Control_SetName;
  UI_Control_SetOnChange := UI.Control_SetOnChange;
  UI_Control_SetOnClick := UI.Control_SetOnClick;
  UI_Control_SetPosition := UI.Control_SetPosition;
  UI_Control_SetSize := UI.Control_SetSize;
  UI_Control_SetText := UI.Control_SetText;
  UI_Control_SetVisible := UI.Control_SetVisible;
  UI_Control_SetWidth := UI.Control_SetWidth;

  UI_DataSource_New := UI.DataSource_New;
  UI_DataSource_SetOnDataChange := UI.DataSource_SetOnDataChange;

  UI_Dialog_About := UI.Dialog_About;
  UI_Dialog_Calendar := UI.Dialog_Calendar;
  UI_Dialog_Color := UI.Dialog_Color;
  UI_Dialog_DateFilter := UI.Dialog_DateFilter;
  UI_Dialog_Error := UI.Dialog_Error;
  UI_Dialog_Font := UI.Dialog_Font;
  UI_Dialog_GetWindow := UI.Dialog_GetWindow;
  UI_Dialog_InputBox := UI.Dialog_InputBox;
  UI_Dialog_InputBox2 := UI.Dialog_InputBox2;
  UI_Dialog_InputBoxA := UI.Dialog_InputBoxA;
  UI_Dialog_Login := UI.Dialog_Login;
  UI_Dialog_Message := UI.Dialog_Message;
  UI_Dialog_New := UI.Dialog_New;
  UI_Dialog_OpenFile := UI.Dialog_OpenFile;
  UI_Dialog_OpenFileA := UI.Dialog_OpenFileA;
  UI_Dialog_SaveFile := UI.Dialog_SaveFile;
  UI_Dialog_SaveFileA := UI.Dialog_SaveFileA;

  UI_Edit_CheckDate := UI.Edit_CheckDate;
  UI_Edit_CheckFloat := UI.Edit_CheckFloat;
  UI_Edit_CheckInt := UI.Edit_CheckInt;
  UI_Edit_New := UI.Edit_New;
  UI_Edit_NewA := UI.Edit_NewA;

  UI_Grid_AddColumn := UI.Grid_AddColumn;
  UI_Grid_New := UI.Grid_New;
  UI_Grid_RestoreColProps := UI.Grid_RestoreColProps;
  UI_Grid_SaveColProps := UI.Grid_SaveColProps;
  UI_Grid_SetColumnWidth := UI.Grid_SetColumnWidth;
  UI_Grid_SetColumnWidthA := UI.Grid_SetColumnWidthA;
  UI_Grid_SetDataSource := UI.Grid_SetDataSource;

  UI_Image_New := UI.Image_New;
  UI_Image_LoadFromFile := UI.Image_LoadFromFile;

  UI_Label_New := UI.Label_New;
  UI_Control_SetFont1 := UI.Label_SetFont;

  UI_ListBox_Add := UI.ListBox_Add;
  UI_ListBox_Clear := UI.ListBox_Clear;
  UI_ListBox_New := UI.ListBox_New;

  UI_MainToolBar := UI.MainToolBar;
  UI_MainToolBar_Set := UI.MainToolBar_Set;

  UI_MainTrayIcon := UI.MainTrayIcon;

  UI_MainWindow := UI.MainWindow;
  UI_MainWindow_AddMenuItem := UI.MainWindow_AddMenuItem;
  UI_MainWindow_AddMenuItem2 := UI.MainWindow_AddMenuItem2;
  UI_MainWindow_GetLeftContainer := UI.MainWindow_GetLeftContainer;
  UI_MainWindow_GetMainContainer := UI.MainWindow_GetMainContainer;
  UI_MainWindow_GetRightContainer := UI.MainWindow_GetRightContainer;
  UI_MainWindow_Set := UI.MainWindow_Set;

  UI_Menu_GetItems := UI.Menu_GetItems;
  UI_Menu_New := UI.Menu_New;

  UI_MenuItem_Add := UI.MenuItem_Add;
  UI_MenuItem_Add2 := UI.MenuItem_Add2;
  UI_MenuItem_FindByName := UI.MenuItem_FindByName;

  UI_PageControl_AddPage := UI.PageControl_AddPage;
  UI_PageControl_New := UI.PageControl_New;

  UI_ProgressBar_New := UI.ProgressBar_New;
  UI_ProgressBar_StepIt := UI.ProgressBar_StepIt;

  UI_PropertyBox_Add := UI.PropertyBox_Add;
  UI_PropertyBox_AddA := UI.PropertyBox_AddA;
  UI_PropertyBox_Item_GetValue := UI.PropertyBox_Item_GetValue;
  UI_PropertyBox_Item_SetValue := UI.PropertyBox_Item_SetValue;
  UI_PropertyBox_New := UI.PropertyBox_New;

  UI_Splitter_New := UI.Splitter_New;

  UI_TextView_AddLine := UI.TextView_AddLine;
  UI_TextView_New := UI.TextView_New;
  UI_TextView_SetFont := UI.TextView_SetFont;
  UI_TextView_SetReadOnly := UI.TextView_SetReadOnly;
  UI_TextView_SetScrollBars := UI.TextView_SetScrollBars;
  UI_TextView_SetWordWrap := UI.TextView_SetWordWrap;

  UI_ToolBar_AddButton := UI.ToolBar_AddButton;
  UI_ToolBar_New := UI.ToolBar_New;

  UI_TrayIcon_GetMenuItems := UI.TrayIcon_GetMenuItems;

  UI_TreeView_AddItem := UI.TreeView_AddItem;
  UI_TreeView_New := UI.TreeView_New;

  UI_Window_Free := UI.Window_Free;
  UI_Window_GetMenu := UI.Window_GetMenu;
  UI_Window_LoadConfig := UI.Window_LoadConfig;
  UI_Window_LoadConfig2 := UI.Window_LoadConfig2;
  UI_Window_New := UI.Window_New;
  UI_Window_SaveConfig := UI.Window_SaveConfig;
  UI_Window_SaveConfig2 := UI.Window_SaveConfig2;
  UI_Window_SetBorderStyle := UI.Window_SetBorderStyle;
  UI_Window_SetFormStyle := UI.Window_SetFormStyle;
  UI_Window_SetPosition := UI.Window_SetPosition;
  UI_Window_ShowModal := UI.Window_ShowModal;

  UI_ReportWin_New := UI.ReportWin_New;
  UI_WaitWin_New := UI.WaitWin_New;
  UI_WaitWin_StepBy := UI.WaitWin_StepBy;
  // Testing
  UI_OnMainFormCreate_Set := UI.OnMainFormCreate_Set;
  UI_MainWindow_SetA := UI.MainWindow_SetA;
  UI_ReportWin_NewA := UI.ReportWin_NewA;

  UI_Calendar_GetDate := UI.Calendar_GetDate;
  UI_Calendar_New := UI.Calendar_New;
  UI_Calendar_SetMonth := UI.Calendar_SetMonth;

  UI_Report_New := UI.Report_New;
  UI_Report_SetText := UI.Report_SetText;}
  {ELSE} // A02
{$ELSE} // A01_OR_02
  UI_InitMainTrayIcon := UI.InitMainTrayIcon;
  UI_InitMenus := UI.InitMenus;
  UI_IsShowApp := UI.IsShowApp;
  UI_IsShowApp_Set := UI.IsShowApp_Set;
  UI_OnMainFormCreate_Set := UI.OnMainFormCreate_Set;
  UI_ProcessMessages := UI.ProcessMessages;
  UI_ShowHelp := UI.ShowHelp;
  UI_Shutdown := UI.Shutdown;

  UI_Box_New := UI.Box_New;
  UI_Button_New := UI.Button_New;

  UI_Calendar_GetDate := UI.Calendar_GetDate;
  UI_Calendar_New := UI.Calendar_New;
  UI_Calendar_SetMonth := UI.Calendar_SetMonth;

  UI_Control_Free := UI.Control_Free;
  UI_Control_FreeAndNil := UI.Control_FreeAndNil;
  UI_Control_GetEnabled := UI.Control_GetEnabled;
  UI_Control_GetHeight := UI.Control_GetHeight;
  UI_Control_GetHint := UI.Control_GetHint;
  UI_Control_GetName := UI.Control_GetName;
  UI_Control_GetText := UI.Control_GetText;
  UI_Control_GetVisible := UI.Control_GetVisible;
  UI_Control_GetWidth := UI.Control_GetWidth;
  UI_Control_SetAlign := UI.Control_SetAlign;
  UI_Control_SetClientSize := UI.Control_SetClientSize;
  UI_Control_SetColor := UI.Control_SetColor;
  UI_Control_SetEnabled := UI.Control_SetEnabled;
  UI_Control_SetFocus := UI.Control_SetFocus;
  UI_Control_SetFont1 := UI.Control_SetFont1;
  UI_Control_SetFont2 := UI.Control_SetFont2;
  UI_Control_SetHint := UI.Control_SetHint;
  UI_Control_SetName := UI.Control_SetName;
  UI_Control_SetOnChange := UI.Control_SetOnChange;
  UI_Control_SetOnClick := UI.Control_SetOnClick;
  UI_Control_SetPosition := UI.Control_SetPosition;
  UI_Control_SetSize := UI.Control_SetSize;
  UI_Control_SetText := UI.Control_SetText;
  UI_Control_SetVisible := UI.Control_SetVisible;
  UI_Control_SetWidth := UI.Control_SetWidth;

  UI_DataSource_New := UI.DataSource_New;
  UI_DataSource_SetOnDataChange := UI.DataSource_SetOnDataChange;

  UI_Dialog_About := UI.Dialog_About;
  UI_Dialog_About_New := UI.Dialog_About_New;
  UI_Dialog_AddButton := UI.Dialog_AddButton;
  UI_Dialog_Calendar := UI.Dialog_Calendar;
  UI_Dialog_Color := UI.Dialog_Color;
  UI_Dialog_DateFilter := UI.Dialog_DateFilter;
  UI_Dialog_Error := UI.Dialog_Error;
  UI_Dialog_Font := UI.Dialog_Font;
  UI_Dialog_GetWindow := UI.Dialog_GetWindow;
  UI_Dialog_InputBox := UI.Dialog_InputBox;
  UI_Dialog_InputBox2 := UI.Dialog_InputBox2;
  UI_Dialog_InputBoxA := UI.Dialog_InputBoxA;
  UI_Dialog_Login := UI.Dialog_Login;
  UI_Dialog_Message := UI.Dialog_Message;
  UI_Dialog_New := UI.Dialog_New;
  UI_Dialog_OpenFile := UI.Dialog_OpenFile;
  UI_Dialog_OpenFileA := UI.Dialog_OpenFileA;
  UI_Dialog_SaveFile := UI.Dialog_SaveFile;
  UI_Dialog_SaveFileA := UI.Dialog_SaveFileA;

  UI_Edit_CheckDate := UI.Edit_CheckDate;
  UI_Edit_CheckFloat := UI.Edit_CheckFloat;
  UI_Edit_CheckInt := UI.Edit_CheckInt;
  UI_Edit_New := UI.Edit_New;
  UI_Edit_NewA := UI.Edit_NewA;

  UI_Grid_AddColumn := UI.Grid_AddColumn;
  UI_Grid_New := UI.Grid_New;
  UI_Grid_RestoreColProps := UI.Grid_RestoreColProps;
  UI_Grid_SaveColProps := UI.Grid_SaveColProps;
  UI_Grid_SetColumnWidth := UI.Grid_SetColumnWidth;
  UI_Grid_SetColumnWidthA := UI.Grid_SetColumnWidthA;
  UI_Grid_SetDataSource := UI.Grid_SetDataSource;

  UI_Image_New := UI.Image_New;
  UI_Image_LoadFromFile := UI.Image_LoadFromFile;

  UI_Label_New := UI.Label_New;

  UI_ListBox_Add := UI.ListBox_Add;
  UI_ListBox_Clear := UI.ListBox_Clear;
  UI_ListBox_New := UI.ListBox_New;

  UI_MainToolBar := UI.MainToolBar;
  //UI_MainToolBar_Set := UI.MainToolBar_Set;

  UI_MainTrayIcon := UI.MainTrayIcon;

  UI_MainWindow := UI.MainWindow;
  UI_MainWindow_AddMenuItem := UI.MainWindow_AddMenuItem;
  UI_MainWindow_AddMenuItem2 := UI.MainWindow_AddMenuItem2;
  UI_MainWindow_GetLeftContainer := UI.MainWindow_GetLeftContainer;
  UI_MainWindow_GetMainContainer := UI.MainWindow_GetMainContainer;
  UI_MainWindow_GetRightContainer := UI.MainWindow_GetRightContainer;
  UI_MainWindow_Set := UI.MainWindow_Set;
  UI_MainWindow_SetA := UI.MainWindow_SetA;

  UI_Menu_GetItems := UI.Menu_GetItems;
  UI_Menu_New := UI.Menu_New;

  UI_MenuItem_Add := UI.MenuItem_Add;
  UI_MenuItem_Add2 := UI.MenuItem_Add2;
  UI_MenuItem_FindByName := UI.MenuItem_FindByName;

  UI_PageControl_AddPage := UI.PageControl_AddPage;
  UI_PageControl_New := UI.PageControl_New;

  UI_ProgressBar_New := UI.ProgressBar_New;
  UI_ProgressBar_StepIt := UI.ProgressBar_StepIt;

  UI_PropertyBox_Add := UI.PropertyBox_Add;
  UI_PropertyBox_AddA := UI.PropertyBox_AddA;
  UI_PropertyBox_Item_GetValue := UI.PropertyBox_Item_GetValue;
  UI_PropertyBox_Item_SetValue := UI.PropertyBox_Item_SetValue;
  UI_PropertyBox_New := UI.PropertyBox_New;

  UI_Report_New := UI.Report_New;
  UI_Report_SetText := UI.Report_SetText;

  UI_ReportWin_New := UI.ReportWin_New;
  UI_ReportWin_NewA := UI.ReportWin_NewA;

  UI_Splitter_New := UI.Splitter_New;

  UI_TextView_AddLine := UI.TextView_AddLine;
  UI_TextView_New := UI.TextView_New;
  UI_TextView_SetFont := UI.TextView_SetFont;
  UI_TextView_SetReadOnly := UI.TextView_SetReadOnly;
  UI_TextView_SetScrollBars := UI.TextView_SetScrollBars;
  UI_TextView_SetWordWrap := UI.TextView_SetWordWrap;

  UI_ToolBar_AddButton := UI.ToolBar_AddButton;
  UI_ToolBar_New := UI.ToolBar_New;

  UI_TrayIcon_GetMenuItems := UI.TrayIcon_GetMenuItems;

  UI_TreeView_AddItem := UI.TreeView_AddItem;
  UI_TreeView_New := UI.TreeView_New;

  UI_WaitWin_New := UI.WaitWin_New;
  UI_WaitWin_StepBy := UI.WaitWin_StepBy;

  UI_Window_Free := UI.Window_Free;
  UI_Window_GetMenu := UI.Window_GetMenu;
  UI_Window_LoadConfig := UI.Window_LoadConfig;
  UI_Window_LoadConfig2 := UI.Window_LoadConfig2;
  UI_Window_New := UI.Window_New;
  UI_Window_SaveConfig := UI.Window_SaveConfig;
  UI_Window_SaveConfig2 := UI.Window_SaveConfig2;
  UI_Window_SetBorderStyle := UI.Window_SetBorderStyle;
  UI_Window_SetFormStyle := UI.Window_SetFormStyle;
  UI_Window_SetPosition := UI.Window_SetPosition;
  UI_Window_ShowModal := UI.Window_ShowModal;
{$ENDIF} // A01_OR_02
end;

end.
