{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 15.05.2011
Version: 0.3.0
}
unit ASystem0;

interface

uses
  ABase0, ARuntime0;

const
  ASystem_Name = 'System';
  ASystem_Uid = $11051501;
  ASystem_Version = $00030000;

// --- Types ---------------------------------------------------------------------------------------

// --- Procs ---------------------------------------------------------------------------------------

type // --- Info functions ---
  ARuntimeGetCompanyNameProc = function: AString; stdcall;
  ARuntimeGetCopyrightProc = function: AString; stdcall;
  ARuntimeGetDataPathProc = function: AString; stdcall;
  ARuntimeGetDescriptionProc = function: AString; stdcall;
  ARuntimeGetExeNameProc = function: AString; stdcall;
  ARuntimeGetExePathProc = function: AString; stdcall;
  ARuntimeGetProductNameProc = function: AString; stdcall;
  ARuntimeGetProductVersionProc = function: AString; stdcall;
  ARuntimeGetProgramNameProc = function: AString; stdcall;
  ARuntimeGetProgramVersionProc = function: AString; stdcall;
  ARuntimeGetTitleProc = function: AString; stdcall;
  ARuntimeGetUrlProc = function: AString; stdcall;

type
  ARuntimeGetConfigProc = function: AConfig; stdcall;
  ARuntimeGetResourceStringProc = function(const Section, Name, Default: AString): AString; stdcall;
  ARuntimeProcessMessagesProc = procedure; stdcall;
  ARuntimeSetConfigProc = procedure(Value: AConfig); stdcall;
  ARuntimeShowErrorProc = procedure(const UserMessage, ExceptMessage: AString); stdcall;
  ARuntimeShowMessageProc = function(const Msg: AString): ADialogBoxCommands; stdcall;
  ARuntimeShowMessageAProc = function(const Text, Caption: AString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
  ARuntimeShutdownProc = procedure; stdcall;

type // --- Set event functions ---
  ARuntimeSetOnProcessMessagesProc = procedure(Value: AProc); stdcall;
  ARuntimeSetOnShowErrorProc = procedure(Value: TAShowErrorProc); stdcall;
  ARuntimeSetOnShowMessageProc = procedure(Value: TAShowMessageProc); stdcall;

type // --- Events and tools ---
  ARuntimeOnAfterRunGetProc = function: AEvent; stdcall;
  ARuntimeOnBeforeRunGetProc = function: AEvent; stdcall;
  ARuntimeOnAfterRunConnectProc = function(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): Integer; stdcall;
  ARuntimeOnAfterRunDisconnectProc = function(Callback: ACallbackProc): AInteger; stdcall;
  ARuntimeOnBeforeRunConnectProc = function(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
  ARuntimeOnBeforeRunDisconnectProc = function(Callback: ACallbackProc): AInteger; stdcall;
type
  ARuntimeParamCountProc = function: AInteger; stdcall;
  ARuntimeParamStrProc = function(Index: AInteger): AString; stdcall;
  ARuntimeShellExecuteProc = function(const Operation, FileName, Parameters, Directory: AString): AInteger; stdcall;

// --- Functions var -------------------------------------------------------------------------------

var // --- Info functions ---
  Runtime_GetCompanyName: ARuntimeGetCompanyNameProc;
  Runtime_GetCopyright: ARuntimeGetCopyrightProc;
  Runtime_GetDataPath: ARuntimeGetDataPathProc;
  Runtime_GetDescription: ARuntimeGetDescriptionProc;
  Runtime_GetExeName: ARuntimeGetExeNameProc;
  Runtime_GetExePath: ARuntimeGetExePathProc;
  Runtime_GetProductName: ARuntimeGetProductNameProc;
  Runtime_GetProductVersion: ARuntimeGetProductVersionProc;
  Runtime_GetProgramName: ARuntimeGetProgramNameProc;
  Runtime_GetProgramVersion: ARuntimeGetProgramVersionProc;
  Runtime_GetTitle: ARuntimeGetTitleProc;
  Runtime_GetUrl: ARuntimeGetUrlProc;

var
  Runtime_GetConfig: ARuntimeGetConfigProc;
  Runtime_GetResourceString: ARuntimeGetResourceStringProc;
  Runtime_ProcessMessages: ARuntimeProcessMessagesProc;
  Runtime_SetConfig: ARuntimeSetConfigProc;
  Runtime_ShowError: ARuntimeShowErrorProc;
  Runtime_ShowMessage: ARuntimeShowMessageProc;
  Runtime_ShowMessageA: ARuntimeShowMessageAProc;

var // --- Set event functions ---
  Runtime_SetOnProcessMessages: ARuntimeSetOnProcessMessagesProc;
  Runtime_SetOnShowError: ARuntimeSetOnShowErrorProc;
  Runtime_SetOnShowMessage: ARuntimeSetOnShowMessageProc;

var // --- Events and tools ---
  Runtime_OnAfterRun: ARuntimeOnAfterRunGetProc;
  Runtime_OnBeforeRun: ARuntimeOnBeforeRunGetProc;
  Runtime_OnAfterRun_Connect: ARuntimeOnAfterRunConnectProc;
  Runtime_OnAfterRun_Disconnect: ARuntimeOnAfterRunDisconnectProc;
  Runtime_OnBeforeRun_Connect: ARuntimeOnBeforeRunConnectProc;
  Runtime_OnBeforeRun_Disconnect: ARuntimeOnBeforeRunDisconnectProc;
var
  Runtime_ParamCount: ARuntimeParamCountProc;
  Runtime_ParamStr: ARuntimeParamStrProc;
  Runtime_ShellExecute: ARuntimeShellExecuteProc;

// -------------------------------------------------------------------------------------------------

type
  ASystem = ^ASystemProcs_Type;
  ASystemProcs_Type = packed record {64x4}
    // --- Info functions ---
    GetCompanyName: ARuntimeGetCompanyNameProc;
    GetCopyright: ARuntimeGetCopyrightProc;
    GetDescription: ARuntimeGetDescriptionProc;
    GetExeName: ARuntimeGetExeNameProc;
    GetExePath: ARuntimeGetExePathProc;
    GetProductName: ARuntimeGetProductNameProc;
    GetProductVersion: ARuntimeGetProductVersionProc;
    GetProgramName: ARuntimeGetProgramNameProc;
    GetProgramVersion: ARuntimeGetProgramVersionProc;
    GetTitle: ARuntimeGetTitleProc;
    GetUrl: ARuntimeGetUrlProc;

    GetConfig: ARuntimeGetConfigProc;
    GetResourceString: ARuntimeGetResourceStringProc;
    ProcessMessages: ARuntimeProcessMessagesProc;
    SetConfig: ARuntimeSetConfigProc;
    ShowError: ARuntimeShowErrorProc;
    ShowMessage: ARuntimeShowMessageProc;
    ShowMessageA: ARuntimeShowMessageAProc;
    Shutdown: ARuntimeShutdownProc;

    // --- Set event functions ---
    SetOnProcessMessages: ARuntimeSetOnProcessMessagesProc;
    SetOnShowError: ARuntimeSetOnShowErrorProc;
    SetOnShowMessage: ARuntimeSetOnShowMessageProc;

    // --- Events and tools ---
    OnAfterRun: ARuntimeOnAfterRunGetProc;
    OnBeforeRun: ARuntimeOnBeforeRunGetProc;
    OnAfterRun_Connect: ARuntimeOnAfterRunConnectProc;
    OnAfterRun_Disconnect: ARuntimeOnAfterRunDisconnectProc;
    OnBeforeRun_Connect: ARuntimeOnBeforeRunConnectProc;
    OnBeforeRun_Disconnect: ARuntimeOnBeforeRunDisconnectProc;

    ParamStr: ARuntimeParamStrProc;
    ShellExecute: ARuntimeShellExecuteProc;
    GetDataPath: ARuntimeGetDataPathProc;

    Reserved41: AInteger; //ParamCount: ARuntimeParamCountProc;
    Reserved42: AInteger;
    Reserved43: AInteger;
    Reserved44: AInteger;
    Reserved45: AInteger;
    Reserved46: AInteger;
    Reserved47: AInteger;
    Reserved48: AInteger;
    Reserved49: AInteger;
    Reserved50: AInteger;
    Reserved51: AInteger;
    Reserved52: AInteger;
    Reserved53: AInteger;
    Reserved54: AInteger;
    Reserved55: AInteger;
    Reserved56: AInteger;
    Reserved57: AInteger;
    Reserved58: AInteger;
    Reserved59: AInteger;
    Reserved60: AInteger;
    Reserved61: AInteger;
    Reserved62: AInteger;
    Reserved63: AInteger;
  end;

var
  System1: ASystemProcs_Type;

procedure System_SetProcs(Procs: ASystem);

implementation

procedure System_SetProcs(Procs: ASystem);
begin
  System1 := Procs^;

  Runtime_GetCompanyName := System1.GetCompanyName;
  Runtime_GetCopyright := System1.GetCopyright;
  Runtime_GetDescription := System1.GetDescription;
  Runtime_GetExeName := System1.GetExeName;
  Runtime_GetExePath := System1.GetExePath;
  Runtime_GetProductName := System1.GetProductName;
  Runtime_GetProductVersion := System1.GetProductVersion;
  Runtime_GetProgramName := System1.GetProgramName;
  Runtime_GetProgramVersion := System1.GetProgramVersion;
  Runtime_GetTitle := System1.GetTitle;
  Runtime_GetUrl := System1.GetUrl;

  Runtime_GetConfig := System1.GetConfig;
  Runtime_GetResourceString := System1.GetResourceString;
  Runtime_ProcessMessages := System1.ProcessMessages;
  Runtime_SetConfig := System1.SetConfig;
  Runtime_ShowError := System1.ShowError;
  Runtime_ShowMessage := System1.ShowMessage;
  Runtime_ShowMessageA := System1.ShowMessageA;

  Runtime_SetOnProcessMessages := System1.SetOnProcessMessages;
  Runtime_SetOnShowError := System1.SetOnShowError;
  Runtime_SetOnShowMessage := System1.SetOnShowMessage;

  Runtime_OnAfterRun := System1.OnAfterRun;
  Runtime_OnBeforeRun := System1.OnBeforeRun;
  Runtime_OnAfterRun_Connect := System1.OnAfterRun_Connect;
  Runtime_OnAfterRun_Disconnect := System1.OnAfterRun_Disconnect;
  Runtime_OnBeforeRun_Connect := System1.OnBeforeRun_Connect;
  Runtime_OnBeforeRun_Disconnect := System1.OnBeforeRun_Disconnect;

  Runtime_ParamStr := System1.ParamStr;
  Runtime_ShellExecute := System1.ShellExecute;
  Runtime_GetDataPath := System1.GetDataPath;
end;

end.
