{
Abstract:     
Author:  Prof1983 <prof1983@yandex.ru>
Created: 23.07.2010
LastMod: 17.05.2011
Version: 0.2.5+0.3.0
}
unit ASettings0;

{DEFINE A02}
{DEFINE A03}

interface

uses
  ABase0;

const
  ASettings_Name = 'Settings';

  ASettings_UID = $00000007;

  ASettings_Version = {$IFDEF A02}$00020500{$ELSE}$00030000{$ENDIF};


// --- Procs type ---

type
  ASettings_Close = procedure(Config: AConfig); stdcall;
  ASettings_DeleteKey = function(Config: AConfig; const Section, Name: AString): ABoolean; stdcall;
  ASettings_DeleteSection = function(Config: AConfig; const Section: AString): ABoolean; stdcall;
  ASettings_IniConfig_New = function(const FileName: AString): AConfig; stdcall;
  ASettings_ReadBool = function(Config: AConfig; const Section, Name: AString; DefValue: ABoolean): ABoolean; stdcall;
  ASettings_ReadInteger = function(Config: AConfig; const Section, Name: AString; DefValue: AInteger): AInteger; stdcall;
  ASettings_ReadFloat = function(Config: AConfig; const Section, Name: AString; DefValue: AFloat): AFloat; stdcall;
  ASettings_ReadSection = function(Config: AConfig; const Section: AString; Strings: AStrings): ABoolean; stdcall;
  ASettings_ReadString = function(Config: AConfig; const Section, Name, DefValue: AString): AString; stdcall;
  ASettings_ReadDateTime = function(Config: AConfig; const Section, Name: AString; DefValue: TDateTime): TDateTime; stdcall;
  ASettings_RegConfig_New = function(const Prefix: AString): AConfig; stdcall;
  ASettings_RegConfig_NewA = function(const Prefix: AString; HKEY: Integer): AConfig; stdcall;
  ASettings_WriteBool = function(Config: AConfig; const Section, Name: AString; Value: Boolean): ABoolean; stdcall;
  ASettings_WriteInteger = function(Config: AConfig; const Section, Name: AString; Value: Integer): ABoolean; stdcall;
  ASettings_WriteFloat = function(Config: AConfig; const Section, Name: AString; Value: AFloat): ABoolean; stdcall;
  ASettings_WriteString = function(Config: AConfig; const Section, Name, Value: AString): ABoolean; stdcall;
  ASettings_WriteDateTime = function(Config: AConfig; const Section, Name: AString; Value: TDateTime): ABoolean; stdcall;

// --- Procs var ---

var
  Settings_Close: ASettings_Close;
  Settings_DeleteKey: ASettings_DeleteKey;
  Settings_DeleteSection: ASettings_DeleteSection;
  Settings_IniConfig_New: ASettings_IniConfig_New;
  Settings_ReadBool: ASettings_ReadBool;
  Settings_ReadInteger: ASettings_ReadInteger;
  Settings_ReadFloat: ASettings_ReadFloat;
  Settings_ReadSection: ASettings_ReadSection;
  Settings_ReadString: ASettings_ReadString;
  Settings_ReadDateTime: ASettings_ReadDateTime;
  Settings_RegConfig_New: ASettings_RegConfig_New;
  Settings_RegConfig_NewA: ASettings_RegConfig_NewA;
  Settings_WriteBool: ASettings_WriteBool;
  Settings_WriteInteger: ASettings_WriteInteger;
  Settings_WriteFloat: ASettings_WriteFloat;
  Settings_WriteString: ASettings_WriteString;
  Settings_WriteDateTime: ASettings_WriteDateTime;

// --- Module ---

type
  ASettingsProcs = ^ASettingsProcs_Type;
  ASettingsProcs_Type = packed record {32x4} {64x4}
    Close: ASettings_Close;
    DeleteKey: ASettings_DeleteKey;
    DeleteSection: ASettings_DeleteSection;
    IniConfig_New: ASettings_IniConfig_New;
    ReadBool: ASettings_ReadBool;
    ReadInteger: ASettings_ReadInteger;
    ReadFloat: ASettings_ReadFloat;
    ReadSection: ASettings_ReadSection;
    ReadString: ASettings_ReadString;
    ReadDateTime: ASettings_ReadDateTime;
    RegConfig_New: ASettings_RegConfig_New;
    RegConfig_NewA: ASettings_RegConfig_NewA;
    WriteBool: ASettings_WriteBool;
    WriteInteger: ASettings_WriteInteger;
    WriteFloat: ASettings_WriteFloat;
    WriteString: ASettings_WriteString;
    WriteDateTime: ASettings_WriteDateTime;
    Reserved17: Integer;
    Reserved18: Integer;
    Reserved19: Integer;
    Reserved20: Integer;
    Reserved21: Integer;
    Reserved22: Integer;
    Reserved23: Integer;
    Reserved24: Integer;
    Reserved25: Integer;
    Reserved26: Integer;
    Reserved27: Integer;
    Reserved28: Integer;
    Reserved29: Integer;
    Reserved30: Integer;
    Reserved31: Integer;

    {$IFDEF A03}
    Reserved32: AInteger;
    Reserved33: AInteger;
    Reserved34: AInteger;
    Reserved35: AInteger;
    Reserved36: AInteger;
    Reserved37: AInteger;
    Reserved38: AInteger;
    Reserved39: AInteger;
    Reserved40: AInteger;
    Reserved41: AInteger;
    Reserved42: AInteger;
    Reserved43: AInteger;
    Reserved44: AInteger;
    Reserved45: AInteger;
    Reserved46: AInteger;
    Reserved47: AInteger;

    Reserved48: AInteger;
    Reserved49: AInteger;
    Reserved50: AInteger;
    Reserved51: AInteger;
    Reserved52: AInteger;
    Reserved53: AInteger;
    Reserved54: AInteger;
    Reserved55: AInteger;
    Reserved56: AInteger;
    Reserved57: AInteger;
    Reserved58: AInteger;
    Reserved59: AInteger;
    Reserved60: AInteger;
    Reserved61: AInteger;
    Reserved62: AInteger;
    Reserved63: AInteger;
    {$ENDIF A03}
  end;

procedure Settings_SetProcs(Procs: ASettingsProcs);

var
  Settings: ASettingsProcs_Type;

implementation

procedure Settings_SetProcs(Procs: ASettingsProcs);
begin
  if not(Assigned(Procs)) then
  begin
    FillChar(Settings, SizeOf(Settings), 0);
    Exit;
  end;
  Settings := Procs^;
  Settings_Close := Settings.Close;
  Settings_DeleteKey := Settings.DeleteKey;
  Settings_DeleteSection := Settings.DeleteSection;
  Settings_IniConfig_New := Settings.IniConfig_New;
  Settings_ReadBool := Settings.ReadBool;
  Settings_ReadInteger := Settings.ReadInteger;
  Settings_ReadFloat := Settings.ReadFloat;
  Settings_ReadSection := Settings.ReadSection;
  Settings_ReadString := Settings.ReadString;
  Settings_ReadDateTime := Settings.ReadDateTime;
  Settings_RegConfig_New := Settings.RegConfig_New;
  Settings_RegConfig_NewA := Settings.RegConfig_NewA;
  Settings_WriteBool := Settings.WriteBool;
  Settings_WriteInteger := Settings.WriteInteger;
  Settings_WriteFloat := Settings.WriteFloat;
  Settings_WriteString := Settings.WriteString;
  Settings_WriteDateTime := Settings.WriteDateTime;
end;

end.
