{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 19.05.2011
Version: 0.2.5+0.3.0
}
unit ARuntime0;

interface

uses
  ABase0;

// --- Types ---------------------------------------------------------------------------------------

{$IFDEF A03}

type
  AModuleInitProc = AProc; //function: AInteger; stdcall;
  AModuleDoneProc = AProc; //function: AInteger; stdcall;

type // Module description
  AModuleDescription = Pointer;

type
  { 1 - System; 2 - UI; 3 - Entities; 4 - Utils; 5 - Data; 6 - Plugins; 7 - Settings;
    8 - UIWorkbench; 9 - UISplash; 10 - UISettings; 11 - ModuleManager }
  AModuleUid = type AInteger;

type // Module (8x4)
  AModule = ^AModuleType;
  AModuleType = packed record
    Version: AVersion;         // Module version ($AABBCCDD). AA=00h, BB=03h.
    Uid: AModuleUid;           // Module unique identificator $YYMMDDxx YY - Year, MM - Month, DD - Day
    Name: PChar;               // Module unuque name
    Description: AModuleDescription; // Module information and description
    Init: AModuleInitProc;     // Init proc
    Done: AModuleDoneProc;     // Done proc
    Reserved06: AInteger;      //Delete: AModuleDeleteProc;
    Procs: Pointer;
  end;

type
  ARuntimeProc = AProc;

{$ELSE} // A03

type
  AModuleInitProc = function: AInteger; stdcall; //ABase.TAInitProc;
  AModuleDoneProc = procedure; stdcall; //ABase.TAProc;
type
  AModuleData = ^AModuleDataType;
  AModuleDataType = packed record
    Version: AVersion;
    Init: AModuleInitProc;
    Done: AModuleDoneProc;
    Name: AString;
    Procs: Pointer;
    Reserved1: AInteger;
    Reserved2: AInteger;
    Reserved3: AInteger;
  end;

type
  AModuleDataRec = AModuleDataType;

{$ENDIF} // A03

// --- Runtime proc types --------------------------------------------------------------------------

{$IFDEF A03}

type
  ARuntime_IsShutdown_Proc = function: ABoolean; stdcall;
  ARuntime_Shutdown_Proc = function: AInteger; stdcall;

type // --- Set event functions ---
  ARuntime_OnRun_Set_Proc = procedure(Value: ARuntimeProc); stdcall;
  ARuntime_OnShutdown_Set_Proc = procedure(Value: ARuntimeProc); stdcall;
  ARuntime_OnAfterRun_Set_Proc = procedure(Value: ARuntimeProc); stdcall;
  ARuntime_OnBeforeRun_Set_Proc = procedure(Value: ARuntimeProc); stdcall;

type // Runtime.Module
  ARuntime_Module_Register_Proc = function(Module: AModule): AInteger; stdcall;

type // Runtime.Modules
  ARuntime_Modules_AddModule_Proc = function(Module: AModule): AInteger; stdcall;
  ARuntime_Modules_Count_Proc = function: AInteger; stdcall;
  ARuntime_Modules_DeleteByName_Proc = function(Name: PChar): AInteger; stdcall;
  ARuntime_Modules_DeleteByUid_Proc = function(UID: AModuleUid): AInteger; stdcall;
  ARuntime_Modules_FindByName_Proc = function(Name: PChar): AInteger; stdcall;
  ARuntime_Modules_FindByUid_Proc = function(Uid: AModuleUid): AInteger; stdcall;
  ARuntime_Modules_GetByName_Proc = function(Name: PChar; Module: AModule): AInteger; stdcall;
  ARuntime_Modules_GetByUid_Proc = function(Uid: AModuleUid; Module: AModule): AInteger; stdcall;
  ARuntime_Modules_InitByName_Proc = function(Name: PChar): AInteger; stdcall;
  ARuntime_Modules_InitByUid_Proc = function(Uid: AModuleUid): AInteger; stdcall;
  ARuntime_Modules_GetNameByIndex_Proc = function(Index: AInteger; Name: PChar; MaxLen: AInteger): AInteger; stdcall;
  ARuntime_Modules_GetUidByIndex_Proc = function(Index: AInteger): AModuleUid; stdcall;

{$ELSE} // A03

type // --- Info functions ---
  ARuntimeGetCompanyNameProc = function: AString; stdcall;
  ARuntimeGetCopyrightProc = function: AString; stdcall;
  ARuntimeGetDataPathProc = function: AString; stdcall;
  ARuntimeGetDescriptionProc = function: AString; stdcall;
  ARuntimeGetExeNameProc = function: AString; stdcall;
  ARuntimeGetExePathProc = function: AString; stdcall;
  ARuntimeGetProductNameProc = function: AString; stdcall;
  ARuntimeGetProductVersionProc = function: AString; stdcall;
  ARuntimeGetProgramNameProc = function: AString; stdcall;
  ARuntimeGetProgramVersionProc = function: AString; stdcall;
  ARuntimeGetTitleProc = function: AString; stdcall;
  ARuntimeGetUrlProc = function: AString; stdcall;

type
  ARuntimeGetConfigProc = function: AConfig; stdcall;
  ARuntimeGetIsShutdownProc = function: ABoolean; stdcall;
  ARuntimeGetResourceStringProc = function(const Section, Name, Default: AString): AString; stdcall;
  ARuntimeProcessMessagesProc = procedure; stdcall;
  ARuntimeSetConfigProc = procedure(Value: AConfig); stdcall;
  ARuntimeShowErrorProc = procedure(const UserMessage, ExceptMessage: AString); stdcall;
  ARuntimeShowMessageProc = function(const Msg: AString): ADialogBoxCommands; stdcall;
  ARuntimeShowMessageAProc = function(const Text, Caption: AString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
  ARuntimeShutdownProc = procedure; stdcall;

type // --- Set event functions ---
  ARuntimeSetOnProcessMessagesProc = procedure(Value: AProc); stdcall;
  ARuntimeSetOnRunProc = procedure(Value: AProc); stdcall;
  ARuntimeSetOnShutdownProc = procedure(Value: AProc); stdcall;
  ARuntimeSetOnShowErrorProc = procedure(Value: TAShowErrorProc); stdcall;
  ARuntimeSetOnShowMessageProc = procedure(Value: TAShowMessageProc); stdcall;

{ Testing }

type
  ARuntimeModuleCountProc = function: AInteger; stdcall;
  ARuntimeModuleDeleteByNameProc = function(const Name: AString): AInteger; stdcall;
  ARuntimeModuleFindByNameProc = function(const Name: AString): AInteger; stdcall;
  ARuntimeModuleGetByNameProc = function(const Name: AString; Module: AModuleData): ABoolean; stdcall;
  ARuntimeModuleGetNameByIndexProc = function(Index: AInteger): AString; stdcall;
  ARuntime_Module_InitByName = function(const ModuleName: AString): AInteger; stdcall;
  ARuntimeModuleRegisterProc = function(Module: AModuleData): AInteger; stdcall;
type // --- Events and tools ---
  ARuntimeOnAfterRunGetProc = function: AEvent; stdcall;
  ARuntimeOnBeforeRunGetProc = function: AEvent; stdcall;
  ARuntimeOnAfterRunConnectProc = function(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): Integer; stdcall;
  ARuntimeOnAfterRunDisconnectProc = function(Callback: ACallbackProc): AInteger; stdcall;
  ARuntimeOnBeforeRunConnectProc = function(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
  ARuntimeOnBeforeRunDisconnectProc = function(Callback: ACallbackProc): AInteger; stdcall;
type
  ARuntimeParamCountProc = function: AInteger; stdcall;
  ARuntimeParamStrProc = function(Index: AInteger): AString; stdcall;
  ARuntimeShellExecuteProc = function(const Operation, FileName, Parameters, Directory: AString): AInteger; stdcall;

{$ENDIF} // A03

// --- Runtime proc vars ---------------------------------------------------------------------------

{$IFDEF A03}

var
  Runtime_IsShutdown: ARuntime_IsShutdown_Proc;
  Runtime_Shutdown: ARuntime_Shutdown_Proc;

var // --- Set event functions ---
  Runtime_OnAfterRun_Set: ARuntime_OnAfterRun_Set_Proc;
  Runtime_OnBeforeRun_Set: ARuntime_OnBeforeRun_Set_Proc;
  Runtime_OnRun_Set: ARuntime_OnRun_Set_Proc;
  Runtime_OnShutdown_Set: ARuntime_OnShutdown_Set_Proc;

var
  Runtime_Module_Register: ARuntime_Module_Register_Proc;

var
  Runtime_Modules_AddModule: ARuntime_Modules_AddModule_Proc;
  Runtime_Modules_Count: ARuntime_Modules_Count_Proc;
  Runtime_Modules_DeleteByName: ARuntime_Modules_DeleteByName_Proc;
  Runtime_Modules_DeleteByUID: ARuntime_Modules_DeleteByUID_Proc;
  Runtime_Modules_FindByName: ARuntime_Modules_FindByName_Proc;
  Runtime_Modules_FindByUID: ARuntime_Modules_FindByUID_Proc;
  Runtime_Modules_GetByName: ARuntime_Modules_GetByName_Proc;
  Runtime_Modules_GetByUID: ARuntime_Modules_GetByUID_Proc;
  Runtime_Modules_GetNameByIndex: ARuntime_Modules_GetNameByIndex_Proc;
  Runtime_Modules_GetUIDByIndex: ARuntime_Modules_GetUIDByIndex_Proc;
  Runtime_Modules_InitByName: ARuntime_Modules_InitByName_Proc;
  Runtime_Modules_InitByUID: ARuntime_Modules_InitByUID_Proc;

{$ELSE} // A03

var // --- Info functions ---
  Runtime_GetCompanyName: ARuntimeGetCompanyNameProc;
  Runtime_GetCopyright: ARuntimeGetCopyrightProc;
  Runtime_GetDataPath: ARuntimeGetDataPathProc;
  Runtime_GetDescription: ARuntimeGetDescriptionProc;
  Runtime_GetExeName: ARuntimeGetExeNameProc;
  Runtime_GetExePath: ARuntimeGetExePathProc;
  Runtime_GetProductName: ARuntimeGetProductNameProc;
  Runtime_GetProductVersion: ARuntimeGetProductVersionProc;
  Runtime_GetProgramName: ARuntimeGetProgramNameProc;
  Runtime_GetProgramVersion: ARuntimeGetProgramVersionProc;
  Runtime_GetTitle: ARuntimeGetTitleProc;
  Runtime_GetUrl: ARuntimeGetUrlProc;

var
  Runtime_GetConfig: ARuntimeGetConfigProc;
  Runtime_GetIsShutdown: ARuntimeGetIsShutdownProc;
  Runtime_GetResourceString: ARuntimeGetResourceStringProc;
  Runtime_ProcessMessages: ARuntimeProcessMessagesProc;
  Runtime_SetConfig: ARuntimeSetConfigProc;
  Runtime_ShowError: ARuntimeShowErrorProc;
  Runtime_ShowMessage: ARuntimeShowMessageProc;
  Runtime_ShowMessageA: ARuntimeShowMessageAProc;
  Runtime_Shutdown: ARuntimeShutdownProc;

var // --- Set event functions ---
  Runtime_SetOnProcessMessages: ARuntimeSetOnProcessMessagesProc;
  Runtime_SetOnRun: ARuntimeSetOnRunProc;
  Runtime_SetOnShutdown: ARuntimeSetOnShutdownProc;
  Runtime_SetOnShowError: ARuntimeSetOnShowErrorProc;
  Runtime_SetOnShowMessage: ARuntimeSetOnShowMessageProc;

var
  Runtime_Module_Count: ARuntimeModuleCountProc;
  Runtime_Module_DeleteByName: ARuntimeModuleDeleteByNameProc;
  Runtime_Module_FindByName: ARuntimeModuleFindByNameProc;
  Runtime_Module_GetByName: ARuntimeModuleGetByNameProc;
  Runtime_Module_GetNameByIndex: ARuntimeModuleGetNameByIndexProc;
  Runtime_Module_InitByName: ARuntime_Module_InitByName;
  Runtime_Module_Register: ARuntimeModuleRegisterProc;
var // --- Events and tools ---
  Runtime_OnAfterRun: ARuntimeOnAfterRunGetProc;
  Runtime_OnBeforeRun: ARuntimeOnBeforeRunGetProc;
  Runtime_OnAfterRun_Connect: ARuntimeOnAfterRunConnectProc;
  Runtime_OnAfterRun_Disconnect: ARuntimeOnAfterRunDisconnectProc;
  Runtime_OnBeforeRun_Connect: ARuntimeOnBeforeRunConnectProc;
  Runtime_OnBeforeRun_Disconnect: ARuntimeOnBeforeRunDisconnectProc;
var
  Runtime_ParamCount: ARuntimeParamCountProc;
  Runtime_ParamStr: ARuntimeParamStrProc;
  Runtime_ShellExecute: ARuntimeShellExecuteProc;

{$ENDIF} // A03

// -------------------------------------------------------------------------------------------------

{$IFDEF A03}

type
  ARuntimeProcs = ^ARuntimeProcs_Type;
  ARuntimeProcs_Type = packed record {64x4}
    // --- Set event functions ---
    OnAfterRun_Set: ARuntime_OnAfterRun_Set_Proc;
    OnBeforeRun_Set: ARuntime_OnBeforeRun_Set_Proc;
    OnRun_Set: ARuntime_OnRun_Set_Proc;
    OnShutdown_Set: ARuntime_OnShutdown_Set_Proc;

    Modules_AddModule: ARuntime_Modules_AddModule_Proc;
    Modules_Count: ARuntime_Modules_Count_Proc;
    Modules_FindByName: ARuntime_Modules_FindByName_Proc;
    Modules_FindByUid: ARuntime_Modules_FindByUid_Proc;
    Modules_DeleteByName: ARuntime_Modules_DeleteByName_Proc;
    Modules_DeleteByUid: ARuntime_Modules_DeleteByUid_Proc;
    Modules_GetByName: ARuntime_Modules_GetByName_Proc;
    Modules_GetByUid: ARuntime_Modules_GetByUid_Proc;
    Modules_GetNameByIndex: ARuntime_Modules_GetNameByIndex_Proc;
    Modules_GetUIDByIndex: ARuntime_Modules_GetUidByIndex_Proc;
    Modules_InitByName: ARuntime_Modules_InitByName_Proc;
    Modules_InitByUid: ARuntime_Modules_InitByUid_Proc;

    IsShutdown: ARuntime_IsShutdown_Proc;
    Shutdown: ARuntime_Shutdown_Proc;
    Module_Register: ARuntime_Module_Register_Proc;
    Reserved19: AInteger;
    Reserved20: AInteger;
    Reserved21: AInteger;
    Reserved22: AInteger;
    Reserved23: AInteger;
    Reserved24: AInteger;
    Reserved25: AInteger;
    Reserved26: AInteger;
    Reserved27: AInteger;
    Reserved28: AInteger;
    Reserved29: AInteger;
    Reserved30: AInteger;
    Reserved31: AInteger;

    Reserved32: AInteger;
    Reserved33: AInteger;
    Reserved34: AInteger;
    Reserved35: AInteger;
    Reserved36: AInteger;
    Reserved37: AInteger;
    Reserved38: AInteger;
    Reserved39: AInteger;
    Reserved40: AInteger;
    Reserved41: AInteger;
    Reserved42: AInteger;
    Reserved43: AInteger;
    Reserved44: AInteger;
    Reserved45: AInteger;
    Reserved46: AInteger;
    Reserved47: AInteger;
    Reserved48: AInteger;
    Reserved49: AInteger;
    Reserved50: AInteger;
    Reserved51: AInteger;
    Reserved52: AInteger;
    Reserved53: AInteger;
    Reserved54: AInteger;
    Reserved55: AInteger;
    Reserved56: AInteger;
    Reserved57: AInteger;
    Reserved58: AInteger;
    Reserved59: AInteger;
    Reserved60: AInteger;
    Reserved61: AInteger;
    Reserved62: AInteger;
    Reserved63: AInteger;
  end;

{$ELSE} // A03

type
  ARuntimeProcs = ^ARuntimeProcs_Type;
  ARuntimeProcs_Type = packed record {64x4}
    // --- Info functions ---
    GetCompanyName: ARuntimeGetCompanyNameProc;
    GetCopyright: ARuntimeGetCopyrightProc;
    GetDescription: ARuntimeGetDescriptionProc;
    GetExeName: ARuntimeGetExeNameProc;
    GetExePath: ARuntimeGetExePathProc;
    GetProductName: ARuntimeGetProductNameProc;
    GetProductVersion: ARuntimeGetProductVersionProc;
    GetProgramName: ARuntimeGetProgramNameProc;
    GetProgramVersion: ARuntimeGetProgramVersionProc;
    GetTitle: ARuntimeGetTitleProc;
    GetUrl: ARuntimeGetUrlProc;

    GetConfig: ARuntimeGetConfigProc;
    GetIsShutdown: ARuntimeGetIsShutdownProc;
    GetResourceString: ARuntimeGetResourceStringProc;
    ProcessMessages: ARuntimeProcessMessagesProc;
    SetConfig: ARuntimeSetConfigProc;
    ShowError: ARuntimeShowErrorProc;
    ShowMessage: ARuntimeShowMessageProc;
    ShowMessageA: ARuntimeShowMessageAProc;
    Shutdown: ARuntimeShutdownProc;

    // --- Set event functions ---
    SetOnProcessMessages: ARuntimeSetOnProcessMessagesProc;
    SetOnRun: ARuntimeSetOnRunProc;
    SetOnShutdown: ARuntimeSetOnShutdownProc;
    SetOnShowError: ARuntimeSetOnShowErrorProc;
    SetOnShowMessage: ARuntimeSetOnShowMessageProc;

    // --- Events and tools ---
    OnAfterRun: ARuntimeOnAfterRunGetProc;
    OnBeforeRun: ARuntimeOnBeforeRunGetProc;
    OnAfterRun_Connect: ARuntimeOnAfterRunConnectProc;
    OnAfterRun_Disconnect: ARuntimeOnAfterRunDisconnectProc;
    OnBeforeRun_Connect: ARuntimeOnBeforeRunConnectProc;
    OnBeforeRun_Disconnect: ARuntimeOnBeforeRunDisconnectProc;

    Module_Count: ARuntimeModuleCountProc;
    Module_FindByName: ARuntimeModuleFindByNameProc;
    Module_GetByName: ARuntimeModuleGetByNameProc;
    Module_GetNameByIndex: ARuntimeModuleGetNameByIndexProc;
    Module_Register: ARuntimeModuleRegisterProc;

    ParamStr: ARuntimeParamStrProc;
    ShellExecute: ARuntimeShellExecuteProc;
    GetDataPath: ARuntimeGetDataPathProc;
    Module_InitByName: ARuntime_Module_InitByName;

    Module_DeleteByName: ARuntimeModuleDeleteByNameProc;
    Reserved41: AInteger; //ParamCount: ARuntimeParamCountProc;
    Reserved42: AInteger;
    Reserved43: AInteger;
    Reserved44: AInteger;
    Reserved45: AInteger;
    Reserved46: AInteger;
    Reserved47: AInteger;
    Reserved48: AInteger;
    Reserved49: AInteger;
    Reserved50: AInteger;
    Reserved51: AInteger;
    Reserved52: AInteger;
    Reserved53: AInteger;
    Reserved54: AInteger;
    Reserved55: AInteger;
    Reserved56: AInteger;
    Reserved57: AInteger;
    Reserved58: AInteger;
    Reserved59: AInteger;
    Reserved60: AInteger;
    Reserved61: AInteger;
    Reserved62: AInteger;
    Reserved63: AInteger;
  end;

{$ENDIF} // A03

var
  Runtime: ARuntimeProcs_Type;

procedure Runtime_SetProcs(RuntimeProcs: ARuntimeProcs);

implementation

procedure Runtime_SetProcs(RuntimeProcs: ARuntimeProcs);
begin
  Runtime := RuntimeProcs^;

  {$IFDEF A03}

  Runtime_OnAfterRun_Set := Runtime.OnAfterRun_Set;
  Runtime_OnBeforeRun_Set := Runtime.OnBeforeRun_Set;
  Runtime_OnRun_Set := Runtime.OnRun_Set;
  Runtime_OnShutdown_Set := Runtime.OnShutdown_Set;

  Runtime_Modules_AddModule := Runtime.Modules_AddModule;
  Runtime_Modules_Count := Runtime.Modules_Count;
  Runtime_Modules_FindByName := Runtime.Modules_FindByName;
  Runtime_Modules_FindByUID := Runtime.Modules_FindByUID;
  Runtime_Modules_DeleteByName := Runtime.Modules_DeleteByName;
  Runtime_Modules_DeleteByUID := Runtime.Modules_DeleteByUID;
  Runtime_Modules_GetByName := Runtime.Modules_GetByName;
  Runtime_Modules_GetByUID := Runtime.Modules_GetByUID;
  Runtime_Modules_GetNameByIndex := Runtime.Modules_GetNameByIndex;
  Runtime_Modules_GetUIDByIndex := Runtime.Modules_GetUIDByIndex;
  Runtime_Modules_InitByName := Runtime.Modules_InitByName;
  Runtime_Modules_InitByUID := Runtime.Modules_InitByUID;

  Runtime_IsShutdown := Runtime.IsShutdown;
  Runtime_Shutdown := Runtime.Shutdown;
  Runtime_Module_Register := Runtime.Module_Register;

  {$ELSE} // A03

  Runtime_GetCompanyName := Runtime.GetCompanyName;
  Runtime_GetCopyright := Runtime.GetCopyright;
  Runtime_GetDescription := Runtime.GetDescription;
  Runtime_GetExeName := Runtime.GetExeName;
  Runtime_GetExePath := Runtime.GetExePath;
  Runtime_GetProductName := Runtime.GetProductName;
  Runtime_GetProductVersion := Runtime.GetProductVersion;
  Runtime_GetProgramName := Runtime.GetProgramName;
  Runtime_GetProgramVersion := Runtime.GetProgramVersion;
  Runtime_GetTitle := Runtime.GetTitle;
  Runtime_GetUrl := Runtime.GetUrl;

  Runtime_GetConfig := Runtime.GetConfig;
  Runtime_GetIsShutdown := Runtime.GetIsShutdown;
  Runtime_GetResourceString := Runtime.GetResourceString;
  Runtime_ProcessMessages := Runtime.ProcessMessages;
  Runtime_SetConfig := Runtime.SetConfig;
  Runtime_ShowError := Runtime.ShowError;
  Runtime_ShowMessage := Runtime.ShowMessage;
  Runtime_ShowMessageA := Runtime.ShowMessageA;
  Runtime_Shutdown := Runtime.Shutdown;

  Runtime_SetOnProcessMessages := Runtime.SetOnProcessMessages;
  Runtime_SetOnRun := Runtime.SetOnRun;
  Runtime_SetOnShutdown := Runtime.SetOnShutdown;
  Runtime_SetOnShowError := Runtime.SetOnShowError;
  Runtime_SetOnShowMessage := Runtime.SetOnShowMessage;

  Runtime_OnAfterRun := Runtime.OnAfterRun;
  Runtime_OnBeforeRun := Runtime.OnBeforeRun;
  Runtime_OnAfterRun_Connect := Runtime.OnAfterRun_Connect;
  Runtime_OnAfterRun_Disconnect := Runtime.OnAfterRun_Disconnect;
  Runtime_OnBeforeRun_Connect := Runtime.OnBeforeRun_Connect;
  Runtime_OnBeforeRun_Disconnect := Runtime.OnBeforeRun_Disconnect;

  Runtime_Module_Count := Runtime.Module_Count;
  Runtime_Module_FindByName := Runtime.Module_FindByName;
  Runtime_Module_GetByName := Runtime.Module_GetByName;
  Runtime_Module_GetNameByIndex := Runtime.Module_GetNameByIndex;
  Runtime_Module_Register := Runtime.Module_Register;

  Runtime_ParamStr := Runtime.ParamStr;
  Runtime_ShellExecute := Runtime.ShellExecute;
  Runtime_GetDataPath := Runtime.GetDataPath;
  Runtime_Module_InitByName := Runtime.Module_InitByName;
  Runtime_Module_DeleteByName := Runtime.Module_DeleteByName;
  //Runtime_ParamCount := Runtime.ParamCount;

  {$ENDIF} // A03
end;

end.
