{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 10.04.2009
LastMod: 16.05.2011
Version: 0.2.5+0.3.0
}
unit APlugins0;

{DEFINE A02}
{DEFINE A03}

interface

uses
  ABase0, ARuntime0;

const
  APlugins_Name = 'Plugins';
  APlugins_UID = $00000006;
  APlugins_Version = {$IFDEF A02}$00020500{$ELSE}$00030000{$ENDIF};

// --- Tepes ---

type
  // Check and add plugin.
  APluginsAddPluginProc = function(const FileName: AString): ABoolean; stdcall;
  APluginsClearProc = function: ABoolean; stdcall;
  APluginsCountProc = function: AInteger; stdcall;
  APluginsDeleteProc = function(Index: AInteger): ABoolean; stdcall;
  APluginsFindProc = procedure(const Path: AString); stdcall;

// ---

type
  APluginsProcs = ^APluginsProcsType;
  APluginsProcsType = packed record {8x4} {32x4}
    AddPlugin: APluginsAddPluginProc;
    Clear: APluginsClearProc;
    Count: APluginsCountProc;
    Delete: APluginsDeleteProc;
    Find: APluginsFindProc;
    Reserved05: Integer;
    Reserved06: Integer;
    Reserved07: Integer;
    {$IFDEF A03}
    Reserved08: AInteger;
    Reserved09: AInteger;
    Reserved10: AInteger;
    Reserved11: AInteger;
    Reserved12: AInteger;
    Reserved13: AInteger;
    Reserved14: AInteger;
    Reserved15: AInteger;

    Reserved16: AInteger;
    Reserved17: AInteger;
    Reserved18: AInteger;
    Reserved19: AInteger;
    Reserved20: AInteger;
    Reserved21: AInteger;
    Reserved22: AInteger;
    Reserved23: AInteger;
    Reserved24: AInteger;
    Reserved25: AInteger;
    Reserved26: AInteger;
    Reserved27: AInteger;
    Reserved28: AInteger;
    Reserved29: AInteger;
    Reserved30: AInteger;
    Reserved31: AInteger;
    {$ENDIF A03}
  end;

// --- Vars ---

var
  Plugins_AddPlugin: APluginsAddPluginProc;
  Plugins_Clear: APluginsClearProc;
  Plugins_Count: APluginsCountProc;
  Plugins_Delete: APluginsDeleteProc;
  Plugins_Find: APluginsFindProc;

var
  Plugins: APluginsProcsType;

procedure Plugins_SetProcs(Procs: APluginsProcs);

implementation

procedure Plugins_SetProcs(Procs: APluginsProcs);
begin
  Plugins := Procs^;
  Plugins_AddPlugin := Plugins.AddPlugin;
  Plugins_Clear := Plugins.Clear;
  Plugins_Count := Plugins.Count;
  Plugins_Delete := Plugins.Delete;
  Plugins_Find := Plugins.Find;
end;

end.
 
