{
      ( .dll, .so)
Author:  Prof1983 <prof1983@yandex.ru>
Created: 02.10.2005
LastMod: 05.05.2011
Version: 0.2.5+0.3.0
}
unit ALibrary0;

{$I Defines.inc}

interface

uses
  {$IFNDEF NoSysUtils}SysUtils,{$ENDIF}
  ABase0;

type
  ALibrary = type Integer;
  ALibraryFlags = Integer;

//   ().  .
function Library_Open(const FileName: AString; Flags: ALibraryFlags): ALibrary; stdcall;
//   ()
function Library_Close(Lib: ALibrary): ABoolean; stdcall;
function Library_BuildPath(const Directory, ModuleName: AString): AString; stdcall;
function Library_GetName(Lib: ALibrary): AString; stdcall;
//   
function Library_GetProcAddress(Lib: ALibrary; const Name: AString): Pointer; stdcall;
function Library_GetSymbol(Lib: ALibrary; const SymbolName: AString; var Symbol: Pointer): ABoolean; stdcall;

implementation

type
  TAModuleRec = record
    FileName: AString;        //    (.dll, .so)
    Handle: HMODULE;          // 
  end;

var
  FModules: array of TAModuleRec;

{ API functions }

type
  LPCSTR = PAnsiChar;
  BOOL = Boolean;
  FARPROC = Pointer;
  HMODULE = Integer;

const
  kernel32  = 'kernel32.dll';

function FreeLibrary(hLibModule: HMODULE): BOOL; stdcall; external kernel32 name 'FreeLibrary';
function GetProcAddress(hModule: HMODULE; lpProcName: LPCSTR): FARPROC; stdcall; external kernel32 name 'GetProcAddress';
function LoadLibrary(lpLibFileName: PChar): HMODULE; stdcall; external kernel32 name 'LoadLibraryA';

{ Private functions }

function AddModule(const FileName: AString; Handle: HMODULE): Integer;
begin
  Result := Length(FModules);
  SetLength(FModules, Result + 1);
  FModules[Result].FileName := FileName;
  FModules[Result].Handle := Handle;
end;

procedure DelModule(Index: Integer);
begin
  if (Index < 0) then Exit;
  FModules[Index] := FModules[High(FModules)];
  SetLength(FModules, High(FModules));
end;

function FindModuleByHandle(Handle: Integer): Integer;
var
  i: Integer;
begin
  for i := 0 to High(FModules) do
  begin
    if (FModules[i].Handle = HMODULE(Handle)) then
    begin
      Result := i;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindModuleByFileName(const FileName: AString): Integer;
var
  i: Integer;
begin
  for i := 0 to High(FModules) do
  begin
    if (FModules[i].FileName = FileName) then
    begin
      Result := i;
      Exit;
    end;
  end;
  Result := -1;
end;

{ Public Functions }

function Library_BuildPath(const Directory, ModuleName: AString): AString;
begin
  Result := ModuleName + '.dll';
  {$IFNDEF NoSysUtils}
  Result := ExpandFileName(Result);
  {$ENDIF}
end;

function Library_Close(Lib: ALibrary): ABoolean;
var
  Index: Integer;
begin
  if (Lib = 0) then
  begin
    Result := True;
    Exit;
  end;
  try
    FreeLibrary(Lib{FHandle});
    Result := True;
  except
    Result := False;
  end;
  Index := FindModuleByHandle(Lib);
  DelModule(Index);
end;

function Library_GetName(Lib: ALibrary): AString;
{$IFNDEF NoSysUtils}
var
  Index: Integer;
{$ENDIF}
begin
  {$IFNDEF NoSysUtils}
  Index := FindModuleByHandle(Lib);
  if (Index >= 0) then
  begin
    Result := ExtractFileName(FModules[Index].FileName);
    Result := ChangeFileExt(Result, '');
  end;
  {$ENDIF}
end;

function Library_GetProcAddress(Lib: ALibrary; const Name: AString): Pointer;
var
  P: PChar;
begin
  P := PChar(string(Name));
  Result := GetProcAddress(Lib{FHandle}, P);
end;

function Library_GetSymbol(Lib: ALibrary; const SymbolName: AString; var Symbol: Pointer): ABoolean;
begin
  Symbol := Library_GetProcAddress(Lib, SymbolName);
  Result := (Symbol <> nil);
end;

function Library_Open(const FileName: AString; Flags: ALibraryFlags): ALibrary;
var
  //Error: LongWord;
  P: PChar;
  Index: Integer;
  Handle: Integer;
begin
  Index := FindModuleByFileName(FileName);
  if (Index >= 0) then
  begin
    Result := FModules[Index].Handle;
    Exit;
  end;

  if (FileName = '') then
  begin
    Result := 0;
    Exit;
  end;
  {$IFNDEF VER170}
  P := PChar(string(FileName));
  Handle := LoadLibrary(P);
  //Handle := Windows.LoadLibrary(P);
  {$ELSE}
  Handle := Windows.LoadLibrary(FileName);
  {$ENDIF}
  if (Handle <= 32) then
  begin
    //Error := GetLastError;
    Result := 0;
    Exit;
  end;
  AddModule(FileName, Handle);
  Result := Handle;
end;

end.
