{
Abstract: Base types and consts (   )
Author:  Prof1983 <prof1983@yandex.ru>
Created: 06.03.2008
LastMod: 15.05.2011
Version: 0.1.1+0.2.5+0.3.0
}
unit ABase0;

{$I A.inc}

{DEFINE A03}

interface

type //  
  AFloat32 = Real;
  AFloat64 = Double;
  AInt32   = LongInt;
  AInt64   = Int64;
  AUInt16  = Word;
  AUInt32  = LongWord;

type //  
  ABoolean = Boolean;
  AChar    = WideChar;
  AInteger = Integer;
  AString1 = WideString; //{$IFDEF COMPILER_12_UP}string{$ELSE}WideString{$ENDIF};

type
  AFloat   = AFloat64;
  AInt     = AInt32;
  AUInt    = AUInt32;

type // .   $AABBCCDD = AA.BB.CC.DD
  AVersion = type Integer;
const //      
  AVersionMask = $FFFF0000;

type
  AString0 = ^AStringType;
  AStringType = packed record  // (4x4) GString
    Str: PWideChar;            // gchar - Points to the string's current \0-terminated value.
    Len: AInteger;             // gint - Current length
    AllocatedLen: AInteger;
    Reserved03: AInteger;
  end;
{
type
  // ( Win32  Linux)
  AData   = Pointer;
  // ( CLR  Java)
  //AData   = TObject;
}

type
  AString  = AString1;

(*
type
  {
    .       .
     0       AI .
      0  1023 .
     1024     AI .
      1025  2047      AI .
      2028  65535 .
      65535  2^31     .
       2^32  2^63   AI .
        2^32   
    (      ).
    :
      ru.narod.profsoft.ai.common.BaseTypes
      org.framerd.OID.OID
  }
  TAID = AInt64;
*)

type
  ALogFlags = type Integer;
const
  ALogFlags_IconMask = $000000F0;
  ALogFlags_IconError = $00000010;
  ALogFlags_IconQuestion = $00000020;
  ALogFlags_IconWarning = $00000030;
  ALogFlags_IconInformation = $00000040;
  ALogFlags_IconUser = $00000080;
const
  ALogIconMask         = $000000F0;
  ALogIconError        = $00000010;
  ALogIconQuestion     = $00000020;
  ALogIconWarning      = $00000030;
  ALogIconInformation  = $00000040;
  ALogIconUser         = $00000080;
{const
  L_ICONERROR = ALogIconError;       // MB_ICONHAND, MB_ICONSTOP
  L_ICONQUESTION = ALogIconQuestion;
  L_ICONWARNING = ALogIconWarning;     // ICONEXCLAMATION
  L_ICONINFORMATION = ALogIconInformation; // MB_ICONASTERISK
  L_USERICON = ALogIconUser;}

type
  AMessageBoxFlags = type Integer;
const
  AMessageBoxFlags_OK = $00000000;
  AMessageBoxFlags_OKCANCEL = $00000001;
  AMessageBoxFlags_ABORTRETRYIGNORE = $00000002;
  AMessageBoxFlags_YESNOCANCEL = $00000003;
  AMessageBoxFlags_YESNO = $00000004;
  AMessageBoxFlags_RETRYCANCEL = $00000005;
  AMessageBoxFlags_ApplyOkCancel = $00000006;
const
  AMessageBoxFlags_ICONERROR = $00000010;       // MB_ICONHAND, MB_ICONSTOP
  AMessageBoxFlags_ICONQUESTION = $00000020;
  AMessageBoxFlags_ICONWARNING = $00000030;     // ICONEXCLAMATION
  AMessageBoxFlags_ICONINFORMATION = $00000040; // MB_ICONASTERISK
  AMessageBoxFlags_USERICON = $00000080;
const
  MB_OK = AMessageBoxFlags_OK;
  MB_OKCANCEL = AMessageBoxFlags_OKCANCEL;
  MB_ABORTRETRYIGNORE = AMessageBoxFlags_ABORTRETRYIGNORE;
  MB_YESNOCANCEL = AMessageBoxFlags_YESNOCANCEL;
  MB_YESNO = AMessageBoxFlags_YESNO;
  MB_RETRYCANCEL = AMessageBoxFlags_RETRYCANCEL;
  MB_ApplyOkCancel = AMessageBoxFlags_ApplyOkCancel;
const
  MB_ICONERROR = AMessageBoxFlags_ICONERROR;
  MB_ICONQUESTION = AMessageBoxFlags_ICONQUESTION;
  MB_ICONWARNING = AMessageBoxFlags_ICONWARNING;
  MB_ICONINFORMATION = AMessageBoxFlags_ICONINFORMATION;
  MB_USERICON = AMessageBoxFlags_USERICON;

type
  ADialogBoxCommands = type Integer;
const
  ID_OK = 1;
  ID_CANCEL = 2;
  ID_ABORT = 3;
  ID_RETRY = 4;
  ID_IGNORE = 5;
  ID_YES = 6;
  ID_NO = 7;
  ID_CLOSE = 8;
  ID_HELP = 9;
  ID_TRYAGAIN = 10;
  ID_CONTINUE = 11;

type
  {$IFDEF A03}
  AProc = function: AInteger; stdcall;
  {$ELSE}
  AProc = procedure; stdcall;
  {$ENDIF}
  ANotifyProc = procedure(Sender: AInteger); stdcall;
  ACallbackProc = procedure(Obj, Data: AInteger); stdcall;
type
  //TAProc = AProc;
  //TANotifyProc = ANotifyProc;
  TAShowErrorProc = procedure(const Caption, UserMessage, ExceptMessage: AString1); stdcall;
  TAShowMessageProc = function(const Text, Caption: AString1; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
  TAddToLogProc = procedure(const Msg: AString1; Flags: ALogFlags);
type
  TAGetBoolProc = function: ABoolean; stdcall;
  TAGetIntProc = function: AInteger; stdcall;
  TAGetStrProc = function: AString1; stdcall;

type
  AConfig = type AInteger;
  AEvent = type AInteger;      // = AEventType^;
  AColor = type AInteger;
  AStrings = type AInteger;

// -------------------------------------------------------------------------------------------------

const
  STR_BOOL: array [Boolean] of string = ('False', 'True');
  STR_BOOL_FIB: array [Boolean] of string = ('''0''', '''1''');

const //   
  STR_BOOL_ENG: array [Boolean] of string = ('false', 'true');
  STR_BOOL_RUS: array [Boolean] of string = ('', '');
  STR_BOOL_RUS2: array [Boolean] of string = ('', '');
const //    
  STR_MONTH_2: array [0..12] of string = ('00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12');
  STR_MONTH_RUS: array [0..12] of string =
    ('', '', '', '', '', '', '', '',
     '', '', '', '', '');
  STR_MONTH_RUS_H: array [0..12] of string =
    ('', '', '', '', '', '', '', '',
     '', '', '', '', '');
  STR_MONTH_ENG: array [0..12] of string =
    ('none', 'January', 'February', 'March', 'April', 'May', 'June', 'July',
     'August', 'September', 'October', 'November', 'December');
  STR_DAYOFWEEK_RUS: array [0..7] of string =
    ('', '', '', '', '', '', '', '');
  STR_DAYOFWEEK_ENG: array [0..7] of string =
    ('none', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');

implementation

end.


