// LastMod: 06.05.2011 by Prof1983 <prof1983@yandex.ru>
//----------------------------------------------------------------------------------------------------------------------
// Include file to determine which compiler is currently being used to build the project/component.
// This file uses ideas from Brad Stowers DFS.inc file (www.delphifreestuff.com).
//
// Portions created by Mike Lischke are Copyright
// (C) 1999-2002 Dipl. Ing. Mike Lischke. All Rights Reserved.
//----------------------------------------------------------------------------------------------------------------------
// The following symbols are defined:
//
// COMPILER_1    : Kylix/Delphi/BCB 1.x is the compiler.
// COMPILER_1_UP : Kylix/Delphi/BCB 1.x or higher is the compiler.
// COMPILER_2    : Kylix/Delphi 2.x or BCB 1.x is the compiler.
// COMPILER_2_UP : Kylix/Delphi 2.x or higher, or BCB 1.x or higher is the compiler.
// COMPILER_3    : Kylix/Delphi/BCB 3.x is the compiler.
// COMPILER_3_UP : Kylix/Delphi/BCB 3.x or higher is the compiler.
// COMPILER_4    : Kylix/Delphi/BCB 4.x is the compiler.
// COMPILER_4_UP : Kylix/Delphi/BCB 4.x or higher is the compiler.
// COMPILER_5    : Kylix/Delphi/BCB 5.x is the compiler.
// COMPILER_5_UP : Kylix/Delphi/BCB 5.x or higher is the compiler.
// COMPILER_6    : Kylix/Delphi/BCB 6.x is the compiler.
// COMPILER_6_UP : Kylix/Delphi/BCB 6.x or higher is the compiler.
// COMPILER_7    : Kylix/Delphi/BCB 7.x is the compiler.
// COMPILER_7_UP : Kylix/Delphi/BCB 7.x or higher is the compiler.
//
// Only defined if Windows is the target:
// CPPB        : Any version of BCB is being used.
// CPPB_1      : BCB v1.x is being used.
// CPPB_3      : BCB v3.x is being used.
// CPPB_3_UP   : BCB v3.x or higher is being used.
// CPPB_4      : BCB v4.x is being used.
// CPPB_4_UP   : BCB v4.x or higher is being used.
// CPPB_5      : BCB v5.x is being used.
// CPPB_5_UP   : BCB v5.x or higher is being used.
// CPPB_6      : BCB v6.x is being used.
// CPPB_6_UP   : BCB v6.x or higher is being used.
//
// Only defined if Windows is the target:
// DELPHI      : Any version of Delphi is being used.
// DELPHI_1    : Delphi v1.x is being used.
// DELPHI_2    : Delphi v2.x is being used.
// DELPHI_2_UP : Delphi v2.x or higher is being used.
// DELPHI_3    : Delphi v3.x is being used.
// DELPHI_3_UP : Delphi v3.x or higher is being used.
// DELPHI_4    : Delphi v4.x is being used.
// DELPHI_4_UP : Delphi v4.x or higher is being used.
// DELPHI_5    : Delphi v5.x is being used.
// DELPHI_5_UP : Delphi v5.x or higher is being used.
// DELPHI_6    : Delphi v6.x is being used.
// DELPHI_6_UP : Delphi v6.x or higher is being used.
// DELPHI_7    : Delphi v7.x is being used.
// DELPHI_7_UP : Delphi v7.x or higher is being used.
//
// Only defined if Linux is the target:
// KYLIX       : Any version of Kylix is being used.
// KYLIX_1     : Kylix 1.x is being used.
// KYLIX_1_UP  : Kylix 1.x or higher is being used.
// KYLIX_2     : Kylix 2.x is being used.
// KYLIX_2_UP  : Kylix 2.x or higher is being used.
// KYLIX_3     : Kylix 3.x is being used.
// KYLIX_3_UP  : Kylix 3.x or higher is being used.
//
// Only defined if Linux is the target:
// QT_CLX      : Trolltech's QT library is being used.
//----------------------------------------------------------------------------------------------------------------------

{$ifdef Win32}

  {$IFDEF VER210}
    {$DEFINE COMPILER_13}
    {$DEFINE DELPHI}
    {$DEFINE DELPHI_13}
    {$DEFINE DELPHI_2010}
  {$ENDIF}

  {$IFDEF VER200}
    {$DEFINE COMPILER_12}
    {$DEFINE DELPHI}
    {$DEFINE DELPHI_12}
    {$DEFINE DELPHI_2009}
  {$ENDIF}

  {$IFDEF VER190}
    {$DEFINE COMPILER_11}
    {$DEFINE DELPHI}
    {$DEFINE DELPHI_11}
    {$DEFINE DELPHI_2007}
  {$ENDIF}

  {$IFDEF VER180}
    {$define COMPILER_10}
    {$define DELPHI}
    {$define DELPHI_10}
  {$ENDIF}

  {$IFDEF VER170}
    {$define COMPILER_9}
    {$define DELPHI}
    {$define DELPHI_9}
  {$ENDIF}

  {$IFDEF VER150}
    {$define COMPILER_7}
    {$define DELPHI}
    {$define DELPHI_7}
  {$ENDIF}

  {$IFDEF VER140}
    {$define COMPILER_6}
    {$ifdef BCB}
      {$define CPPB}
      {$define CPPB_6}
    {$else}
      {$define DELPHI}
      {$define DELPHI_6}
    {$endif}
  {$ENDIF}

  {$IFDEF VER130}
    {$define COMPILER_5}
    {$ifdef BCB}
      {$define CPPB}
      {$define CPPB_5}
    {$else}
      {$define DELPHI}
      {$define DELPHI_5}
    {$endif}
  {$ENDIF}

  {$IFDEF VER125}
    {$define COMPILER_4}
    {$define CPPB}
    {$define CPPB_4}
  {$ENDIF}

  {$IFDEF VER120}
    {$define COMPILER_4}
    {$define DELPHI}
    {$define DELPHI_4}
  {$ENDIF}

  {$IFDEF VER110}
    {$define COMPILER_3}
    {$define CPPB}
    {$define CPPB_3}
  {$ENDIF}

  {$IFDEF VER100}
    {$define COMPILER_3}
    {$define DELPHI}
    {$define DELPHI_3}
  {$ENDIF}

  {$IFDEF VER93}
    {$define COMPILER_2} // C++ Builder v1 compiler is really v2
    {$define CPPB}
    {$define CPPB_1}
  {$ENDIF}

  {$IFDEF VER90}
    {$define COMPILER_2}
    {$define DELPHI}
    {$define DELPHI_2}
  {$ENDIF}

  {$IFDEF VER80}
    {$define COMPILER_1}
    {$define DELPHI}
    {$define DELPHI_1}
  {$ENDIF}

  {$IFDEF DELPHI_2} {$DEFINE DELPHI_2_UP} {$ENDIF}
  {$IFDEF DELPHI_3} {$DEFINE DELPHI_3_UP} {$ENDIF}
  {$IFDEF DELPHI_4} {$DEFINE DELPHI_4_UP} {$ENDIF}
  {$IFDEF DELPHI_5} {$DEFINE DELPHI_5_UP} {$ENDIF}
  {$IFDEF DELPHI_6} {$DEFINE DELPHI_6_UP} {$ENDIF}
  {$IFDEF DELPHI_7} {$DEFINE DELPHI_7_UP} {$ENDIF}
  {$IFDEF DELPHI_9} {$DEFINE DELPHI_9_UP} {$ENDIF}
  {$IFDEF DELPHI_10} {$DEFINE DELPHI_10_UP} {$ENDIF}
  {$IFDEF DELPHI_11} {$DEFINE DELPHI_11_UP} {$ENDIF}
  {$IFDEF DELPHI_12} {$DEFINE DELPHI_12_UP} {$ENDIF}
  {$IFDEF DELPHI_13} {$DEFINE DELPHI_13_UP} {$ENDIF}

  {$IFDEF DELPHI_13_UP} {$DEFINE DELPHI_12_UP} {$ENDIF}
  {$IFDEF DELPHI_12_UP} {$DEFINE DELPHI_11_UP} {$ENDIF}
  {$IFDEF DELPHI_11_UP} {$DEFINE DELPHI_10_UP} {$ENDIF}
  {$IFDEF DELPHI_10_UP} {$DEFINE DELPHI_9_UP} {$ENDIF}
  {$IFDEF DELPHI_9_UP} {$DEFINE DELPHI_8_UP} {$ENDIF}
  {$IFDEF DELPHI_8_UP} {$DEFINE DELPHI_7_UP} {$ENDIF}
  {$IFDEF DELPHI_7_UP} {$DEFINE DELPHI_6_UP} {$ENDIF}
  {$IFDEF DELPHI_6_UP} {$DEFINE DELPHI_5_UP} {$ENDIF}
  {$IFDEF DELPHI_5_UP} {$DEFINE DELPHI_4_UP} {$ENDIF}
  {$IFDEF DELPHI_4_UP} {$DEFINE DELPHI_3_UP} {$ENDIF}
  {$IFDEF DELPHI_3_UP} {$DEFINE DELPHI_2_UP} {$ENDIF}
  {$IFDEF DELPHI_2_UP} {$DEFINE DELPHI_1_UP} {$ENDIF}



  {$ifdef CPPB_3}
    {$define CPPB_3_UP}
  {$endif}

  {$ifdef CPPB_4}
    {$define CPPB_3_UP}
    {$define CPPB_4_UP}
  {$endif}

  {$ifdef CPPB_5}
    {$define CPPB_3_UP}
    {$define CPPB_4_UP}
    {$define CPPB_5_UP}
  {$endif}

  {$ifdef CPPB_6}
    {$define CPPB_3_UP}
    {$define CPPB_4_UP}
    {$define CPPB_5_UP}
    {$define CPPB_6_UP}
  {$endif}

  {$ifdef CPPB_3_UP}
    // C++ Builder requires this if you use Delphi components in run-time packages.
    {$ObjExportAll On}
  {$endif}

{$else (not Windows)}
  // Linux is the target
  {$define QT_CLX}

  {$define KYLIX}
  {$define KYLIX_1}
  {$define KYLIX_1_UP}

  {$ifdef VER150}
    {$define COMPILER_7}
    {$define KYLIX_3}
  {$endif}

  {$ifdef VER140}
    {$define COMPILER_6}
    {$define KYLIX_2}
  {$endif}

  {$ifdef KYLIX_2}
    {$define KYLIX_2_UP}
  {$endif}

  {$ifdef KYLIX_3}
    {$define KYLIX_2_UP}
    {$define KYLIX_3_UP}
  {$endif}

{$endif}

// Compiler defines common to all platforms.
{$IFDEF COMPILER_1} {$DEFINE COMPILER_1_UP} {$ENDIF}
{$IFDEF COMPILER_2} {$DEFINE COMPILER_2_UP} {$ENDIF}
{$IFDEF COMPILER_3} {$DEFINE COMPILER_3_UP} {$ENDIF}
{$IFDEF COMPILER_4} {$DEFINE COMPILER_4_UP} {$ENDIF}
{$IFDEF COMPILER_5} {$DEFINE COMPILER_5_UP} {$ENDIF}
{$IFDEF COMPILER_6} {$DEFINE COMPILER_6_UP} {$ENDIF}
{$IFDEF COMPILER_7} {$DEFINE COMPILER_7_UP} {$ENDIF}
{$IFDEF COMPILER_9} {$DEFINE COMPILER_9_UP} {$ENDIF}
{$IFDEF COMPILER_10} {$DEFINE COMPILER_10_UP} {$ENDIF}
{$IFDEF COMPILER_11} {$DEFINE COMPILER_11_UP} {$ENDIF}
{$IFDEF COMPILER_12} {$DEFINE COMPILER_12_UP} {$ENDIF}
{$IFDEF COMPILER_13} {$DEFINE COMPILER_13_UP} {$ENDIF}

{$IFDEF COMPILER_13_UP} {$DEFINE COMPILER_12_UP} {$ENDIF}
{$IFDEF COMPILER_12_UP} {$DEFINE COMPILER_11_UP} {$ENDIF}
{$IFDEF COMPILER_11_UP} {$DEFINE COMPILER_10_UP} {$ENDIF}
{$IFDEF COMPILER_10_UP} {$DEFINE COMPILER_9_UP} {$ENDIF}
{$IFDEF COMPILER_9_UP} {$DEFINE COMPILER_8_UP} {$ENDIF}
{$IFDEF COMPILER_8_UP} {$DEFINE COMPILER_7_UP} {$ENDIF}
{$IFDEF COMPILER_7_UP} {$DEFINE COMPILER_6_UP} {$ENDIF}
{$IFDEF COMPILER_6_UP} {$DEFINE COMPILER_5_UP} {$ENDIF}
{$IFDEF COMPILER_5_UP} {$DEFINE COMPILER_4_UP} {$ENDIF}
{$IFDEF COMPILER_4_UP} {$DEFINE COMPILER_3_UP} {$ENDIF}
{$IFDEF COMPILER_3_UP} {$DEFINE COMPILER_2_UP} {$ENDIF}

//----------------------------------------------------------------------------------------------------------------------

{$ALIGN ON}
{$BOOLEVAL OFF}

{$ifdef COMPILER_7_UP}
  {$define THEME_7_UP} { Allows experimental theme support on pre-Delphi 7. }
{$endif}

{$IFDEF COMPILER_6_UP}
{$WARN SYMBOL_PLATFORM OFF} { We are going to use Win32 specific symbols! }
{$ENDIF}

{$IFDEF COMPILER_7_UP}
{$WARN UNSAFE_CODE OFF} { We are not going to be "safe"! }
{$WARN UNSAFE_TYPE OFF}
{$WARN UNSAFE_CAST OFF}
{$ENDIF}