(clear) ;; Test simple switching
(set-strategy depth)
(unwatch all)
(watch rules)
(watch focus)
(defmodule MAIN (export ?ALL))
(deffacts info (a) (b))
(defrule MAIN::start => (focus A B C))
(defmodule A (import MAIN ?ALL))
(defrule A::arule1 (a) =>)
(defrule A::arule2 (b) =>)
(defmodule B (import MAIN ?ALL))
(defrule B::brule1 (a) =>)
(defrule B::brule2 (b) =>)
(defmodule C (import MAIN ?ALL))
(defrule C::crule1 (a) =>)
(defrule C::crule2 (b) =>)
(reset)
(run)
(clear) ;; Test early return
(defmodule MAIN (export ?ALL))
(deffacts info (a) (b))
(defrule MAIN::start => (focus A B C))
(defmodule A (import MAIN ?ALL))
(defrule A::arule1 (a) =>)
(defrule A::arule2 (b) => (return))
(defmodule B (import MAIN ?ALL))
(defrule B::brule1 (a) =>)
(defrule B::brule2 (b) => (return))
(defmodule C (import MAIN ?ALL))
(defrule C::crule1 (a) =>)
(defrule C::crule2 (b) => (return))
(reset)
(run)
(clear) ;; Test nesting
(defmodule MAIN (export ?ALL))
(deffacts info (a) (b) (c))
(defrule MAIN::start => (focus A))
(defmodule A (import MAIN ?ALL))
(defrule A::arule1 (a) =>)
(defrule A::arule2 (b) => (focus B))
(defrule A::arule3 (c) => (focus B))
(defmodule B (import MAIN ?ALL))
(defrule B::brule1 (a) =>)
(defrule B::brule2 (b) => (focus C))
(defrule B::brule3 (c) => (focus C))
(defmodule C (import MAIN ?ALL))
(defrule C::crule1 (a) =>)
(defrule C::crule2 (b) => (return))
(defrule C::crule3 (c) => (focus A))
(reset)
(run)
(clear) ;; Autofocus
(defrule error (declare (auto-focus)) =>)
(defrule error (declare (auto-focus TRUE FALSE)) =>)
(defrule error (declare (auto-focus 6)) =>)
(clear)
(defmodule MAIN (export ?ALL))
(deffacts info (a) (b) (c))
(defrule MAIN::mrule1 (c) => (assert (d)))
(defrule MAIN::mrule2 (b) => (assert (e)))
(defrule MAIN::mrule3 (a) =>)
(defmodule A (import MAIN ?ALL))
(defrule A::arule1 (declare (auto-focus TRUE)) (d) =>)
(defrule A::arule2 (declare (auto-focus TRUE)) (e) => (assert (f)))
(defrule A::arule3 (f) =>)
(reset)
(run)
