(deftemplate PERSON
   (slot name)
   (slot sex)
   (slot age (type NUMBER)))
(deftemplate FEMALE
   (slot name)
   (slot sex (default female))
   (slot age (type NUMBER)))
(deftemplate MALE
   (slot name)
   (slot sex (default male))
   (slot age (type NUMBER)))
(deftemplate GIRL
   (slot name)
   (slot sex (default female))
   (slot age (type NUMBER)
             (default 4)
             (range 0.0 17.9)))
(deftemplate WOMAN
   (slot name)
   (slot sex (default female))
   (slot age (type NUMBER)
             (default 25)
             (range 18.0 100.0)))
(deftemplate BOY
   (slot name)
   (slot sex (default male))
   (slot age (type NUMBER)
             (default 4)
             (range 0.0 17.9)))
(deftemplate MAN
   (slot name)
   (slot sex (default male))
   (slot age (type NUMBER)
             (default 25)
             (range 18.0 100.0)))
(deffacts PEOPLE
   (PERSON (name [Girl-1]) (sex male) (age 8))
   (PERSON (name [Girl-2]) (sex male) (age 4))
   (PERSON (name [Woman-1]) (sex female) (age 18))
   (PERSON (name [Woman-2]) (sex female) (age 60))
   (PERSON (name [Woman-3]) (sex female) (age 25))
   (PERSON (name [Boy-1]) (sex male) (age 8))
   (PERSON (name [Boy-2]) (sex male) (age 4))
   (PERSON (name [Boy-3]) (sex male) (age 4))
   (PERSON (name [Boy-4]) (sex male) (age 4))
   (PERSON (name [Man-1]) (sex male) (age 18))
   (PERSON (name [Man-2]) (sex male) (age 60))

   (MALE (name [Boy-1]) (age 8))
   (MALE (name [Boy-2]) (age 4))
   (MALE (name [Boy-3]) (age 4))
   (MALE (name [Boy-4]) (age 4))
   (MALE (name [Man-1]) (age 18))
   (MALE (name [Man-2]) (age 60))

   (FEMALE (name [Girl-1]) (age 8))
   (FEMALE (name [Girl-2]) (age 4))
   (FEMALE (name [Woman-1]) (age 18))
   (FEMALE (name [Woman-2]) (age 60))
   (FEMALE (name [Woman-3]) (age 25))

   (GIRL (name [Girl-1]) (age 8))
   (GIRL (name [Girl-2]))

   (BOY (name [Boy-1]) (age 8))
   (BOY (name [Boy-2]))
   (BOY (name [Boy-3]))
   (BOY (name [Boy-4]))

   (MAN (name [Man-1]) (age 18))
   (MAN (name [Man-2]) (age 60))
 
   (WOMAN (name [Woman-1]) (age 18))
   (WOMAN (name [Woman-2]) (age 60))
   (WOMAN (name [Woman-3]))
   )
(deffunction count-facts (?template)
  (bind ?count 0)
  (do-for-all-facts ((?fct ?template)) TRUE
     (bind ?count (+ ?count 1)))
  ?count)
(deffunction count-facts-2 (?template)
  (length (find-all-facts ((?fct ?template)) TRUE)))
(deftemplate A (slot name)) ; (is-a USER))
(deftemplate B) ; (is-a A))
(deftemplate C) ; (is-a A))
(deftemplate D (slot name)) ; (is-a B C))
(defglobal ?*list* = (mv-append V W))
(deftemplate V (slot name))
(deftemplate W (slot name))
(deftemplate X (slot name))
(deftemplate Y (slot name))
(deftemplate Z (slot name))
(deftemplate USER)
