#include <windows.h>
#include <stdio.h>
#include "clips.h"

#define THREADCOUNT 2
char *InputClipsFile[THREADCOUNT] ={"MultiRun.clp","MultiRun.clp" };
void *TEnv[THREADCOUNT];

void ClipsThreadmain(int i)
{
	int lNoRules,error;
	char asTemp[512];

	TEnv[i] = CreateEnvironment();
    
	error = EnvLoad(TEnv[i],InputClipsFile[i]);
	if(!error)
	{
		printf("load error \n");	
		exit(1);
	}

	sprintf( asTemp,"( gen1 of context (Count 0))" );
	EnvMakeInstance(TEnv[i],asTemp);

	/* run the Clips rules */
	lNoRules = EnvRun(TEnv[i],-1L);
	printf("Number of Rules Fired %d \n",lNoRules);

	EnvClear(TEnv[i]);
	DestroyEnvironment(TEnv[i]);
}
void main()
{
   DWORD IDThread;
   HANDLE hThread[THREADCOUNT];
   DWORD dwWaitResult; 
   int i;
   
   // Create multiple threads
   for (i = 0; i < THREADCOUNT; i++) 
   { 
      hThread[i] = CreateThread(
			NULL,					// no security attributes 
			0,                      // use default stack size 
			(LPTHREAD_START_ROUTINE) ClipsThreadmain, // thread function 
			(LPVOID)i,              // thread function argument 
			0,                      // use default creation flags 
			&IDThread);             // returns thread identifier 
 
      // Check the return value for success. 
      if (hThread[i] == NULL) 
         fprintf(stdout,"CreateThread error\n"); 
   }
   for (i=0;i<THREADCOUNT;i++)
   {
		dwWaitResult = WaitForSingleObject(hThread[i], INFINITE);
   }
   for (i=0;i<THREADCOUNT;i++)
   {
		CloseHandle(hThread[i]);
   }
}

