package com.ibm.able.examples.rules;

import java.io.*;
import java.util.Vector;

import com.ibm.able.data.*;
public class TstRuleObject implements Serializable {
  /*  Tst class used to test method invocation from rules 
   *   
   */

  static final long serialVersionUID = -2957688736132440413L;
    
  protected String name = "" ; 
  protected int intValue = 20 ; 
  protected String strValue = "this is a test string" ;
  protected double dblValue = 3.4 ; 
  protected Vector vecValue = new Vector();
  
  public TstRuleObject() {
    System.out.println("TstRuleObject()") ; 
  }
  
  public TstRuleObject(Object tstObj) {
     System.out.println("TstRuleObject(Object)") ;  	
  }
  
  public TstRuleObject(TstRuleObject tstObj) {
     System.out.println("TstRuleObject(TstRuleObject)") ;  	
  }
  
  public TstRuleObject(String theName) {
  	 System.out.println("TstRuleObject(String)") ;  
     name = theName ; 	 
  } 
  
  public TstRuleObject(Double theDouble) { 
     dblValue = theDouble.doubleValue() ;  
     System.out.println("TstRuleObject(Double)") ;	
  }
  
  public TstRuleObject(String theName, double theDouble) { 
     name = theName ; 
     dblValue = theDouble ; 
     System.out.println("TstRuleObject(String,double)") ;	
  }
  
  public void method0() {
  	 System.out.println("method0() - no args -- returns void") ; 
  }
  
  public String method1(String s1, Double d1) {
     String s = "method1(String,Double) - 2 args= " + s1 + " " + d1 ;	
     System.out.println(s) ; 
     return s ; 
  }
 
  public String method1(String s1, double d1) {
     String s = "method1(String,double) - 2 args= " + s1 + " " + d1 ;	
     System.out.println(s) ; 
     return s ; 
  } 
  
  public String method1(String s1, float f1) {
     String s = "method1(String,float) - 2 args= " + s1 + " " + f1 ;	
     System.out.println(s) ; 
     return s ; 
  } 
   
  public String method1(String s1, Integer i1) {
     String s = "method1(String,Integer) - 2 args= " + s1 + " " + i1 ;	
     System.out.println(s) ; 
     return s ; 
  }
  
  public String method1(String s1, Long long1) {
     String s = "method1(String,Long) - 2 args= " + s1 + " " + long1 ;	
     System.out.println(s) ; 
     return s ; 
  }
  
  public String method1(Object s1, Object d1) {
     String s = "method1(Object,Object) - 2 args= " + s1 + " " + d1 ;	
     System.out.println(s) ; 
     return s ; 
  } 

  public String method1(String s1, Object d1) {
     String s = "method1(String,Object) - 2 args= " + s1 + " " + d1 ;	
     System.out.println(s) ; 
     return s ; 
  }  
  
  public String method1(Object s1, Double d1) {
     String s = "method1(Object,Double) - 2 args= " + s1 + " " + d1 ;	
     System.out.println(s) ; 
     return s ; 
  }

  // method1 and method2 are matching sigs .... 1 is more specific
  public String method2(String s1, Object obj1) {
  	 String s = "method2 - 2 args= " + s1 + " " + obj1 ;
     System.out.println(s) ; 
     return s ;   	
  }
  
  public void method3(String s1, Double d1, Object i1) {
    String s=  "method3(String,Double,Object) - 3 args= " + s1 + " " + d1 + " " + i1 ;	
    System.out.println(s) ; 
  }
  
  public void method3(Object s1, Double d1, Object i1) {
    String s=  "method3(Object,Double,Object) - 3 args= " + s1 + " " + d1 + " " + i1 ;	
    System.out.println(s) ; 
  }
  
  public void method3(Object s1, Double d1, String i1) {
    String s=  "method3(Object,Double,String) - 3 args= " + s1 + " " + d1 + " " + i1 ;	
    System.out.println(s) ; 
  }
 
  public void method4(String s1, Object i1, Double d1, String s2) {
   String s = "method4 - 4 args= " + s1 + " " + i1 + " " + d1 + " " +s2;	
   System.out.println(s) ; 
  }
  
  public String method5(String s1, double d1) {
     String s = "method5(String,double) - 2 args= " + s1 + " " + d1 ;	
     System.out.println(s) ; 
     return s ; 
  } 
  
  public double getDblValue() {
  	 return dblValue ; 
  }

  public String getName() {
  	 return name ; 
  }

  public String getStrValue() {
  	 return strValue ; 
  }

  public int getIntValue() {
  	 return intValue ; 
  }


  public int[] getIntArray() {
  	 return new int[5] ; 
  }
  
  public Vector getVecValue() {
  	   return vecValue ;
  }
  
  public void setVecValue(Vector theVec) {
  	  vecValue = theVec ; 
  }
  
  public void callIntArrayMethod(int[] anIntArray) {
    String s=  "callIntArrayMethod(int[]) - 1 arg= " + anIntArray ; 	
    System.out.println(s) ;
  }

  // used to test external function invocation from predicate rules
  // pass the return boolean , a values to be assigned to the variable 
  static public boolean getGenericValue(boolean truth,  Object value, AbleVariable theVar) throws AbleDataException {
 	     theVar.setGenericValue(value);
 	     return truth ; 
 }

}

