package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.ablebean
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * A Thing has a name, location, can be placed on top of another thing,
 * and a weight description.
 * 
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:56:24 $
 */
public class Thing implements Serializable {

   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;
   String name = "aThing";
   String location = "";
   String onTopOf = "floor";
   String weight = "light";

   public Thing() {
   }

   public Thing(String name) {
      this.name = name;
   }

   public Thing(String name, String location) {
      this.name = name;
      this.location = location;
   }

   public Thing(String name, String location, String onTopOf) {
      this.name = name;
      this.location = location;
      this.onTopOf = onTopOf;
   }

   public Thing(String name, String location, String onTopOf, String weight) {
      this.name = name;
      this.location = location;
      this.onTopOf = onTopOf;
      this.weight = weight;
   }

   public String getName() {
      return name;
   }
   public void setName(String name) {
      this.name = name;
   }

   public String getLocation() {
      return location;
   }
   public void setLocation(String location) {
      this.location = location;
   }

   public String getOnTopOf() {
      return onTopOf;
   }
   public void setOnTopOf(String onTopOf) {
      this.onTopOf = onTopOf;
   }

   public String getWeight() {
      return weight;
   }
   public void setWeight(String weight) {
      this.weight = weight;
   }

   public String toString() {
      return name
         + "=(location="
         + location
         + " onTopOf="
         + onTopOf
         + " weight="
         + weight
         + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }
}
