package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2003 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;


/**
 * This class contains the planning actions specified in the ARL file
 * Plan_SystemRecovery.arl.
 *
 * @version  $Revision: 1.6 $, $Date: 2005/03/02 22:02:35 $
 */
public class SystemRecoveryActions implements Serializable {
  // Serialized version identifier in form YYYYMMDDVerRelModxx
  static final long serialVersionUID     = 2003100800200000001L;
  private static long delay = 500L;
  /**
   * Create the SystemRecovery object that can perform the system
   * recovery planning actions specified in Plan_SystemRecovery ABLE
   * rule language (ARL) source file.
   *
   */
  public SystemRecoveryActions() {
  }


  /**
   * Start the specified database on the specified EServer.
   *
   * @return    <i>true</i> if the action is successful;
   *            <i>false</i> otherwise.
   */
  public static boolean startdb(String theDB, String theEServer) {
    System.out.println("  \tSystemRecovery starting DB<"+theDB+"> because...");
    System.out.println("  \t  \tEServer<"+theEServer+"> is running.");
    System.out.println("  \t  \tDB<"+theDB+"> is installed on EServer<"+theEServer+">, but DB<"+theDB+"> is not running.");
    System.out.println("  \tTherefore, DB<"+theDB+"> must be started.");
    System.out.println("  \t  \tStarting DB<"+theDB+">.");

    try {Thread.sleep(delay);} catch(InterruptedException ex) { ; } // Do necessary action

    System.out.println("  \t  \tDB<"+theDB+"> started successfully.");
    return true;
  }


  /**
   * Start the specified WAS server on the specified EServer.
   *
   * @return    <i>true</i> if the action is successful;
   *            <i>false</i> otherwise.
   */
  public static boolean startwasserver(String theWASServer, String theEServer, String theDB) {
    System.out.println("  \tSystemRecovery starting WAS Server<"+theWASServer+"> because...");
    System.out.println("  \t  \tEServer<"+theEServer+"> is running.");
    System.out.println("  \t  \tDB<"+theDB+"> is installed on EServer<"+theEServer+"> and DB<"+theDB+"> is running.");
    System.out.println("  \t  \tWAS Server<"+theWASServer+"> is installed on EServer<"+theEServer+">, but WAS Server<"+theWASServer+"> is not running.");
    System.out.println("  \tTherefore, WAS Server<"+theWASServer+"> must be started.");
    System.out.println("  \t  \tStarting WAS Server<"+theWASServer+">.");

    try {Thread.sleep(delay);} catch(InterruptedException ex) { ; } // Do necessary action

    System.out.println("  \t  \tWAS Server<"+theWASServer+"> started successfully.");
    return true;
  }


  /**
   * Start the specified application on the specified EServer.
   *
   * @return    <i>true</i> if the action is successful;
   *            <i>false</i> otherwise.
   */
  public static boolean startapp(String theApp, String theEServer, String theDB, String theDirServer, String theWASServer) {
    System.out.println("  \tSystemRecovery starting application<"+theApp+"> because...");
    System.out.println("  \t  \tEServer<"+theEServer+"> is running.");
    System.out.println("  \t  \tDB<"+theDB+"> is installed on EServer<"+theEServer+"> and DB<"+theDB+"> is running.");
    System.out.println("  \t  \tWAS Server<"+theWASServer+"> is installed on EServer<"+theEServer+"> and WAS Server<"+theWASServer+"> is running.");
    System.out.println("  \t  \tDir Server<"+theDirServer+"> is running.");
    System.out.println("  \t  \tApplication<"+theApp+"> is installed on EServer<"+theEServer+">, but Application<"+theApp+"> is not running.");
    System.out.println("  \tTherefore, application<"+theApp+"> must be started.");
    System.out.println("  \t  \tStarting application<"+theApp+">.");

    try {Thread.sleep(delay);} catch(InterruptedException ex) { ; } // Do necessary action

    System.out.println("  \t  \tApplication<"+theApp+"> started successfully.");
    return true;
  }


  /**
   * Display pertinent information about this object.
   */
  public String toString() {
    return "SystemRecoveryActions" + "=()";
  }


  /**
   * Determine the copyright of this class.
   *
   * @return    A String containing this class's copyright statement.
   *            <p>
   */
  private static String Copyright() {
    return Able.Copyright;
  }

}
