package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;
import java.util.Vector;

import com.ibm.able.Able;

/**
 * A shopping cart has a name and contains objects.
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:56:24 $
 */

public class ShoppingCart implements Serializable {

   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;
   String name = "aCart";
   Vector contents = new Vector();

   public ShoppingCart() {
   }

   public ShoppingCart(String name) {
      this.name = name;
   }

   public ShoppingCart(String name, Vector contents) {
      this.name = name;
      this.contents = contents;
   }

   public ShoppingCart(String name, Object[] contents) {
      this.name = name;
      this.contents = new Vector();
      for (int i = 0; i < contents.length; i++) {
         this.contents.add(contents[i]);
      }
   }

   public String getName() {
      return name;
   }
   public void setName(String name) {
      this.name = name;
   }

   public Vector getContents() {
      return contents;
   }
   public void setContents(Vector contents) {
      this.contents = contents;
   }

   public boolean contains(String item) {
      if (contents.indexOf(item) > -1) {
         return true;
      } else {
         return false;
      }
   }
   public String toString() {
      return name + "=(contents=" + contents + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }
}
