package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.rmi.RemoteException;

import javax.swing.JFrame;

import com.ibm.able.AbleObjectCustomizer;


/**
 * This class provides the customizer for the fuzzy SampleSensorEffector.
 *
 * @version  $Revision: 1.2 $, $Date: 2001/09/26 20:31:03 $
 *
 */
public class SampleSensorEffectorCustomizer extends AbleObjectCustomizer {

  //-----------------------------------------------------------------
  // Member variables
  //-----------------------------------------------------------------


  //-----------------------------------------------------------------
  // Constructors
  //-----------------------------------------------------------------
  /**
   *  Construct a Self Organizing Map Customizer dialog.  Dialog is
   *  not modal so other windows can be active at the same time.
   *
   * @param frame the frame from which the dialog is displayed.
   * @param title the String to display in the dialog's title bar.
   */
  public SampleSensorEffectorCustomizer(JFrame frame, String title) {
    super(frame, title, false);   // non-modal
    setCustomizer(this);          // so OK calls updateObject on this
  }


  /**
   *  Construct a Self Organizing Map Customizer Dialog.  Dialog is
   *  not modal so other windows can be active at the same time.
   *
   */
  public SampleSensorEffectorCustomizer() {
    this(new JFrame(), "Sample Fuzzy Sensor/Effector Customizer");
  }


  //--------------------------------------------------------------------
  // Methods inherited from Customizer interface
  //--------------------------------------------------------------------
  /**
   * Write the data from the object to the panel(s) provided
   * by this customizer. The panel saves a reference to the
   * bean being customized.
   * Pass the object and its data to any inherited panel.
   *
   * @param     theBean
   *            The bean that is to be changed.
   */
  public void setObject(Object theBean) {
    super.setObject(theBean);
  }


  /**
   * Update the bean that is being customized.  This method is
   * called when the dialog's OK button is pressed.
   *
   * @exception RemoteException is thrown when the panel values
   *            cannot be set on the bean.
   */
  public void updateObject() throws RemoteException {
    super.updateObject();
  }

}
