package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.File;
import java.lang.reflect.Method;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.rules.AbleRuleSet;


/**
 * This class is a command line test case (it has a main() method)
 * that creates a fuzzy ruleset, a fuzzy ruleset listener, wires the
 * two together, and then processes the rules. Lots of listener
 * messages should result on the java console.
 *
 * @version  $Revision: 1.14 $, $Date: 2002/10/10 15:36:18 $
 */
public class SampleSensorEffector extends AbleObject {

  /**
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  static final long serialVersionUID = 2001100500100300000L;
  //==================================================================
  //
  // Constructors
  //
  //==================================================================
  public SampleSensorEffector() throws AbleException {
    this("SampleSensorEffector");
  }

  public SampleSensorEffector(String theName) throws AbleException {
    super(theName);
    init();
  }


  public void process() throws AbleException {
    runSample();
  }


  //==================================================================
  //
  // Methods specific to this class
  //
  //==================================================================
  public void runSample() {

    try {
      //------------------------------------------------
      // Start ABLE's message and trace logging
      //------------------------------------------------
      Able.startMessageAndTraceLogging();

      //--------------------------------------------------------------
      // Create a ruleset for testing
      //--------------------------------------------------------------
      AbleRuleSet lclRuleSet = new AbleRuleSet();

      //--------------------------------------------------------------
      // Create a fuzzy ruleset listener and add it to the ruleset.
      // This is purposely done BEFORE the ruleset is instantiated.
      //--------------------------------------------------------------
      // The Fuzzy Change Listener is broken by the latest round of Rule changes
      //AbleFuzzyChgListener lclFuzzyListener  = new AbleFuzzyChgListener();
      //lclRuleSet.addRuleSetChangeListener(lclFuzzyListener);

      //--------------------------------------------------------------
      // Instantiate the ruleset by reading a source rule file.
      // This is purposely done AFTER the listener is added above.
      //--------------------------------------------------------------
      String lclPath = Able.ProductDirectory+"examples"+File.separator+"rules"+File.separator;
      lclRuleSet.parseFromARL(lclPath + "SampleSensorEffector.arl");

      //--------------------------------------------------------------
      // Create the sensors & effectors and add them to the ruleset.
      //--------------------------------------------------------------
      Class        lclClass    = this.getClass();
      Method       lclSenMethod= lclClass.getMethod("tstLockMethod", new Class[] {Object.class});
      Method       lclEffMethod= lclClass.getMethod("setLockMethod", new Class[] {Object.class});
      AbleUserDefinedFunction lclSensor   = new AbleUserDefinedFunction("tstLock", this, lclSenMethod);
      AbleUserDefinedFunction lclEffector = new AbleUserDefinedFunction("setLock", this, lclEffMethod);

      lclRuleSet.addUserDefinedFunction(lclSensor);
      lclRuleSet.addUserDefinedFunction(lclEffector);

      lclRuleSet.init();

      //--------------------------------------------------------------
      // Get the input buffer from the ruleset and load it with sample
      // data.
      //--------------------------------------------------------------
      Object[] lclInpBuffer = (Object[])lclRuleSet.getInputBuffer();
      lclInpBuffer[0] = new Boolean(true);  // vB1
      lclInpBuffer[1] = new Double(9.9);    // vN1
      lclInpBuffer[2] = "Ghi";              // vC1
      lclInpBuffer[3] = new Double(88.88);  // vF1

      //--------------------------------------------------------------
      // Process the fuzzy ruleset.
      //--------------------------------------------------------------
      lclRuleSet.process();

      //--------------------------------------------------------------
      // Check the output buffer
      //--------------------------------------------------------------
      Object[] lclOutBuffer = (Object[])lclRuleSet.getOutputBuffer();

      for (int i=0; i<lclOutBuffer.length; i++) {
        if (trace.isLogging()) trace.text(Able.TRC_HIGH,this,"runSample","!! Output element[" + i + "]: <" + lclOutBuffer[i] + ">");
      }
    }
    catch(Exception theException) {
      if (trace.isLogging()) {
        trace.text(Able.TRC_LOW,this,"runSample","!! Caught nasty exception: "
          + theException.getLocalizedMessage());
        trace.exception(Able.TRC_LOW,this,"runSample",theException);
      }
    }
  }


  /**
   * The "sensor" named "tstLock".
   *
   * <p>This method simply returns a new copy of the argument.
   *
   */
  public Object tstLockMethod(Object theTstObject) {
    System.out.println("!! In SENSOR. Object is: " + theTstObject.getClass().getName() + ": <" + theTstObject.toString() + ">");
    return performSensorEffector(theTstObject);
  }


  /**
   * The "effector" named "setLock".
   *
   * <p>This method simply returns a new copy of the argument.
   *
   */
  public Object setLockMethod(Object theTstObject) {
    System.out.println("!! In EFFECTOR. Object is: " + theTstObject.getClass().getName() + ": <" + theTstObject.toString() + ">");
    return performSensorEffector(theTstObject);
  }


  /**
   * A helper routine used by the sensor and effector methods.
   *
   * <p>This method simply returns a new copy of the argument.
   *
   */
  private Object performSensorEffector(Object theTstObject) {
    if (theTstObject instanceof Boolean) {return new Boolean( ((Boolean)theTstObject).booleanValue() );}
    if (theTstObject instanceof Double ) {return new Double ( ((Double )theTstObject).doubleValue() ); }
    if (theTstObject instanceof String ) {return new String (  (String )theTstObject );                }

    return new Double(12.34);
  }


  //==================================================================
  //
  // Main method
  //
  //==================================================================
  public static void main(String[] args) {
    try {
      SampleSensorEffector lclSampleSensorEffector = new SampleSensorEffector();

      lclSampleSensorEffector.runSample();

      System.exit(0);
    }
    catch(Throwable theThrowable) {
      if (Able.TraceLog.isLogging())
        Able.TraceLog.exception(Able.TRC_HIGH,
          "com.ibm.able.examples.rules.SampleSensorEffector", "main", theThrowable);
    }
  }

}
